/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.handlers;

import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IConfirmCallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.ui.PlatformUI;

public class MoveCopyCallback
implements IConfirmCallback {
    public boolean requires(Object object) {
        return true;
    }

    public int confirms(Object object) {
        final boolean isDirectory = this.isDirectory(object);
        final String path = this.getAbsolutePath(object);
        final String name = this.getName(object);
        final int[] results = new int[1];
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                String title = isDirectory ? Messages.FSOperation_ConfirmFolderReplaceTitle : Messages.FSOperation_ConfirmFileReplace;
                String message = NLS.bind((String)(isDirectory ? Messages.FSOperation_ConfirmFolderReplaceMessage : Messages.FSOperation_ConfirmFileReplaceMessage), (Object)path, (Object)name);
                final Image titleImage = UIPlugin.getImage("ReplaceFolderConfirm");
                MessageDialog qDialog = new MessageDialog(parent, title, null, message, 3, new String[]{Messages.FSOperation_ConfirmDialogYes, Messages.FSOperation_ConfirmDialogYesToAll, Messages.FSOperation_ConfirmDialogNo, Messages.FSOperation_ConfirmDialogCancel}, 0){

                    public Image getQuestionImage() {
                        return titleImage;
                    }
                };
                results[0] = qDialog.open();
            }
        });
        return results[0];
    }

    private String getName(Object object) {
        if (object instanceof IFSTreeNode) {
            return ((IFSTreeNode)object).getName();
        }
        if (object instanceof File) {
            return ((File)object).getName();
        }
        return String.valueOf(object);
    }

    private String getAbsolutePath(Object object) {
        if (object instanceof IFSTreeNode) {
            return ((IFSTreeNode)object).getLocation();
        }
        if (object instanceof File) {
            return ((File)object).getAbsolutePath();
        }
        return String.valueOf(object);
    }

    private boolean isDirectory(Object object) {
        if (object instanceof IFSTreeNode) {
            return ((IFSTreeNode)object).isDirectory();
        }
        if (object instanceof File) {
            return ((File)object).isDirectory();
        }
        return false;
    }
}

