/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.properties;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNodeWorkingCopy;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations.UiExecutor;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.properties.AdvancedAttributesDialog;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.ui.dialogs.PropertyPage;

public class GeneralInformationPage
extends PropertyPage {
    private static final DecimalFormat SIZE_FORMAT = new DecimalFormat();
    IFSTreeNode node;
    IFSTreeNodeWorkingCopy fWorkingCopy;
    Button btnReadOnly;
    Button btnHidden;
    Button[] btnPermissions;

    protected void createSeparator(Composite parent) {
        Label label = new Label(parent, 274);
        GridData data = new GridData(4, 1, true, false);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
    }

    protected void createField(String text, String value, Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 16384;
        data.verticalAlignment = 128;
        label.setLayoutData((Object)data);
        Text txt = new Text(parent, 72);
        data = new GridData();
        data.verticalAlignment = 128;
        data.widthHint = 300;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        txt.setLayoutData((Object)data);
        txt.setBackground(txt.getDisplay().getSystemColor(22));
        txt.setText(value);
    }

    protected String getSizeText(long size) {
        return NLS.bind((String)Messages.GeneralInformationPage_FileSizeInfo, (Object)SIZE_FORMAT.format(size / 1024L), (Object)SIZE_FORMAT.format(size));
    }

    protected String getDateText(long time) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3);
        return dateFormat.format(new Date(time));
    }

    protected void createAttributesSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.GeneralInformationPage_Attributes);
        GridData data = new GridData();
        data.horizontalAlignment = 16384;
        label.setLayoutData((Object)data);
        Composite attr = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, true);
        layout.marginHeight = 0;
        attr.setLayout((Layout)layout);
        this.btnReadOnly = new Button(attr, 32);
        this.btnReadOnly.setText(Messages.GeneralInformationPage_ReadOnly);
        this.btnReadOnly.setEnabled(this.node.isAgentOwner());
        this.btnReadOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GeneralInformationPage.this.btnReadOnly.getSelection() != GeneralInformationPage.this.fWorkingCopy.isReadOnly()) {
                    GeneralInformationPage.this.fWorkingCopy.setReadOnly(GeneralInformationPage.this.btnReadOnly.getSelection());
                }
            }
        });
        this.btnHidden = new Button(attr, 32);
        this.btnHidden.setText(Messages.GeneralInformationPage_Hidden);
        this.btnHidden.setEnabled(this.node.isAgentOwner());
        this.btnHidden.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button btnHidden = (Button)e.getSource();
                GeneralInformationPage.this.fWorkingCopy.setHidden(btnHidden.getSelection());
            }
        });
        Button btnAdvanced = new Button(attr, 8);
        btnAdvanced.setText(Messages.GeneralInformationPage_Advanced);
        btnAdvanced.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralInformationPage.this.showAdvancedAttributes();
            }
        });
        this.updateAttributes();
    }

    private void updateAttributes() {
        this.btnReadOnly.setSelection(this.fWorkingCopy.isReadOnly());
        this.btnHidden.setSelection(this.fWorkingCopy.isHidden());
    }

    void showAdvancedAttributes() {
        AdvancedAttributesDialog dialog = new AdvancedAttributesDialog(this.getShell(), this.fWorkingCopy.createWorkingCopy());
        if (dialog.open() == 0) {
            IFSTreeNodeWorkingCopy result = dialog.getResult();
            UiExecutor.execute(result.operationCommit());
        }
    }

    protected void createPermissionsSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.GeneralInformationPage_PermissionText);
        GridData data = new GridData();
        data.horizontalAlignment = 16384;
        data.verticalAlignment = 128;
        label.setLayoutData((Object)data);
        Composite perms = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        perms.setLayout((Layout)gridLayout);
        this.btnPermissions = new Button[9];
        this.createPermissionGroup(perms, 0, Messages.PermissionsGroup_UserPermissions);
        this.createPermissionGroup(perms, 3, Messages.PermissionsGroup_GroupPermissions);
        this.createPermissionGroup(perms, 6, Messages.PermissionsGroup_OtherPermissions);
        this.updatePermissions();
    }

    protected void createPermissionGroup(Composite parent, int bit, String header) {
        Label label = new Label(parent, 0);
        label.setText(header);
        GridData data = new GridData();
        data.horizontalAlignment = 16384;
        label.setLayoutData((Object)data);
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, true);
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        this.createPermissionButton(Messages.PermissionsGroup_Readable, bit, group);
        this.createPermissionButton(Messages.PermissionsGroup_Writable, bit + 1, group);
        this.createPermissionButton(Messages.PermissionsGroup_Executable, bit + 2, group);
    }

    private void createPermissionButton(String label, final int index, Composite parent) {
        this.btnPermissions[index] = new Button(parent, 32);
        this.btnPermissions[index].setText(label);
        this.btnPermissions[index].setEnabled(this.node.isAgentOwner());
        this.btnPermissions[index].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int bit = 1 << 8 - index;
                GeneralInformationPage.this.fWorkingCopy.setPermission(bit, GeneralInformationPage.this.btnPermissions[index].getSelection());
            }
        });
    }

    private void updatePermissions() {
        int i = 0;
        while (i < 9) {
            int bit = 1 << 8 - i;
            this.btnPermissions[i].setSelection(this.fWorkingCopy.getPermission(bit));
            ++i;
        }
    }

    protected void performDefaults() {
        this.fWorkingCopy = this.node.createWorkingCopy();
        if (this.node.isWindowsNode()) {
            this.updateAttributes();
        } else {
            this.updatePermissions();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.hasAttrsChanged()) {
            UiExecutor.execute(this.fWorkingCopy.operationCommit());
        }
        return this.getErrorMessage() == null;
    }

    private boolean hasAttrsChanged() {
        return this.fWorkingCopy.isDirty();
    }

    protected Control createContents(Composite parent) {
        long lm;
        IAdaptable element = this.getElement();
        Assert.isTrue((boolean)(element instanceof IFSTreeNode));
        this.node = (IFSTreeNode)element;
        this.fWorkingCopy = this.node.createWorkingCopy();
        Composite page = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        page.setLayout((Layout)gridLayout);
        this.createField(Messages.GeneralInformationPage_Name, this.fWorkingCopy.getName(), page);
        String fileType = this.fWorkingCopy.getFileTypeLabel();
        this.createField(Messages.GeneralInformationPage_Type, fileType, page);
        String location = this.fWorkingCopy.isFileSystem() || this.fWorkingCopy.isRootDirectory() ? Messages.GeneralInformationPage_Computer : this.fWorkingCopy.getLocation();
        this.createField(Messages.GeneralInformationPage_Location, location, page);
        if (this.fWorkingCopy.isFile()) {
            long size = this.fWorkingCopy.getSize();
            this.createField(Messages.GeneralInformationPage_Size, size > 0L ? this.getSizeText(size) : "", page);
        }
        this.createField(Messages.GeneralInformationPage_Modified, (lm = this.fWorkingCopy.getModificationTime()) != 0L ? this.getDateText(lm) : "", page);
        if (this.fWorkingCopy.isFile()) {
            long at = this.fWorkingCopy.getAccessTime();
            this.createField(Messages.GeneralInformationPage_Accessed, at != 0L ? this.getDateText(at) : "", page);
        }
        this.createSeparator(page);
        if (this.fWorkingCopy.isWindowsNode()) {
            this.createAttributesSection(page);
        } else {
            this.createPermissionsSection(page);
        }
        return page;
    }
}

