/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.bindings;

import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfo;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfoVisitor;
import org.eclipse.wb.internal.core.databinding.model.CodeGenerationSupport;
import org.eclipse.wb.internal.core.databinding.model.IASTObjectInfo2;
import org.eclipse.wb.internal.core.databinding.model.IBindingInfo;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.parser.AbstractParser;
import org.eclipse.wb.internal.core.databinding.parser.IModelResolver;
import org.eclipse.wb.internal.core.databinding.ui.editor.IPageListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.IUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.BindingContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ChooseClassConfiguration;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.LabelUiContentProvider;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.utils.StringUtilities;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swing.databinding.DatabindingsProvider;
import org.eclipse.wb.internal.swing.databinding.Messages;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.TypeObjectInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.ConverterInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.ValidatorInfo;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;
import org.eclipse.wb.internal.swing.databinding.model.properties.PropertyInfo;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.BindingNameUiContentProvider;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.ConverterUiContentProvider;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.ValidatorUiContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BindingInfo
extends AstObjectInfo
implements IBindingInfo,
IASTObjectInfo2 {
    private static final String SET_CONVERTER = "org.jdesktop.beansbinding.Binding.setConverter(org.jdesktop.beansbinding.Converter)";
    private static final String SET_VALIDATOR = "org.jdesktop.beansbinding.Binding.setValidator(org.jdesktop.beansbinding.Validator)";
    private static ChooseClassConfiguration m_converterConfiguration;
    private static ChooseClassConfiguration m_validatorConfiguration;
    protected final ObserveInfo m_target;
    protected final ObserveInfo m_targetProperty;
    protected final PropertyInfo m_targetAstProperty;
    protected final ObserveInfo m_model;
    protected final ObserveInfo m_modelProperty;
    protected final PropertyInfo m_modelAstProperty;
    protected ConverterInfo m_converter;
    protected ValidatorInfo m_validator;
    private String m_name;
    private boolean m_field;

    public BindingInfo(ObserveInfo target, ObserveInfo targetProperty, PropertyInfo targetAstProperty, ObserveInfo model, ObserveInfo modelProperty, PropertyInfo modelAstProperty) {
        this.m_target = target;
        this.m_targetProperty = targetProperty;
        this.m_targetAstProperty = targetAstProperty;
        this.m_model = model;
        this.m_modelProperty = modelProperty;
        this.m_modelAstProperty = modelAstProperty;
    }

    public final IObserveInfo getTarget() {
        return this.m_target;
    }

    public final IObserveInfo getTargetProperty() {
        return this.m_targetProperty;
    }

    public IGenericType getTargetPropertyType() {
        return this.m_targetProperty.getObjectType();
    }

    public final PropertyInfo getTargetAstProperty() {
        return this.m_targetAstProperty;
    }

    public final IObserveInfo getModel() {
        return this.m_model;
    }

    public final IObserveInfo getModelProperty() {
        return this.m_modelProperty;
    }

    public IGenericType getModelPropertyType() {
        return this.m_modelProperty.getObjectType();
    }

    public final PropertyInfo getModelAstProperty() {
        return this.m_modelAstProperty;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public final ConverterInfo getConverter() {
        return this.m_converter;
    }

    public final void setConverter(ConverterInfo converter) {
        this.m_converter = converter;
    }

    public final ValidatorInfo getValidator() {
        return this.m_validator;
    }

    public final void setValidator(ValidatorInfo validator) {
        this.m_validator = validator;
    }

    public void createContentProviders(List<BindingInfo> bindings, List<IUiContentProvider> providers, IPageListener listener, DatabindingsProvider provider) throws Exception {
        listener.setTitle(Messages.BindingInfo_listenerTitle);
        listener.setMessage(Messages.BindingInfo_listenerMessage);
        providers.add((IUiContentProvider)new LabelUiContentProvider(Messages.BindingInfo_target, this.getTargetPresentationText(false)));
        this.m_targetProperty.createContentProviders(providers, this.m_target, this.m_targetAstProperty);
        providers.add((IUiContentProvider)new LabelUiContentProvider(Messages.BindingInfo_model, this.getModelPresentationText(false)));
        this.m_modelProperty.createContentProviders(providers, this.m_model, this.m_modelAstProperty);
        providers.add((IUiContentProvider)new ConverterUiContentProvider(this.createConverterConfiguration(), this));
        providers.add((IUiContentProvider)new ValidatorUiContentProvider(this.createValidatorConfiguration(), this));
        providers.add((IUiContentProvider)new BindingNameUiContentProvider(this));
        providers.add((IUiContentProvider)new BindingContentProvider((IASTObjectInfo2)this, provider.getJavaInfoRoot()));
    }

    protected final ChooseClassConfiguration createConverterConfiguration() {
        if (m_converterConfiguration == null) {
            m_converterConfiguration = new ChooseClassConfiguration();
            m_converterConfiguration.setDialogFieldLabel(Messages.BindingInfo_converterLabel);
            m_converterConfiguration.setValueScope("org.jdesktop.beansbinding.Converter");
            m_converterConfiguration.setClearValue("N/S");
            m_converterConfiguration.setBaseClassName("org.jdesktop.beansbinding.Converter");
            m_converterConfiguration.setConstructorParameters(ArrayUtils.EMPTY_CLASS_ARRAY);
            m_converterConfiguration.setEmptyClassErrorMessage(Messages.BindingInfo_converterError);
            m_converterConfiguration.setErrorMessagePrefix(Messages.BindingInfo_converterErrorPrefix);
        }
        m_converterConfiguration.clearDefaultStrings();
        if (this.m_converter != null && !StringUtils.isEmpty((String)this.m_converter.getParameters())) {
            m_converterConfiguration.addDefaultStart(this.m_converter.getFullClassName());
        }
        return m_converterConfiguration;
    }

    protected final ChooseClassConfiguration createValidatorConfiguration() {
        if (m_validatorConfiguration == null) {
            m_validatorConfiguration = new ChooseClassConfiguration();
            m_validatorConfiguration.setDialogFieldLabel(Messages.BindingInfo_validatorLabel);
            m_validatorConfiguration.setValueScope("org.jdesktop.beansbinding.Validator");
            m_validatorConfiguration.setClearValue("N/S");
            m_validatorConfiguration.setBaseClassName("org.jdesktop.beansbinding.Validator");
            m_validatorConfiguration.setConstructorParameters(ArrayUtils.EMPTY_CLASS_ARRAY);
            m_validatorConfiguration.setEmptyClassErrorMessage(Messages.BindingInfo_validatorError);
            m_validatorConfiguration.setErrorMessagePrefix(Messages.BindingInfo_validatorErrorPrefix);
        }
        m_validatorConfiguration.clearDefaultStrings();
        if (this.m_validator != null && !StringUtils.isEmpty((String)this.m_validator.getParameters())) {
            m_validatorConfiguration.addDefaultStart(this.m_validator.getFullClassName());
        }
        return m_validatorConfiguration;
    }

    public final boolean isField() {
        return this.m_field;
    }

    public final void setField() {
        this.m_field = true;
    }

    protected final void setVariableIdentifier(final JavaInfo javaInfoRoot, final String type, final String newVariable, boolean newFieldState) {
        try {
            boolean oldFieldState = this.m_field;
            this.m_field = newFieldState;
            final String oldVariable = this.getVariableIdentifier();
            this.setVariableIdentifier(newVariable);
            final TypeDeclaration rootNode = JavaInfoUtils.getTypeDeclaration((JavaInfo)javaInfoRoot);
            if (!oldFieldState && newFieldState) {
                ExecutionUtils.run((ObjectInfo)javaInfoRoot, (RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        BodyDeclarationTarget fieldTarget = new BodyDeclarationTarget(rootNode, null, true);
                        javaInfoRoot.getEditor().addFieldDeclaration("private " + type + " " + newVariable + ";", fieldTarget);
                    }
                });
            } else if (oldFieldState && !newFieldState) {
                ExecutionUtils.run((ObjectInfo)javaInfoRoot, (RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        FieldDeclaration[] fieldDeclarationArray = rootNode.getFields();
                        int n = fieldDeclarationArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            FieldDeclaration field = fieldDeclarationArray[n2];
                            VariableDeclarationFragment fragment = (VariableDeclarationFragment)DomGenerics.fragments((FieldDeclaration)field).get(0);
                            if (fragment.getName().getIdentifier().equals(oldVariable)) {
                                javaInfoRoot.getEditor().removeBodyDeclaration((BodyDeclaration)field);
                                return;
                            }
                            ++n2;
                        }
                        Assert.fail((String)MessageFormat.format(Messages.BindingInfo_undefinedField, oldVariable));
                    }
                });
            } else if (oldFieldState && newFieldState) {
                ExecutionUtils.run((ObjectInfo)javaInfoRoot, (RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        FieldDeclaration[] fieldDeclarationArray = rootNode.getFields();
                        int n = fieldDeclarationArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            FieldDeclaration field = fieldDeclarationArray[n2];
                            VariableDeclarationFragment fragment = (VariableDeclarationFragment)DomGenerics.fragments((FieldDeclaration)field).get(0);
                            if (fragment.getName().getIdentifier().equals(oldVariable)) {
                                javaInfoRoot.getEditor().setIdentifier(fragment.getName(), newVariable);
                                return;
                            }
                            ++n2;
                        }
                        Assert.fail((String)MessageFormat.format(Messages.BindingInfo_undefinedField, oldVariable));
                    }
                });
            }
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
        }
    }

    public boolean isManaged() {
        return false;
    }

    protected final void addFinishSourceCode(List<String> lines, CodeGenerationSupport generationSupport, boolean addBind) throws Exception {
        if (this.m_converter != null) {
            lines.add(String.valueOf(this.getVariableIdentifier()) + ".setConverter(" + this.m_converter.getSourceCode(lines, generationSupport) + ");");
        }
        if (this.m_validator != null) {
            lines.add(String.valueOf(this.getVariableIdentifier()) + ".setValidator(" + this.m_validator.getSourceCode(lines, generationSupport) + ");");
        }
        if (addBind) {
            lines.add(String.valueOf(this.getVariableIdentifier()) + ".bind();");
        }
    }

    protected final String getCreateMethodHeaderEnd() {
        if (StringUtils.isEmpty((String)this.m_name)) {
            return ")";
        }
        return ", \"" + StringUtilities.escapeJava((String)this.m_name) + "\")";
    }

    public AstObjectInfo parseExpression(AstEditor editor, String signature, MethodInvocation invocation, Expression[] arguments, IModelResolver resolver, IDatabindingsProvider provider) throws Exception {
        if (SET_CONVERTER.equals(signature)) {
            Assert.isNull((Object)((Object)this.m_converter));
            TypeObjectInfo converter = (TypeObjectInfo)resolver.getModel(arguments[0]);
            if (converter == null) {
                AbstractParser.addError((AstEditor)editor, (String)MessageFormat.format(Messages.BindingInfo_converterNotFound, arguments[0]), (Throwable)new Throwable());
                return null;
            }
            this.m_converter = new ConverterInfo(converter.getObjectType(), this);
            this.m_converter.setParameters(converter.getParameters());
            this.m_converter.setVariableIdentifier(converter.getVariableIdentifier());
        } else if (SET_VALIDATOR.equals(signature)) {
            Assert.isNull((Object)((Object)this.m_validator));
            TypeObjectInfo validator = (TypeObjectInfo)resolver.getModel(arguments[0]);
            if (validator == null) {
                AbstractParser.addError((AstEditor)editor, (String)MessageFormat.format(Messages.BindingInfo_validatorNotFound, arguments[0]), (Throwable)new Throwable());
                return null;
            }
            this.m_validator = new ValidatorInfo(validator.getObjectType(), this);
            this.m_validator.setParameters(validator.getParameters());
            this.m_validator.setVariableIdentifier(validator.getVariableIdentifier());
        }
        return null;
    }

    public void preCreate() throws Exception {
    }

    public void create(List<BindingInfo> bindings) throws Exception {
        this.m_target.createBinding(this);
        this.m_targetProperty.createBinding(this);
        this.m_model.createBinding(this);
        this.m_modelProperty.createBinding(this);
    }

    public void edit(List<BindingInfo> bindings) throws Exception {
    }

    public boolean delete(List<BindingInfo> bindings) throws Exception {
        return true;
    }

    public void postDelete() throws Exception {
        this.m_target.deleteBinding(this);
        this.m_targetProperty.deleteBinding(this);
        this.m_model.deleteBinding(this);
        this.m_modelProperty.deleteBinding(this);
    }

    public void move(List<BindingInfo> bindings) {
    }

    public String getTargetPresentationText(boolean full) throws Exception {
        return this.m_targetAstProperty.getPresentationText(this.m_target, this.m_targetProperty, full);
    }

    public String getModelPresentationText(boolean full) throws Exception {
        return this.m_modelAstProperty.getPresentationText(this.m_model, this.m_modelProperty, full);
    }

    public void accept(AstObjectInfoVisitor visitor) throws Exception {
        super.accept(visitor);
        this.m_targetAstProperty.accept(visitor);
        this.m_modelAstProperty.accept(visitor);
    }
}

