/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.bundle;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.server.bundle.CDOServerApplication;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.CDOServerExporter;
import org.eclipse.emf.cdo.server.CDOServerImporter;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.server.CDOCommand;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.emf.cdo.spi.server.RepositoryConfigurator;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOCommandProvider
implements CommandProvider {
    private static final String NEW_LINE = "\r\n";
    private static final CDOCommand list = new CDOCommand("list", "list all active repositories"){

        public void execute(String[] args) throws Exception {
            IManagedContainer container = CDOServerApplication.getContainer();
            Object[] objectArray = container.getElements("org.eclipse.emf.cdo.server.repositories");
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof InternalRepository) {
                    InternalRepository repository = (InternalRepository)element;
                    this.println(repository.getName());
                }
                ++n2;
            }
        }
    };
    private static final CDOCommand start = new CDOCommand("start", "start repositories from a config file", new CDOCommand.CommandParameter[]{CDOCommand.parameter("config-file")}){

        public void execute(String[] args) throws Exception {
            String configFile = args[0];
            IManagedContainer container = CDOServerApplication.getContainer();
            RepositoryConfigurator repositoryConfigurator = new RepositoryConfigurator(container);
            IRepository[] repositories = repositoryConfigurator.configure(new File(configFile));
            this.println("Repositories started:");
            if (repositories != null) {
                IRepository[] iRepositoryArray = repositories;
                int n = repositories.length;
                int n2 = 0;
                while (n2 < n) {
                    IRepository repository = iRepositoryArray[n2];
                    this.println(repository.getName());
                    ++n2;
                }
            }
        }
    };
    private static final CDOCommand stop = new CDOCommand.WithRepository("stop", "stop a repository"){

        public void execute(InternalRepository repository, String[] args) throws Exception {
            LifecycleUtil.deactivate((Object)repository);
            this.println("Repository stopped");
        }
    };
    private static final CDOCommand exportXML = new CDOCommand.WithRepository("export", "export the contents of a repository to an XML file", new CDOCommand.CommandParameter[]{CDOCommand.parameter("export-file")}){

        public void execute(InternalRepository repository, String[] args) throws Exception {
            String exportFile = args[0];
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(exportFile);
                CDOServerExporter.XML exporter = new CDOServerExporter.XML(repository);
                exporter.exportRepository(out);
                if (args.length > 1 && "withSystemPackages".equalsIgnoreCase(args[1])) {
                    exporter.setExportSystemPackages(true);
                }
                this.println("Repository exported");
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                throw throwable;
            }
            IOUtil.close((Closeable)out);
        }
    };
    private static final CDOCommand importXML = new CDOCommand.WithRepository("import", "import the contents of a repository from an XML file", new CDOCommand.CommandParameter[]{CDOCommand.parameter("import-file")}){

        public void execute(InternalRepository repository, String[] args) throws Exception {
            String importFile = args[0];
            FileInputStream in = null;
            try {
                in = new FileInputStream(importFile);
                LifecycleUtil.deactivate((Object)repository);
                CDOServerImporter.XML importer = new CDOServerImporter.XML(repository);
                importer.importRepository(in);
                IManagedContainer container = CDOServerApplication.getContainer();
                CDOServerUtil.addRepository(container, repository);
                this.println("Repository imported");
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                throw throwable;
            }
            IOUtil.close((Closeable)in);
        }
    };
    private static final CDOCommand branches = new CDOCommand.WithRepository("branches", "dump the branches of a repository"){

        public void execute(InternalRepository repository, String[] args) throws Exception {
            this.branches(repository.getBranchManager().getMainBranch(), "");
        }

        private void branches(InternalCDOBranch branch, String prefix) {
            this.println(String.valueOf(prefix) + branch);
            prefix = String.valueOf(prefix) + "   ";
            InternalCDOBranch[] internalCDOBranchArray = branch.getBranches();
            int n = internalCDOBranchArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOBranch child = internalCDOBranchArray[n2];
                this.branches(child, prefix);
                ++n2;
            }
        }
    };
    private static final CDOCommand packages = new CDOCommand.WithRepository("packages", "dump the packages of a repository"){

        public void execute(InternalRepository repository, String[] args) throws Exception {
            InternalCDOPackageRegistry packageRegistry = repository.getPackageRegistry(false);
            InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageRegistry.getPackageUnits();
            int n = internalCDOPackageUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
                this.println(packageUnit);
                InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageUnit.getPackageInfos();
                int n3 = internalCDOPackageInfoArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n4];
                    this.println("   " + packageInfo);
                    ++n4;
                }
                ++n2;
            }
        }
    };
    private static final CDOCommand sessions = new CDOCommand.WithRepository("sessions", "dump the sessions of a repository"){

        public void execute(InternalRepository repository, String[] args) throws Exception {
            InternalSessionManager sessionManager = repository.getSessionManager();
            InternalSession[] internalSessionArray = sessionManager.getSessions();
            int n = internalSessionArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalSession session = internalSessionArray[n2];
                this.println(session);
                InternalView[] internalViewArray = session.getViews();
                int n3 = internalViewArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    InternalView view = internalViewArray[n4];
                    this.println("   " + view);
                    ++n4;
                }
                ++n2;
            }
        }
    };
    private static final CDOCommand locks = new CDOCommand.WithAccessor("locks", "dump the locks of a repository", new CDOCommand.CommandParameter[]{CDOCommand.optional("username-prefix")}){

        public void execute(InternalRepository repository, IStoreAccessor accessor, String[] args) throws Exception {
            String usernamePrefix = args[0];
            repository.getLockingManager().getLockAreas(usernamePrefix, new IDurableLockingManager.LockArea.Handler(){

                public boolean handleLockArea(IDurableLockingManager.LockArea area) {
                    this.println(area.getDurableLockingID());
                    this.println("   userID = " + area.getUserID());
                    this.println("   branch = " + area.getBranch());
                    this.println("   timeStamp = " + CDOCommonUtil.formatTimeStamp((long)area.getTimeStamp()));
                    this.println("   readOnly = " + area.isReadOnly());
                    this.println("   locks = " + area.getLocks());
                    return true;
                }
            });
        }
    };
    private static final CDOCommand deletelocks = new CDOCommand.WithAccessor("deletelocks", "delete a durable locking area of a repository", new CDOCommand.CommandParameter[]{CDOCommand.parameter("area-id")}){

        public void execute(InternalRepository repository, IStoreAccessor accessor, String[] args) throws Exception {
            String areaID = args[0];
            repository.getLockingManager().deleteLockArea(areaID);
        }
    };

    public CDOCommandProvider(BundleContext bundleContext) {
        bundleContext.registerService(CommandProvider.class.getName(), (Object)this, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object _cdo(CommandInterpreter interpreter) {
        try {
            Map<String, CDOCommand> commands = this.getCommands();
            String cmd = interpreter.nextArgument();
            CDOCommand command = commands.get(cmd);
            if (command == null) {
                interpreter.println((Object)this.getHelp());
                return null;
            }
            try {
                command.setInterpreter(interpreter);
                command.execute();
                return null;
            }
            finally {
                command.setInterpreter(null);
            }
        }
        catch (CDOCommand.CommandException ex) {
            interpreter.println((Object)ex.getMessage());
            return null;
        }
        catch (Exception ex) {
            interpreter.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public String getHelp() {
        StringBuilder builder = new StringBuilder();
        try {
            builder.append("---CDO commands---\r\n");
            ArrayList<CDOCommand> commands = new ArrayList<CDOCommand>(this.getCommands().values());
            Collections.sort(commands, new Comparator<CDOCommand>(){

                @Override
                public int compare(CDOCommand o1, CDOCommand o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (CDOCommand command : commands) {
                try {
                    builder.append("   ");
                    builder.append(command.getSyntax());
                    builder.append(" - ");
                    builder.append(command.getDescription());
                    builder.append(NEW_LINE);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
        return builder.toString();
    }

    public synchronized Map<String, CDOCommand> getCommands() {
        HashMap<String, CDOCommand> commands = new HashMap<String, CDOCommand>();
        this.addCommand(commands, list);
        this.addCommand(commands, start);
        this.addCommand(commands, stop);
        this.addCommand(commands, exportXML);
        this.addCommand(commands, importXML);
        this.addCommand(commands, branches);
        this.addCommand(commands, deletelocks);
        this.addCommand(commands, locks);
        this.addCommand(commands, packages);
        this.addCommand(commands, sessions);
        try {
            for (String name : IPluginContainer.INSTANCE.getFactoryTypes("org.eclipse.emf.cdo.server.commands")) {
                try {
                    CDOCommand command = this.createCommand(name);
                    this.addCommand(commands, command);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
        return commands;
    }

    protected CDOCommand createCommand(String name) {
        return (CDOCommand)((Object)IPluginContainer.INSTANCE.getElement("org.eclipse.emf.cdo.server.commands", name, null));
    }

    private void addCommand(Map<String, CDOCommand> commands, CDOCommand command) {
        commands.put(command.getName(), command);
    }
}

