/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.admin;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.ui.internal.admin.messages.Messages;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.io.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StoreType {
    private static final List<StoreType> INSTANCES = Collections.unmodifiableList(Arrays.asList(StoreType.initStoreTypes()));
    private final String id;
    private final String name;

    public StoreType(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public static List<StoreType> getInstances() {
        return INSTANCES;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public abstract String getStoreTypeID();

    public String getStoreXML(Map<String, Object> storeProperties) {
        String template = this.getTemplate();
        return this.fillTemplate(template, storeProperties);
    }

    protected abstract String fillTemplate(String var1, Map<String, Object> var2);

    protected String replaceVariables(String template, Map<String, String> variables) {
        String result = template;
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            result = result.replace("{{" + entry.getKey() + "}}", entry.getValue());
        }
        return result;
    }

    private String getTemplate() {
        URL url = this.getClass().getResource(String.valueOf(this.getStoreTypeID()) + ".template.xml");
        return IOUtil.readText((URL)url);
    }

    public String toString() {
        return this.getName();
    }

    private static StoreType[] initStoreTypes() {
        return new StoreType[]{new Database("h2", Messages.StoreType_0, "org.h2.jdbcx.JdbcDataSource", "jdbc:h2:%s")};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Database
    extends StoreType {
        public static final String PROPERTY_PATH = "path";
        public static final String PROPERTY_CONNECTION_KEEP_ALIVE_PERIOD = "connectionKeepAlivePeriod";
        public static final String DEFAULT_CONNECTION_KEEP_ALIVE_PERIOD = "60";
        public static final String PROPERTY_READER_POOL_CAPACITY = "readerPoolCapacity";
        public static final String DEFAULT_READER_POOL_CAPACITY = "15";
        public static final String PROPERTY_WRITER_POOL_CAPACITY = "writerPoolCapacity";
        public static final String DEFAULT_WRITER_POOL_CAPACITY = "15";
        private final String adapter;
        private final String dataSourceClassName;
        private final String urlPattern;

        public Database(String id, String name, String dataSourceClassName, String urlPattern) {
            super("db." + id, name);
            this.adapter = id;
            this.dataSourceClassName = dataSourceClassName;
            this.urlPattern = urlPattern;
        }

        @Override
        public String getStoreTypeID() {
            return "db";
        }

        public String getAdapter() {
            return this.adapter;
        }

        public String getDataSourceClassName() {
            return this.dataSourceClassName;
        }

        public String getDataSourceURL(String storePath) {
            return String.format(this.urlPattern, storePath);
        }

        @Override
        protected String fillTemplate(String xmlTemplate, Map<String, Object> storeProperties) {
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("adapter", this.getAdapter());
            variables.put("dataSource.class", this.getDataSourceClassName());
            variables.put("dataSource.url", this.getDataSourceURL((String)storeProperties.get(PROPERTY_PATH)));
            variables.put("keepAlive", this.defaultString(storeProperties, PROPERTY_CONNECTION_KEEP_ALIVE_PERIOD, DEFAULT_CONNECTION_KEEP_ALIVE_PERIOD));
            variables.put("readerPool", this.defaultString(storeProperties, PROPERTY_READER_POOL_CAPACITY, "15"));
            variables.put("writerPool", this.defaultString(storeProperties, PROPERTY_WRITER_POOL_CAPACITY, "15"));
            return this.replaceVariables(xmlTemplate, variables);
        }

        private String defaultString(Map<String, Object> storeProperties, String key, String defaultValue) {
            String value = (String)storeProperties.get(key);
            return StringUtil.isEmpty((String)value) ? defaultValue : value;
        }
    }
}

