/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lookup;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.PrecedenceBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TypeModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public abstract class AbstractOTReferenceBinding
extends TypeBinding {
    public int modifiers;
    private boolean isBoundBase = false;
    private boolean isRolish = false;
    public ReferenceBinding baseclass;
    public CallinCalloutBinding[] callinCallouts;
    public PrecedenceBinding[] precedences = PrecedenceBinding.NoPrecedences;
    public TypeModel model;
    public RoleModel roleModel;
    public TeamModel _teamModel;
    public PackageBinding.TeamPackageBinding teamPackage;

    public abstract ReferenceBinding[] memberTypes();

    @Override
    public abstract ReferenceBinding superclass();

    public abstract boolean isBinaryBinding();

    @Override
    public abstract int depth();

    protected abstract ReferenceBinding _this();

    public AbstractOTReferenceBinding(ReferenceBinding prototype) {
        super(prototype);
    }

    protected AbstractOTReferenceBinding() {
    }

    public boolean isBoundBase() {
        if (this.isBoundBase) {
            return true;
        }
        if ((this.tagBits & 0x20000L) != 0L) {
            return false;
        }
        if (this.isInterface()) {
            ReferenceBinding[] referenceBindingArray = this._this().superInterfaces();
            int n = referenceBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceBinding superInterface = referenceBindingArray[n2];
                if (superInterface != null && superInterface.isBoundBase()) {
                    return true;
                }
                ++n2;
            }
        } else if (this.superclass() != null) {
            return this.superclass().isBoundBase();
        }
        return false;
    }

    public void setIsBoundBase(ReferenceBinding roleType) {
        this.isBoundBase = true;
    }

    public void setIsRoleLocal() {
        this.isRolish = true;
        if (this.roleModel == null) {
            this.roleModel = new RoleModel((ReferenceBinding)this);
        }
    }

    public TeamModel getTeamModel() {
        if (this._teamModel == null && this.isRole()) {
            this._teamModel = this.roleModel.getTeamModelOfThis();
        }
        return this._teamModel;
    }

    public void setTeamModel(TeamModel teamModel) {
        this._teamModel = teamModel;
    }

    public CallinCalloutBinding[] allCallins() {
        HashSet<CallinCalloutBinding> cpInhSrcs = new HashSet<CallinCalloutBinding>();
        HashMap<String, CallinCalloutBinding> callins = this.internalGetCallins(cpInhSrcs);
        CallinCalloutBinding[] result = new CallinCalloutBinding[callins.size()];
        callins.values().toArray(result);
        return result;
    }

    HashMap<String, CallinCalloutBinding> internalGetCallins(HashSet<CallinCalloutBinding> cpInhSrcs) {
        HashMap<String, CallinCalloutBinding> callins = new HashMap<String, CallinCalloutBinding>();
        ReferenceBinding superRole = this.superclass();
        if (superRole != null && superRole.isRole()) {
            callins.putAll(superRole.internalGetCallins(cpInhSrcs));
        }
        if (this.callinCallouts != null) {
            int i = 0;
            while (i < this.callinCallouts.length) {
                CallinCalloutBinding callinBinding = this.callinCallouts[i];
                if (callinBinding.type == 1 && !cpInhSrcs.contains(callinBinding.getOrigin())) {
                    cpInhSrcs.add(callinBinding.getOrigin());
                    callins.put(new String(callinBinding.getQualifiedName()), callinBinding);
                }
                ++i;
            }
        }
        ReferenceBinding[] memberTypes = this.memberTypes();
        int i = 0;
        while (i < memberTypes.length) {
            callins.putAll(memberTypes[i].internalGetCallins(cpInhSrcs));
            ++i;
        }
        return callins;
    }

    protected void maybeSetTeamPackage(char[][] compoundName, PackageBinding parentPackage, LookupEnvironment environment, ModuleBinding enclosingModule) {
        if (this.isTeam()) {
            Object packageName;
            char[][] segments = CharOperation.splitOn('$', compoundName[compoundName.length - 1]);
            int segLength = segments.length;
            if (segLength > 1) {
                int packLength = parentPackage.compoundName.length;
                packageName = new char[packLength + segLength - 1][];
                System.arraycopy(parentPackage.compoundName, 0, packageName, 0, packLength);
                System.arraycopy(segments, 0, packageName, packLength, segLength - 1);
            } else {
                packageName = parentPackage.compoundName;
            }
            if (environment.nameEnvironment.isPackage((char[][])packageName, this.sourceName())) {
                this.teamPackage = new PackageBinding.TeamPackageBinding(compoundName, parentPackage, environment, enclosingModule);
            }
        }
    }

    public void addCallinCallouts(CallinCalloutBinding[] mappings) {
        if (this.callinCallouts == null) {
            this.callinCallouts = mappings;
        } else {
            int oldLen = this.callinCallouts.length;
            int addLen = mappings.length;
            CallinCalloutBinding[] newMappings = new CallinCalloutBinding[oldLen + addLen];
            System.arraycopy(this.callinCallouts, 0, newMappings, 0, oldLen);
            System.arraycopy(mappings, 0, newMappings, oldLen, addLen);
            this.callinCallouts = newMappings;
        }
    }

    @Override
    public final boolean isTeam() {
        if ((this.modifiers & 0x4000000) != 0) {
            return true;
        }
        if (TypeAnalyzer.isOrgObjectteamsTeam(this._this())) {
            if (this._teamModel == null) {
                this.setupOrgObjectteamsTeamModel();
            }
            return true;
        }
        return false;
    }

    protected void setupOrgObjectteamsTeamModel() {
        assert (!this.isBinaryBinding());
        TypeDeclaration teamDecl = ((SourceTypeBinding)this).scope.referenceContext;
        teamDecl.modifiers |= 0x4000000;
        this._teamModel = teamDecl.getTeamModel();
        this._teamModel.setBinding(this._this());
        if (this.model != null) {
            this._teamModel.setState(this.model.getState());
        }
        TypeDeclaration[] memberTypes = teamDecl.memberTypes;
        TypeDeclaration confinedClass = null;
        TypeDeclaration confinedIfc = null;
        int i = 0;
        while (i < memberTypes.length) {
            memberTypes[i].modifiers |= 0x1000000;
            RoleModel memberRole = memberTypes[i].getRoleModel(this._teamModel);
            if (memberTypes[i].getModel() != null) {
                memberRole.setState(memberTypes[i].getModel().getState());
            }
            if (CharOperation.equals(memberTypes[i].name, IOTConstants.OTCONFINED)) {
                confinedClass = memberTypes[i];
            } else if (CharOperation.equals(memberTypes[i].name, IOTConstants.CONFINED)) {
                confinedIfc = memberTypes[i];
            }
            ++i;
        }
        if (confinedClass == null || confinedIfc == null) {
            throw new InternalCompilerError("required type Team.Confined not found");
        }
        confinedClass.getRoleModel()._interfacePart = confinedIfc;
        confinedIfc.getRoleModel()._classPart = confinedClass;
    }

    @Override
    public boolean isRole() {
        if (this.isEnum()) {
            return false;
        }
        if ((this.modifiers & 0x1000000) != 0) {
            return true;
        }
        if (this.isRolish) {
            return true;
        }
        ReferenceBinding enclosingTeam = TeamModel.getEnclosingTeam(this._this());
        if (enclosingTeam == null) {
            return false;
        }
        if (this.isLocalType() && this.depth() - enclosingTeam.depth() == 1 && !enclosingTeam.isRole()) {
            return false;
        }
        this.isRolish = true;
        return true;
    }

    public boolean isSourceRole() {
        return (this.modifiers & 0x1000000) != 0 && !this.isSynthInterface();
    }

    public boolean isDirectRole() {
        return (this.modifiers & 0x1000000) != 0;
    }

    public boolean isRegularInterface() {
        return (this.modifiers & 0x1200) == 512;
    }

    public boolean isSynthInterface() {
        return (this.modifiers & 0x1200) == 4608;
    }

    public void unrolify(TypeDeclaration ast) {
        this.isRolish = false;
        this.modifiers &= 0xFEFFFFFF;
        if (ast != null) {
            ast.modifiers &= 0xFEFFFFFF;
        }
        int state = this.roleModel.getState();
        this.model.setState(state);
        ReferenceBinding interfaceBinding = this.roleModel.getInterfacePartBinding();
        if (this.isClass() && interfaceBinding != null) {
            interfaceBinding.unrolify(this.roleModel.getInterfaceAst());
        }
    }

    public ReferenceBinding baseclass() {
        return this.baseclass;
    }

    public ReferenceBinding rawBaseclass() {
        return this.baseclass();
    }

    protected abstract boolean implementsMethod(MethodBinding var1);
}

