/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.dtfj;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DTFJException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageFactory;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.ImageStackFrame;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaLocation;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaReference;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaStackFrame;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.java.JavaVMOption;
import com.ibm.dtfj.runtime.ManagedRuntime;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.Modifier;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayLong;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.collect.HashMapIntLong;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.HashMapLongObject;
import org.eclipse.mat.collect.IteratorInt;
import org.eclipse.mat.collect.IteratorLong;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.collect.SetLong;
import org.eclipse.mat.dtfj.InitDTFJ;
import org.eclipse.mat.dtfj.MessageFormat;
import org.eclipse.mat.dtfj.Messages;
import org.eclipse.mat.parser.IIndexBuilder;
import org.eclipse.mat.parser.IPreliminaryIndex;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.index.IndexManager;
import org.eclipse.mat.parser.index.IndexReader;
import org.eclipse.mat.parser.index.IndexWriter;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.parser.model.XGCRootInfo;
import org.eclipse.mat.parser.model.XSnapshotInfo;
import org.eclipse.mat.snapshot.MultipleSnapshotsException;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.FieldDescriptor;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DTFJIndexBuilder
implements IIndexBuilder {
    static final String METHOD = "<method>";
    private static final String METHOD_TYPE = "<method type>";
    static final String STACK_FRAME = "<stack frame>";
    private static final String NATIVE_MEMORY = "<native memory>";
    private static final String NATIVE_MEMORY_TYPE = "<native memory type>";
    static final String STACK_DEPTH = "stackDepth";
    static final String FRAME_NUMBER = "frameNumber";
    static final String LOCATION_ADDRESS = "locationAddress";
    static final String COMPILATION_LEVEL = "compilationLevel";
    static final String LINE_NUMBER = "lineNumber";
    private static final String DECLARING_CLASS = "declaringClass";
    static final String METHOD_NAME = "methodName";
    static final String FILE_NAME = "fileName";
    static final String METHOD_NAME_PREFIX = ".";
    static final String METHOD_NAME_SIG = "(";
    private static final String PLUGIN_ID = InitDTFJ.getDefault().getBundle().getSymbolicName();
    static final String RUNTIME_ID_KEY = "$runtimeId";
    private static final int ARRAY_PIECE_SIZE = 100000;
    private static final int NATIVE_STACK_FRAME_SIZE = 2048;
    private static final int JAVA_STACK_FRAME_SIZE = 256;
    private static final long JAVA_STACK_SECTION_MAX_SIZE = 0x100000L;
    private static final long NATIVE_STACK_SECTION_MAX_SIZE = 0x100000L;
    private static final boolean haveDTFJRoots = true;
    private static final boolean useDTFJRoots = true;
    private boolean haveDTFJRefs = false;
    private boolean useDTFJRefs = false;
    private static final boolean useThreadRefsNotRoots = true;
    private static final boolean presumeRoots = false;
    private static final boolean markAllLoaders = false;
    private static final boolean useSystemClassRoots = true;
    private static final boolean skipWeakRoots = true;
    private static final boolean fixBadSuperclass = false;
    private static final boolean faultyMethodEquals = false;
    private final String methodsAsClassesPref = Platform.getPreferencesService().getString(PLUGIN_ID, "methodsAsClasses", "", null);
    private final boolean suppressClassNativeSizes = Platform.getPreferencesService().getBoolean(PLUGIN_ID, "suppressClassNativeSizes", false, null);
    private final boolean getExtraInfo2 = "all".equals(this.methodsAsClassesPref);
    private final boolean getExtraInfo3 = "frames".equals(this.methodsAsClassesPref);
    private final boolean getExtraInfo = this.getExtraInfo2 || this.getExtraInfo3 || "running".equals(this.methodsAsClassesPref);
    private static final String JAVA_LANG_CLASS = "java/lang/Class";
    private static final String JAVA_LANG_CLASSLOADER = "java/lang/ClassLoader";
    private static final boolean guessFinalizables = true;
    private static final boolean debugInfo = InitDTFJ.getDefault().isDebugging();
    private static final IProgressListener.Severity Severity_INFO = debugInfo ? IProgressListener.Severity.ERROR : IProgressListener.Severity.INFO;
    private static final IProgressListener.Severity Severity_WARNING = debugInfo ? IProgressListener.Severity.ERROR : IProgressListener.Severity.WARNING;
    private static final int errorCount = debugInfo ? DTFJIndexBuilder.getDebugOption("org.eclipse.mat.dtfj/errorCount", 20) : 20;
    private static final boolean verbose = InitDTFJ.getDefault().isDebugging() && DTFJIndexBuilder.getDebugOption("org.eclipse.mat.dtfj/debug/verbose", false);
    private static final int INDEX_COUNT_FOR_TEMPFILE = 5000000;
    private File dump;
    private String pfx;
    private String runtimeId;
    private RuntimeInfo dtfjInfo;
    private IndexWriter.IntArray1NWriter outRefs;
    private ObjectToSize indexToSize;
    private IIndexReader.IOne2SizeIndex arrayToSize;
    private IndexWriter.Identifier indexToAddress0;
    private IIndexReader.IOne2LongIndex indexToAddress;
    private IndexWriter.IntIndexCollector objectToClass;
    private IIndexReader.IOne2OneIndex objectToClass1;
    private HashMapIntObject<ClassImpl> idToClass;
    private HashMapIntObject<List<XGCRootInfo>> gcRoot;
    private HashMapIntObject<HashMapIntObject<List<XGCRootInfo>>> threadRoots;
    private boolean foundFinalizableGCRoots = false;
    private int modifiersFound;
    private int addressSpacePointerSize;
    private boolean compressedRefs;
    private HashMap<JavaClass, Long> dummyClassAddress = new HashMap();
    private HashMap<JavaMethod, Long> dummyMethodAddress = new HashMap();
    private IdentityHashMap<JavaMethod, Long> dummyMethodAddress2 = new IdentityHashMap();
    private HashMapLongObject<JavaMethod> methodAddresses = new HashMapLongObject();
    private long nextClassAddress = 0x1000000080000000L;
    HashMapIntObject<ArrayLong> loaderClassCache;
    private HashMapIntObject<String> missedRoots;
    private HashMapIntObject<ClassImpl> idToClass2;
    private IndexWriter.IntIndexCollector objectToClass2;
    private ObjectToSize objectToSize2;
    private int msgNgetRefsMissing = errorCount;
    private int msgNgetRefsExtra = errorCount;
    private int msgNarrayRefsNPE = errorCount;
    private int msgNgetRefsUnavailable = errorCount;
    private int msgNgetRefsCorrupt = errorCount;
    private int msgNbigSegs = errorCount;
    private int msgNinvalidArray = errorCount;
    private int msgNinvalidObj = errorCount;
    private int msgNbrokenEquals = errorCount;
    private int msgNbrokenInterfaceSuper = errorCount;
    private int msgNmissingLoaderMsg = errorCount;
    private int msgNcorruptCount = errorCount;
    private int msgNrootsWarning = errorCount;
    private int msgNguessFinalizable = errorCount;
    private int msgNgetRefsAllMissing = errorCount;
    private int msgNgetSuperclass = errorCount;
    private int msgNnullThreadObject = errorCount;
    private int msgNbadThreadInfo = errorCount;
    private int msgNunexpectedModifiers = errorCount;
    private int msgNcorruptSection = errorCount;
    private int msgNclassForObject = errorCount;
    private int msgNcomponentClass = errorCount;
    private int msgNtypeForClassObject = errorCount;
    private int msgNobjectSize = errorCount;
    private int msgNoutboundReferences = errorCount;
    private int msgNnoSuperClassForArray = errorCount;
    private int msgNproblemReadingJavaStackFrame = errorCount;
    private static final String[] primitives = new String[]{Boolean.TYPE.getName(), Byte.TYPE.getName(), Short.TYPE.getName(), Character.TYPE.getName(), Integer.TYPE.getName(), Long.TYPE.getName(), Float.TYPE.getName(), Double.TYPE.getName(), Void.TYPE.getName()};
    private static final HashSet<String> primSet = new HashSet<String>(Arrays.asList(primitives));

    public void cancel() {
        if (this.dtfjInfo != null) {
            DumpCache.releaseDump(this.dump, this.dtfjInfo, true);
        }
        if (this.outRefs != null) {
            this.outRefs.cancel();
            this.outRefs = null;
        }
        if (this.arrayToSize != null) {
            try {
                this.arrayToSize.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.arrayToSize.delete();
            this.arrayToSize = null;
        }
        this.indexToAddress0 = null;
        if (this.indexToAddress != null) {
            try {
                this.indexToAddress.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.indexToAddress.delete();
            this.indexToAddress = null;
        }
        this.objectToClass = null;
        if (this.objectToClass1 != null) {
            try {
                this.objectToClass1.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.objectToClass1.delete();
            this.objectToClass1 = null;
        }
        this.idToClass = null;
        if (this.objectToClass2 != null) {
            try {
                this.objectToClass2.close();
                this.objectToClass2.delete();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.objectToClass2 = null;
        }
        this.idToClass2 = null;
        this.objectToSize2 = null;
    }

    public void clean(int[] purgedMapping, IProgressListener listener) throws IOException {
        if (purgedMapping == null) {
            listener.sendUserMessage(IProgressListener.Severity.ERROR, Messages.DTFJIndexBuilder_NullPurgedMapping, null);
            return;
        }
        listener.beginTask(Messages.DTFJIndexBuilder_PurgingDeadObjectsFromImage, purgedMapping.length / 10000);
        int count = 0;
        long memFree = 0L;
        int i = 0;
        while (i < purgedMapping.length) {
            if (i % 10000 == 0) {
                listener.worked(1);
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
            }
            if (purgedMapping[i] == -1) {
                ++count;
                if (this.objectToSize2 != null) {
                    long objSize = this.objectToSize2.getSize(i);
                    memFree += objSize;
                    if (verbose) {
                        int type = this.objectToClass2.get(i);
                        if (debugInfo) {
                            DTFJIndexBuilder.debugPrint("Purging " + i + " size " + objSize + " type " + type + " " + this.idToClass2.get(type));
                        }
                    }
                }
                if (this.missedRoots != null && this.missedRoots.containsKey(i) && debugInfo) {
                    DTFJIndexBuilder.debugPrint("Alternative roots would have found root " + i + " " + (String)this.missedRoots.get(i));
                }
            }
            ++i;
        }
        if (debugInfo) {
            listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_PurgedIdentifiers, count, memFree), null);
        }
        this.objectToSize2 = null;
        this.missedRoots = null;
        DumpCache.releaseDump(this.dump, this.dtfjInfo, false);
        listener.done();
    }

    public void fill(IPreliminaryIndex index, IProgressListener listener) throws SnapshotException, IOException {
        String msg;
        Iterator j;
        SetInt newRoots;
        long claddr;
        JavaClass sup;
        int pseudoClasses;
        long clsaddr;
        Object next;
        long then1 = System.currentTimeMillis();
        int workCount = 10000;
        int workObjectsStep = 10000;
        listener.beginTask(MessageFormat.format(Messages.DTFJIndexBuilder_ProcessingImageFromFile, this.dump), 10000);
        int workCountSoFar = 0;
        XSnapshotInfo ifo = index.getSnapshotInfo();
        DumpCache.clearCachedDump(this.dump);
        Serializable dumpType = ifo.getProperty("$heapFormat");
        this.dtfjInfo = DumpCache.getDump(this.dump, dumpType);
        long now1 = System.currentTimeMillis();
        listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_TookmsToGetImageFromFile, now1 - then1, this.dump, dumpType), null);
        try {
            ifo.setCreationDate(new Date(this.dtfjInfo.getImage().getCreationTime()));
        }
        catch (DataUnavailable e) {
            listener.sendUserMessage(IProgressListener.Severity.WARNING, Messages.DTFJIndexBuilder_NoDateInImage, (Throwable)e);
        }
        listener.worked(1);
        ++workCountSoFar;
        listener.subTask(Messages.DTFJIndexBuilder_FindingJVM);
        Serializable rtId = ifo.getProperty(RUNTIME_ID_KEY);
        if (rtId instanceof String && !rtId.equals("")) {
            this.runtimeId = (String)((Object)rtId);
        }
        this.dtfjInfo = DTFJIndexBuilder.getRuntime(this.dtfjInfo.getImageFactory(), this.dtfjInfo.getImage(), (Serializable)((Object)this.runtimeId), listener);
        String actualRuntimeId = this.dtfjInfo.getRuntimeId();
        if (actualRuntimeId != null) {
            ifo.setProperty(RUNTIME_ID_KEY, (Serializable)((Object)actualRuntimeId));
            listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_DTFJJavaRuntime, actualRuntimeId), null);
        }
        try {
            ifo.setJvmInfo(this.dtfjInfo.getJavaRuntime().getVersion());
            listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_JVMVersion, ifo.getJvmInfo()), null);
        }
        catch (CorruptDataException e) {
            listener.sendUserMessage(IProgressListener.Severity.WARNING, Messages.DTFJIndexBuilder_NoRuntimeVersionFound, (Throwable)e);
            try {
                ifo.setJvmInfo(this.dtfjInfo.getJavaRuntime().getFullVersion());
                listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_JVMFullVersion, ifo.getJvmInfo()), null);
            }
            catch (CorruptDataException e2) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, Messages.DTFJIndexBuilder_NoRuntimeFullVersionFound, (Throwable)e2);
            }
        }
        int pointerSize = this.getPointerSize(this.dtfjInfo, listener);
        ifo.setIdentifierSize(this.getPointerBytes(pointerSize));
        listener.worked(1);
        ++workCountSoFar;
        listener.subTask(Messages.DTFJIndexBuilder_Pass1);
        this.indexToAddress0 = new IndexWriter.Identifier();
        long lastAddress = 0L;
        Iterator i = this.dtfjInfo.getJavaRuntime().getHeaps();
        while (i.hasNext()) {
            Object next2 = i.next();
            if (DTFJIndexBuilder.isCorruptData(next2, listener, Messages.DTFJIndexBuilder_CorruptDataReadingHeaps, this.dtfjInfo.getJavaRuntime())) continue;
            JavaHeap jh = (JavaHeap)next2;
            Iterator i2 = jh.getSections();
            while (i2.hasNext()) {
                Object next22 = i2.next();
                if (DTFJIndexBuilder.isCorruptData(next22, listener, Messages.DTFJIndexBuilder_CorruptDataReadingHeapSections, this.dtfjInfo.getJavaRuntime()) && !(next22 instanceof ImageSection)) continue;
                ImageSection is = (ImageSection)next22;
                long endAddr = is.getBaseAddress().add(is.getSize()).getAddress();
                lastAddress = Math.max(lastAddress, endAddr);
            }
        }
        if (lastAddress != 0L) {
            this.nextClassAddress = lastAddress + 7L & 0xFFFFFFFFFFFFFFF8L;
        }
        listener.worked(1);
        ++workCountSoFar;
        listener.subTask(Messages.DTFJIndexBuilder_FindingClassLoaders);
        JavaObject bootLoaderObject = null;
        JavaClassLoader bootLoader = null;
        long bootLoaderAddress = 0L;
        long fixedBootLoaderAddress = 0L;
        ClassImpl bootLoaderType = null;
        boolean foundBootLoader = false;
        HashMap<JavaObject, JavaClassLoader> loaders = new HashMap<JavaObject, JavaClassLoader>();
        HashSet<JavaClass> loaderTypes = new HashSet<JavaClass>();
        Iterator i2 = this.dtfjInfo.getJavaRuntime().getJavaClassLoaders();
        while (i2.hasNext()) {
            Object next3 = i2.next();
            if (DTFJIndexBuilder.isCorruptData(next3, listener, Messages.DTFJIndexBuilder_CorruptDataReadingClassLoaders1, this.dtfjInfo.getJavaRuntime())) continue;
            JavaClassLoader jcl = (JavaClassLoader)next3;
            long loaderAddress = 0L;
            try {
                JavaClassLoader jcl2;
                JavaObject loaderObject = jcl.getObject();
                loaders.put(loaderObject, jcl);
                if (loaderObject == null) {
                    if (debugInfo) {
                        DTFJIndexBuilder.debugPrint("Found class loader with null Java object " + jcl);
                    }
                    if (foundBootLoader) continue;
                    bootLoader = jcl;
                    bootLoaderObject = loaderObject;
                    bootLoaderAddress = 0L;
                    fixedBootLoaderAddress = this.fixBootLoaderAddress(bootLoaderAddress, bootLoaderAddress);
                    if (debugInfo) {
                        DTFJIndexBuilder.debugPrint("adding boot loader object at " + DTFJIndexBuilder.format(bootLoaderAddress));
                    }
                    foundBootLoader = true;
                    continue;
                }
                loaderAddress = loaderObject.getID().getAddress();
                if (bootLoader == null) {
                    bootLoader = jcl;
                    bootLoaderObject = loaderObject;
                    bootLoaderAddress = loaderAddress;
                    fixedBootLoaderAddress = this.fixBootLoaderAddress(bootLoaderAddress, bootLoaderAddress);
                    if (debugInfo) {
                        DTFJIndexBuilder.debugPrint("adding potential boot loader object at " + DTFJIndexBuilder.format(bootLoaderAddress));
                    }
                }
                JavaClass loaderObjectClass = loaderObject.getJavaClass();
                loaderTypes.add(loaderObjectClass);
                String loaderClassName = this.getClassName(loaderObjectClass, listener);
                if (loaderClassName.equals("*System*")) {
                    if (debugInfo) {
                        DTFJIndexBuilder.debugPrint("Found class loader of type *System* " + jcl);
                    }
                    if (foundBootLoader) continue;
                    bootLoader = jcl;
                    bootLoaderObject = loaderObject;
                    bootLoaderAddress = loaderAddress;
                    fixedBootLoaderAddress = this.fixBootLoaderAddress(bootLoaderAddress, bootLoaderAddress);
                    if (debugInfo) {
                        DTFJIndexBuilder.debugPrint("adding boot loader object at " + DTFJIndexBuilder.format(bootLoaderAddress));
                    }
                    foundBootLoader = true;
                    continue;
                }
                if (debugInfo) {
                    DTFJIndexBuilder.debugPrint("Found class loader " + loaderClassName + " at " + DTFJIndexBuilder.format(loaderAddress));
                }
                if (jcl.equals((Object)(jcl2 = this.getClassLoader(loaderObjectClass, listener)))) {
                    if (debugInfo) {
                        DTFJIndexBuilder.debugPrint("Found class loader which loaded itself " + loaderClassName + " at " + DTFJIndexBuilder.format(loaderAddress));
                    }
                    if (foundBootLoader) continue;
                    bootLoader = jcl;
                    bootLoaderObject = loaderObject;
                    bootLoaderAddress = loaderAddress;
                    fixedBootLoaderAddress = this.fixBootLoaderAddress(bootLoaderAddress, bootLoaderAddress);
                    if (debugInfo) {
                        DTFJIndexBuilder.debugPrint("adding boot loader object at " + DTFJIndexBuilder.format(bootLoaderAddress));
                    }
                    foundBootLoader = true;
                    continue;
                }
                if (!debugInfo) continue;
                DTFJIndexBuilder.debugPrint("Found other class loader " + loaderClassName + " at " + DTFJIndexBuilder.format(loaderAddress));
            }
            catch (CorruptDataException e) {
                listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemFindingClassLoaderInformation, DTFJIndexBuilder.format(loaderAddress)), (Throwable)e);
            }
        }
        if (bootLoader == null) {
            fixedBootLoaderAddress = this.fixBootLoaderAddress(bootLoaderAddress, bootLoaderAddress);
            this.indexToAddress0.add(fixedBootLoaderAddress);
            if (debugInfo) {
                DTFJIndexBuilder.debugPrint("No boot class loader found so adding dummy boot class loader object at " + DTFJIndexBuilder.format(fixedBootLoaderAddress));
            }
        } else if (bootLoaderObject == null) {
            this.indexToAddress0.add(fixedBootLoaderAddress);
        }
        AbstractSet allClasses = new LinkedHashSet<JavaClass>();
        listener.worked(1);
        ++workCountSoFar;
        listener.subTask(Messages.DTFJIndexBuilder_FindingClasses);
        Iterator i3 = this.dtfjInfo.getJavaRuntime().getJavaClassLoaders();
        while (i3.hasNext()) {
            Object next4 = i3.next();
            if (DTFJIndexBuilder.isCorruptData(next4, listener, Messages.DTFJIndexBuilder_CorruptDataReadingClassLoaders, this.dtfjInfo.getJavaRuntime())) continue;
            JavaClassLoader jcl = (JavaClassLoader)next4;
            Iterator j2 = jcl.getDefinedClasses();
            while (j2.hasNext()) {
                Object next2 = j2.next();
                if (DTFJIndexBuilder.isCorruptData(next2, listener, Messages.DTFJIndexBuilder_CorruptDataReadingClasses, jcl)) continue;
                JavaClass j22 = (JavaClass)next2;
                this.rememberClass(j22, allClasses, listener);
            }
        }
        listener.worked(1);
        ++workCountSoFar;
        listener.subTask(Messages.DTFJIndexBuilder_FindingObjects);
        int objProgress = 0;
        int s2 = this.indexToAddress0.size();
        Iterator i4 = this.dtfjInfo.getJavaRuntime().getHeaps();
        while (i4.hasNext()) {
            Object next5 = i4.next();
            if (DTFJIndexBuilder.isCorruptData(next5, listener, Messages.DTFJIndexBuilder_CorruptDataReadingHeaps, this.dtfjInfo.getJavaRuntime())) continue;
            JavaHeap jh = (JavaHeap)next5;
            Iterator j3 = jh.getObjects();
            while (j3.hasNext()) {
                Object next2 = j3.next();
                if (DTFJIndexBuilder.isCorruptData(next2, listener, Messages.DTFJIndexBuilder_CorruptDataReadingObjects, this.dtfjInfo.getJavaRuntime())) continue;
                JavaObject jo = (JavaObject)next2;
                if (++objProgress % 10000 == 0) {
                    listener.worked(1);
                    ++workCountSoFar;
                    if (listener.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                }
                long objAddress = jo.getID().getAddress();
                objAddress = this.fixBootLoaderAddress(bootLoaderAddress, objAddress);
                this.rememberObject(jo, objAddress, allClasses, listener);
            }
        }
        int nobj = this.indexToAddress0.size() - s2;
        if (debugInfo) {
            DTFJIndexBuilder.debugPrint("Objects on heap " + nobj);
        }
        listener.worked(1);
        ++workCountSoFar;
        listener.subTask(Messages.DTFJIndexBuilder_FindingClassesCachedByClassLoaders);
        Iterator i5 = this.dtfjInfo.getJavaRuntime().getJavaClassLoaders();
        while (i5.hasNext()) {
            Object next6 = i5.next();
            if (DTFJIndexBuilder.isCorruptData(next6, listener, Messages.DTFJIndexBuilder_CorruptDataReadingClassLoaders, this.dtfjInfo.getJavaRuntime())) continue;
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            JavaClassLoader jcl = (JavaClassLoader)next6;
            Iterator j4 = jcl.getCachedClasses();
            while (j4.hasNext()) {
                JavaClass j2;
                Object next2 = j4.next();
                if (DTFJIndexBuilder.isCorruptData(next2, listener, Messages.DTFJIndexBuilder_CorruptDataReadingCachedClasses, jcl) || allClasses.contains(j2 = (JavaClass)next2)) continue;
                try {
                    String className = j2.getName();
                    listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_AddingExtraClassViaCachedList, className), null);
                }
                catch (CorruptDataException e) {
                    listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_AddingExtraClassOfUnknownNameViaCachedList, j2), (Throwable)e);
                }
                this.rememberClass(j2, allClasses, listener);
            }
        }
        if (this.indexToAddress0.size() > 0) {
            this.indexToAddress0.sort();
        }
        LinkedHashSet<JavaMethod> allMethods = new LinkedHashSet<JavaMethod>();
        LinkedHashMap<Long, Long> allFrames = new LinkedHashMap<Long, Long>();
        HashMapLongObject missingObjects = new HashMapLongObject();
        listener.worked(1);
        ++workCountSoFar;
        listener.subTask(Messages.DTFJIndexBuilder_FindingThreadObjectsMissingFromHeap);
        Iterator i6 = this.dtfjInfo.getJavaRuntime().getThreads();
        while (i6.hasNext()) {
            JavaObject threadObject;
            next = i6.next();
            if (DTFJIndexBuilder.isCorruptData(next, listener, Messages.DTFJIndexBuilder_CorruptDataReadingThreads, this.dtfjInfo.getJavaRuntime())) continue;
            JavaThread th = (JavaThread)next;
            try {
                threadObject = th.getObject();
            }
            catch (CorruptDataException e) {
                threadObject = null;
            }
            long threadAddress = DTFJIndexBuilder.getThreadAddress(th, listener);
            if (threadAddress != 0L && this.indexToAddress0.reverse(threadAddress) < 0) {
                missingObjects.put(threadAddress, (Object)threadObject);
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ThreadObjectNotFound, DTFJIndexBuilder.format(threadAddress)), null);
            }
            if (!this.getExtraInfo) continue;
            int frameId = 0;
            long prevFrameAddress = 0L;
            Iterator ii = th.getStackFrames();
            while (ii.hasNext()) {
                block183: {
                    Object next2 = ii.next();
                    if (!DTFJIndexBuilder.isCorruptData(next2, listener, Messages.DTFJIndexBuilder_CorruptDataReadingJavaStackFrames, th)) {
                        JavaStackFrame jf = (JavaStackFrame)next2;
                        if (listener.isCanceled()) {
                            throw new IProgressListener.OperationCanceledException();
                        }
                        JavaLocation jl = null;
                        try {
                            long frameAddress;
                            jl = jf.getLocation();
                            JavaMethod jm = jl.getMethod();
                            prevFrameAddress = frameAddress = DTFJIndexBuilder.getFrameAddress(jf, prevFrameAddress, pointerSize);
                            if (frameAddress == 0L) break block183;
                            if (this.indexToAddress0.reverse(frameAddress) < 0) {
                                String oldMethodName;
                                String newMethodName;
                                long methodAddress = this.getMethodAddress(jm, listener);
                                if (!allFrames.containsKey(frameAddress)) {
                                    if (!this.getExtraInfo3) {
                                        allMethods.add(jm);
                                    }
                                    allFrames.put(frameAddress, methodAddress);
                                    break block183;
                                }
                                try {
                                    newMethodName = DTFJIndexBuilder.getMethodName(jm, listener);
                                }
                                catch (CorruptDataException e) {
                                    newMethodName = DTFJIndexBuilder.format(methodAddress);
                                }
                                long oldMethodAddress = (Long)allFrames.get(frameAddress);
                                try {
                                    JavaMethod oldJm = (JavaMethod)this.methodAddresses.get(((Long)allFrames.get(frameAddress)).longValue());
                                    oldMethodName = oldJm != null ? DTFJIndexBuilder.getMethodName(oldJm, listener) : DTFJIndexBuilder.format(oldMethodAddress);
                                }
                                catch (CorruptDataException e) {
                                    oldMethodName = DTFJIndexBuilder.format((Long)allFrames.get(oldMethodAddress));
                                }
                                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_DuplicateJavaStackFrame, frameId, DTFJIndexBuilder.format(frameAddress), newMethodName, oldMethodName, DTFJIndexBuilder.format(threadAddress)), null);
                                break block183;
                            }
                            listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_IgnoringJavaStackFrame, frameId, DTFJIndexBuilder.format(frameAddress), DTFJIndexBuilder.format(threadAddress)), null);
                        }
                        catch (CorruptDataException e) {
                            if (jl != null) {
                                if (this.msgNproblemReadingJavaStackFrame-- > 0) {
                                    listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemReadingJavaStackFrameLocation, frameId, jl, DTFJIndexBuilder.format(threadAddress)), (Throwable)e);
                                }
                            }
                            if (this.msgNproblemReadingJavaStackFrame-- <= 0) break block183;
                            listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemReadingJavaStackFrame, frameId, DTFJIndexBuilder.format(threadAddress)), (Throwable)e);
                        }
                    }
                }
                ++frameId;
            }
        }
        listener.worked(1);
        ++workCountSoFar;
        listener.subTask(Messages.DTFJIndexBuilder_FindingMonitorObjects);
        i6 = this.dtfjInfo.getJavaRuntime().getMonitors();
        while (i6.hasNext()) {
            long monitorAddress;
            JavaMonitor jm;
            JavaObject obj;
            next = i6.next();
            if (DTFJIndexBuilder.isCorruptData(next, listener, Messages.DTFJIndexBuilder_CorruptDataReadingMonitors, this.dtfjInfo.getJavaRuntime()) || (obj = (jm = (JavaMonitor)next).getObject()) == null || this.indexToAddress0.reverse(monitorAddress = obj.getID().getAddress()) >= 0) continue;
            missingObjects.put(monitorAddress, (Object)obj);
            listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_MonitorObjectNotFound, DTFJIndexBuilder.format(monitorAddress)), null);
        }
        listener.worked(1);
        ++workCountSoFar;
        listener.subTask(Messages.DTFJIndexBuilder_FindingClassLoaderObjects);
        for (JavaObject obj : loaders.keySet()) {
            if (obj == null) continue;
            long loaderAddress = obj.getID().getAddress();
            if (this.indexToAddress0.reverse(loaderAddress = this.fixBootLoaderAddress(bootLoaderAddress, loaderAddress)) >= 0) continue;
            missingObjects.put(loaderAddress, (Object)obj);
            try {
                String type = this.getClassName(obj.getJavaClass(), listener);
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ClassLoaderObjectNotFoundType, DTFJIndexBuilder.format(loaderAddress), type), null);
            }
            catch (CorruptDataException e) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ClassLoaderObjectNotFound, DTFJIndexBuilder.format(loaderAddress)), (Throwable)e);
            }
        }
        listener.worked(1);
        ++workCountSoFar;
        listener.subTask(Messages.DTFJIndexBuilder_AddingMissingObjects);
        Iterator it = missingObjects.entries();
        while (it.hasNext()) {
            HashMapLongObject.Entry entry = (HashMapLongObject.Entry)it.next();
            JavaObject obj = (JavaObject)entry.getValue();
            long address = entry.getKey();
            if (obj != null) {
                this.rememberObject(obj, address, allClasses, listener);
                continue;
            }
            this.indexToAddress0.add(address);
        }
        LinkedHashSet<JavaClass> extraSuperclasses = new LinkedHashSet<JavaClass>();
        block48: for (JavaClass cls : allClasses) {
            JavaClass sup2 = this.getSuperclass(cls, listener);
            while (sup2 != null) {
                if (allClasses.contains(sup2) || !extraSuperclasses.add(sup2)) continue block48;
                sup2 = this.getSuperclass(sup2, listener);
            }
        }
        for (JavaClass sup3 : extraSuperclasses) {
            try {
                String className = sup3.getName();
                listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_AddingExtraClassViaSuperclassList, className), null);
            }
            catch (CorruptDataException e) {
                listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_AddingExtraClassOfUnknownNameViaSuperclassList, sup3), (Throwable)e);
            }
            this.rememberClass(sup3, allClasses, listener);
        }
        extraSuperclasses.clear();
        final IProgressListener listen = listener;
        TreeSet<JavaClass> sortedClasses = new TreeSet<JavaClass>(new Comparator<JavaClass>(){

            @Override
            public int compare(JavaClass o1, JavaClass o2) {
                long clsaddr2;
                long clsaddr1 = DTFJIndexBuilder.this.getClassAddress(o1, listen);
                return clsaddr1 < (clsaddr2 = DTFJIndexBuilder.this.getClassAddress(o2, listen)) ? -1 : (clsaddr1 > clsaddr2 ? 1 : 0);
            }
        });
        sortedClasses.addAll(allClasses);
        allClasses = sortedClasses;
        if (this.getExtraInfo && this.getExtraInfo2) {
            listener.worked(1);
            ++workCountSoFar;
            listener.subTask(Messages.DTFJIndexBuilder_FindingAllMethods);
            for (JavaClass jc : allClasses) {
                Iterator i7 = jc.getDeclaredMethods();
                while (i7.hasNext()) {
                    Object next7 = i7.next();
                    if (this.isCorruptData(next7, listener, Messages.DTFJIndexBuilder_CorruptDataReadingDeclaredMethods, jc)) continue;
                    JavaMethod jm = (JavaMethod)next7;
                    allMethods.add(jm);
                }
            }
        }
        long nativeAddr = 0L;
        long nativeTypeAddr = 0L;
        long methodTypeAddr = 0L;
        long methodAddr = 0L;
        long stackFrameAddr = 0L;
        if (this.getExtraInfo) {
            nativeAddr = this.nextClassAddress;
            this.indexToAddress0.add(nativeAddr);
            this.nextClassAddress += 8L;
            nativeTypeAddr = this.nextClassAddress;
            this.indexToAddress0.add(nativeTypeAddr);
            this.nextClassAddress += 8L;
            if (this.getExtraInfo3) {
                stackFrameAddr = this.nextClassAddress;
                this.indexToAddress0.add(stackFrameAddr);
                this.nextClassAddress += 8L;
            } else {
                methodTypeAddr = this.nextClassAddress;
                this.indexToAddress0.add(methodTypeAddr);
                this.nextClassAddress += 8L;
                methodAddr = this.nextClassAddress;
                this.indexToAddress0.add(methodAddr);
                this.nextClassAddress += 8L;
                for (JavaMethod jm : allMethods) {
                    this.indexToAddress0.add(this.getMethodAddress(jm, listener));
                }
            }
            Iterator iterator = allFrames.keySet().iterator();
            while (iterator.hasNext()) {
                long frame = (Long)iterator.next();
                this.indexToAddress0.add(frame);
            }
            if (debugInfo) {
                DTFJIndexBuilder.debugPrint("added methods " + allMethods.size() + " frames " + allFrames.size());
            }
        }
        if (this.indexToAddress0.size() > 0) {
            this.indexToAddress0.sort();
        }
        IndexWriter.Identifier indexToAddressCls = new IndexWriter.Identifier();
        DummyJavaClass clsJavaLangClassLoader = null;
        JavaClass clsJavaLangClass = null;
        for (JavaClass j2 : allClasses) {
            try {
                JavaObject clsObject = j2.getObject();
                if (clsObject == null) continue;
                clsJavaLangClass = clsObject.getJavaClass();
                break;
            }
            catch (IllegalArgumentException e) {
                listener.sendUserMessage(IProgressListener.Severity.ERROR, Messages.DTFJIndexBuilder_ProblemFindingJavaLangClass, (Throwable)e);
            }
            catch (CorruptDataException e) {
                if (this.msgNcorruptCount-- <= 0) continue;
                listener.sendUserMessage(IProgressListener.Severity.WARNING, Messages.DTFJIndexBuilder_ProblemFindingJavaLangClass, (Throwable)e);
            }
        }
        if (clsJavaLangClass != null) {
            allClasses.add(clsJavaLangClass);
        }
        for (JavaClass cls : allClasses) {
            long clsaddr2;
            String clsName = null;
            clsName = this.getClassName(cls, listen);
            if (clsJavaLangClassLoader == null && clsName.equals(JAVA_LANG_CLASSLOADER)) {
                clsJavaLangClassLoader = cls;
            }
            if (clsJavaLangClass == null && clsName.equals(JAVA_LANG_CLASS)) {
                clsJavaLangClass = cls;
            }
            if (this.indexToAddress0.reverse(clsaddr2 = this.getClassAddress(cls, listener)) < 0) {
                indexToAddressCls.add(clsaddr2);
                if (!debugInfo) continue;
                DTFJIndexBuilder.debugPrint("adding class " + clsName + " at " + DTFJIndexBuilder.format(clsaddr2) + " to the identifier list");
                continue;
            }
            if (!debugInfo) continue;
            DTFJIndexBuilder.debugPrint("skipping class " + clsName + " at " + DTFJIndexBuilder.format(clsaddr2) + " as the associated object is already on the identifier list");
        }
        if (clsJavaLangClass == null) {
            listener.sendUserMessage(IProgressListener.Severity.WARNING, Messages.DTFJIndexBuilder_ProblemFindingJavaLangClassViaName, null);
            clsJavaLangClass = new DummyJavaClass(JAVA_LANG_CLASS);
            allClasses.add(clsJavaLangClass);
            clsaddr = this.getClassAddress(clsJavaLangClass, listener);
            indexToAddressCls.add(clsaddr);
        }
        if (clsJavaLangClassLoader == null) {
            clsJavaLangClassLoader = new DummyJavaClass(JAVA_LANG_CLASSLOADER);
            allClasses.add(clsJavaLangClassLoader);
            clsaddr = this.getClassAddress(clsJavaLangClassLoader, listener);
            indexToAddressCls.add(clsaddr);
        }
        int i8 = 0;
        while (i8 < indexToAddressCls.size()) {
            this.indexToAddress0.add(indexToAddressCls.get(i8));
            ++i8;
        }
        indexToAddressCls = null;
        int nClasses = allClasses.size();
        if (this.getExtraInfo) {
            pseudoClasses = this.getExtraInfo3 ? 3 : 4;
            nClasses += allMethods.size() + pseudoClasses;
        } else {
            pseudoClasses = 0;
        }
        if (this.indexToAddress0.size() > 0) {
            this.indexToAddress0.sort();
        }
        Runtime runtime = Runtime.getRuntime();
        long maxFree = runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
        long indexCountForTempFile = Math.max(5000000L, maxFree / 16L);
        this.indexToAddress = (long)this.indexToAddress0.size() >= indexCountForTempFile ? new IndexWriter.LongIndexStreamer().writeTo(IndexManager.Index.IDENTIFIER.getFile(String.valueOf(this.pfx) + "temp."), this.indexToAddress0.iterator()) : this.indexToAddress0;
        this.indexToAddress0 = null;
        index.setIdentifiers(this.indexToAddress);
        if (this.getExtraInfo) {
            listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_FoundIdentifiersObjectsClassesMethods, this.indexToAddress.size(), this.indexToAddress.size() - nClasses - allFrames.size(), allFrames.size(), nClasses - allMethods.size() - pseudoClasses, allMethods.size()), null);
        } else {
            listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_FoundIdentifiersObjectsClasses, this.indexToAddress.size(), this.indexToAddress.size() - nClasses, nClasses), null);
        }
        if (debugInfo) {
            DTFJIndexBuilder.debugPrint("Total identifiers " + this.indexToAddress.size());
        }
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        listener.worked(1);
        ++workCountSoFar;
        listener.subTask(Messages.DTFJIndexBuilder_Pass2);
        if (debugInfo) {
            DTFJIndexBuilder.debugPrint("Classes " + nClasses);
        }
        this.idToClass = new HashMapIntObject(nClasses);
        if (debugInfo) {
            this.objectToSize2 = new ObjectToSize(this.indexToAddress.size());
        }
        listener.worked(1);
        ++workCountSoFar;
        listener.subTask(Messages.DTFJIndexBuilder_BuildingClasses);
        ClassImpl jlc = this.genClass(clsJavaLangClass, this.idToClass, bootLoaderAddress, 0L, listener);
        this.genClass2(clsJavaLangClass, jlc, jlc, pointerSize, listener);
        ClassImpl jlcl = this.genClass(clsJavaLangClassLoader, this.idToClass, bootLoaderAddress, 0L, listener);
        this.genClass2(clsJavaLangClassLoader, jlcl, jlc, pointerSize, listener);
        boolean foundFields = false;
        for (JavaClass j2 : allClasses) {
            List fd;
            ClassImpl ci;
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            if (j2.equals((Object)clsJavaLangClass) || j2.equals((Object)clsJavaLangClassLoader)) continue;
            long newSuper = 0L;
            if (loaderTypes.contains(j2) && ((sup = this.getSuperclass(j2, listener)) == null || this.getSuperclass(sup, listener) == null)) {
                newSuper = jlcl.getObjectAddress();
            }
            if ((ci = this.genClass(j2, this.idToClass, bootLoaderAddress, newSuper, listener)) == null) continue;
            this.genClass2(j2, ci, jlc, pointerSize, listener);
            if (foundFields || (fd = ci.getFieldDescriptors()).isEmpty()) continue;
            foundFields = true;
        }
        if (bootLoaderObject == null) {
            bootLoaderType = jlcl;
        }
        if (!foundFields) {
            this.haveDTFJRefs = true;
            this.useDTFJRefs = true;
        }
        if (this.getExtraInfo) {
            ClassImpl nativeType = this.genDummyType(NATIVE_MEMORY_TYPE, nativeTypeAddr, nativeAddr, null, new FieldDescriptor[0], this.idToClass, bootLoaderAddress, listener);
            ClassImpl nativeMemory = this.genDummyType(NATIVE_MEMORY, nativeAddr, 0L, nativeType, new FieldDescriptor[0], this.idToClass, bootLoaderAddress, listener);
            if (this.getExtraInfo3) {
                FieldDescriptor[] fld = new FieldDescriptor[]{new FieldDescriptor(LINE_NUMBER, 10), new FieldDescriptor(COMPILATION_LEVEL, 10), new FieldDescriptor(LOCATION_ADDRESS, 11), new FieldDescriptor(FILE_NAME, 2), new FieldDescriptor(METHOD_NAME, 2), new FieldDescriptor(FRAME_NUMBER, 10), new FieldDescriptor(STACK_DEPTH, 10)};
                ClassImpl classImpl = this.genDummyType(STACK_FRAME, stackFrameAddr, nativeAddr, nativeType, fld, this.idToClass, bootLoaderAddress, listener);
            } else {
                FieldDescriptor[] fld = new FieldDescriptor[]{new FieldDescriptor(LINE_NUMBER, 10), new FieldDescriptor(COMPILATION_LEVEL, 10), new FieldDescriptor(LOCATION_ADDRESS, 11), new FieldDescriptor(FILE_NAME, 2), new FieldDescriptor(FRAME_NUMBER, 10), new FieldDescriptor(STACK_DEPTH, 10)};
                ClassImpl methodType = this.genDummyType(METHOD_TYPE, methodTypeAddr, nativeTypeAddr, nativeType, new FieldDescriptor[0], this.idToClass, bootLoaderAddress, listener);
                ClassImpl method = this.genDummyType(METHOD, methodAddr, nativeAddr, methodType, fld, this.idToClass, bootLoaderAddress, listener);
                for (JavaMethod jm : allMethods) {
                    try {
                        ClassImpl classImpl = this.genClass(jm, methodAddr, methodType, this.idToClass, bootLoaderAddress, listener);
                    }
                    catch (CorruptDataException e) {
                        listener.sendUserMessage(IProgressListener.Severity.ERROR, Messages.DTFJIndexBuilder_ProblemBuildingClassObjectForMethod, (Throwable)e);
                    }
                }
            }
        }
        int maxClsId = 0;
        Iterator i9 = this.idToClass.values();
        while (i9.hasNext()) {
            ClassImpl ci = (ClassImpl)i9.next();
            int supid = ci.getSuperClassId();
            if (supid >= 0 && (sup = (ClassImpl)this.idToClass.get(supid)) != null) {
                sup.addSubClass(ci);
            }
            maxClsId = Math.max(maxClsId, ci.getObjectId());
        }
        index.setClassesById(this.idToClass);
        SetLong finalizableClass = new SetLong();
        for (JavaClass cls : allClasses) {
            long addr = this.isFinalizable(cls, listener);
            if (addr == 0L) continue;
            finalizableClass.add(addr);
        }
        this.objectToClass = new IndexWriter.IntIndexCollector(this.indexToAddress.size(), IndexWriter.mostSignificantBit((int)maxClsId));
        this.outRefs = new IndexWriter.IntArray1NWriter(this.indexToAddress.size(), IndexManager.Index.OUTBOUND.getFile(String.valueOf(this.pfx) + "temp."));
        BitField refd = new BitField(this.indexToAddress.size());
        Iterator i10 = this.idToClass.values();
        while (i10.hasNext()) {
            ClassImpl ci = (ClassImpl)i10.next();
            int clsId = ci.getClassId();
            int objId = ci.getObjectId();
            this.objectToClass.set(objId, clsId);
        }
        listener.worked(1);
        listener.subTask(Messages.DTFJIndexBuilder_FindingOutboundReferencesForClasses);
        int classFrac = 3;
        int workObjectsStep2 = Math.max(1, 3 * allClasses.size() / (10000 - ++workCountSoFar));
        int work2 = (10000 - workCountSoFar) * workObjectsStep2 / (3 * allClasses.size() + 1);
        for (JavaClass j2 : allClasses) {
            if (++objProgress % workObjectsStep2 == 0) {
                listener.worked(work2);
                workCountSoFar += work2;
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
            }
            claddr = this.getClassAddress(j2, listener);
            int objId = this.indexToAddress.reverse(claddr);
            ArrayLong ref = this.exploreClass(this.indexToAddress, fixedBootLoaderAddress, this.idToClass, j2, listener);
            if (ref == null) continue;
            try {
                this.checkRefs(j2, Messages.DTFJIndexBuilder_CheckRefsClass, ref, jlc.getObjectAddress(), bootLoaderAddress, listener);
            }
            catch (CorruptDataException e) {
                String clsName = null;
                ClassImpl ci = (ClassImpl)this.idToClass.get(objId);
                if (ci != null) {
                    clsName = ci.getName();
                }
                if (clsName == null) {
                    clsName = j2.toString();
                }
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemCheckingOutboundReferencesForClass, clsName), (Throwable)e);
            }
            this.addRefs(refd, objId, ref);
            this.outRefs.log(this.indexToAddress, objId, ref);
        }
        if (this.getExtraInfo) {
            this.addDummyTypeRefs(nativeAddr, refd);
            this.addDummyTypeRefs(nativeTypeAddr, refd);
            if (this.getExtraInfo3) {
                this.addDummyTypeRefs(stackFrameAddr, refd);
            } else {
                for (JavaMethod m2 : allMethods) {
                    claddr = this.getMethodAddress(m2, listener);
                    this.addDummyTypeRefs(claddr, refd);
                }
                this.addDummyTypeRefs(methodTypeAddr, refd);
                this.addDummyTypeRefs(methodAddr, refd);
            }
        }
        if (this.getExtraInfo) {
            Iterator claddr2 = allFrames.keySet().iterator();
            while (claddr2.hasNext()) {
                long addr = (Long)claddr2.next();
                int objId = this.indexToAddress.reverse(addr);
                long frameTypeAddr = this.getExtraInfo3 ? stackFrameAddr : (Long)allFrames.get(addr);
                int clsId = this.indexToAddress.reverse(frameTypeAddr);
                this.objectToClass.set(objId, clsId);
            }
        }
        listener.worked(1);
        ++workCountSoFar;
        listener.subTask(Messages.DTFJIndexBuilder_FindingRoots);
        this.indexToSize = new ObjectToSize(this.indexToAddress.size());
        boolean scanUp = bootLoaderAddress == 0L;
        boolean goodDTFJRoots = this.processDTFJRoots(pointerSize, scanUp, listener);
        SetInt prevRoots = this.rootSet();
        if (!goodDTFJRoots) {
            workCountSoFar = this.processConservativeRoots(pointerSize, fixedBootLoaderAddress, scanUp, workCountSoFar, listener);
            this.missedRoots = this.addMissedRoots(this.missedRoots);
            newRoots = this.rootSet();
        } else if (verbose) {
            File threadsFileSave;
            HashMapIntObject<List<XGCRootInfo>> gcRoot2 = this.gcRoot;
            HashMapIntObject<HashMapIntObject<List<XGCRootInfo>>> threadRoots2 = this.threadRoots;
            File threadsFile = new File(String.valueOf(this.pfx) + "threads");
            if (threadsFile.renameTo(threadsFileSave = new File(String.valueOf(this.pfx) + ".save.threads"))) {
                boolean ren;
                workCountSoFar = this.processConservativeRoots(pointerSize, fixedBootLoaderAddress, scanUp, workCountSoFar, listener);
                this.missedRoots = this.addMissedRoots(this.missedRoots);
                newRoots = this.rootSet();
                this.gcRoot = gcRoot2;
                this.threadRoots = threadRoots2;
                boolean del = threadsFile.delete();
                if (!del && debugInfo) {
                    DTFJIndexBuilder.debugPrint("Unable to delete " + threadsFile);
                }
                if (!(ren = threadsFileSave.renameTo(threadsFile)) && debugInfo) {
                    DTFJIndexBuilder.debugPrint("Unable to rename " + threadsFileSave + " to " + threadsFile);
                }
            } else {
                newRoots = prevRoots;
            }
        } else {
            newRoots = prevRoots;
        }
        for (int i11 : newRoots) {
            if (prevRoots.contains(i11) || !debugInfo) continue;
            DTFJIndexBuilder.debugPrint("DTFJ Roots missed object id " + i11 + " " + DTFJIndexBuilder.format(this.indexToAddress.get(i11)) + " " + (String)this.missedRoots.get(i11));
        }
        for (int i12 : prevRoots) {
            if (newRoots.contains(i12) || !debugInfo) continue;
            DTFJIndexBuilder.debugPrint("DTFJ Roots has extra object id " + i12 + " " + DTFJIndexBuilder.format(this.indexToAddress.get(i12)) + " " + (String)this.missedRoots.get(i12));
        }
        listener.worked(1);
        ++workCountSoFar;
        listener.subTask(Messages.DTFJIndexBuilder_FindingOutboundReferencesForObjects);
        this.loaderClassCache = this.initLoaderClassesCache();
        int objProgress2 = 0;
        Iterator i13 = this.dtfjInfo.getJavaRuntime().getHeaps();
        while (i13.hasNext()) {
            Object next8 = i13.next();
            if (DTFJIndexBuilder.isCorruptData(next8, listener, Messages.DTFJIndexBuilder_CorruptDataReadingHeaps, this.dtfjInfo.getJavaRuntime())) continue;
            JavaHeap jh = (JavaHeap)next8;
            j = jh.getObjects();
            while (j.hasNext()) {
                Object next2 = j.next();
                if (DTFJIndexBuilder.isCorruptData(next2, listener, Messages.DTFJIndexBuilder_CorruptDataReadingObjects, this.dtfjInfo.getJavaRuntime())) continue;
                JavaObject jo = (JavaObject)next2;
                if (++objProgress2 % 10000 == 0) {
                    int workDone = 10000 * (10000 - workCountSoFar) / (10000 + nobj - objProgress2);
                    if (debugInfo) {
                        DTFJIndexBuilder.debugPrint("workCount=" + workCountSoFar + "/" + 10000 + " objects=" + objProgress2 + "/" + nobj + " " + workDone);
                    }
                    listener.worked(workDone);
                    workCountSoFar += workDone;
                    if (listener.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                }
                this.processHeapObject(jo, jo.getID().getAddress(), pointerSize, bootLoaderAddress, loaders, jlc, refd, listener);
            }
        }
        Iterator it2 = missingObjects.entries();
        while (it2.hasNext()) {
            HashMapLongObject.Entry entry = (HashMapLongObject.Entry)it2.next();
            long objAddr = entry.getKey();
            JavaObject jo = (JavaObject)entry.getValue();
            this.processHeapObject(jo, objAddr, pointerSize, bootLoaderAddress, loaders, jlc, refd, listener);
        }
        if (bootLoaderObject == null) {
            ArrayLong aa = new ArrayLong();
            aa.add(bootLoaderType.getObjectAddress());
            int objId = this.indexToAddress.reverse(fixedBootLoaderAddress);
            this.addLoaderClasses(objId, aa);
            try {
                this.checkRefs(bootLoaderObject, Messages.DTFJIndexBuilder_CheckRefsBootLoader, aa, jlc.getObjectAddress(), bootLoaderAddress, listener);
            }
            catch (CorruptDataException e) {
                listener.sendUserMessage(IProgressListener.Severity.INFO, Messages.DTFJIndexBuilder_ProblemCheckingBootLoaderReferences, (Throwable)e);
            }
            this.addRefs(refd, objId, aa);
            this.outRefs.log(this.indexToAddress, objId, aa);
            if (bootLoaderType.getHeapSizePerInstance() == -1L) {
                bootLoaderType.setHeapSizePerInstance(0L);
            }
            bootLoaderType.addInstance(bootLoaderType.getHeapSizePerInstance());
            this.objectToClass.set(objId, bootLoaderType.getObjectId());
            if (debugInfo) {
                this.objectToSize2.set(objId, bootLoaderType.getHeapSizePerInstance());
            }
        }
        if (this.getExtraInfo) {
            int count = 0;
            j = allFrames.keySet().iterator();
            while (j.hasNext()) {
                long addr = (Long)j.next();
                ArrayLong aa = new ArrayLong();
                int objId = this.indexToAddress.reverse(addr);
                int clsId = this.objectToClass.get(objId);
                ClassImpl cls = (ClassImpl)this.idToClass.get(clsId);
                long frameTypeAddr = cls.getObjectAddress();
                long size = this.indexToSize.getSize(objId);
                if (size == 0L) {
                    size = cls.getHeapSizePerInstance();
                }
                cls.addInstance(size);
                if (debugInfo) {
                    this.objectToSize2.set(objId, size);
                }
                aa.add(frameTypeAddr);
                Iterator it3 = this.threadRoots.values();
                while (it3.hasNext()) {
                    HashMapIntObject hm = (HashMapIntObject)it3.next();
                    Iterator i22 = hm.values();
                    while (i22.hasNext()) {
                        List l2 = (List)i22.next();
                        for (XGCRootInfo xf : l2) {
                            ++count;
                            if (xf.getContextAddress() != addr) continue;
                            aa.add(xf.getObjectAddress());
                        }
                    }
                }
                this.addRefs(refd, objId, aa);
                this.outRefs.log(this.indexToAddress, objId, aa);
            }
        }
        this.arrayToSize = this.indexToSize.writeTo(IndexManager.Index.A2SIZE.getFile(String.valueOf(this.pfx) + "temp."));
        this.indexToSize = null;
        index.setArray2size(this.arrayToSize);
        IIndexReader.IOne2ManyIndex out2b = this.outRefs.flush();
        this.outRefs = null;
        index.setOutbound(out2b);
        if (!goodDTFJRoots || !this.foundFinalizableGCRoots) {
            int finalizables = 0;
            listener.subTask(Messages.DTFJIndexBuilder_GeneratingExtraRootsFromFinalizables);
            int i14 = 0;
            while (i14 < this.indexToAddress.size()) {
                int clsId = this.objectToClass.get(i14);
                long clsAddr = this.indexToAddress.get(clsId);
                if (finalizableClass.contains(clsAddr)) {
                    long addr = this.indexToAddress.get(i14);
                    if (!refd.get(i14) && !this.gcRoot.containsKey(i14)) {
                        ClassImpl classInfo = (ClassImpl)this.idToClass.get(clsId);
                        String clsInfo = classInfo != null ? classInfo.getName() : DTFJIndexBuilder.format(clsAddr);
                        ++finalizables;
                        this.addRoot(this.gcRoot, addr, addr, 512);
                        refd.set(i14);
                        if (this.msgNguessFinalizable-- > 0) {
                            listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_ObjectIsFinalizable, clsInfo, DTFJIndexBuilder.format(addr)), null);
                        }
                        if (debugInfo) {
                            DTFJIndexBuilder.debugPrint("extra finalizable root " + i14 + " " + DTFJIndexBuilder.format(addr));
                        }
                    }
                }
                ++i14;
            }
            listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_FinalizableObjectsMarkedAsRoots, finalizables), null);
        }
        i = this.dtfjInfo.getJavaRuntime().getThreads();
        while (i.hasNext()) {
            Object next9 = i.next();
            if (DTFJIndexBuilder.isCorruptData(next9, listener, Messages.DTFJIndexBuilder_CorruptDataReadingThreads, this.dtfjInfo.getJavaRuntime())) continue;
            JavaThread th = (JavaThread)next9;
            this.checkThreadBlockingObject(th, listener);
        }
        if (this.gcRoot.isEmpty() || this.threadRoots.isEmpty() || this.threadRootObjects() == 0) {
            listener.subTask(Messages.DTFJIndexBuilder_GeneratingExtraRootsMarkingAllUnreferenced);
            index.getSnapshotInfo().setProperty("keep_unreachable_objects", (Serializable)Integer.valueOf(1));
            int extras = 0;
            int i15 = 0;
            while (i15 < this.indexToAddress.size()) {
                if (!refd.get(i15)) {
                    long addr = this.indexToAddress.get(i15);
                    if (!this.gcRoot.containsKey(i15)) {
                        ++extras;
                        this.addRoot(this.gcRoot, addr, addr, 1);
                        refd.set(i15);
                        if (debugInfo) {
                            DTFJIndexBuilder.debugPrint("extra root " + i15 + " " + DTFJIndexBuilder.format(addr));
                        }
                    }
                }
                ++i15;
            }
            Iterator it4 = this.gcRoot.entries();
            while (it4.hasNext()) {
                HashMapIntObject.Entry e = (HashMapIntObject.Entry)it4.next();
                List<XGCRootInfo> l = (List<XGCRootInfo>)e.getValue();
                switch (l.size()) {
                    case 1: {
                        l = Collections.singletonList((XGCRootInfo)l.get(0));
                        break;
                    }
                    default: {
                        if (l instanceof ArrayList) {
                            ((ArrayList)l).trimToSize();
                            break;
                        }
                        l = new ArrayList<XGCRootInfo>(l);
                    }
                }
                this.gcRoot.put(e.getKey(), l);
            }
            listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_UnreferenceObjectsMarkedAsRoots, extras), null);
        }
        index.setGcRoots(this.gcRoot);
        index.setThread2objects2roots(this.threadRoots);
        if (goodDTFJRoots) {
            msg = MessageFormat.format(Messages.DTFJIndexBuilder_UsingDTFJRoots, this.gcRoot.size());
            listener.sendUserMessage(IProgressListener.Severity.INFO, msg, null);
            if (debugInfo) {
                DTFJIndexBuilder.debugPrint(msg);
            }
        } else {
            msg = MessageFormat.format(Messages.DTFJIndexBuilder_UsingConservativeGarbageCollectionRoots, this.gcRoot.size());
            listener.sendUserMessage(IProgressListener.Severity.WARNING, msg, null);
            if (debugInfo) {
                DTFJIndexBuilder.debugPrint(msg);
            }
        }
        this.objectToClass1 = (long)this.objectToClass.size() >= indexCountForTempFile ? this.objectToClass.writeTo(IndexManager.Index.O2CLASS.getFile(String.valueOf(this.pfx) + "temp.")) : this.objectToClass;
        this.objectToClass = null;
        index.setObject2classId(this.objectToClass1);
        if (verbose) {
            this.idToClass2 = this.copy(this.idToClass);
            this.objectToClass2 = this.copy(this.objectToClass1, IndexWriter.mostSignificantBit((int)maxClsId));
        }
        if (ifo.getIdentifierSize() == 8) {
            ifo.setProperty("$useCompressedOops", (Serializable)Boolean.valueOf(this.compressedRefs));
        }
        int skippedMessages = 0;
        skippedMessages += Math.max(0, 0);
        skippedMessages += Math.max(0, -this.msgNgetRefsMissing);
        skippedMessages += Math.max(0, -this.msgNgetRefsExtra);
        skippedMessages += Math.max(0, -this.msgNarrayRefsNPE);
        skippedMessages += Math.max(0, -this.msgNgetRefsUnavailable);
        skippedMessages += Math.max(0, -this.msgNgetRefsCorrupt);
        skippedMessages += Math.max(0, -this.msgNbigSegs);
        skippedMessages += Math.max(0, -this.msgNinvalidArray);
        skippedMessages += Math.max(0, -this.msgNinvalidObj);
        skippedMessages += Math.max(0, -this.msgNbrokenEquals);
        skippedMessages += Math.max(0, -this.msgNbrokenInterfaceSuper);
        skippedMessages += Math.max(0, -this.msgNmissingLoaderMsg);
        skippedMessages += Math.max(0, -this.msgNcorruptCount);
        skippedMessages += Math.max(0, -this.msgNrootsWarning);
        skippedMessages += Math.max(0, -this.msgNguessFinalizable);
        skippedMessages += Math.max(0, -this.msgNgetRefsAllMissing);
        skippedMessages += Math.max(0, -this.msgNgetSuperclass);
        skippedMessages += Math.max(0, -this.msgNnullThreadObject);
        skippedMessages += Math.max(0, -this.msgNbadThreadInfo);
        skippedMessages += Math.max(0, -this.msgNunexpectedModifiers);
        skippedMessages += Math.max(0, -this.msgNcorruptSection);
        skippedMessages += Math.max(0, -this.msgNclassForObject);
        skippedMessages += Math.max(0, -this.msgNcomponentClass);
        skippedMessages += Math.max(0, -this.msgNtypeForClassObject);
        skippedMessages += Math.max(0, -this.msgNobjectSize);
        skippedMessages += Math.max(0, -this.msgNoutboundReferences);
        skippedMessages += Math.max(0, -this.msgNnoSuperClassForArray);
        if ((skippedMessages += Math.max(0, -this.msgNproblemReadingJavaStackFrame)) > 0) {
            listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_RepeatedMessagesSuppressed, skippedMessages), null);
        }
        long now2 = System.currentTimeMillis();
        listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_TookmsToParseFile, now2 - now1, this.dump), null);
        this.gcRoot = null;
        this.threadRoots = null;
        this.dummyClassAddress = null;
        this.dummyMethodAddress = null;
        this.dummyMethodAddress2 = null;
        this.methodAddresses = null;
        this.loaderClassCache = null;
        listener.done();
    }

    private void addDummyTypeRefs(long methodTypeAddr, BitField refd) throws IOException {
        int objId;
        ClassImpl ci;
        if (methodTypeAddr != 0L && (ci = (ClassImpl)this.idToClass.get(objId = this.indexToAddress.reverse(methodTypeAddr))) != null) {
            ArrayLong ref = ci.getReferences();
            this.addRefs(refd, objId, ref);
            this.outRefs.log(this.indexToAddress, objId, ref);
        }
    }

    static long getFrameAddress(JavaStackFrame jf, long prevFrameAddress, int pointerSize) {
        long frameAddress;
        try {
            frameAddress = DTFJIndexBuilder.getAlignedAddress(jf.getBasePointer(), pointerSize).getAddress();
        }
        catch (CorruptDataException e) {
            frameAddress = 0L;
        }
        if (frameAddress == 0L && prevFrameAddress != 0L) {
            frameAddress = prevFrameAddress + (long)((pointerSize + 31) / 32 * 4);
        }
        return frameAddress;
    }

    private PrintWriter createThreadInfoFile() {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(this.pfx) + "threads"), "UTF-8"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pw;
    }

    private void printThreadStack(PrintWriter out, JavaThread th) {
        out.print("Thread ");
        long threadAddress = DTFJIndexBuilder.getThreadAddress(th, null);
        out.println(threadAddress != 0L ? "0x" + Long.toHexString(threadAddress) : "<unknown>");
        Iterator it = th.getStackFrames();
        while (it.hasNext()) {
            block37: {
                Object next = it.next();
                out.print(" at ");
                if (!(next instanceof CorruptData)) {
                    JavaStackFrame jsf = (JavaStackFrame)next;
                    try {
                        JavaLocation jl;
                        block36: {
                            jl = jsf.getLocation();
                            try {
                                JavaMethod jm = jl.getMethod();
                                try {
                                    JavaClass jc = jm.getDeclaringClass();
                                    out.print(jc.getName().replace("/", METHOD_NAME_PREFIX));
                                    out.print(METHOD_NAME_PREFIX);
                                }
                                catch (CorruptDataException jc) {
                                }
                                catch (DataUnavailable jc) {
                                    // empty catch block
                                }
                                try {
                                    out.print(jm.getName());
                                }
                                catch (CorruptDataException jc) {
                                    // empty catch block
                                }
                                try {
                                    out.print(jm.getSignature());
                                }
                                catch (CorruptDataException jc) {
                                    // empty catch block
                                }
                                out.print(" ");
                                try {
                                    if (!Modifier.isNative(jm.getModifiers())) break block36;
                                    out.print("(Native Method)");
                                    break block37;
                                }
                                catch (CorruptDataException jc) {
                                }
                            }
                            catch (CorruptDataException jm) {
                                // empty catch block
                            }
                        }
                        try {
                            out.print(METHOD_NAME_SIG);
                            out.print(jl.getFilename());
                            try {
                                out.print(":" + jl.getLineNumber());
                            }
                            catch (CorruptDataException jm) {
                            }
                            catch (DataUnavailable jm) {
                                // empty catch block
                            }
                            int cl = 0;
                            try {
                                cl = jl.getCompilationLevel();
                            }
                            catch (CorruptDataException jc) {
                                // empty catch block
                            }
                            if (cl > 0) {
                                out.print("(Compiled Code)");
                            }
                        }
                        catch (DataUnavailable e) {
                            int cl = 0;
                            try {
                                cl = jl.getCompilationLevel();
                            }
                            catch (CorruptDataException corruptDataException) {
                                // empty catch block
                            }
                            if (cl > 0) {
                                out.print("Compiled Code");
                            } else {
                                out.print("Unknown Source");
                            }
                            out.print(")");
                            break block37;
                        }
                        catch (CorruptDataException e) {
                            try {
                                int cl = 0;
                                try {
                                    cl = jl.getCompilationLevel();
                                }
                                catch (CorruptDataException corruptDataException) {
                                    // empty catch block
                                }
                                if (cl > 0) {
                                    out.print("Compiled Code");
                                } else {
                                    out.print("Unknown Source");
                                }
                                break block37;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                out.print(")");
                            }
                        }
                        out.print(")");
                    }
                    catch (CorruptDataException corruptDataException) {
                        // empty catch block
                    }
                }
            }
            out.println();
        }
        out.println();
        out.println(" locals:");
    }

    private void printLocal(PrintWriter pw, long target, int frameNum) {
        if (this.indexToAddress.reverse(target) >= 0) {
            pw.println("  objectId=0x" + Long.toHexString(target) + ", line=" + frameNum);
        }
    }

    private int processConservativeRoots(int pointerSize, long fixedBootLoaderAddress, boolean scanUp, int workCountSoFar, IProgressListener listener) {
        Object next;
        this.gcRoot = new HashMapIntObject();
        listener.subTask(Messages.DTFJIndexBuilder_GeneratingSystemRoots);
        this.addRoot(this.gcRoot, fixedBootLoaderAddress, fixedBootLoaderAddress, 2);
        Iterator i = this.idToClass.values();
        while (i.hasNext()) {
            ClassImpl ci = (ClassImpl)i.next();
            if (ci.getClassLoaderAddress() != fixedBootLoaderAddress) continue;
            this.addRoot(this.gcRoot, ci.getObjectAddress(), ci.getClassLoaderAddress(), 2);
        }
        listener.subTask(Messages.DTFJIndexBuilder_GeneratingThreadRoots);
        PrintWriter pw = this.createThreadInfoFile();
        this.threadRoots = new HashMapIntObject();
        Iterator i2 = this.dtfjInfo.getJavaRuntime().getThreads();
        while (i2.hasNext()) {
            next = i2.next();
            if (DTFJIndexBuilder.isCorruptData(next, listener, Messages.DTFJIndexBuilder_CorruptDataReadingThreads, this.dtfjInfo.getJavaRuntime())) continue;
            JavaThread th = (JavaThread)next;
            listener.worked(1);
            ++workCountSoFar;
            if (listener.isCanceled()) {
                if (pw != null) {
                    pw.close();
                }
                throw new IProgressListener.OperationCanceledException();
            }
            try {
                long threadAddress = DTFJIndexBuilder.getThreadAddress(th, null);
                if (threadAddress != 0L) {
                    try {
                        int threadState = th.getState();
                        if ((threadState & 1) == 0) {
                            continue;
                        }
                    }
                    catch (CorruptDataException e) {
                        listener.sendUserMessage(Severity_INFO, MessageFormat.format(Messages.DTFJIndexBuilder_ThreadStateNotFound, DTFJIndexBuilder.format(threadAddress)), (Throwable)e);
                    }
                    catch (IllegalArgumentException e) {
                        listener.sendUserMessage(Severity_INFO, MessageFormat.format(Messages.DTFJIndexBuilder_ThreadNameNotFound, DTFJIndexBuilder.format(threadAddress)), (Throwable)e);
                    }
                    this.addRoot(this.gcRoot, threadAddress, threadAddress, 256);
                    int threadID = this.indexToAddress.reverse(threadAddress);
                    HashMapIntObject thr = new HashMapIntObject();
                    this.threadRoots.put(threadID, (Object)thr);
                } else {
                    CorruptDataException e1;
                    long jniEnvAddress;
                    String name = "";
                    try {
                        name = th.getName();
                        jniEnvAddress = th.getJNIEnv().getAddress();
                        e1 = null;
                    }
                    catch (CorruptDataException e) {
                        jniEnvAddress = 0L;
                        e1 = e;
                    }
                    if (this.msgNnullThreadObject-- > 0) {
                        listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_ThreadObjectNotFoundSoIgnoring, name, DTFJIndexBuilder.format(jniEnvAddress)), (Throwable)e1);
                    }
                }
                this.scanJavaThread(th, threadAddress, pointerSize, this.threadRoots, listener, scanUp, pw);
                try {
                    ImageThread it = th.getImageThread();
                    this.scanImageThread(th, it, threadAddress, pointerSize, this.threadRoots, listener);
                }
                catch (DataUnavailable e) {
                    listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_NativeThreadNotFound, DTFJIndexBuilder.format(threadAddress)), (Throwable)e);
                }
            }
            catch (CorruptDataException e) {
                if (this.msgNbadThreadInfo-- <= 0) continue;
                listener.sendUserMessage(IProgressListener.Severity.WARNING, Messages.DTFJIndexBuilder_ProblemReadingThreadInformation, (Throwable)e);
            }
        }
        if (pw != null) {
            pw.close();
        }
        listener.subTask(Messages.DTFJIndexBuilder_GeneratingMonitorRoots);
        i2 = this.dtfjInfo.getJavaRuntime().getMonitors();
        while (i2.hasNext()) {
            JavaMonitor jm;
            JavaObject obj;
            next = i2.next();
            if (DTFJIndexBuilder.isCorruptData(next, listener, Messages.DTFJIndexBuilder_CorruptDataReadingMonitors, this.dtfjInfo.getJavaRuntime()) || (obj = (jm = (JavaMonitor)next).getObject()) == null) continue;
            try {
                JavaThread jt = jm.getOwner();
                if (jt != null) {
                    this.addRootForThread(obj, jt, listener);
                }
            }
            catch (CorruptDataException e) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_UnableToFindThreadOwningMonitor, DTFJIndexBuilder.format(jm.getID().getAddress()), DTFJIndexBuilder.format(obj.getID().getAddress())), (Throwable)e);
                this.addRootForThread(obj, null, listener);
            }
            this.addRootForThreads(obj, jm.getEnterWaiters(), listener);
            this.addRootForThreads(obj, jm.getNotifyWaiters(), listener);
        }
        return workCountSoFar;
    }

    private boolean processDTFJRoots(int pointerSize, boolean scanUp, IProgressListener listener) {
        Iterator it;
        boolean goodDTFJRoots = false;
        listener.subTask(Messages.DTFJIndexBuilder_FindingRootsFromDTFJ);
        if (debugInfo) {
            DTFJIndexBuilder.debugPrint("DTFJ roots");
        }
        HashMapIntObject gcRoot2 = new HashMapIntObject();
        HashMapIntObject threadRoots2 = new HashMapIntObject();
        goodDTFJRoots = true;
        this.missedRoots = new HashMapIntObject();
        try {
            it = this.dtfjInfo.getJavaRuntime().getHeapRoots();
            if (it == null) {
                it = Collections.EMPTY_LIST.iterator();
                listener.sendUserMessage(Severity_WARNING, Messages.DTFJIndexBuilder_DTFJgetHeapRootsReturnsNull, null);
            }
        }
        catch (LinkageError e) {
            goodDTFJRoots = false;
            it = Collections.EMPTY_LIST.iterator();
            listener.sendUserMessage(Severity_WARNING, Messages.DTFJIndexBuilder_DTFJDoesNotSupportHeapRoots, (Throwable)e);
        }
        if (goodDTFJRoots) {
            listener.subTask(Messages.DTFJIndexBuilder_GeneratingGlobalRoots);
            if (debugInfo) {
                DTFJIndexBuilder.debugPrint("Processing global roots");
            }
            while (it.hasNext()) {
                Object next = it.next();
                if (DTFJIndexBuilder.isCorruptData(next, listener, Messages.DTFJIndexBuilder_CorruptDataReadingRoots, this.dtfjInfo.getJavaRuntime())) continue;
                JavaReference r = (JavaReference)next;
                this.processRoot(r, null, (HashMapIntObject<List<XGCRootInfo>>)gcRoot2, (HashMapIntObject<HashMapIntObject<List<XGCRootInfo>>>)threadRoots2, pointerSize, listener);
            }
            listener.subTask(Messages.DTFJIndexBuilder_GeneratingThreadRoots);
            if (debugInfo) {
                DTFJIndexBuilder.debugPrint("Processing thread roots");
            }
            PrintWriter pw = null;
            if (gcRoot2.size() > 0) {
                pw = this.createThreadInfoFile();
            }
            Iterator thit = this.dtfjInfo.getJavaRuntime().getThreads();
            while (thit.hasNext()) {
                Object next = thit.next();
                if (DTFJIndexBuilder.isCorruptData(next, listener, Messages.DTFJIndexBuilder_CorruptDataReadingThreads, this.dtfjInfo.getJavaRuntime())) continue;
                JavaThread th = (JavaThread)next;
                if (pw != null) {
                    this.printThreadStack(pw, th);
                }
                long prevAddr = 0L;
                long prevFrameAddress = 0L;
                int frameNum = 0;
                Object nextFrame = null;
                Iterator ii = th.getStackFrames();
                while (nextFrame != null || ii.hasNext()) {
                    Object next2;
                    if (nextFrame != null) {
                        next2 = nextFrame;
                        nextFrame = null;
                    } else {
                        next2 = ii.next();
                    }
                    if (!DTFJIndexBuilder.isCorruptData(next2, listener, Messages.DTFJIndexBuilder_CorruptDataReadingJavaStackFrames, th)) {
                        JavaStackFrame jf = next2;
                        if (jf.getHeapRoots() == null) {
                            if (this.msgNrootsWarning-- > 0) {
                                listener.sendUserMessage(Severity_WARNING, Messages.DTFJIndexBuilder_DTFJgetHeapRootsFromStackFrameReturnsNull, null);
                            }
                        } else {
                            Iterator i3 = jf.getHeapRoots();
                            while (i3.hasNext()) {
                                Object next3 = i3.next();
                                if (DTFJIndexBuilder.isCorruptData(next3, listener, Messages.DTFJIndexBuilder_CorruptDataReadingRoots, this.dtfjInfo.getJavaRuntime())) continue;
                                JavaReference r = (JavaReference)next3;
                                this.processRoot(r, th, (HashMapIntObject<List<XGCRootInfo>>)gcRoot2, (HashMapIntObject<HashMapIntObject<List<XGCRootInfo>>>)threadRoots2, pointerSize, listener);
                                if (pw == null) continue;
                                try {
                                    long target;
                                    Object o = r.getTarget();
                                    if (o instanceof JavaObject) {
                                        JavaObject jo = (JavaObject)o;
                                        target = jo.getID().getAddress();
                                        this.printLocal(pw, target, frameNum);
                                        continue;
                                    }
                                    if (!(o instanceof JavaClass)) continue;
                                    JavaClass jc = (JavaClass)o;
                                    target = this.getClassAddress(jc, listener);
                                    this.printLocal(pw, target, frameNum);
                                }
                                catch (CorruptDataException corruptDataException) {
                                }
                                catch (DataUnavailable dataUnavailable) {
                                    // empty catch block
                                }
                            }
                            if (this.getExtraInfo) {
                                long frameAddress = DTFJIndexBuilder.getFrameAddress(jf, prevFrameAddress, pointerSize);
                                long searchSize = 256L;
                                if (scanUp) {
                                    if (ii.hasNext() && !DTFJIndexBuilder.isCorruptData(nextFrame = ii.next(), listener, Messages.DTFJIndexBuilder_CorruptDataReadingJavaStackFrames, th)) {
                                        JavaStackFrame jf2 = nextFrame;
                                        try {
                                            ImagePointer ip2 = DTFJIndexBuilder.getAlignedAddress(jf2.getBasePointer(), pointerSize);
                                            long address2 = ip2.getAddress();
                                            long s2 = address2 - frameAddress;
                                            if (s2 > 0L && s2 < searchSize) {
                                                searchSize = s2;
                                            }
                                        }
                                        catch (CorruptDataException ip2) {}
                                    }
                                } else {
                                    if (prevAddr == 0L) {
                                        prevAddr = this.getJavaStackBase(th, frameAddress);
                                    }
                                    long s2 = frameAddress - prevAddr;
                                    prevAddr = frameAddress;
                                    if (s2 > 0L && s2 < searchSize) {
                                        searchSize = s2;
                                    }
                                    searchSize = -searchSize;
                                }
                                prevFrameAddress = frameAddress;
                                int frameId = this.indexToAddress.reverse(frameAddress);
                                if (frameAddress != 0L && frameId >= 0) {
                                    long size = Math.abs(searchSize);
                                    this.setFrameSize(frameId, size);
                                    long threadAddress = DTFJIndexBuilder.getThreadAddress(th, null);
                                    if (threadAddress != 0L) {
                                        int thrId = this.indexToAddress.reverse(threadAddress);
                                        HashMapIntObject thr = (HashMapIntObject)threadRoots2.get(thrId);
                                        if (thr == null) {
                                            thr = new HashMapIntObject();
                                            threadRoots2.put(thrId, (Object)thr);
                                        }
                                        this.addRoot((HashMapIntObject<List<XGCRootInfo>>)thr, frameAddress, threadAddress, 4096);
                                    } else {
                                        this.addRoot((HashMapIntObject<List<XGCRootInfo>>)gcRoot2, frameAddress, frameAddress, 4096);
                                    }
                                }
                            }
                        }
                    }
                    ++frameNum;
                }
                if (pw == null) continue;
                pw.println();
            }
            if (pw != null) {
                pw.close();
            }
            if (gcRoot2.isEmpty()) {
                goodDTFJRoots = false;
                listener.sendUserMessage(IProgressListener.Severity.WARNING, Messages.DTFJIndexBuilder_NoDTFJRootsFound, null);
            }
            this.gcRoot = gcRoot2;
            this.threadRoots = threadRoots2;
        }
        return goodDTFJRoots;
    }

    private long setFrameSize(int frameId, long size) {
        if (this.getExtraInfo3) {
            return size;
        }
        int clsId = this.objectToClass.get(frameId);
        ClassImpl cls = (ClassImpl)this.idToClass.get(clsId);
        if (cls != null && cls.getName().contains(METHOD_NAME_SIG)) {
            long prevSize = cls.getHeapSizePerInstance();
            if (prevSize <= 0L || prevSize == 256L) {
                cls.setHeapSizePerInstance(size);
            } else if (size == 256L) {
                size = prevSize;
            } else if (size != prevSize) {
                this.indexToSize.set(frameId, size);
            }
        }
        return size;
    }

    private HashMapIntObject<String> addMissedRoots(HashMapIntObject<String> roots) {
        if (roots == null) {
            roots = new HashMapIntObject();
        }
        IteratorInt ii = this.gcRoot.keys();
        while (ii.hasNext()) {
            int i = ii.next();
            List lr = (List)this.gcRoot.get(i);
            String info = XGCRootInfo.getTypeSetAsString((GCRootInfo[])((GCRootInfo[])lr.toArray(new XGCRootInfo[lr.size()])));
            String prev = (String)roots.get(i);
            roots.put(i, (Object)(prev != null ? String.valueOf(prev) + "," + info : info));
        }
        int[] nArray = this.threadRoots.getAllKeys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int[] oldRoots1;
            int key = nArray[n2];
            int[] nArray2 = oldRoots1 = ((HashMapIntObject)this.threadRoots.get(key)).getAllKeys();
            int n3 = oldRoots1.length;
            int n4 = 0;
            while (n4 < n3) {
                int i = nArray2[n4];
                List lr = (List)((HashMapIntObject)this.threadRoots.get(key)).get(i);
                String info = XGCRootInfo.getTypeSetAsString((GCRootInfo[])((GCRootInfo[])lr.toArray(new XGCRootInfo[lr.size()])));
                String prev = (String)roots.get(i);
                roots.put(i, (Object)(prev != null ? String.valueOf(prev) + "," + info : info));
                ++n4;
            }
            ++n2;
        }
        return roots;
    }

    private SetInt rootSet() {
        SetInt prevRoots = new SetInt();
        if (this.gcRoot != null) {
            int[] oldRoots;
            int[] nArray = oldRoots = this.gcRoot.getAllKeys();
            int n = oldRoots.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                prevRoots.add(i);
                ++n2;
            }
            nArray = this.threadRoots.getAllKeys();
            n = nArray.length;
            n2 = 0;
            while (n2 < n) {
                int key = nArray[n2];
                int[] nArray2 = oldRoots = ((HashMapIntObject)this.threadRoots.get(key)).getAllKeys();
                int n3 = oldRoots.length;
                int n4 = 0;
                while (n4 < n3) {
                    int i = nArray2[n4];
                    prevRoots.add(i);
                    ++n4;
                }
                ++n2;
            }
        }
        return prevRoots;
    }

    private int threadRootObjects() {
        int objRoots = 0;
        Iterator it = this.threadRoots.values();
        while (it.hasNext()) {
            HashMapIntObject hm = (HashMapIntObject)it.next();
            IteratorInt i2 = hm.keys();
            block1: while (i2.hasNext()) {
                int objId = i2.next();
                if (this.idToClass.containsKey(objId)) continue;
                Iterator i3 = ((List)hm.get(objId)).iterator();
                while (i3.hasNext()) {
                    int type = ((XGCRootInfo)i3.next()).getType();
                    if (type != 64 && type != 128 && type != 4) continue;
                    ++objRoots;
                    continue block1;
                }
            }
        }
        return objRoots;
    }

    private void rememberObject(JavaObject jo, long objAddress, Set<JavaClass> allClasses, IProgressListener listener) {
        block2: {
            this.indexToAddress0.add(objAddress);
            try {
                JavaClass cls = jo.getJavaClass();
                this.rememberClass(cls, allClasses, listener);
            }
            catch (CorruptDataException e) {
                if (this.msgNclassForObject-- <= 0) break block2;
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemFindingClassesForObject, DTFJIndexBuilder.format(objAddress)), (Throwable)e);
            }
        }
    }

    private void rememberClass(JavaClass cls, Set<JavaClass> allClasses, IProgressListener listener) {
        block2: while (allClasses.add(cls)) {
            if (debugInfo) {
                DTFJIndexBuilder.debugPrint("Adding extra class " + this.getClassName(cls, listener));
            }
            try {
                while (cls.isArray()) {
                    if (!allClasses.add(cls = cls.getComponentType())) continue block2;
                    if (!debugInfo) continue;
                    DTFJIndexBuilder.debugPrint("Adding extra array component class " + this.getClassName(cls, listener));
                }
            }
            catch (CorruptDataException e) {
                if (this.msgNcomponentClass-- <= 0) continue;
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemFindingComponentClass, DTFJIndexBuilder.format(this.getClassAddress(cls, listener))), (Throwable)e);
            }
        }
    }

    private void processHeapObject(JavaObject jo, long objAddr, int pointerSize, long bootLoaderAddress, HashMap<JavaObject, JavaClassLoader> loaders, ClassImpl jlc, BitField refd, IProgressListener listener) throws IOException {
        ArrayLong aa;
        int objId;
        block43: {
            long clsAddr;
            JavaClass type;
            block42: {
                ClassImpl cls;
                objId = this.indexToAddress.reverse(objAddr = this.fixBootLoaderAddress(bootLoaderAddress, objAddr));
                if (objId < 0) {
                    listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_SkippingObject, DTFJIndexBuilder.format(objAddr)), null);
                    return;
                }
                if (this.idToClass.get(objId) != null) {
                    return;
                }
                int clsId = -1;
                type = null;
                clsAddr = 0L;
                try {
                    if (jo != null) {
                        type = jo.getJavaClass();
                        clsAddr = this.getClassAddress(type, listener);
                        clsId = this.indexToAddress.reverse(clsAddr);
                    }
                    if (clsId >= 0) {
                        if (verbose) {
                            DTFJIndexBuilder.debugPrint("found object " + objId + " " + this.getClassName(type, listener) + " at " + DTFJIndexBuilder.format(objAddr) + " clsId " + clsId);
                        }
                    } else if (type != null) {
                        listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemGettingClassIDType, DTFJIndexBuilder.format(objAddr), this.getClassName(type, listener), DTFJIndexBuilder.format(clsAddr)), null);
                    } else {
                        listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemGettingClassID, DTFJIndexBuilder.format(objAddr)), null);
                    }
                }
                catch (CorruptDataException e) {
                    listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemGettingClassID, DTFJIndexBuilder.format(objAddr)), (Throwable)e);
                }
                if (clsId < 0) {
                    clsId = jlc.getSuperClassId();
                    clsAddr = jlc.getSuperClassAddress();
                    if (clsAddr == 0L) {
                        cls = this.findClassFromName("java.lang.Object", listener);
                        if (cls == null) {
                            cls = jlc;
                        }
                        clsId = cls.getObjectId();
                        clsAddr = cls.getObjectAddress();
                    }
                    if (loaders.get(jo) != null && (cls = this.findJavaLangClassloader(listener)) != null) {
                        clsId = cls.getObjectId();
                        clsAddr = cls.getObjectAddress();
                    }
                }
                this.objectToClass.set(objId, clsId);
                cls = (ClassImpl)this.idToClass.get(clsId);
                try {
                    if (cls != null) {
                        long size;
                        if (cls == jlc && debugInfo) {
                            DTFJIndexBuilder.debugPrint("Found class as object at " + DTFJIndexBuilder.format(objAddr));
                        }
                        if (jo != null) {
                            size = this.getObjectSize(jo, pointerSize);
                        } else {
                            size = cls.getHeapSizePerInstance();
                            if (size < 0L) {
                                size = 0L;
                            }
                        }
                        cls.addInstance(size);
                        if (cls.isArrayType()) {
                            long bigSize;
                            int headerPointer;
                            int arrayLen = jo.getArraySize();
                            this.indexToSize.set(objId, size);
                            if (debugInfo) {
                                this.objectToSize2.set(objId, size);
                            }
                            if ((headerPointer = this.getPointerBytes(pointerSize)) == 8 && (bigSize = this.calculateArraySize(cls, arrayLen, headerPointer)) > size) {
                                boolean showSize = false;
                                if (showSize && debugInfo) {
                                    DTFJIndexBuilder.debugPrint("Array size with " + headerPointer + " pointers calculated " + bigSize + " actual " + size + " arrayLen " + arrayLen);
                                }
                                headerPointer = 4;
                                this.compressedRefs = true;
                                if (showSize) {
                                    bigSize = this.calculateArraySize(cls, arrayLen, headerPointer);
                                    if (debugInfo) {
                                        DTFJIndexBuilder.debugPrint("Array size with " + headerPointer + " pointers calculated " + bigSize + " actual " + size + " arrayLen " + arrayLen);
                                    }
                                }
                            }
                            cls.setHeapSizePerInstance((long)headerPointer);
                        } else {
                            long oldSize = cls.getHeapSizePerInstance();
                            if (oldSize < 0L) {
                                cls.setHeapSizePerInstance(size);
                                oldSize = cls.getHeapSizePerInstance();
                            }
                            if (oldSize != size) {
                                this.indexToSize.set(objId, size);
                            }
                            if (debugInfo) {
                                this.objectToSize2.set(objId, size);
                            }
                        }
                    } else {
                        listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemGettingObjectClass, DTFJIndexBuilder.format(objAddr)), null);
                    }
                }
                catch (CorruptDataException e) {
                    if (this.msgNobjectSize-- > 0) {
                        listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemGettingObjectSize, DTFJIndexBuilder.format(objAddr)), (Throwable)e);
                    }
                    cls.addInstance(0L);
                    if (cls.getHeapSizePerInstance() != -1L) break block42;
                    cls.setHeapSizePerInstance(0L);
                }
            }
            aa = new ArrayLong();
            aa.add(clsAddr);
            if (loaders.containsKey(jo)) {
                this.addLoaderClasses(objId, aa);
            }
            if (type != null) {
                try {
                    if (jo.isArray()) {
                        int arrayLen = jo.getArraySize();
                        this.exploreArray(this.indexToAddress, bootLoaderAddress, this.idToClass, jo, type, aa, arrayLen, listener);
                        break block43;
                    }
                    this.exploreObject(this.indexToAddress, bootLoaderAddress, this.idToClass, jo, type, aa, false, listener);
                }
                catch (CorruptDataException e) {
                    if (this.msgNoutboundReferences-- > 0) {
                        listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemGettingOutboundReferences, DTFJIndexBuilder.format(objAddr)), (Throwable)e);
                    }
                    break block43;
                }
            }
            if (debugInfo) {
                DTFJIndexBuilder.debugPrint("Null type");
            }
        }
        try {
            this.checkRefs(jo, Messages.DTFJIndexBuilder_CheckRefsObject, aa, jlc.getObjectAddress(), bootLoaderAddress, listener);
        }
        catch (CorruptDataException e) {
            listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemCheckingOutboundReferences, DTFJIndexBuilder.format(objAddr)), (Throwable)e);
        }
        this.addThreadRefs(objId, aa);
        this.addRefs(refd, objId, aa);
        this.outRefs.log(this.indexToAddress, objId, aa);
    }

    private long calculateArraySize(ClassImpl cls, int arrayLen, int pointerBytes) {
        int elem = cls.getName().equals("byte[]") ? 1 : (cls.getName().equals("short[]") ? 2 : (cls.getName().equals("int[]") ? 4 : (cls.getName().equals("long[]") ? 8 : (cls.getName().equals("boolean[]") ? 1 : (cls.getName().equals("char[]") ? 2 : (cls.getName().equals("float[]") ? 4 : (cls.getName().equals("double[]") ? 8 : pointerBytes)))))));
        long bigSize = 2L * (long)pointerBytes + 4L + (long)elem * (long)arrayLen;
        return bigSize;
    }

    private ClassImpl findJavaLangClassloader(IProgressListener listener) {
        return this.findClassFromName("java.lang.ClassLoader", listener);
    }

    private ClassImpl findClassFromName(String name, IProgressListener listener) {
        Iterator i = this.idToClass.values();
        while (i.hasNext()) {
            ClassImpl cls = (ClassImpl)i.next();
            if (cls != null) {
                if (!cls.getName().equals(name)) continue;
                return cls;
            }
            listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_NullClassImpl, i), null);
        }
        return null;
    }

    private void scanJavaThread(JavaThread th, long threadAddress, int pointerSize, HashMapIntObject<HashMapIntObject<List<XGCRootInfo>>> thr, IProgressListener listener, boolean scanUp, PrintWriter pw) throws CorruptDataException {
        Object next2;
        if (pw != null) {
            this.printThreadStack(pw, th);
        }
        int frameId = 0;
        HashSet<ImagePointer> searched = new HashSet<ImagePointer>();
        long veryFirstAddr = 0L;
        long prevAddr = 0L;
        long prevFrameAddress = 0L;
        Object nextFrame = null;
        Iterator ii = th.getStackFrames();
        while (nextFrame != null || ii.hasNext()) {
            if (nextFrame != null) {
                next2 = nextFrame;
                nextFrame = null;
            } else {
                next2 = ii.next();
            }
            if (!DTFJIndexBuilder.isCorruptData(next2, listener, Messages.DTFJIndexBuilder_CorruptDataReadingJavaStackFrames, th)) {
                long address;
                LinkedHashSet<ImagePointer> searchedInFrame;
                JavaStackFrame jf;
                block56: {
                    String sig;
                    String methodName;
                    jf = next2;
                    if (listener.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    searchedInFrame = new LinkedHashSet<ImagePointer>();
                    address = 0L;
                    long searchSize = 256L;
                    try {
                        ImagePointer ip = DTFJIndexBuilder.getAlignedAddress(jf.getBasePointer(), pointerSize);
                        address = ip.getAddress();
                        if (scanUp) {
                            if (ii.hasNext() && !DTFJIndexBuilder.isCorruptData(nextFrame = ii.next(), listener, Messages.DTFJIndexBuilder_CorruptDataReadingJavaStackFrames, th)) {
                                JavaStackFrame jf2 = nextFrame;
                                try {
                                    ImagePointer ip2 = DTFJIndexBuilder.getAlignedAddress(jf2.getBasePointer(), pointerSize);
                                    long address2 = ip2.getAddress();
                                    long s2 = address2 - address;
                                    if (s2 > 0L && s2 < searchSize) {
                                        searchSize = s2;
                                    }
                                }
                                catch (CorruptDataException ip2) {}
                            }
                        } else {
                            if (prevAddr == 0L) {
                                prevAddr = this.getJavaStackBase(th, address);
                            }
                            long s2 = address - prevAddr;
                            prevAddr = address;
                            if (s2 > 0L && s2 < searchSize) {
                                searchSize = s2;
                            }
                            searchSize = -searchSize;
                        }
                        if (veryFirstAddr == 0L) {
                            veryFirstAddr = Math.min(address, address + searchSize);
                        }
                        if (debugInfo) {
                            DTFJIndexBuilder.debugPrint("Frame " + jf.getLocation().getMethod().getName());
                        }
                        this.searchFrame(pointerSize, threadAddress, thr, ip, searchSize, 64, this.gcRoot, searchedInFrame, null);
                    }
                    catch (MemoryAccessException e) {
                        JavaLocation jl = null;
                        try {
                            jl = jf.getLocation();
                            JavaMethod jm = jl.getMethod();
                            String className = jm.getDeclaringClass().getName();
                            methodName = jm.getName();
                            String modifiers = this.getModifiers(jm, listener);
                            sig = jm.getSignature();
                            listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_PossibleProblemReadingJavaStackFramesMethod, frameId, DTFJIndexBuilder.format(address), searchSize, modifiers, className, methodName, sig, DTFJIndexBuilder.format(threadAddress)), (Throwable)e);
                        }
                        catch (DataUnavailable e2) {
                            listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_PossibleProblemReadingJavaStackFramesLocation, frameId, DTFJIndexBuilder.format(address), searchSize, jl, DTFJIndexBuilder.format(threadAddress)), (Throwable)e);
                        }
                        catch (CorruptDataException e2) {
                            if (jl != null) {
                                listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_PossibleProblemReadingJavaStackFramesLocation, frameId, DTFJIndexBuilder.format(address), searchSize, jl, DTFJIndexBuilder.format(threadAddress)), (Throwable)e);
                                break block56;
                            }
                            listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_PossibleProblemReadingJavaStackFrames, frameId, DTFJIndexBuilder.format(address), searchSize, DTFJIndexBuilder.format(threadAddress)), (Throwable)e);
                        }
                    }
                    catch (CorruptDataException e) {
                        JavaLocation jl = null;
                        try {
                            jl = jf.getLocation();
                            JavaMethod jm = jl.getMethod();
                            String className = jm.getDeclaringClass().getName();
                            methodName = jm.getName();
                            String modifiers = this.getModifiers(jm, listener);
                            try {
                                sig = jm.getSignature();
                            }
                            catch (CorruptDataException e2) {
                                sig = "()";
                            }
                            if (this.msgNproblemReadingJavaStackFrame-- > 0) {
                                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemReadingJavaStackFramesMethod, frameId, DTFJIndexBuilder.format(address), searchSize, modifiers, className, methodName, sig, DTFJIndexBuilder.format(threadAddress)), (Throwable)e);
                            }
                        }
                        catch (DataUnavailable e2) {
                            if (this.msgNproblemReadingJavaStackFrame-- > 0) {
                                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemReadingJavaStackFramesLocation, frameId, DTFJIndexBuilder.format(address), searchSize, jl, DTFJIndexBuilder.format(threadAddress)), (Throwable)e);
                            }
                        }
                        catch (CorruptDataException e2) {
                            if (jl != null) {
                                if (this.msgNproblemReadingJavaStackFrame-- > 0) {
                                    listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemReadingJavaStackFramesLocation, frameId, DTFJIndexBuilder.format(address), searchSize, jl, DTFJIndexBuilder.format(threadAddress)), (Throwable)e);
                                }
                                break block56;
                            }
                            if (this.msgNproblemReadingJavaStackFrame-- <= 0) break block56;
                            listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemReadingJavaStackFrames, frameId, DTFJIndexBuilder.format(address), searchSize, DTFJIndexBuilder.format(threadAddress)), (Throwable)e);
                        }
                    }
                }
                searched.addAll(searchedInFrame);
                if (pw != null) {
                    for (ImagePointer addr : searchedInFrame) {
                        try {
                            long target = this.getPointerAddressAt(addr, 0L, pointerSize);
                            this.printLocal(pw, target, frameId);
                        }
                        catch (MemoryAccessException target) {
                        }
                        catch (CorruptDataException target) {
                            // empty catch block
                        }
                    }
                }
                if (this.getExtraInfo) {
                    prevFrameAddress = DTFJIndexBuilder.getFrameAddress(jf, prevFrameAddress, pointerSize);
                }
                if (!this.getExtraInfo || address == 0L) {
                    try {
                        long clsAddress;
                        if (this.getExtraInfo && prevFrameAddress != 0L) {
                            clsAddress = prevFrameAddress;
                        } else {
                            JavaMethod jm = jf.getLocation().getMethod();
                            JavaClass cls = jm.getDeclaringClass();
                            clsAddress = this.getClassAddress(cls, listener);
                        }
                        int clsId = this.indexToAddress.reverse(clsAddress);
                        if (clsId >= 0) {
                            HashMapIntObject thr1 = (HashMapIntObject)thr.get(this.indexToAddress.reverse(threadAddress));
                            if (thr1 != null) {
                                this.addRoot((HashMapIntObject<List<XGCRootInfo>>)thr1, clsAddress, threadAddress, 64);
                            } else {
                                this.addRoot(this.gcRoot, clsAddress, threadAddress, 64);
                            }
                        }
                    }
                    catch (DataUnavailable dataUnavailable) {
                    }
                    catch (CorruptDataException corruptDataException) {
                        // empty catch block
                    }
                }
            }
            ++frameId;
        }
        if (pw != null) {
            pw.println();
        }
        ii = th.getStackSections();
        while (ii.hasNext()) {
            next2 = ii.next();
            if (DTFJIndexBuilder.isCorruptData(next2, listener, Messages.DTFJIndexBuilder_CorruptDataReadingJavaStackSections, th)) continue;
            ImageSection is = next2;
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            ImagePointer ip = is.getBaseAddress();
            long size = is.getSize();
            try {
                if (debugInfo) {
                    DTFJIndexBuilder.debugPrint("Java stack section");
                }
                if (size <= 0x100000L) {
                    this.searchFrame(pointerSize, threadAddress, thr, ip, size, 64, this.gcRoot, null, searched);
                    continue;
                }
                long size2 = size;
                size = 524288L;
                listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_HugeJavaStackSection, DTFJIndexBuilder.format(ip.getAddress()), size2, DTFJIndexBuilder.format(threadAddress), size), null);
                this.searchFrame(pointerSize, threadAddress, thr, ip, size, 64, this.gcRoot, null, searched);
                ip = ip.add(size2 - size);
                this.searchFrame(pointerSize, threadAddress, thr, ip, size, 64, this.gcRoot, null, searched);
            }
            catch (MemoryAccessException e) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemReadingJavaStackSection, DTFJIndexBuilder.format(ip.getAddress()), size, DTFJIndexBuilder.format(threadAddress)), (Throwable)e);
            }
            catch (CorruptDataException e) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemReadingJavaStackSection, DTFJIndexBuilder.format(ip.getAddress()), size, DTFJIndexBuilder.format(threadAddress)), (Throwable)e);
            }
        }
    }

    private void checkThreadBlockingObject(JavaThread th, IProgressListener listener) {
        try {
            JavaObject blockingObject = th.getBlockingObject();
            if (blockingObject != null) {
                long objAddress = blockingObject.getID().getAddress();
                long thrd2 = DTFJIndexBuilder.getThreadAddress(th, null);
                if (thrd2 != 0L) {
                    this.addRoot(this.gcRoot, objAddress, thrd2, 32);
                }
            }
        }
        catch (DTFJException e) {
            listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemReadingJavaThreadInformationFor, th), (Throwable)e);
        }
    }

    private long getJavaStackBase(JavaThread th, long addr) {
        Iterator ii = th.getStackSections();
        while (ii.hasNext()) {
            ImageSection is;
            long base;
            Object next2 = ii.next();
            if (next2 instanceof CorruptData || (base = (is = (ImageSection)next2).getBaseAddress().getAddress()) > addr || addr >= base + is.getSize()) continue;
            return base;
        }
        return 0L;
    }

    private void scanImageThread(JavaThread th, ImageThread it, long threadAddress, int pointerSize, HashMapIntObject<HashMapIntObject<List<XGCRootInfo>>> thr, IProgressListener listener) throws CorruptDataException {
        try {
            int frameId = 0;
            Object nextFrame = null;
            Iterator ii = it.getStackFrames();
            while (nextFrame != null || ii.hasNext()) {
                Object next2;
                if (nextFrame != null) {
                    next2 = nextFrame;
                    nextFrame = null;
                } else {
                    next2 = ii.next();
                }
                if (!DTFJIndexBuilder.isCorruptData(next2, listener, Messages.DTFJIndexBuilder_CorruptDataReadingNativeStackFrames, th)) {
                    ImageStackFrame jf = next2;
                    if (listener.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    ImagePointer ip = jf.getBasePointer();
                    long searchSize = 2048L;
                    if (ii.hasNext() && !DTFJIndexBuilder.isCorruptData(nextFrame = ii.next(), listener, Messages.DTFJIndexBuilder_CorruptDataReadingNativeStackFrames, th)) {
                        ImageStackFrame jf2 = nextFrame;
                        try {
                            ImagePointer ip2 = jf2.getBasePointer();
                            long s2 = ip2.getAddress() - ip.getAddress();
                            if (s2 > 0L && s2 < searchSize) {
                                searchSize = s2;
                            }
                        }
                        catch (CorruptDataException corruptDataException) {
                            // empty catch block
                        }
                    }
                    try {
                        if (debugInfo) {
                            DTFJIndexBuilder.debugPrint("native stack frame");
                        }
                        this.searchFrame(pointerSize, threadAddress, thr, ip, searchSize, 128, this.gcRoot, null, null);
                    }
                    catch (MemoryAccessException e) {
                        listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_PossibleProblemReadingNativeStackFrame, frameId, DTFJIndexBuilder.format(ip.getAddress()), searchSize, DTFJIndexBuilder.format(threadAddress)), (Throwable)e);
                    }
                    catch (CorruptDataException e) {
                        listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemReadingNativeStackFrame, frameId, DTFJIndexBuilder.format(ip.getAddress()), searchSize, DTFJIndexBuilder.format(threadAddress)), (Throwable)e);
                    }
                }
                ++frameId;
            }
        }
        catch (DataUnavailable e) {
            listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_NativeStackFrameNotFound, DTFJIndexBuilder.format(threadAddress)), (Throwable)e);
        }
        Iterator ii = it.getStackSections();
        while (ii.hasNext()) {
            Object next2 = ii.next();
            if (DTFJIndexBuilder.isCorruptData(next2, listener, Messages.DTFJIndexBuilder_DTFJIndexBuilder_CorruptDataReadingNativeStackSection, th)) continue;
            ImageSection is = (ImageSection)next2;
            ImagePointer ip = is.getBaseAddress();
            long size = is.getSize();
            try {
                if (debugInfo) {
                    DTFJIndexBuilder.debugPrint("native stack section");
                }
                if (size <= 0x100000L) {
                    this.searchFrame(pointerSize, threadAddress, thr, ip, size, 128, this.gcRoot, null, null);
                    continue;
                }
                long size2 = size;
                size = 524288L;
                listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_HugeNativeStackSection, DTFJIndexBuilder.format(ip.getAddress()), size2, DTFJIndexBuilder.format(threadAddress), size), null);
                this.searchFrame(pointerSize, threadAddress, thr, ip, size, 128, this.gcRoot, null, null);
                ip = ip.add(size2 - size);
                this.searchFrame(pointerSize, threadAddress, thr, ip, size, 128, this.gcRoot, null, null);
            }
            catch (MemoryAccessException e) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemReadingNativeStackSection, DTFJIndexBuilder.format(ip.getAddress()), size, DTFJIndexBuilder.format(threadAddress)), (Throwable)e);
            }
            catch (CorruptDataException e) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemReadingNativeStackSection, DTFJIndexBuilder.format(ip.getAddress()), size, DTFJIndexBuilder.format(threadAddress)), (Throwable)e);
            }
        }
    }

    private int newRootType(int rootType) {
        return GCRootInfo.getTypeAsString((int)rootType) != null ? rootType : 1;
    }

    private void processRoot(JavaReference r, JavaThread thread, HashMapIntObject<List<XGCRootInfo>> gcRoot2, HashMapIntObject<HashMapIntObject<List<XGCRootInfo>>> threadRoots2, int pointerSize, IProgressListener listener) {
        if (debugInfo) {
            DTFJIndexBuilder.debugPrint("Process root " + r);
        }
        int type = 0;
        boolean threadRoot = false;
        int rootType = 0;
        try {
            rootType = r.getRootType();
            switch (rootType) {
                case 1: {
                    type = 8;
                    break;
                }
                case 5: {
                    type = 128;
                    type = 4;
                    threadRoot = true;
                    break;
                }
                case 3: {
                    type = 32;
                    threadRoot = true;
                    break;
                }
                case 4: {
                    type = 64;
                    threadRoot = true;
                    break;
                }
                case 2: {
                    type = 2;
                    break;
                }
                case 6: {
                    type = 256;
                    break;
                }
                case 7: {
                    if (debugInfo) {
                        DTFJIndexBuilder.debugPrint("Root type HEAP_ROOT_OTHER");
                    }
                    type = 1;
                    break;
                }
                case 0: {
                    if (debugInfo) {
                        DTFJIndexBuilder.debugPrint("Root type HEAP_ROOT_UNKNOWN");
                    }
                    type = 1;
                    break;
                }
                case 8: {
                    type = 512;
                    this.foundFinalizableGCRoots = true;
                    break;
                }
                case 9: {
                    type = 1024;
                    break;
                }
                case 10: {
                    type = 2;
                    break;
                }
                case 11: {
                    type = 1;
                    break;
                }
                default: {
                    if (debugInfo) {
                        DTFJIndexBuilder.debugPrint("Unknown root type " + rootType);
                    }
                    type = 1;
                    break;
                }
            }
        }
        catch (CorruptDataException e) {
            type = 1;
            listener.sendUserMessage(IProgressListener.Severity.INFO, Messages.DTFJIndexBuilder_UnableToFindTypeOfRoot, (Throwable)e);
        }
        int reach = 0;
        try {
            reach = r.getReachability();
            switch (reach) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    return;
                }
            }
        }
        catch (CorruptDataException e) {
            listener.sendUserMessage(IProgressListener.Severity.INFO, Messages.DTFJIndexBuilder_UnableToFindReachabilityOfRoot, (Throwable)e);
        }
        int refType = 0;
        try {
            refType = r.getReferenceType();
        }
        catch (CorruptDataException e) {
            listener.sendUserMessage(IProgressListener.Severity.INFO, Messages.DTFJIndexBuilder_UnableToFindReferenceTypeOfRoot, (Throwable)e);
        }
        try {
            String desc2;
            long target = 0L;
            Object o = r.getTarget();
            if (o instanceof JavaObject) {
                JavaObject jo = (JavaObject)o;
                target = jo.getID().getAddress();
            } else if (o instanceof JavaClass) {
                JavaClass jc = (JavaClass)o;
                target = this.getClassAddress(jc, listener);
            } else {
                if (o != null) {
                    listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_UnableToFindTargetOfRoot, o, o.getClass()), null);
                    if (debugInfo) {
                        DTFJIndexBuilder.debugPrint("Unexpected root type " + o.getClass());
                    }
                } else {
                    listener.sendUserMessage(IProgressListener.Severity.INFO, Messages.DTFJIndexBuilder_NullTargetOfRoot, null);
                    if (debugInfo) {
                        DTFJIndexBuilder.debugPrint("Unexpected null root target");
                    }
                }
                return;
            }
            long source = target;
            try {
                Object so = r.getSource();
                if (so instanceof JavaObject) {
                    JavaObject jo = (JavaObject)so;
                    source = jo.getID().getAddress();
                } else if (so instanceof JavaClass) {
                    JavaClass jc = (JavaClass)so;
                    source = this.getClassAddress(jc, listener);
                } else if (so instanceof JavaStackFrame) {
                    JavaStackFrame js = (JavaStackFrame)so;
                    if (this.getExtraInfo) {
                        source = DTFJIndexBuilder.getAlignedAddress(js.getBasePointer(), pointerSize).getAddress();
                    }
                    if (!(thread == null || this.getExtraInfo && source != 0L && this.indexToAddress.reverse(source) >= 0)) {
                        source = DTFJIndexBuilder.getThreadAddress(thread, listener);
                    }
                } else if (so instanceof JavaThread) {
                    String desc;
                    JavaThread jt = (JavaThread)so;
                    source = DTFJIndexBuilder.getThreadAddress(jt, listener);
                    if (thread != null && (source == 0L || this.indexToAddress.reverse(source) < 0)) {
                        source = DTFJIndexBuilder.getThreadAddress(thread, listener);
                    }
                    if ((desc = r.getDescription()).startsWith("stack") || desc.startsWith("Register")) {
                        type = 128;
                        threadRoot = true;
                    }
                } else if (so instanceof JavaRuntime) {
                    if (debugInfo) {
                        DTFJIndexBuilder.debugPrint("Unexpected source " + so);
                    }
                } else if (so != null && debugInfo) {
                    DTFJIndexBuilder.debugPrint("Unexpected source " + so);
                }
            }
            catch (CorruptDataException e) {
                listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_UnableToFindSourceOfRoot, DTFJIndexBuilder.format(target)), (Throwable)e);
            }
            catch (DataUnavailable e) {
                listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_UnableToFindSourceOfRoot, DTFJIndexBuilder.format(target)), (Throwable)e);
            }
            int targetId = this.indexToAddress.reverse(target);
            String desc = String.valueOf(targetId) + " " + DTFJIndexBuilder.format(target) + " " + DTFJIndexBuilder.format(source) + " " + rootType + " " + refType + " " + reach + " " + r.getDescription();
            if (targetId < 0) {
                desc2 = "";
                CorruptDataException e1 = null;
                try {
                    if (o instanceof JavaObject) {
                        JavaObject jo = (JavaObject)o;
                        desc2 = this.getClassName(jo.getJavaClass(), listener);
                    } else if (o instanceof JavaClass) {
                        JavaClass jc = (JavaClass)o;
                        desc2 = this.getClassName(jc, listener);
                    } else {
                        desc2 = String.valueOf(desc2) + o;
                    }
                }
                catch (CorruptDataException e) {
                    e1 = e;
                }
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_UnableToFindRoot, DTFJIndexBuilder.format(target), desc2, DTFJIndexBuilder.format(source), rootType, r.getDescription()), (Throwable)e1);
                return;
            }
            if (this.newRootType(type) == 1) {
                desc2 = "";
                CorruptDataException e1 = null;
                try {
                    if (o instanceof JavaObject) {
                        JavaObject jo = (JavaObject)o;
                        desc2 = this.getClassName(jo.getJavaClass(), listener);
                    } else if (o instanceof JavaClass) {
                        JavaClass jc = (JavaClass)o;
                        desc2 = this.getClassName(jc, listener);
                    } else {
                        desc2 = o.toString();
                    }
                }
                catch (CorruptDataException e) {
                    e1 = e;
                }
                listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_MATRootTypeUnknown, type, DTFJIndexBuilder.format(target), desc2, DTFJIndexBuilder.format(source), rootType, r.getDescription()), (Throwable)e1);
            }
            if (threadRoot) {
                int thrId = this.indexToAddress.reverse(source);
                if (thrId >= 0) {
                    HashMapIntObject thr = (HashMapIntObject)threadRoots2.get(thrId);
                    if (thr == null) {
                        thr = new HashMapIntObject();
                        threadRoots2.put(thrId, (Object)thr);
                    }
                    this.addRoot((HashMapIntObject<List<XGCRootInfo>>)thr, target, source, type);
                } else {
                    this.addRoot(gcRoot2, target, source, type);
                }
            } else {
                this.addRoot(gcRoot2, target, source, type);
            }
            int tgt = targetId;
            int src = this.indexToAddress.reverse(source);
            if (src < 0) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_UnableToFindSourceID, DTFJIndexBuilder.format(target), DTFJIndexBuilder.format(source), r.getDescription()), null);
            }
            this.missedRoots.put(Integer.valueOf(tgt).intValue(), (Object)desc);
        }
        catch (DataUnavailable e) {
            listener.sendUserMessage(IProgressListener.Severity.WARNING, Messages.DTFJIndexBuilder_ProblemGettingRoots, (Throwable)e);
        }
        catch (CorruptDataException e) {
            listener.sendUserMessage(IProgressListener.Severity.WARNING, Messages.DTFJIndexBuilder_ProblemGettingRoots, (Throwable)e);
        }
    }

    private long getObjectSize(JavaObject jo, int pointerSize) throws CorruptDataException {
        long s = jo.getSize() + 7L & 0xFFFFFFFFFFFFFFF8L;
        return s;
    }

    private static ImagePointer getAlignedAddress(ImagePointer p, int pointerSize) {
        if (p == null) {
            return p;
        }
        long addr = p.getAddress();
        addr = pointerSize == 64 ? (addr &= 7L) : (addr &= 3L);
        return p.add(-addr);
    }

    private HashMapIntObject<ClassImpl> copy(HashMapIntObject<ClassImpl> idToClass1) {
        HashMapIntObject idToClass2 = new HashMapIntObject(idToClass1.size());
        IteratorInt ii = idToClass1.keys();
        while (ii.hasNext()) {
            int i = ii.next();
            idToClass2.put(i, (Object)((ClassImpl)idToClass1.get(i)));
        }
        return idToClass2;
    }

    private IndexWriter.IntIndexCollector copy(IIndexReader.IOne2OneIndex objectToClass1, int bits) {
        IndexWriter.IntIndexCollector objectToClass2 = new IndexWriter.IntIndexCollector(objectToClass1.size(), bits);
        int i = 0;
        while (i < objectToClass1.size()) {
            int j = objectToClass1.get(i);
            objectToClass2.set(i, j);
            ++i;
        }
        return objectToClass2;
    }

    private HashMapIntObject<ArrayLong> initLoaderClassesCache() {
        HashMapIntObject cache = new HashMapIntObject();
        Iterator i = this.idToClass.values();
        while (i.hasNext()) {
            ClassImpl ci = (ClassImpl)i.next();
            int load = ci.getClassLoaderId();
            if (!cache.containsKey(load)) {
                cache.put(load, (Object)new ArrayLong());
            }
            ArrayLong classes = (ArrayLong)cache.get(load);
            if (this.getExtraInfo2 && ci.getName().contains(METHOD_NAME_SIG)) continue;
            if (debugInfo) {
                DTFJIndexBuilder.debugPrint("Adding ref to class " + ci.getObjectId() + " at address " + DTFJIndexBuilder.format(ci.getObjectAddress()) + " for loader " + load);
            }
            classes.add(ci.getObjectAddress());
        }
        return cache;
    }

    private void addLoaderClasses(int objId, ArrayLong aa) {
        ArrayLong classes;
        if (debugInfo) {
            DTFJIndexBuilder.debugPrint("Found loader " + objId + " at address " + DTFJIndexBuilder.format(this.indexToAddress.get(objId)) + " size=" + this.idToClass.size());
        }
        if ((classes = (ArrayLong)this.loaderClassCache.get(objId)) != null) {
            aa.addAll(classes);
        }
    }

    private static boolean isCorruptData(Object next, IProgressListener listener, String msg) {
        if (next instanceof CorruptData) {
            CorruptData d = (CorruptData)next;
            if (listener != null) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(msg, DTFJIndexBuilder.formattedCorruptDataAddress(d), d.toString()), (Throwable)new CorruptDataException(d));
            }
            return true;
        }
        return false;
    }

    private boolean isCorruptData(Object next, IProgressListener listener, String msg, String detail, long addr) {
        if (next instanceof CorruptData) {
            CorruptData d = (CorruptData)next;
            if (listener != null) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(msg, DTFJIndexBuilder.formattedCorruptDataAddress(d), d.toString(), detail, DTFJIndexBuilder.format(addr)), (Throwable)new CorruptDataException(d));
            }
            return true;
        }
        return false;
    }

    private static String formattedCorruptDataAddress(CorruptData d) {
        ImagePointer ip = d.getAddress();
        if (ip != null) {
            return DTFJIndexBuilder.format(d.getAddress().getAddress());
        }
        return "null";
    }

    private static boolean isCorruptData(Object next, IProgressListener listener, String msg, JavaRuntime detail) {
        if (next instanceof CorruptData) {
            long addr;
            CorruptData d = (CorruptData)next;
            try {
                addr = detail.getJavaVM().getAddress();
            }
            catch (CorruptDataException e) {
                addr = 0L;
            }
            DTFJIndexBuilder.logCorruptData(listener, msg, d, addr);
            return true;
        }
        return false;
    }

    private static boolean isCorruptData(Object next, IProgressListener listener, String msg, JavaClassLoader detail) {
        if (next instanceof CorruptData) {
            long addr;
            CorruptData d = (CorruptData)next;
            try {
                JavaObject ldr = detail.getObject();
                addr = ldr != null ? ldr.getID().getAddress() : 0L;
            }
            catch (CorruptDataException e) {
                addr = 0L;
            }
            DTFJIndexBuilder.logCorruptData(listener, msg, d, addr);
            return true;
        }
        return false;
    }

    private boolean isCorruptData(Object next, IProgressListener listener, String msg, JavaClass detail) {
        if (next instanceof CorruptData) {
            String name;
            CorruptData d = (CorruptData)next;
            long addr = this.getClassAddress(detail, listener);
            try {
                name = detail.getName();
            }
            catch (CorruptDataException e) {
                name = e.toString();
            }
            if (listener != null) {
                listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageFormat.format(msg, DTFJIndexBuilder.formattedCorruptDataAddress(d), d.toString(), name, DTFJIndexBuilder.format(addr)), (Throwable)new CorruptDataException(d));
            }
            return true;
        }
        return false;
    }

    private boolean isCorruptData(Object next, IProgressListener listener, String msg, JavaClass jc, JavaMethod detail) {
        if (next instanceof CorruptData) {
            String methSig;
            String methName;
            String clsName;
            CorruptData d = (CorruptData)next;
            try {
                clsName = jc != null ? jc.getName() : "";
            }
            catch (CorruptDataException e) {
                clsName = e.toString();
            }
            try {
                methName = detail.getName();
            }
            catch (CorruptDataException e) {
                methName = e.toString();
            }
            try {
                methSig = detail.getSignature();
            }
            catch (CorruptDataException e) {
                methSig = e.toString();
            }
            long addr = jc != null ? this.getClassAddress(jc, listener) : 0L;
            String modifiers = this.getModifiers(detail, listener);
            if (listener != null) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(msg, DTFJIndexBuilder.formattedCorruptDataAddress(d), d.toString(), clsName, DTFJIndexBuilder.format(addr), modifiers, clsName, methName, methSig), (Throwable)new CorruptDataException(d));
            }
            return true;
        }
        return false;
    }

    private String getModifiers(JavaMethod detail, IProgressListener listener) {
        int mods;
        Throwable e1 = null;
        try {
            mods = detail.getModifiers();
        }
        catch (CorruptDataException e) {
            mods = 0;
            e1 = e;
        }
        int expectedMods = 3391;
        int unexpectedMods = mods & 0xFFFFF2C0;
        if ((e1 != null || unexpectedMods != 0) && this.msgNunexpectedModifiers-- >= 0) {
            String sig;
            String methClass;
            String methName;
            String m1;
            block10: {
                block9: {
                    m1 = Modifier.toString(unexpectedMods);
                    methName = "";
                    methClass = "";
                    sig = "";
                    try {
                        methName = detail.getName();
                        methClass = detail.getDeclaringClass().getName();
                    }
                    catch (CorruptDataException e) {
                        if (e1 == null) {
                            e1 = e;
                        }
                    }
                    catch (DataUnavailable e) {
                        if (e1 != null) break block9;
                        e1 = e;
                    }
                }
                try {
                    sig = detail.getSignature();
                }
                catch (CorruptDataException e) {
                    sig = "()";
                    if (e1 != null) break block10;
                    e1 = e;
                }
            }
            String mod = Modifier.toString(mods);
            listener.sendUserMessage(Severity_INFO, MessageFormat.format(Messages.DTFJIndexBuilder_UnexpectedModifiers, DTFJIndexBuilder.format(unexpectedMods), m1, mod, methClass, methName, sig), e1);
        }
        String modifiers = Modifier.toString(mods & 0xD3F);
        return modifiers;
    }

    private static boolean isCorruptData(Object next, IProgressListener listener, String msg, JavaThread detail) {
        if (next instanceof CorruptData) {
            String name;
            long addr;
            CorruptData d = (CorruptData)next;
            if (detail == null) {
                addr = 0L;
                name = "";
            } else {
                addr = DTFJIndexBuilder.getThreadAddress(detail, null);
                try {
                    name = detail.getName();
                }
                catch (CorruptDataException e) {
                    name = e.toString();
                }
            }
            if (listener != null) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(msg, DTFJIndexBuilder.formattedCorruptDataAddress(d), d.toString(), name, DTFJIndexBuilder.format(addr)), (Throwable)new CorruptDataException(d));
            }
            return true;
        }
        return false;
    }

    private static void logCorruptData(IProgressListener listener, String msg, CorruptData d, long addr) {
        if (listener != null) {
            listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageFormat.format(msg, DTFJIndexBuilder.formattedCorruptDataAddress(d), d.toString(), DTFJIndexBuilder.format(addr)), (Throwable)new CorruptDataException(d));
        }
    }

    static RuntimeInfo getRuntime(ImageFactory fact, Image image, Serializable requestedId, IProgressListener listener) throws IOException, MultipleSnapshotsException {
        ImageAddressSpace ias = null;
        ImageProcess proc = null;
        JavaRuntime run = null;
        String fullRuntimeId = null;
        int nAddr = 0;
        int nProc = 0;
        int nJavaRuntimes = 0;
        ArrayList<MultipleSnapshotsException.Context> runtimes = new ArrayList<MultipleSnapshotsException.Context>();
        String lastAddr = "";
        String lastProc = "";
        String lastJavaRuntime = "";
        if ("".equals(requestedId)) {
            requestedId = null;
        }
        String[] sp = (requestedId instanceof String ? (String)((Object)requestedId) : "").split("\\.", 3);
        String id0 = sp[0];
        String id1 = sp.length > 1 ? sp[1] : "";
        String id2 = sp.length > 2 ? sp[2] : "";
        ImageProcess currentProc = DTFJIndexBuilder.currentProcess(image);
        JavaRuntime currentRuntime = DTFJIndexBuilder.currentRuntime(currentProc);
        int addrId = 0;
        Iterator i1 = image.getAddressSpaces();
        while (i1.hasNext()) {
            Object next1 = i1.next();
            if (!DTFJIndexBuilder.isCorruptData(next1, listener, Messages.DTFJIndexBuilder_CorruptDataReadingAddressSpaces)) {
                ias = (ImageAddressSpace)next1;
                ++nAddr;
                lastAddr = DTFJIndexBuilder.addressSpaceId(ias, addrId);
                int procId = 0;
                Iterator i2 = ias.getProcesses();
                while (i2.hasNext()) {
                    Object next2 = i2.next();
                    if (!DTFJIndexBuilder.isCorruptData(next2, listener, Messages.DTFJIndexBuilder_CorruptDataReadingProcesses)) {
                        proc = (ImageProcess)next2;
                        ++nProc;
                        lastProc = DTFJIndexBuilder.processId(proc, procId, listener);
                        int runtimeId = 0;
                        Iterator i3 = proc.getRuntimes();
                        while (i3.hasNext()) {
                            Object next3 = i3.next();
                            if (!DTFJIndexBuilder.isCorruptData(next3, listener, Messages.DTFJIndexBuilder_CorruptDataReadingRuntimes)) {
                                String currentId = String.valueOf(lastAddr) + METHOD_NAME_PREFIX + lastProc + METHOD_NAME_PREFIX + runtimeId;
                                if (next3 instanceof JavaRuntime) {
                                    JavaRuntime runtime = (JavaRuntime)next3;
                                    try {
                                        lastJavaRuntime = DTFJIndexBuilder.format(runtime.getJavaVM().getAddress());
                                    }
                                    catch (CorruptDataException e) {
                                        lastJavaRuntime = Integer.toString(runtimeId);
                                    }
                                    currentId = String.valueOf(lastAddr) + METHOD_NAME_PREFIX + lastProc + METHOD_NAME_PREFIX + lastJavaRuntime;
                                    ++nJavaRuntimes;
                                    boolean inCurrentRuntime = runtime.equals((Object)currentRuntime) || currentRuntime == null;
                                    CorruptDataException e1 = null;
                                    String version = null;
                                    try {
                                        version = runtime.getVersion();
                                    }
                                    catch (CorruptDataException e) {
                                        e1 = e;
                                    }
                                    runtimes.add(DTFJIndexBuilder.getRuntimeDetails(lastAddr, lastProc, lastJavaRuntime, runtime));
                                    if (run == null && (requestedId == null && inCurrentRuntime || currentId.equals(requestedId) || (id0.length() == 0 || id0.equals(lastAddr) || id0.equals(Integer.toString(addrId))) && (id1.length() == 0 || id1.equals(lastProc) || id1.equals(Integer.toString(procId))) && (id2.length() == 0 || id2.equals(lastJavaRuntime) || id2.equals(Integer.toString(runtimeId))))) {
                                        run = runtime;
                                        fullRuntimeId = currentId;
                                        if (requestedId != null && listener != null) {
                                            listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_FoundJavaRuntime, currentId, lastAddr, lastProc, lastJavaRuntime, version), (Throwable)e1);
                                        }
                                    }
                                } else {
                                    ManagedRuntime mr = (ManagedRuntime)next3;
                                    CorruptDataException e1 = null;
                                    String version = null;
                                    try {
                                        version = mr.getVersion();
                                    }
                                    catch (CorruptDataException e) {
                                        e1 = e;
                                    }
                                    if (listener != null) {
                                        listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_IgnoringManagedRuntime, currentId, lastAddr, lastProc, lastJavaRuntime, version), (Throwable)e1);
                                    }
                                }
                            }
                            ++runtimeId;
                        }
                    }
                    ++procId;
                }
            }
            ++addrId;
        }
        if (run == null) {
            if (requestedId != null) {
                throw new IOException(MessageFormat.format(Messages.DTFJIndexBuilder_UnableToFindJavaRuntimeId, requestedId, nAddr, lastAddr, nProc, lastProc, nJavaRuntimes, lastJavaRuntime));
            }
            throw new IOException(MessageFormat.format(Messages.DTFJIndexBuilder_UnableToFindJavaRuntime, nAddr, lastAddr, nProc, lastProc, nJavaRuntimes, lastJavaRuntime));
        }
        if (requestedId == null) {
            if (nJavaRuntimes > 1) {
                MultipleSnapshotsException multipleRuntimeException = new MultipleSnapshotsException(MessageUtil.format((String)Messages.DTFJIndexBuilder_JavaRuntimesFound, (Object[])new Object[]{nJavaRuntimes}));
                for (MultipleSnapshotsException.Context runtime : runtimes) {
                    multipleRuntimeException.addContext(runtime);
                }
                throw multipleRuntimeException;
            }
            fullRuntimeId = null;
        }
        return new RuntimeInfo(fact, image, ias, proc, run, fullRuntimeId);
    }

    private static MultipleSnapshotsException.Context getRuntimeDetails(String addressSpace, String process, String runtimeId, JavaRuntime runtime) {
        String uniqueContext = String.valueOf(addressSpace) + METHOD_NAME_PREFIX + process + METHOD_NAME_PREFIX + runtimeId;
        MultipleSnapshotsException.Context context = new MultipleSnapshotsException.Context(uniqueContext);
        String description = MessageFormat.format(Messages.DTFJIndexBuilder_Runtime_Description, addressSpace, process, runtimeId);
        context.setDescription(description);
        String version = "";
        try {
            version = runtime.getVersion();
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        context.setVersion(version);
        try {
            Iterator optsIter = runtime.getJavaVMInitArgs().getOptions();
            while (optsIter.hasNext()) {
                Object o = optsIter.next();
                if (!(o instanceof JavaVMOption)) continue;
                JavaVMOption jvmOpt = (JavaVMOption)o;
                context.addOption(jvmOpt.getOptionString());
            }
        }
        catch (DataUnavailable dataUnavailable) {
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        return context;
    }

    private static String addressSpaceId(ImageAddressSpace ias, int addrId) {
        String lastAddr = null;
        try {
            lastAddr = ias.getID();
        }
        catch (DataUnavailable dataUnavailable) {
        }
        catch (CorruptDataException corruptDataException) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        if (lastAddr == null) {
            String defaultToString;
            lastAddr = ias.toString();
            if (lastAddr.equals(defaultToString = String.valueOf(ias.getClass().getName()) + '@' + Integer.toHexString(System.identityHashCode(ias)))) {
                lastAddr = Integer.toString(addrId);
            }
            if (lastAddr.matches(".*0x[0-9A-Fa-f]+")) {
                lastAddr = lastAddr.substring(lastAddr.lastIndexOf("0x"));
            }
        }
        return lastAddr;
    }

    private static String processId(ImageProcess proc, int procId, IProgressListener listener) {
        String lastProc;
        try {
            lastProc = proc.getID();
            if (lastProc.matches("[0123456789]")) {
                lastProc = "0x" + lastProc;
            }
        }
        catch (DataUnavailable e) {
            if (listener != null) {
                listener.sendUserMessage(IProgressListener.Severity.INFO, Messages.DTFJIndexBuilder_ErrorReadingProcessID, (Throwable)e);
            }
            lastProc = Integer.toString(procId);
        }
        catch (CorruptDataException e) {
            if (listener != null) {
                listener.sendUserMessage(IProgressListener.Severity.INFO, Messages.DTFJIndexBuilder_ErrorReadingProcessID, (Throwable)e);
            }
            lastProc = Integer.toString(procId);
        }
        return lastProc;
    }

    private static ImageProcess currentProcess(Image image) {
        int spaces = 0;
        ImageAddressSpace firstSpace = null;
        Iterator i1 = image.getAddressSpaces();
        while (i1.hasNext()) {
            Object next1 = i1.next();
            if (next1 instanceof CorruptData) continue;
            ++spaces;
            ImageAddressSpace ias = (ImageAddressSpace)next1;
            ImageProcess currentProc = ias.getCurrentProcess();
            if (currentProc != null) {
                return currentProc;
            }
            if (++spaces != 1) continue;
            firstSpace = ias;
        }
        if (spaces == 1) {
            int processes = 0;
            ImageProcess firstProc = null;
            Iterator i2 = firstSpace.getProcesses();
            while (i2.hasNext()) {
                Object next2 = i2.next();
                if (next2 instanceof CorruptData || ++processes != 1) continue;
                firstProc = (ImageProcess)next2;
            }
            if (processes == 1) {
                return firstProc;
            }
        }
        return null;
    }

    private static JavaRuntime currentRuntime(ImageProcess proc) {
        if (proc == null) {
            return null;
        }
        try {
            ImageThread imgThrd = proc.getCurrentThread();
            if (imgThrd != null) {
                Iterator i3 = proc.getRuntimes();
                while (i3.hasNext()) {
                    Object next3 = i3.next();
                    if (next3 instanceof CorruptData || !(next3 instanceof JavaRuntime)) continue;
                    JavaRuntime runtime = (JavaRuntime)next3;
                    Iterator i4 = runtime.getThreads();
                    while (i4.hasNext()) {
                        Object next4 = i4.next();
                        if (next4 instanceof CorruptData || !(next4 instanceof JavaThread)) continue;
                        JavaThread jt = (JavaThread)next4;
                        try {
                            if (!imgThrd.equals(jt.getImageThread())) continue;
                            return runtime;
                        }
                        catch (DataUnavailable dataUnavailable) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        catch (CorruptDataException imgThrd) {
        }
        catch (UnsupportedOperationException imgThrd) {
            // empty catch block
        }
        int runtimes = 0;
        JavaRuntime firstRuntime = null;
        Iterator i3 = proc.getRuntimes();
        while (i3.hasNext()) {
            Object next3 = i3.next();
            if (next3 instanceof CorruptData || !(next3 instanceof JavaRuntime) || ++runtimes != 1) continue;
            firstRuntime = (JavaRuntime)next3;
        }
        if (runtimes == 1) {
            return firstRuntime;
        }
        return null;
    }

    private int getPointerSize(RuntimeInfo info, IProgressListener listener) {
        int pointerSize = 0;
        long maxAddress = 0L;
        ImageAddressSpace ias = info.getImageAddressSpace();
        Iterator it = ias.getImageSections();
        while (it.hasNext()) {
            Object next1 = it.next();
            if (next1 instanceof CorruptData) continue;
            ImageSection sect = (ImageSection)next1;
            maxAddress = Math.max(maxAddress, sect.getBaseAddress().getAddress());
            maxAddress = Math.max(maxAddress, sect.getBaseAddress().getAddress() + sect.getSize() - 1L);
        }
        ImageProcess proc = info.getImageProcess();
        JavaRuntime run = info.getJavaRuntime();
        pointerSize = proc.getPointerSize();
        long ptrBits = 0L;
        long longBits = 0L;
        try {
            ImagePointer ip = run.getJavaVM();
            int i = 0;
            while (i < 200) {
                ImagePointer pointer = ip.getPointerAt((long)i);
                if (pointer != null) {
                    ptrBits |= pointer.getAddress();
                }
                longBits |= ip.getLongAt((long)i);
                ++i;
            }
        }
        catch (CorruptDataException corruptDataException) {
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
        if (longBits == -1L) {
            this.addressSpacePointerSize = 0;
            while (ptrBits != 0L) {
                ++this.addressSpacePointerSize;
                ptrBits >>>= 1;
            }
            if (this.addressSpacePointerSize != pointerSize) {
                listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_UsingProcessPointerSizeNotAddressSpacePointerSize, pointerSize, ias.toString(), this.addressSpacePointerSize), null);
            }
        }
        if ((maxAddress & (-1L >>> 64 - pointerSize ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_HighestMemoryAddressFromAddressSpaceIsUnaccessibleFromPointers, DTFJIndexBuilder.format(maxAddress), ias.toString(), pointerSize), null);
        }
        return pointerSize;
    }

    private int getPointerBytes(int pointerSize) {
        return (pointerSize + 7) / 8;
    }

    private void addRootForThreads(JavaObject obj, Iterator<?> j, IProgressListener listener) {
        while (j.hasNext()) {
            Object next2 = j.next();
            if (DTFJIndexBuilder.isCorruptData(next2, listener, Messages.DTFJIndexBuilder_CorruptDataReadingThreadsFromMonitors)) continue;
            JavaThread jt2 = (JavaThread)next2;
            this.addRootForThread(obj, jt2, listener);
        }
    }

    private void addRootForThread(JavaObject obj, JavaThread jt2, IProgressListener listener) {
        long objAddress = obj.getID().getAddress();
        if (jt2 != null) {
            long thrd2 = DTFJIndexBuilder.getThreadAddress(jt2, null);
            if (thrd2 != 0L) {
                int thrId = this.indexToAddress.reverse(thrd2);
                if (thrId >= 0) {
                    HashMapIntObject thr = (HashMapIntObject)this.threadRoots.get(thrId);
                    if (thr != null) {
                        this.addRoot((HashMapIntObject<List<XGCRootInfo>>)thr, objAddress, thrd2, 32);
                        return;
                    }
                    listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemFindingRootInformation, DTFJIndexBuilder.format(thrd2), DTFJIndexBuilder.format(objAddress)), null);
                } else {
                    listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemFindingThread, DTFJIndexBuilder.format(thrd2), DTFJIndexBuilder.format(objAddress)), null);
                }
            }
        } else if (debugInfo) {
            DTFJIndexBuilder.debugPrint("Null thread, so no thread specific root");
        }
        this.addRoot(this.gcRoot, objAddress, objAddress, 32);
    }

    private void checkRefs(Object type, String desc, ArrayLong aa, long addrJavaLangClass, long bootLoaderAddress, IProgressListener listener) throws CorruptDataException {
        Iterator i2;
        long objAddr;
        if (!this.haveDTFJRefs) {
            return;
        }
        if (!this.useDTFJRefs && !debugInfo) {
            return;
        }
        RefStore objset = debugInfo ? new RefMap() : new RefSet();
        boolean hasDTFJRefs = false;
        String name = "";
        if (type instanceof JavaClass) {
            JavaClass sup;
            JavaObject clsObj;
            JavaClass jc = (JavaClass)type;
            try {
                clsObj = jc.getObject();
            }
            catch (CorruptDataException e) {
                clsObj = null;
            }
            if (clsObj != null) {
                JavaClass javaClass = clsObj.getJavaClass();
            }
            name = this.getClassName(jc, listener);
            objAddr = this.getClassAddress(jc, listener);
            try {
                if (clsObj != null) {
                    i2 = clsObj.getReferences();
                    hasDTFJRefs |= i2.hasNext();
                    this.collectRefs(i2, objset, desc, name, objAddr, listener);
                } else {
                    objset.put(addrJavaLangClass, "added java.lang.Class address");
                }
                i2 = jc.getReferences();
            }
            catch (LinkageError e) {
                return;
            }
            catch (NullPointerException e) {
                if (this.msgNarrayRefsNPE-- > 0) {
                    listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageFormat.format(Messages.DTFJIndexBuilder_ExceptionGettingOutboundReferences, desc, name, DTFJIndexBuilder.format(objAddr)), (Throwable)e);
                }
                return;
            }
            if (clsObj != null) {
                // empty if block
            }
            JavaClassLoader classLoader = this.getClassLoader(jc, listener);
            long loaderAddr = this.getLoaderAddress(classLoader, bootLoaderAddress);
            if (classLoader == null || classLoader.getObject() == null) {
                if (debugInfo) {
                    DTFJIndexBuilder.debugPrint("Null loader obj " + this.getClassName(jc, listener));
                }
                objset.put(loaderAddr, "added boot loader");
            }
            if ((sup = this.getSuperclass(jc, listener)) != null) {
                // empty if block
            }
            if (this.getExtraInfo && this.getExtraInfo2) {
                Iterator i = jc.getDeclaredMethods();
                while (i.hasNext()) {
                    Object next = i.next();
                    if (this.isCorruptData(next, listener, Messages.DTFJIndexBuilder_CorruptDataReadingDeclaredMethods, jc)) continue;
                    JavaMethod jm = (JavaMethod)next;
                    objset.put(this.getMethodAddress(jm, listener), "method");
                }
            }
        } else {
            if (type instanceof JavaObject) {
                JavaObject jo;
                block35: {
                    jo = (JavaObject)type;
                    objAddr = jo.getID().getAddress();
                    try {
                        JavaClass clsObj = jo.getJavaClass();
                        name = this.getClassName(clsObj, listener);
                        if (clsObj.isArray()) {
                            objset.put(this.getClassAddress(clsObj, listener), "added array class address");
                        }
                    }
                    catch (CorruptDataException e) {
                        int objId = this.indexToAddress.reverse(objAddr);
                        int clsId = this.objectToClass.get(objId);
                        ClassImpl cls = (ClassImpl)this.idToClass.get(clsId);
                        if (cls == null) break block35;
                        long classAddr = cls.getObjectAddress();
                        name = cls.getName();
                        objset.put(classAddr, "added dummy class address");
                    }
                }
                try {
                    i2 = jo.getReferences();
                }
                catch (LinkageError e) {
                    return;
                }
                catch (OutOfMemoryError e) {
                    listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageFormat.format(Messages.DTFJIndexBuilder_ErrorGettingOutboundReferences, desc, name, DTFJIndexBuilder.format(objAddr)), (Throwable)e);
                    return;
                }
            }
            return;
        }
        int objId = this.indexToAddress.reverse(objAddr);
        hasDTFJRefs |= i2.hasNext();
        this.collectRefs(i2, objset, desc, name, objAddr, listener);
        if (debugInfo) {
            String clsInfo;
            SetLong inBoth = new SetLong();
            boolean missingRefs = false;
            for (long l : aa) {
                if (!objset.containsKey(l)) {
                    missingRefs = true;
                    int newObjId = this.indexToAddress.reverse(l);
                    clsInfo = this.objDesc(newObjId);
                    if (this.msgNgetRefsMissing-- <= 0) continue;
                    listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_DTFJGetReferencesMissingID, newObjId, DTFJIndexBuilder.format(l), clsInfo, desc, name, objId, DTFJIndexBuilder.format(objAddr)), null);
                    continue;
                }
                inBoth.add(l);
            }
            Iterator it = objset.entries();
            while (it.hasNext()) {
                HashMapLongObject.Entry ee = it.next();
                Long l = ee.getKey();
                if (inBoth.contains(l.longValue())) continue;
                int newObjId = this.indexToAddress.reverse(l.longValue());
                clsInfo = this.objDesc(newObjId);
                if (this.msgNgetRefsExtra-- <= 0) continue;
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_DTFJGetReferencesExtraID, newObjId, DTFJIndexBuilder.format(l), ee.getValue(), clsInfo, desc, name, objId, DTFJIndexBuilder.format(objAddr)), null);
            }
        }
        if (this.useDTFJRefs) {
            if (objset.size() == 0 || !hasDTFJRefs) {
                if (!aa.isEmpty() && this.msgNgetRefsAllMissing-- > 0) {
                    listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_DTFJGetReferencesMissingAllReferences, name, objId, DTFJIndexBuilder.format(objAddr)), null);
                }
            } else {
                aa.clear();
                IteratorLong it = objset.keys();
                while (it.hasNext()) {
                    aa.add(it.next());
                }
            }
        }
    }

    private String objDesc(int newObjId) {
        String clsInfo;
        if (newObjId >= 0) {
            ClassImpl classInfo = (ClassImpl)this.idToClass.get(newObjId);
            if (classInfo != null) {
                clsInfo = MessageFormat.format(Messages.DTFJIndexBuilder_ObjDescClass, classInfo.getName());
            } else {
                int clsId = this.objectToClass.get(newObjId);
                if (clsId >= 0 && clsId < this.indexToAddress.size()) {
                    long clsAddr = this.indexToAddress.get(clsId);
                    classInfo = (ClassImpl)this.idToClass.get(clsId);
                    clsInfo = classInfo != null ? MessageFormat.format(Messages.DTFJIndexBuilder_ObjDescObjType, classInfo.getName(), DTFJIndexBuilder.format(clsAddr)) : MessageFormat.format(Messages.DTFJIndexBuilder_ObjDescObjTypeAddress, DTFJIndexBuilder.format(clsAddr));
                } else {
                    clsInfo = "";
                }
            }
        } else {
            clsInfo = "";
        }
        return clsInfo;
    }

    /*
     * Unable to fully structure code
     */
    private void collectRefs(Iterator<?> i2, RefStore<String> objset, String desc, String name, long objAddr, IProgressListener listener) {
        if (i2 != null) ** GOTO lbl37
        return;
lbl-1000:
        // 1 sources

        {
            next3 = i2.next();
            if (this.isCorruptData(next3, listener, Messages.DTFJIndexBuilder_CorruptDataReadingReferences, name, objAddr)) continue;
            jr = (JavaReference)next3;
            try {
                target = jr.getTarget();
                if (jr.isClassReference()) {
                    addr = this.getClassAddress((JavaClass)target, listener);
                } else if (jr.isObjectReference()) {
                    addr = ((JavaObject)target).getID().getAddress();
                } else {
                    listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageFormat.format(Messages.DTFJIndexBuilder_UnexpectedReferenceType, new Object[]{jr.getDescription(), desc, name, DTFJIndexBuilder.format(objAddr)}), null);
                    if (target == null) {
                        listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_UnexpectedNullReferenceTarget, new Object[]{jr.getDescription(), desc, name, DTFJIndexBuilder.format(objAddr)}), null);
                        continue;
                    }
                    if (target instanceof JavaClass) {
                        addr = this.getClassAddress((JavaClass)target, listener);
                    } else if (target instanceof JavaObject) {
                        addr = ((JavaObject)target).getID().getAddress();
                    } else {
                        listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_UnexpectedReferenceTargetType, new Object[]{target, jr.getDescription(), desc, name, DTFJIndexBuilder.format(objAddr)}), null);
                        continue;
                    }
                }
                if (addr == objAddr && (jr.getReferenceType() == 12 || jr.getReferenceType() == 13)) continue;
                objset.put(addr, jr.getDescription());
                continue;
            }
            catch (DataUnavailable e) {
                if (this.msgNgetRefsUnavailable-- <= 0) continue;
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_UnableToGetOutboundReference, new Object[]{jr.getDescription(), desc, name, DTFJIndexBuilder.format(objAddr)}), (Throwable)e);
                continue;
            }
            catch (CorruptDataException e) {
                if (this.msgNgetRefsCorrupt-- <= 0) continue;
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_UnableToGetOutboundReference, new Object[]{jr.getDescription(), desc, name, DTFJIndexBuilder.format(objAddr)}), (Throwable)e);
            }
lbl37:
            // 10 sources

            ** while (i2.hasNext())
        }
lbl38:
        // 1 sources

    }

    private void addThreadRefs(int obj, ArrayLong aa) {
        HashMapIntObject hm = (HashMapIntObject)this.threadRoots.get(obj);
        if (hm != null) {
            IteratorInt i = hm.keys();
            while (i.hasNext()) {
                int objId = i.next();
                aa.add(this.indexToAddress.get(objId));
            }
        }
    }

    private void addRefs(BitField refd, int objId, ArrayLong ref) {
        for (long ad : ref) {
            int id = this.indexToAddress.reverse(ad);
            if (id < 0 || objId == id) continue;
            refd.set(id);
        }
    }

    private long getClassAddress(JavaClass type, IProgressListener listener) {
        JavaObject clsObject;
        Throwable e1 = null;
        try {
            clsObject = type.getObject();
        }
        catch (CorruptDataException e) {
            clsObject = null;
            e1 = e;
        }
        catch (IllegalArgumentException e) {
            clsObject = null;
            e1 = e;
        }
        if (clsObject == null) {
            ImagePointer ip = type.getID();
            if (ip != null) {
                return ip.getAddress();
            }
            Long addr = this.dummyClassAddress.get(type);
            if (addr != null) {
                return addr;
            }
            long clsAddr = this.nextClassAddress;
            this.dummyClassAddress.put(type, clsAddr);
            this.nextClassAddress += 8L;
            String clsName = this.getClassName(type, listener);
            listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_ClassHasNoAddress, clsName, DTFJIndexBuilder.format(clsAddr)), e1);
            return clsAddr;
        }
        return clsObject.getID().getAddress();
    }

    private long fixBootLoaderAddress(long bootLoaderAddress, long objAddress) {
        return objAddress;
    }

    private void searchFrame(int pointerSize, long threadAddress, HashMapIntObject<HashMapIntObject<List<XGCRootInfo>>> thrs, ImagePointer ip, long searchSize, int rootType, HashMapIntObject<List<XGCRootInfo>> gc, Set<ImagePointer> searchedAddresses, Set<ImagePointer> excludedAddresses) throws CorruptDataException, MemoryAccessException {
        long frameAddress;
        if (debugInfo) {
            DTFJIndexBuilder.debugPrint("searching thread " + DTFJIndexBuilder.format(threadAddress) + " " + DTFJIndexBuilder.format(ip.getAddress()) + " " + DTFJIndexBuilder.format(searchSize) + " " + rootType);
        }
        HashMapIntObject thr = (HashMapIntObject)thrs.get(this.indexToAddress.reverse(threadAddress));
        if (this.getExtraInfo) {
            frameAddress = ip.getAddress();
            int frameId = this.indexToAddress.reverse(frameAddress);
            if (frameAddress != 0L && frameId >= 0) {
                if (thr != null) {
                    this.addRoot((HashMapIntObject<List<XGCRootInfo>>)thr, frameAddress, threadAddress, rootType);
                    thr = new HashMapIntObject();
                    thrs.put(frameId, (Object)thr);
                } else {
                    this.addRoot(gc, frameAddress, threadAddress, rootType);
                }
                long size = Math.abs(searchSize);
                this.setFrameSize(frameId, size);
            } else {
                frameAddress = threadAddress;
            }
        } else {
            frameAddress = threadAddress;
        }
        int pointerAdjust = searchSize >= 0L ? this.getPointerBytes(pointerSize) : -this.getPointerBytes(pointerSize);
        long j = 0L;
        while (Math.abs(j) < Math.abs(searchSize)) {
            ImagePointer location = ip.add(j);
            long addr = this.getPointerAddressAt(location, 0L, pointerSize);
            int id = this.indexToAddress.reverse(addr);
            if (!(addr == 0L || id < 0 || excludedAddresses != null && excludedAddresses.contains(location))) {
                if (searchedAddresses != null) {
                    searchedAddresses.add(location);
                }
                if (thr != null) {
                    this.addRoot((HashMapIntObject<List<XGCRootInfo>>)thr, addr, frameAddress, rootType);
                } else {
                    this.addRoot(gc, addr, frameAddress, rootType);
                }
            }
            j += (long)pointerAdjust;
        }
    }

    private long getPointerAddressAt(ImagePointer ip, long j, int pointerSize) throws MemoryAccessException, CorruptDataException {
        long addr;
        if (this.addressSpacePointerSize == pointerSize) {
            ImagePointer i2 = ip.getPointerAt(j);
            addr = i2 != null ? i2.getAddress() : 0L;
        } else {
            switch (pointerSize) {
                case 64: {
                    addr = ip.getLongAt(j);
                    break;
                }
                case 31: 
                case 32: {
                    addr = (long)ip.getIntAt(j) & (1L << pointerSize) - 1L;
                    break;
                }
                default: {
                    ImagePointer i2 = ip.getPointerAt(j);
                    addr = i2.getAddress();
                }
            }
        }
        return addr;
    }

    private void genClass2(JavaClass j2, ClassImpl ci, ClassImpl jlc, int pointerSize, IProgressListener listener) {
        ci.setClassInstance(jlc);
        long size = 0L;
        try {
            JavaObject object = j2.getObject();
            if (object != null) {
                size = this.getObjectSize(object, pointerSize);
                if (jlc.getHeapSizePerInstance() < 0L) {
                    jlc.setHeapSizePerInstance(size);
                }
            }
        }
        catch (IllegalArgumentException e) {
            listener.sendUserMessage(IProgressListener.Severity.WARNING, Messages.DTFJIndexBuilder_ProblemGettingSizeOfJavaLangClass, (Throwable)e);
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        if (!this.suppressClassNativeSizes) {
            size += this.classSize(j2, listener);
        }
        ci.setUsedHeapSize(size);
        if (debugInfo) {
            this.objectToSize2.set(ci.getObjectId(), size);
        }
        jlc.addInstance(size);
        if (debugInfo) {
            DTFJIndexBuilder.debugPrint("build class " + ci.getName() + " at " + ci.getObjectId() + " address " + DTFJIndexBuilder.format(ci.getObjectAddress()) + " loader " + ci.getClassLoaderId() + " super " + ci.getSuperClassId() + " size " + ci.getUsedHeapSize());
        }
    }

    private long classSize(JavaClass jc, IProgressListener listener) {
        long size = 0L;
        try {
            JavaObject jo = jc.getObject();
            if (jo != null) {
                size += jo.getSize();
            }
        }
        catch (CorruptDataException jo) {
            // empty catch block
        }
        Iterator i = jc.getDeclaredMethods();
        while (i.hasNext()) {
            Object next = i.next();
            if (this.isCorruptData(next, listener, Messages.DTFJIndexBuilder_CorruptDataReadingDeclaredMethods, jc)) continue;
            JavaMethod jm = (JavaMethod)next;
            if (this.getExtraInfo && this.getExtraInfo2) continue;
            size += this.getMethodSize(jc, jm, listener);
        }
        return size;
    }

    private long getMethodSize(JavaClass jc, JavaMethod jm, IProgressListener listener) {
        long sizeSeg;
        int bigSegment;
        ImageSection is;
        Object next2;
        long size = 0L;
        Iterator j = jm.getBytecodeSections();
        while (j.hasNext()) {
            next2 = j.next();
            if (this.isCorruptData(next2, listener, Messages.DTFJIndexBuilder_CorruptDataReadingBytecodeSections, jc, jm)) continue;
            is = (ImageSection)next2;
            bigSegment = 65536;
            sizeSeg = this.checkSegmentSize(jc, jm, is, 65536, Messages.DTFJIndexBuilder_UnexpectedBytecodeSectionSize, listener);
            size += sizeSeg;
        }
        j = jm.getCompiledSections();
        while (j.hasNext()) {
            next2 = j.next();
            if (this.isCorruptData(next2, listener, Messages.DTFJIndexBuilder_CorruptDataReadingCompiledSections, jc, jm)) continue;
            is = (ImageSection)next2;
            bigSegment = 393216;
            sizeSeg = this.checkSegmentSize(jc, jm, is, 393216, Messages.DTFJIndexBuilder_UnexpectedCompiledCodeSectionSize, listener);
            size += sizeSeg;
        }
        return size;
    }

    private long checkSegmentSize(JavaClass jc, JavaMethod jm, ImageSection is, int bigSegment, String message, IProgressListener listener) {
        long sizeSeg = is.getSize();
        if (sizeSeg < 0L || sizeSeg >= (long)bigSegment) {
            String methSig;
            String methName;
            String clsName;
            try {
                clsName = jc != null ? jc.getName() : "";
            }
            catch (CorruptDataException e) {
                clsName = e.toString();
            }
            try {
                methName = jm.getName();
            }
            catch (CorruptDataException e) {
                methName = e.toString();
            }
            try {
                methSig = jm.getSignature();
            }
            catch (CorruptDataException e) {
                methSig = e.toString();
            }
            if (this.msgNbigSegs-- > 0) {
                String mods = this.getModifiers(jm, listener);
                listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(message, DTFJIndexBuilder.format(is.getBaseAddress().getAddress()), sizeSeg, bigSegment, mods, clsName, methName, methSig), null);
            }
            sizeSeg = 0L;
        }
        return sizeSeg;
    }

    private long isFinalizable(JavaClass c, IProgressListener listener) {
        long ca = 0L;
        String cn = this.getClassName(c, listener);
        ca = this.getClassAddress(c, listener);
        while (this.getSuperclass(c, listener) != null) {
            String cn1 = this.getClassName(c, listener);
            long ca1 = this.getClassAddress(c, listener);
            Iterator it = c.getDeclaredMethods();
            while (it.hasNext()) {
                Object next = it.next();
                if (this.isCorruptData(next, listener, Messages.DTFJIndexBuilder_CorruptDataReadingDeclaredMethods, c)) continue;
                JavaMethod m = (JavaMethod)next;
                try {
                    if (!m.getName().equals("finalize")) continue;
                    try {
                        if (!m.getSignature().equals("()V")) continue;
                        return ca;
                    }
                    catch (CorruptDataException e) {
                        listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemDetirminingFinalizeMethodSig, cn1, DTFJIndexBuilder.format(ca1)), (Throwable)e);
                        return ca;
                    }
                }
                catch (CorruptDataException e) {
                    listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemDetirminingFinalizeMethod, cn1, DTFJIndexBuilder.format(ca1)), (Throwable)e);
                }
            }
            c = this.getSuperclass(c, listener);
        }
        return 0L;
    }

    private ArrayLong exploreClass(IIndexReader.IOne2LongIndex m2, long bootLoaderAddress, HashMapIntObject<ClassImpl> hm, JavaClass j2, IProgressListener listener) {
        String clsName = null;
        long claddr = this.getClassAddress(j2, listener);
        int objId = m2.reverse(claddr);
        ClassImpl ci = (ClassImpl)hm.get(objId);
        if (debugInfo) {
            DTFJIndexBuilder.debugPrint("Class " + this.getClassName(j2, listener) + " " + DTFJIndexBuilder.format(claddr) + " " + objId + " " + ci);
        }
        if (ci == null) {
            return null;
        }
        int clsId = ci.getClassId();
        clsName = ci.getName();
        if (debugInfo) {
            DTFJIndexBuilder.debugPrint("found class object " + objId + " type " + clsName + " at " + DTFJIndexBuilder.format(ci.getObjectAddress()) + " clsId " + clsId);
        }
        ArrayLong ref = ci.getReferences();
        if (this.getExtraInfo && this.getExtraInfo2) {
            Iterator i = j2.getDeclaredMethods();
            while (i.hasNext()) {
                Object next = i.next();
                if (this.isCorruptData(next, listener, Messages.DTFJIndexBuilder_CorruptDataReadingDeclaredMethods, j2)) continue;
                JavaMethod jm = (JavaMethod)next;
                ref.add(this.getMethodAddress(jm, listener));
            }
        }
        return ref;
    }

    private void exploreArray(IIndexReader.IOne2LongIndex m2, long bootLoaderAddress, HashMapIntObject<ClassImpl> hm, JavaObject jo, JavaClass type, ArrayLong aa, int arrayLen, IProgressListener listener) throws CorruptDataException {
        if (this.useDTFJRefs && !debugInfo) {
            return;
        }
        boolean primitive = DTFJIndexBuilder.isPrimitiveArray(type);
        if (!primitive) {
            int arrayStep = 100000;
            int arrayOffset = 0;
            while (arrayOffset < arrayLen) {
                String typeName;
                arrayStep = Math.min(arrayStep, arrayLen - arrayOffset);
                JavaObject[] refs = new JavaObject[arrayStep];
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                try {
                    try {
                        if (debugInfo) {
                            DTFJIndexBuilder.debugPrint("Array copy " + arrayOffset + " " + arrayLen + " " + arrayStep);
                        }
                        jo.arraycopy(arrayOffset, (Object)refs, 0, arrayStep);
                    }
                    catch (IllegalArgumentException e) {
                        try {
                            typeName = type.getName();
                        }
                        catch (CorruptDataException e1) {
                            typeName = e1.toString();
                        }
                        listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemReadingArray, typeName, arrayLen, arrayOffset, arrayStep, DTFJIndexBuilder.format(jo.getID().getAddress())), (Throwable)e);
                    }
                    int idx = arrayOffset;
                    JavaObject[] javaObjectArray = refs;
                    int n = refs.length;
                    int e1 = 0;
                    while (e1 < n) {
                        JavaObject jao = javaObjectArray[e1];
                        if (jao != null) {
                            long elementObjAddress = jao.getID().getAddress();
                            int elementRef = m2.reverse(elementObjAddress = this.fixBootLoaderAddress(bootLoaderAddress, elementObjAddress));
                            if (elementRef < 0) {
                                if (this.msgNinvalidArray-- > 0) {
                                    String typeName2;
                                    String name;
                                    CorruptDataException e12 = null;
                                    if (debugInfo) {
                                        try {
                                            JavaClass javaClass = jao.getJavaClass();
                                            name = javaClass != null ? javaClass.getName() : "";
                                        }
                                        catch (CorruptDataException e) {
                                            name = e.toString();
                                            e12 = e;
                                        }
                                    } else {
                                        name = "?";
                                    }
                                    try {
                                        typeName2 = type.getName();
                                    }
                                    catch (CorruptDataException e) {
                                        typeName2 = e.toString();
                                        e12 = e;
                                    }
                                    listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_InvalidArrayElement, DTFJIndexBuilder.format(elementObjAddress), name, idx, typeName2, arrayLen, DTFJIndexBuilder.format(jo.getID().getAddress())), (Throwable)e12);
                                }
                            } else if (hm.get(elementRef) != null) {
                                if (verbose) {
                                    DTFJIndexBuilder.debugPrint("Found class ref field " + elementRef + " from array " + m2.reverse(jo.getID().getAddress()));
                                }
                                aa.add(elementObjAddress);
                            } else {
                                if (verbose) {
                                    DTFJIndexBuilder.debugPrint("Found obj ref field " + elementRef + " from array " + m2.reverse(jo.getID().getAddress()));
                                }
                                aa.add(elementObjAddress);
                            }
                        }
                        ++idx;
                        ++e1;
                    }
                }
                catch (CorruptDataException e) {
                    try {
                        typeName = type.getName();
                    }
                    catch (CorruptDataException e1) {
                        typeName = e1.toString();
                    }
                    listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemReadingArray, typeName, arrayLen, arrayOffset, arrayStep, DTFJIndexBuilder.format(jo.getID().getAddress())), (Throwable)e);
                }
                catch (MemoryAccessException e) {
                    try {
                        typeName = type.getName();
                    }
                    catch (CorruptDataException e1) {
                        typeName = e1.toString();
                    }
                    listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemReadingArray, typeName, arrayLen, arrayOffset, arrayStep, DTFJIndexBuilder.format(jo.getID().getAddress())), (Throwable)e);
                }
                arrayOffset += arrayStep;
            }
        }
    }

    static boolean isPrimitiveArray(JavaClass type) throws CorruptDataException {
        String name2;
        block6: {
            try {
                name2 = type.getName();
                if (!name2.startsWith("[[")) break block6;
                return false;
            }
            catch (CorruptDataException name2) {
                JavaClass elemClass;
                block7: {
                    try {
                        elemClass = type.getComponentType();
                        if (!elemClass.isArray()) break block7;
                        return false;
                    }
                    catch (CorruptDataException e) {
                        return false;
                    }
                }
                boolean primitive = DTFJIndexBuilder.isPrimitiveName(elemClass.getName());
                return primitive;
            }
        }
        return "[B".equals(name2) || "[S".equals(name2) || "[I".equals(name2) || "[J".equals(name2) || "[Z".equals(name2) || "[C".equals(name2) || "[F".equals(name2) || "[D".equals(name2);
    }

    private boolean isPrimitive(JavaClass elemClass) throws CorruptDataException {
        boolean primitive = this.getSuperclass(elemClass, null) == null && !elemClass.getName().equals("java/lang/Object") && !Modifier.isInterface(elemClass.getModifiers());
        return primitive;
    }

    private void exploreObject(IIndexReader.IOne2LongIndex m2, long bootLoaderAddress, HashMapIntObject<ClassImpl> hm, JavaObject jo, JavaClass type, ArrayLong aa, boolean verbose, IProgressListener listener) {
        if (this.useDTFJRefs && !debugInfo) {
            return;
        }
        String typeName = this.getClassName(type, listener);
        if (verbose) {
            DTFJIndexBuilder.debugPrint("Exploring " + type + " at " + jo.getID().getAddress());
        }
        JavaClass jc = type;
        while (jc != null) {
            String clsName = this.getClassName(jc, listener);
            Iterator ii = jc.getDeclaredFields();
            while (ii.hasNext()) {
                String sig;
                String fieldName;
                Object next3 = ii.next();
                if (this.isCorruptData(next3, listener, Messages.DTFJIndexBuilder_CorruptDataReadingDeclaredFields, jc)) continue;
                JavaField jf = (JavaField)next3;
                try {
                    fieldName = jf.getName();
                }
                catch (CorruptDataException e) {
                    fieldName = "?";
                }
                try {
                    sig = jf.getSignature();
                }
                catch (CorruptDataException e) {
                    sig = "L?";
                }
                try {
                    if (Modifier.isStatic(jf.getModifiers()) || !sig.startsWith("[") && !sig.startsWith("L")) continue;
                    try {
                        Object obj;
                        try {
                            obj = jf.get(jo);
                        }
                        catch (IllegalArgumentException e) {
                            obj = null;
                            fieldName = jf.getName();
                            listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemReadingObjectFromField, clsName, fieldName, sig, typeName, DTFJIndexBuilder.format(jo.getID().getAddress())), (Throwable)e);
                        }
                        if (!(obj instanceof JavaObject)) continue;
                        JavaObject jo2 = (JavaObject)obj;
                        long fieldObjAddress = jo2.getID().getAddress();
                        int fieldRef = m2.reverse(fieldObjAddress = this.fixBootLoaderAddress(bootLoaderAddress, fieldObjAddress));
                        if (fieldRef < 0) {
                            String name;
                            if (this.msgNinvalidObj-- <= 0) continue;
                            CorruptDataException e1 = null;
                            try {
                                JavaClass javaClass = jo2.getJavaClass();
                                name = javaClass != null ? javaClass.getName() : "";
                            }
                            catch (CorruptDataException e) {
                                e1 = e;
                                name = e.toString();
                            }
                            listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_InvalidObjectFieldReference, DTFJIndexBuilder.format(fieldObjAddress), name, clsName, fieldName, sig, typeName, DTFJIndexBuilder.format(jo.getID().getAddress())), (Throwable)e1);
                            continue;
                        }
                        if (verbose) {
                            if (hm.get(fieldRef) != null) {
                                if (debugInfo) {
                                    DTFJIndexBuilder.debugPrint("Found class ref field " + fieldRef + " from " + m2.reverse(jo.getID().getAddress()));
                                }
                            } else if (debugInfo) {
                                DTFJIndexBuilder.debugPrint("Found obj ref field " + fieldRef + " from " + m2.reverse(jo.getID().getAddress()));
                            }
                        }
                        aa.add(fieldObjAddress);
                    }
                    catch (CorruptDataException e) {
                        listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemReadingObjectFromField, clsName, fieldName, sig, typeName, DTFJIndexBuilder.format(jo.getID().getAddress())), (Throwable)e);
                    }
                    catch (MemoryAccessException e) {
                        listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemReadingObjectFromField, clsName, fieldName, sig, typeName, DTFJIndexBuilder.format(jo.getID().getAddress())), (Throwable)e);
                    }
                }
                catch (CorruptDataException e) {
                    listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemReadingObjectFromField, clsName, fieldName, sig, typeName, DTFJIndexBuilder.format(jo.getID().getAddress())), (Throwable)e);
                }
            }
            jc = this.getSuperclass(jc, listener);
        }
    }

    private void addRoot(HashMapIntObject<List<XGCRootInfo>> gc, long obj, long ctx, int type) {
        XGCRootInfo rri = new XGCRootInfo(obj, ctx, this.newRootType(type));
        rri.setContextId(this.indexToAddress.reverse(rri.getContextAddress()));
        rri.setObjectId(this.indexToAddress.reverse(rri.getObjectAddress()));
        int objectId = rri.getObjectId();
        ArrayList<XGCRootInfo> rootsForID = (ArrayList<XGCRootInfo>)gc.get(objectId);
        if (rootsForID == null) {
            rootsForID = new ArrayList<XGCRootInfo>(1);
            gc.put(objectId, rootsForID);
        }
        rootsForID.add(rri);
        if (debugInfo) {
            int clsId = this.objectToClass.get(objectId);
            ClassImpl cls = (ClassImpl)this.idToClass.get(clsId);
            String clsName = cls != null ? cls.getName() : "";
            String desc = DTFJIndexBuilder.format(obj) + " " + objectId + " ctx " + DTFJIndexBuilder.format(ctx) + " " + rri.getContextId() + " type:" + clsName;
            DTFJIndexBuilder.debugPrint("Root " + type + " " + desc);
        }
    }

    private ClassImpl genClass(JavaClass j2, HashMapIntObject<ClassImpl> hm, long bootLoaderAddress, long sup, IProgressListener listener) {
        int loaderId;
        Iterator f1;
        Field f;
        JavaClass j3;
        JavaObject joc;
        Object val;
        int superId;
        long loader;
        long claddr = this.getClassAddress(j2, listener);
        String name = this.getClassName(j2, listener);
        try {
            int loaderId2;
            JavaClassLoader load = this.getClassLoader(j2, listener);
            if (load == null) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_UnableToFindClassLoader, name, DTFJIndexBuilder.format(claddr)), null);
            }
            if ((loaderId2 = this.indexToAddress.reverse(loader = this.getLoaderAddress(load, bootLoaderAddress))) < 0) {
                listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageFormat.format(Messages.DTFJIndexBuilder_ClassLoaderAtAddressNotFound, DTFJIndexBuilder.format(loader), loaderId2, DTFJIndexBuilder.format(claddr), this.indexToAddress.reverse(claddr), name), null);
                loader = this.fixBootLoaderAddress(bootLoaderAddress, bootLoaderAddress);
            }
        }
        catch (CorruptDataException e) {
            listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_UnableToFindClassLoader, name, DTFJIndexBuilder.format(claddr)), (Throwable)e);
            loader = this.fixBootLoaderAddress(bootLoaderAddress, bootLoaderAddress);
        }
        if (sup == 0L) {
            JavaClass superClass = this.getSuperclass(j2, listener);
            long l = sup = superClass != null ? this.getClassAddress(superClass, listener) : 0L;
        }
        if (sup != 0L) {
            superId = this.indexToAddress.reverse(sup);
            if (superId < 0) {
                listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageFormat.format(Messages.DTFJIndexBuilder_SuperclassNotFound, DTFJIndexBuilder.format(sup), superId, DTFJIndexBuilder.format(claddr), this.indexToAddress.reverse(claddr), name), null);
                sup = 0L;
            }
        } else {
            superId = -1;
        }
        ArrayList<FieldDescriptor> al = new ArrayList<FieldDescriptor>();
        ArrayList<Field> al2 = new ArrayList<Field>();
        Iterator f12 = j2.getDeclaredFields();
        while (f12.hasNext()) {
            Object next = f12.next();
            if (this.isCorruptData(next, listener, Messages.DTFJIndexBuilder_CorruptDataReadingDeclaredFields, j2)) continue;
            JavaField jf = (JavaField)next;
            String fieldName = "?";
            String fieldSignature = "?";
            try {
                fieldName = jf.getName();
                try {
                    fieldSignature = jf.getSignature();
                }
                catch (CorruptDataException corruptDataException) {
                    // empty catch block
                }
                if (Modifier.isStatic(jf.getModifiers())) {
                    val = null;
                    try {
                        Object o = jf.get(null);
                        if (o instanceof JavaObject) {
                            JavaObject jo = (JavaObject)o;
                            long address = jo.getID().getAddress();
                            val = new ObjectReference(null, address);
                        } else if (o instanceof Number || o instanceof Character || o instanceof Boolean || o == null) {
                            val = o;
                        } else {
                            listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_UnexpectedValueForStaticField, o, fieldName, fieldSignature, j2.getName(), DTFJIndexBuilder.format(claddr)), null);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageFormat.format(Messages.DTFJIndexBuilder_InvalidStaticField, fieldName, fieldSignature, name, DTFJIndexBuilder.format(claddr)), (Throwable)e);
                    }
                    catch (CorruptDataException e) {
                        listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_InvalidStaticField, fieldName, fieldSignature, name, DTFJIndexBuilder.format(claddr)), (Throwable)e);
                    }
                    catch (MemoryAccessException e) {
                        listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_InvalidStaticField, fieldName, fieldSignature, name, DTFJIndexBuilder.format(claddr)), (Throwable)e);
                    }
                    Field f2 = new Field(fieldName, DTFJIndexBuilder.signatureToType(fieldSignature, val), val);
                    if (debugInfo) {
                        DTFJIndexBuilder.debugPrint("Adding static field " + fieldName + " " + f2.getType() + " " + val + " " + f2.getValue());
                    }
                    al2.add(f2);
                    continue;
                }
                FieldDescriptor fd = new FieldDescriptor(fieldName, DTFJIndexBuilder.signatureToType(fieldSignature));
                al.add(fd);
            }
            catch (CorruptDataException e) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_InvalidField, fieldName, fieldSignature, name, DTFJIndexBuilder.format(claddr)), (Throwable)e);
            }
        }
        try {
            joc = j2.getObject();
        }
        catch (CorruptDataException e) {
            joc = null;
        }
        catch (IllegalArgumentException e) {
            listener.sendUserMessage(IProgressListener.Severity.ERROR, Messages.DTFJIndexBuilder_ProblemBuildingClassObject, (Throwable)e);
            joc = null;
        }
        if (joc != null) {
            try {
                j3 = joc.getJavaClass();
            }
            catch (CorruptDataException e) {
                long objAddr = joc.getID().getAddress();
                if (this.msgNtypeForClassObject-- > 0) {
                    listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageFormat.format(Messages.DTFJIndexBuilder_UnableToFindTypeOfObject, DTFJIndexBuilder.format(objAddr), DTFJIndexBuilder.format(claddr), name), (Throwable)e);
                }
                j3 = null;
            }
        } else {
            if (j2.getID() != null) {
                if (debugInfo) {
                    DTFJIndexBuilder.debugPrint("No Java object for " + this.getClassName(j2, listener) + " at " + DTFJIndexBuilder.format(j2.getID().getAddress()));
                }
            } else if (debugInfo) {
                DTFJIndexBuilder.debugPrint("No Java object for " + this.getClassName(j2, listener));
            }
            j3 = null;
        }
        while (j3 != null) {
            Iterator f13 = j3.getDeclaredFields();
            while (f13.hasNext()) {
                Object next = f13.next();
                if (this.isCorruptData(next, listener, Messages.DTFJIndexBuilder_CorruptDataReadingDeclaredFields, j3)) continue;
                JavaField jf = (JavaField)next;
                String className2 = this.getClassName(j3, listener);
                String fieldName = "?";
                String fieldSignature = "?";
                try {
                    fieldName = jf.getName();
                    try {
                        fieldSignature = jf.getSignature();
                    }
                    catch (CorruptDataException address) {
                        // empty catch block
                    }
                    if (Modifier.isStatic(jf.getModifiers())) continue;
                    Object val2 = null;
                    try {
                        Object o = jf.get(joc);
                        if (o instanceof JavaObject) {
                            JavaObject jo = (JavaObject)o;
                            long address = jo.getID().getAddress();
                            val2 = new ObjectReference(null, address);
                        } else if (o instanceof Number || o instanceof Character || o instanceof Boolean || o == null) {
                            val2 = o;
                        }
                    }
                    catch (CorruptDataException e) {
                        listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_InvalidField, fieldName, fieldSignature, className2, DTFJIndexBuilder.format(claddr)), (Throwable)e);
                    }
                    catch (MemoryAccessException e) {
                        listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_InvalidField, fieldName, fieldSignature, className2, DTFJIndexBuilder.format(claddr)), (Throwable)e);
                    }
                    f = new Field("<" + fieldName + ">", DTFJIndexBuilder.signatureToType(fieldSignature, val2), val2);
                    al2.add(f);
                }
                catch (CorruptDataException e) {
                    listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_InvalidField, fieldName, fieldSignature, className2, DTFJIndexBuilder.format(claddr)), (Throwable)e);
                }
            }
            j3 = this.getSuperclass(j3, listener);
        }
        int cpindex = 1;
        try {
            f1 = j2.getConstantPoolReferences();
        }
        catch (IllegalArgumentException e) {
            listener.sendUserMessage(IProgressListener.Severity.ERROR, Messages.DTFJIndexBuilder_ProblemBuildingClassObject, (Throwable)e);
            f1 = Collections.EMPTY_LIST.iterator();
        }
        while (f1.hasNext()) {
            long address;
            Object next = f1.next();
            if (this.isCorruptData(next, listener, Messages.DTFJIndexBuilder_CorruptDataReadingConstantPoolReferences, j2)) continue;
            val = null;
            if (next instanceof JavaObject) {
                JavaObject jo = (JavaObject)next;
                address = jo.getID().getAddress();
            } else {
                if (!(next instanceof JavaClass)) continue;
                JavaClass jc = (JavaClass)next;
                address = this.getClassAddress(jc, listener);
            }
            val = new ObjectReference(null, address);
            f = new Field("<constant pool[" + cpindex++ + "]>", 2, val);
            al2.add(f);
        }
        Field[] statics = al2.toArray(new Field[al2.size()]);
        FieldDescriptor[] fld = al.toArray(new FieldDescriptor[al.size()]);
        String cname = this.getMATClassName(j2, listener);
        ClassImpl ci = new ClassImpl(claddr, cname, sup, loader, statics, fld);
        long claddr2 = ci.getObjectAddress();
        int clsId = this.indexToAddress.reverse(claddr2);
        if (clsId >= 0) {
            ci.setObjectId(clsId);
        } else {
            listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageFormat.format(Messages.DTFJIndexBuilder_ClassAtAddressNotFound, DTFJIndexBuilder.format(claddr), clsId, name), null);
        }
        if (sup != 0L) {
            ci.setSuperClassIndex(superId);
        }
        if ((loaderId = this.indexToAddress.reverse(loader)) >= 0) {
            ci.setClassLoaderIndex(loaderId);
        } else {
            listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageFormat.format(Messages.DTFJIndexBuilder_ClassLoaderAtAddressNotFound, DTFJIndexBuilder.format(loader), loaderId, DTFJIndexBuilder.format(claddr), clsId, name), null);
        }
        hm.put(this.indexToAddress.reverse(claddr), (Object)ci);
        return ci;
    }

    private long getMethodAddress(JavaMethod m, IProgressListener listener) {
        String methName;
        Long addr;
        JavaMethod other;
        ImageSection is;
        Object next;
        JavaClass jc;
        if (!this.getExtraInfo) {
            return 0L;
        }
        long ret = 0L;
        try {
            jc = m.getDeclaringClass();
        }
        catch (DataUnavailable e) {
            jc = null;
        }
        catch (CorruptDataException e) {
            jc = null;
        }
        Iterator it = m.getBytecodeSections();
        while (it.hasNext()) {
            next = it.next();
            if (next instanceof CorruptData && this.msgNcorruptSection-- <= 0 || this.isCorruptData(next, listener, Messages.DTFJIndexBuilder_CorruptDataReadingBytecodeSections, jc, m) || (ret = (is = (ImageSection)next).getBaseAddress().getAddress()) == 0L) continue;
            other = (JavaMethod)this.methodAddresses.get(ret);
            if (other == null) {
                this.methodAddresses.put(ret, (Object)m);
                return ret;
            }
            if (!m.equals((Object)other)) continue;
            return ret;
        }
        it = m.getCompiledSections();
        while (it.hasNext()) {
            next = it.next();
            if (this.isCorruptData(next, listener, Messages.DTFJIndexBuilder_CorruptDataReadingCompiledCodeSections, jc, m) || (ret = (is = (ImageSection)next).getBaseAddress().getAddress()) == 0L) continue;
            other = (JavaMethod)this.methodAddresses.get(ret);
            if (other == null) {
                this.methodAddresses.put(ret, (Object)m);
                return ret;
            }
            if (!m.equals((Object)other)) continue;
            return ret;
        }
        boolean faultyEquals = false;
        Long l = addr = !faultyEquals ? this.dummyMethodAddress.get(m) : this.dummyMethodAddress2.get(m);
        if (addr != null) {
            return addr;
        }
        long clsAd = jc != null ? this.getClassAddress(jc, listener) : 0L;
        try {
            methName = DTFJIndexBuilder.getMethodName(m, listener);
        }
        catch (CorruptDataException e) {
            methName = e.toString();
        }
        long clsAddr = this.nextClassAddress;
        if (!faultyEquals) {
            this.dummyMethodAddress.put(m, clsAddr);
        } else {
            this.dummyMethodAddress2.put(m, clsAddr);
        }
        this.nextClassAddress += 8L;
        if (ret != 0L) {
            listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_MethodHasNonUniqueAddress, methName, DTFJIndexBuilder.format(clsAd), DTFJIndexBuilder.format(ret), DTFJIndexBuilder.format(clsAddr)), null);
        } else {
            listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_MethodHasNoAddress, methName, DTFJIndexBuilder.format(clsAd), DTFJIndexBuilder.format(clsAddr)), null);
        }
        return clsAddr;
    }

    private ClassImpl genClass(JavaMethod m, long sup, ClassImpl jlc, HashMapIntObject<ClassImpl> hm, long bootLoaderAddress, IProgressListener listener) throws CorruptDataException {
        int loaderId;
        long claddr2;
        int clsId;
        int superId;
        long loader;
        Field[] statics;
        JavaClass jc;
        if (!this.getExtraInfo) {
            return null;
        }
        String name = METHOD_NAME_PREFIX + DTFJIndexBuilder.getMethodName(m, listener);
        long claddr = this.getMethodAddress(m, listener);
        try {
            jc = m.getDeclaringClass();
            ObjectReference val = new ObjectReference(null, this.getClassAddress(jc, listener));
            statics = new Field[]{new Field(DECLARING_CLASS, 2, (Object)val)};
            JavaClassLoader load = this.getClassLoader(jc, listener);
            loader = this.getLoaderAddress(load, bootLoaderAddress);
            String className = this.getMATClassName(jc, listener);
            name = String.valueOf(className) + name;
        }
        catch (DTFJException e) {
            jc = null;
            statics = new Field[]{};
            loader = this.fixBootLoaderAddress(bootLoaderAddress, bootLoaderAddress);
            listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_DeclaringClassNotFound, name, DTFJIndexBuilder.format(claddr)), (Throwable)e);
        }
        if (sup != 0L) {
            superId = this.indexToAddress.reverse(sup);
            if (superId < 0) {
                listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageFormat.format(Messages.DTFJIndexBuilder_SuperclassNotFound, DTFJIndexBuilder.format(sup), superId, DTFJIndexBuilder.format(claddr), this.indexToAddress.reverse(claddr), name), null);
                sup = 0L;
            }
        } else {
            superId = -1;
        }
        ClassImpl ci = new ClassImpl(claddr, name, sup, loader, statics, new FieldDescriptor[0]);
        if (debugInfo) {
            DTFJIndexBuilder.debugPrint("building method class " + name + " " + DTFJIndexBuilder.format(claddr));
        }
        if ((clsId = this.indexToAddress.reverse(claddr2 = ci.getObjectAddress())) >= 0) {
            ci.setObjectId(clsId);
        } else {
            listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageFormat.format(Messages.DTFJIndexBuilder_ClassAtAddressNotFound, DTFJIndexBuilder.format(claddr), clsId, name), null);
        }
        if (sup != 0L) {
            ci.setSuperClassIndex(superId);
        }
        if ((loaderId = this.indexToAddress.reverse(loader)) >= 0) {
            ci.setClassLoaderIndex(loaderId);
        } else {
            listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageFormat.format(Messages.DTFJIndexBuilder_ClassLoaderAtAddressNotFound, DTFJIndexBuilder.format(loader), loaderId, DTFJIndexBuilder.format(claddr), clsId, name), null);
        }
        hm.put(ci.getObjectId(), (Object)ci);
        ci.setClassInstance(jlc);
        long size = this.getExtraInfo2 ? this.getMethodSize(jc, m, listener) : 0L;
        ci.setUsedHeapSize(size);
        ci.setHeapSizePerInstance(0L);
        if (debugInfo) {
            this.objectToSize2.set(ci.getObjectId(), size);
        }
        jlc.addInstance(size);
        return ci;
    }

    private ClassImpl genDummyType(String cname, long claddr, long superType, ClassImpl type, FieldDescriptor[] fields, HashMapIntObject<ClassImpl> hm, long bootLoaderAddress, IProgressListener listener) {
        int loaderId;
        long loader = bootLoaderAddress;
        Field[] statics = new Field[0];
        FieldDescriptor[] fld = new FieldDescriptor[0];
        ClassImpl ci = new ClassImpl(claddr, cname, superType, loader, statics, fld);
        long claddr2 = ci.getObjectAddress();
        int clsId = this.indexToAddress.reverse(claddr2);
        if (clsId >= 0) {
            ci.setObjectId(clsId);
        } else {
            listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageFormat.format(Messages.DTFJIndexBuilder_ClassAtAddressNotFound, DTFJIndexBuilder.format(claddr), clsId, cname), null);
        }
        if (superType != 0L) {
            int superId = this.indexToAddress.reverse(superType);
            ci.setSuperClassIndex(superId);
        }
        if ((loaderId = this.indexToAddress.reverse(loader)) >= 0) {
            ci.setClassLoaderIndex(loaderId);
        } else {
            listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageFormat.format(Messages.DTFJIndexBuilder_ClassLoaderAtAddressNotFound, DTFJIndexBuilder.format(loader), loaderId, DTFJIndexBuilder.format(claddr), clsId, cname), null);
        }
        hm.put(ci.getObjectId(), (Object)ci);
        if (type == null) {
            type = ci;
        }
        ci.setClassInstance(type);
        int size = 0;
        ci.setUsedHeapSize((long)size);
        ci.setHeapSizePerInstance(0L);
        if (debugInfo) {
            this.objectToSize2.set(ci.getObjectId(), size);
        }
        type.addInstance((long)size);
        return ci;
    }

    static String getMethodName(JavaMethod meth, IProgressListener listener) throws CorruptDataException {
        String name = meth.getName();
        try {
            String sig = meth.getSignature();
            if (sig.equals("")) {
                sig = "()";
            }
            name = String.valueOf(name) + sig;
        }
        catch (CorruptDataException e) {
            name = String.valueOf(name) + "()";
        }
        return name;
    }

    static int signatureToType(String sig, Object value) {
        int ret = DTFJIndexBuilder.signatureToType(sig);
        if (ret == -1) {
            ret = DTFJIndexBuilder.signatureToType(value);
        }
        return ret;
    }

    static int signatureToType(String sig) {
        int ret;
        if (sig.length() == 0) {
            return -1;
        }
        switch (sig.charAt(0)) {
            case 'L': {
                ret = 2;
                break;
            }
            case '[': {
                ret = 2;
                break;
            }
            case 'Z': {
                ret = 4;
                break;
            }
            case 'B': {
                ret = 8;
                break;
            }
            case 'C': {
                ret = 5;
                break;
            }
            case 'S': {
                ret = 9;
                break;
            }
            case 'I': {
                ret = 10;
                break;
            }
            case 'J': {
                ret = 11;
                break;
            }
            case 'F': {
                ret = 6;
                break;
            }
            case 'D': {
                ret = 7;
                break;
            }
            default: {
                ret = -1;
            }
        }
        return ret;
    }

    static int signatureToType(Object o) {
        int ret = o instanceof JavaObject || o == null ? 2 : (o instanceof Byte ? 8 : (o instanceof Short ? 9 : (o instanceof Integer ? 10 : (o instanceof Long ? 11 : (o instanceof Float ? 6 : (o instanceof Double ? 7 : (o instanceof Boolean ? 4 : (o instanceof Character ? 5 : -1))))))));
        return ret;
    }

    static long getThreadAddress(JavaThread th, IProgressListener listener) {
        long ret = 0L;
        CorruptDataException e = null;
        try {
            JavaObject o = th.getObject();
            if (o != null) {
                ret = o.getID().getAddress();
            }
        }
        catch (CorruptDataException e1) {
            e = e1;
        }
        if (ret == 0L) {
            block15: {
                try {
                    ret = th.getJNIEnv().getAddress();
                }
                catch (CorruptDataException e2) {
                    ImagePointer ip = null;
                    if (e != null) {
                        ip = e.getCorruptData().getAddress();
                    }
                    if (ip == null) {
                        ip = e2.getCorruptData().getAddress();
                    }
                    if (ip == null) break block15;
                    ret = ip.getAddress();
                }
            }
            if (listener != null) {
                String name;
                if (ret == 0L) {
                    try {
                        name = th.getName();
                        listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemReadingJavaThreadInformationFor, name), (Throwable)e);
                    }
                    catch (CorruptDataException e2) {
                        listener.sendUserMessage(IProgressListener.Severity.WARNING, Messages.DTFJIndexBuilder_ProblemReadingJavaThreadInformation, (Throwable)e);
                        listener.sendUserMessage(IProgressListener.Severity.INFO, Messages.DTFJIndexBuilder_ProblemReadingJavaThreadName, (Throwable)e2);
                    }
                } else {
                    try {
                        name = th.getName();
                        listener.sendUserMessage(IProgressListener.Severity.INFO, MessageFormat.format(Messages.DTFJIndexBuilder_UsingAddressForThreadName, DTFJIndexBuilder.format(ret), name), (Throwable)e);
                    }
                    catch (CorruptDataException e2) {
                        listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_UsingAddressForThread, DTFJIndexBuilder.format(ret)), (Throwable)e);
                        listener.sendUserMessage(IProgressListener.Severity.INFO, Messages.DTFJIndexBuilder_ProblemReadingJavaThreadName, (Throwable)e2);
                    }
                }
            }
        }
        return ret;
    }

    private long getLoaderAddress(JavaClassLoader load, long bootLoaderAddress) throws CorruptDataException {
        JavaObject loaderObject;
        long loader = load == null ? bootLoaderAddress : ((loaderObject = load.getObject()) == null ? bootLoaderAddress : loaderObject.getID().getAddress());
        loader = this.fixBootLoaderAddress(bootLoaderAddress, loader);
        return loader;
    }

    private String getClassName(JavaClass javaClass, IProgressListener listen) {
        String name;
        try {
            name = javaClass.getName();
        }
        catch (CorruptDataException e) {
            long id = this.getClassAddress(javaClass, listen);
            name = "corruptClassName@" + DTFJIndexBuilder.format(id);
            try {
                if (javaClass.isArray()) {
                    name = "[LcorruptArrayClassName@" + DTFJIndexBuilder.format(id) + ";";
                    JavaClass comp = javaClass.getComponentType();
                    String compName = this.getClassName(comp, listen);
                    name = compName.startsWith("[") ? "[" + compName : "[L" + compName + ";";
                }
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
        }
        return name;
    }

    private String getClassSignature(JavaClass javaClass) throws CorruptDataException {
        String sig = "L" + javaClass.getName() + ";";
        return sig;
    }

    private static boolean isPrimitiveName(String name) {
        return primSet.contains(name);
    }

    private JavaClass getSuperclass(JavaClass j2, IProgressListener listener) {
        JavaClass sup = null;
        try {
            sup = j2.getSuperclass();
            if (sup == null) {
                if (j2.isArray() && j2.getObject() != null && j2.getObject().getJavaClass().getSuperclass() != null) {
                    sup = j2.getObject().getJavaClass();
                    while (sup.getSuperclass() != null) {
                        sup = sup.getSuperclass();
                    }
                    if (listener != null && this.msgNnoSuperClassForArray-- > 0) {
                        listener.sendUserMessage(Severity_INFO, MessageFormat.format(Messages.DTFJIndexBuilder_NoSuperclassForArray, j2.getName(), sup.getName()), null);
                    }
                }
            } else if ((this.msgNgetSuperclass > 0 || this.modifiersFound > 0) && Modifier.isInterface(j2.getModifiers())) {
                ++this.modifiersFound;
                if (listener != null && this.msgNbrokenInterfaceSuper-- > 0) {
                    listener.sendUserMessage(Severity_INFO, MessageFormat.format(Messages.DTFJIndexBuilder_InterfaceShouldNotHaveASuperclass, j2.getName(), sup.getName()), null);
                }
                sup = null;
            } else {
                String name = j2.getName();
                if (DTFJIndexBuilder.isPrimitiveName(name)) {
                    if (listener != null) {
                        listener.sendUserMessage(Severity_INFO, MessageFormat.format(Messages.DTFJIndexBuilder_PrimitiveShouldNotHaveASuperclass, j2.getName(), sup.getName()), null);
                    }
                    sup = null;
                }
            }
            return sup;
        }
        catch (CorruptDataException e) {
            long addr = this.getClassAddress(j2, listener);
            String name = this.getClassName(j2, listener);
            if (listener != null && this.msgNgetSuperclass-- > 0) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageFormat.format(Messages.DTFJIndexBuilder_ProblemGettingSuperclass, name, DTFJIndexBuilder.format(addr)), (Throwable)e);
            }
            return sup;
        }
    }

    private JavaClassLoader getClassLoader1(JavaClass j2, IProgressListener listener) throws CorruptDataException {
        JavaClassLoader load;
        JavaClass j3 = j2;
        while ((load = j3.getClassLoader()) == null && j3.isArray()) {
            if (this.msgNmissingLoaderMsg-- > 0) {
                listener.sendUserMessage(Severity_INFO, MessageFormat.format(Messages.DTFJIndexBuilder_NoClassLoader, j3.getName(), j3.getComponentType().getName()), null);
            }
            j3 = j3.getComponentType();
        }
        return load;
    }

    private JavaClassLoader getClassLoader(JavaClass j1, IProgressListener listener) throws CorruptDataException {
        JavaClassLoader load;
        try {
            load = this.getClassLoader1(j1, listener);
        }
        catch (CorruptDataException e) {
            JavaClassLoader load2 = this.getClassLoader2(j1, listener);
            if (load2 != null) {
                return load2;
            }
            throw e;
        }
        if (load == null) {
            load = this.getClassLoader2(j1, listener);
        }
        return load;
    }

    private JavaClassLoader getClassLoader2(JavaClass j1, IProgressListener listener) throws CorruptDataException {
        Iterator i = this.dtfjInfo.getJavaRuntime().getJavaClassLoaders();
        while (i.hasNext()) {
            Object next = i.next();
            if (DTFJIndexBuilder.isCorruptData(next, listener, Messages.DTFJIndexBuilder_CorruptDataReadingClassLoaders1, this.dtfjInfo.getJavaRuntime())) continue;
            JavaClassLoader jcl = (JavaClassLoader)next;
            Iterator j = jcl.getDefinedClasses();
            while (j.hasNext()) {
                JavaClass j2;
                Object next2 = j.next();
                if (DTFJIndexBuilder.isCorruptData(next2, listener, Messages.DTFJIndexBuilder_CorruptDataReadingClasses, jcl) || !(j2 = (JavaClass)next2).equals((Object)j1)) continue;
                return jcl;
            }
        }
        return null;
    }

    private static String format(long address) {
        return "0x" + Long.toHexString(address);
    }

    private String getMATClassName(JavaClass j2, IProgressListener listener) {
        String d = this.getClassName(j2, listener).replace('/', '.');
        int dim = 0;
        int d_len = d.length();
        while (dim < d_len && d.charAt(dim) == '[') {
            ++dim;
        }
        if (dim > 0) {
            int j = d_len;
            int i = dim;
            if (j > i && d.charAt(j - 1) == ';') {
                --j;
                if (d.charAt(i) == 'L') {
                    ++i;
                }
                d = d.substring(i, j);
            } else if ((d = d.substring(i, j)).equals("Z")) {
                d = "boolean";
            } else if (d.equals("B")) {
                d = "byte";
            } else if (d.equals("S")) {
                d = "short";
            } else if (d.equals("C")) {
                d = "char";
            } else if (d.equals("I")) {
                d = "int";
            } else if (d.equals("F")) {
                d = "float";
            } else if (d.equals("J")) {
                d = "long";
            } else if (d.equals("D")) {
                d = "double";
            } else if (d.startsWith("L")) {
                d = d.substring(1);
            }
            StringBuilder a = new StringBuilder(d);
            while (dim > 0) {
                a.append("[]");
                --dim;
            }
            d = a.toString();
        }
        return d;
    }

    public void init(File file, String prefix) {
        this.dump = file.getAbsoluteFile();
        this.pfx = prefix;
    }

    private static Image getUncachedDump(File dump, Serializable format) throws Error, IOException {
        return DTFJIndexBuilder.getDynamicDTFJDump(dump, format);
    }

    private static Image getDynamicDTFJDump(File dump, Serializable format) throws IOException {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint point = reg.getExtensionPoint("com.ibm.dtfj.api", "imagefactory");
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ex = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ex.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String id;
                    IConfigurationElement el = iConfigurationElementArray[n4];
                    if (el.getName().equals("factory") && (id = el.getAttribute("id")) != null && id.equals(format)) {
                        File dumpFile = null;
                        File metaFile = null;
                        try {
                            IContentType[] cts2;
                            IContentType[] cts;
                            IContentType ct0;
                            String name;
                            ImageFactory fact;
                            LinkedHashSet attemptedFiles;
                            block64: {
                                FileInputStream is;
                                block62: {
                                    block60: {
                                        attemptedFiles = new LinkedHashSet();
                                        fact = (ImageFactory)el.createExecutableExtension("action");
                                        name = dump.getName();
                                        is = null;
                                        try {
                                            try {
                                                is = new FileInputStream(dump);
                                                ct0 = Platform.getContentTypeManager().findContentTypeFor((InputStream)is, name);
                                            }
                                            catch (IOException e) {
                                                ct0 = null;
                                                if (is != null) {
                                                    is.close();
                                                }
                                                break block60;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            if (is != null) {
                                                is.close();
                                            }
                                            throw throwable;
                                        }
                                        if (is != null) {
                                            is.close();
                                        }
                                    }
                                    try {
                                        try {
                                            is = new FileInputStream(dump);
                                            cts = Platform.getContentTypeManager().findContentTypesFor((InputStream)is, name);
                                        }
                                        catch (IOException e) {
                                            cts = new IContentType[]{};
                                            if (is != null) {
                                                is.close();
                                            }
                                            break block62;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        if (is != null) {
                                            is.close();
                                        }
                                        throw throwable;
                                    }
                                    if (is != null) {
                                        is.close();
                                    }
                                }
                                try {
                                    try {
                                        is = new FileInputStream(dump);
                                        cts2 = Platform.getContentTypeManager().findContentTypesFor((InputStream)is, null);
                                    }
                                    catch (IOException e) {
                                        cts2 = new IContentType[]{};
                                        if (is != null) {
                                            is.close();
                                        }
                                        break block64;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (is != null) {
                                        is.close();
                                    }
                                    throw throwable;
                                }
                                if (is != null) {
                                    is.close();
                                }
                            }
                            IConfigurationElement[] iConfigurationElementArray2 = el.getChildren();
                            int n5 = iConfigurationElementArray2.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IConfigurationElement el2 = iConfigurationElementArray2[n6];
                                if (el2.getName().equals("content-types")) {
                                    boolean[] foundext;
                                    String string = el2.getAttribute("dump-type");
                                    String metaId = el2.getAttribute("meta-type");
                                    IContentType cext = Platform.getContentTypeManager().getContentType(string);
                                    IContentType cmeta = Platform.getContentTypeManager().getContentType(metaId);
                                    if (cmeta != null) {
                                        foundext = new boolean[1];
                                        boolean[] foundmeta = new boolean[1];
                                        String[] actualExts = DTFJIndexBuilder.getActualExts(cext, name, ct0, cts, cts2, foundext);
                                        String[] actualMetaExts = DTFJIndexBuilder.getActualExts(cmeta, name, ct0, cts, cts2, foundmeta);
                                        String[] possibleExts = DTFJIndexBuilder.getPossibleExts(cext);
                                        String[] possibleMetaExts = DTFJIndexBuilder.getPossibleExts(cmeta);
                                        boolean extFirst = foundext[0];
                                        int i = 0;
                                        while (i < 2) {
                                            ArrayList<File> fs;
                                            int p;
                                            String ext1;
                                            String metaExt1;
                                            int n7;
                                            int n8;
                                            String[] stringArray;
                                            int n9;
                                            int n10;
                                            String[] stringArray2;
                                            if (extFirst) {
                                                stringArray2 = actualExts;
                                                n10 = actualExts.length;
                                                n9 = 0;
                                                while (n9 < n10) {
                                                    String ext = stringArray2[n9];
                                                    stringArray = possibleMetaExts;
                                                    n8 = possibleMetaExts.length;
                                                    n7 = 0;
                                                    while (n7 < n8) {
                                                        String metaExt = stringArray[n7];
                                                        metaExt1 = ext.equals("") && !metaExt.equals("") ? METHOD_NAME_PREFIX + metaExt : metaExt;
                                                        String string2 = ext1 = metaExt.equals("") && !ext.equals("") ? METHOD_NAME_PREFIX + ext : ext;
                                                        if (debugInfo) {
                                                            DTFJIndexBuilder.debugPrint("ext " + ext + " " + ext1 + " " + metaExt + " " + metaExt1);
                                                        }
                                                        if (DTFJIndexBuilder.endsWithIgnoreCase(name, ext1)) {
                                                            p = name.length() - ext1.length();
                                                            dumpFile = dump;
                                                            metaFile = new File(dump.getParentFile(), String.valueOf(name.substring(0, p)) + metaExt1);
                                                            fs = new ArrayList<File>();
                                                            fs.add(dumpFile);
                                                            fs.add(metaFile);
                                                            attemptedFiles.add(fs);
                                                        }
                                                        ++n7;
                                                    }
                                                    ++n9;
                                                }
                                            } else {
                                                stringArray2 = actualMetaExts;
                                                n10 = actualMetaExts.length;
                                                n9 = 0;
                                                while (n9 < n10) {
                                                    String metaExt = stringArray2[n9];
                                                    stringArray = possibleExts;
                                                    n8 = possibleExts.length;
                                                    n7 = 0;
                                                    while (n7 < n8) {
                                                        String ext = stringArray[n7];
                                                        metaExt1 = ext.equals("") && !metaExt.equals("") ? METHOD_NAME_PREFIX + metaExt : metaExt;
                                                        String string3 = ext1 = metaExt.equals("") && !ext.equals("") ? METHOD_NAME_PREFIX + ext : ext;
                                                        if (debugInfo) {
                                                            DTFJIndexBuilder.debugPrint("meta " + ext + " " + ext1 + " " + metaExt + " " + metaExt1);
                                                        }
                                                        if (DTFJIndexBuilder.endsWithIgnoreCase(name, metaExt1)) {
                                                            p = name.length() - metaExt1.length();
                                                            dumpFile = new File(dump.getParentFile(), String.valueOf(name.substring(0, p)) + ext1);
                                                            metaFile = dump;
                                                            fs = new ArrayList();
                                                            fs.add(dumpFile);
                                                            fs.add(metaFile);
                                                            attemptedFiles.add(fs);
                                                        }
                                                        ++n7;
                                                    }
                                                    ++n9;
                                                }
                                            }
                                            ++i;
                                            boolean bl = extFirst = !extFirst;
                                        }
                                    } else if (cext != null) {
                                        String[] actualExts;
                                        foundext = new boolean[1];
                                        String[] stringArray = actualExts = DTFJIndexBuilder.getActualExts(cext, name, ct0, cts, cts2, foundext);
                                        int n11 = actualExts.length;
                                        int n12 = 0;
                                        while (n12 < n11) {
                                            String ext = stringArray[n12];
                                            if (DTFJIndexBuilder.endsWithIgnoreCase(name, ext)) {
                                                dumpFile = dump;
                                                metaFile = null;
                                                ArrayList<File> fs = new ArrayList<File>();
                                                fs.add(dumpFile);
                                                attemptedFiles.add(fs);
                                                break;
                                            }
                                            ++n12;
                                        }
                                    }
                                }
                                ++n6;
                            }
                            dumpFile = dump;
                            metaFile = null;
                            ArrayList<File> fs = new ArrayList<File>();
                            fs.add(dump);
                            attemptedFiles.add(fs);
                            RuntimeException savedRuntimeException = null;
                            FileNotFoundException savedFileException = null;
                            IOException savedIOException = null;
                            try {
                                for (List list : attemptedFiles) {
                                    dumpFile = (File)list.get(0);
                                    if (list.size() >= 2) {
                                        metaFile = (File)list.get(1);
                                        try {
                                            Image image = fact.getImage(dumpFile, metaFile);
                                            DumpCache.factoryMap.put(image, fact);
                                            return image;
                                        }
                                        catch (FileNotFoundException e) {
                                            DTFJIndexBuilder.checkIfDiskFull(dumpFile, metaFile, e, format);
                                            continue;
                                        }
                                        catch (IOException e) {
                                            if (e.getCause() != null && e.getCause().getMessage().contains("Not a javacore file.")) {
                                                savedRuntimeException = null;
                                                savedFileException = null;
                                                savedIOException = e;
                                                continue;
                                            }
                                            throw e;
                                        }
                                    }
                                    metaFile = null;
                                    try {
                                        Image image = fact.getImage(dumpFile);
                                        DumpCache.factoryMap.put(image, fact);
                                        return image;
                                    }
                                    catch (RuntimeException e) {
                                        savedRuntimeException = e;
                                        savedFileException = null;
                                        savedIOException = null;
                                    }
                                    catch (FileNotFoundException e) {
                                        savedRuntimeException = null;
                                        savedFileException = e;
                                        savedIOException = null;
                                        DTFJIndexBuilder.checkIfDiskFull(dumpFile, metaFile, e, format);
                                    }
                                }
                            }
                            catch (IOException iOException) {
                                DumpCache.clearCachedDumps();
                                IOException e12 = new IOException(MessageFormat.format(Messages.DTFJIndexBuilder_UnableToReadDumpMetaInDTFJFormat, dumpFile, metaFile, format));
                                e12.initCause(iOException);
                                throw e12;
                            }
                            if (savedIOException != null) {
                                IOException iOException = new IOException(MessageFormat.format(Messages.DTFJIndexBuilder_UnableToReadDumpMetaInDTFJFormat, dumpFile, metaFile, format));
                                iOException.initCause(savedIOException);
                                throw iOException;
                            }
                            if (savedRuntimeException != null) {
                                IOException iOException = new IOException(MessageFormat.format(Messages.DTFJIndexBuilder_UnableToReadDumpInDTFJFormat, dumpFile, format));
                                iOException.initCause(savedRuntimeException);
                                throw iOException;
                            }
                            if (savedFileException != null) {
                                IOException iOException = new IOException(MessageFormat.format(Messages.DTFJIndexBuilder_UnableToReadDumpInDTFJFormat, dumpFile, format));
                                iOException.initCause(savedFileException);
                                throw iOException;
                            }
                        }
                        catch (CoreException e) {
                            IOException e1 = new IOException(MessageFormat.format(Messages.DTFJIndexBuilder_UnableToReadDumpInDTFJFormat, dump, format));
                            e1.initCause(e);
                            throw e1;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        throw new IOException(MessageFormat.format(Messages.DTFJIndexBuilder_UnableToFindDTFJForFormat, format));
    }

    private static String[] getActualExts(IContentType cext, String name, IContentType ctdump, IContentType[] cts, IContentType[] cts2, boolean[] found) {
        int n;
        LinkedHashSet<String> exts = new LinkedHashSet<String>();
        if (debugInfo) {
            DTFJIndexBuilder.debugPrint("Match " + cext);
        }
        if (ctdump != null && ctdump.isKindOf(cext)) {
            if (debugInfo) {
                DTFJIndexBuilder.debugPrint("Found default type " + ctdump);
            }
            exts.addAll(Arrays.asList(ctdump.getFileSpecs(8)));
        }
        if (cts.length > 0) {
            IContentType[] iContentTypeArray = cts;
            n = cts.length;
            int n2 = 0;
            while (n2 < n) {
                IContentType ct = iContentTypeArray[n2];
                if (ct.isKindOf(cext)) {
                    if (debugInfo) {
                        DTFJIndexBuilder.debugPrint("Found possible type with file name " + ct);
                    }
                    exts.addAll(Arrays.asList(ct.getFileSpecs(8)));
                }
                ++n2;
            }
        }
        if (cts.length == 0) {
            if (debugInfo) {
                DTFJIndexBuilder.debugPrint("No types");
            }
            boolean foundType = false;
            IContentType[] iContentTypeArray = cts2;
            int n3 = cts2.length;
            n = 0;
            while (n < n3) {
                IContentType ct = iContentTypeArray[n];
                if (ct.isKindOf(cext)) {
                    if (debugInfo) {
                        DTFJIndexBuilder.debugPrint("Found possible type without file name " + ct);
                    }
                    foundType = true;
                    exts.addAll(Arrays.asList(ct.getFileSpecs(8)));
                }
                ++n;
            }
            if (foundType) {
                int lastDot = name.lastIndexOf(46);
                if (lastDot >= 0) {
                    exts.add(name.substring(lastDot + 1));
                } else {
                    exts.add("");
                }
            }
        }
        if (exts.isEmpty()) {
            found[0] = false;
            exts.addAll(Arrays.asList(DTFJIndexBuilder.getPossibleExts(cext)));
        } else {
            found[0] = true;
        }
        if (debugInfo) {
            DTFJIndexBuilder.debugPrint("All exts " + exts);
        }
        return exts.toArray(new String[exts.size()]);
    }

    private static String[] getPossibleExts(IContentType cext) {
        LinkedHashSet<String> exts = new LinkedHashSet<String>();
        exts.addAll(Arrays.asList(cext.getFileSpecs(8)));
        IContentType[] iContentTypeArray = Platform.getContentTypeManager().getAllContentTypes();
        int n = iContentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType ct = iContentTypeArray[n2];
            if (ct.isKindOf(cext)) {
                exts.addAll(Arrays.asList(ct.getFileSpecs(8)));
            }
            ++n2;
        }
        return exts.toArray(new String[exts.size()]);
    }

    private static boolean endsWithIgnoreCase(String s1, String s2) {
        int start = s1.length() - s2.length();
        return start >= 0 && s2.compareToIgnoreCase(s1.substring(start)) == 0;
    }

    private static void checkIfDiskFull(File dumpFile, File metaFile, FileNotFoundException e, Serializable format) throws IOException {
        if (e.getMessage().contains("Unable to write")) {
            DumpCache.clearCachedDumps();
            IOException e1 = new IOException(MessageFormat.format(Messages.DTFJIndexBuilder_UnableToReadDumpMetaInDTFJFormat, dumpFile, metaFile, format));
            e1.initCause(e);
            throw e1;
        }
    }

    private static void debugPrint(String msg) {
        System.out.println(msg);
    }

    private static boolean getDebugOption(String option, boolean defaultValue) {
        String val = Platform.getDebugOption((String)option);
        if (val != null) {
            return Boolean.parseBoolean(val);
        }
        return defaultValue;
    }

    private static int getDebugOption(String option, int defaultValue) {
        String val = Platform.getDebugOption((String)option);
        if (val != null) {
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static void cleanUp(boolean closeFailed, boolean softRefCleared) {
        if (closeFailed) {
            System.currentTimeMillis();
            System.gc();
            System.runFinalization();
        } else if (softRefCleared) {
            System.runFinalization();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DummyJavaClass
    implements JavaClass,
    CorruptData {
        private final String name;

        public DummyJavaClass(String name) {
            this.name = name;
        }

        public JavaClassLoader getClassLoader() throws CorruptDataException {
            throw new CorruptDataException((CorruptData)this);
        }

        public JavaClass getComponentType() throws CorruptDataException {
            throw new CorruptDataException((CorruptData)this);
        }

        public Iterator<?> getConstantPoolReferences() {
            return Collections.EMPTY_LIST.iterator();
        }

        public Iterator<?> getDeclaredFields() {
            return Collections.EMPTY_LIST.iterator();
        }

        public Iterator<?> getDeclaredMethods() {
            return Collections.EMPTY_LIST.iterator();
        }

        public ImagePointer getID() {
            return null;
        }

        public Iterator<?> getInterfaces() {
            return Collections.EMPTY_LIST.iterator();
        }

        public int getModifiers() throws CorruptDataException {
            throw new CorruptDataException((CorruptData)this);
        }

        public String getName() throws CorruptDataException {
            return this.name;
        }

        public JavaObject getObject() throws CorruptDataException {
            return null;
        }

        public Iterator<?> getReferences() {
            return Collections.EMPTY_LIST.iterator();
        }

        public JavaClass getSuperclass() throws CorruptDataException {
            throw new CorruptDataException((CorruptData)this);
        }

        public boolean isArray() throws CorruptDataException {
            return false;
        }

        public ImagePointer getAddress() {
            return null;
        }

        public long getInstanceSize() throws DataUnavailable, CorruptDataException {
            throw new DataUnavailable();
        }

        public JavaObject getProtectionDomain() throws DataUnavailable, CorruptDataException {
            throw new DataUnavailable();
        }

        public boolean isPacked() throws DataUnavailable, CorruptDataException {
            throw new DataUnavailable();
        }

        public long getPackedDataSize() throws DataUnavailable, CorruptDataException {
            throw new DataUnavailable();
        }
    }

    static class DumpCache {
        private static final Map<File, ImageSoftReference> imageMap = new HashMap<File, ImageSoftReference>();
        private static final Map<Image, ImageFactory> factoryMap = Collections.synchronizedMap(new WeakHashMap());
        private static int imageCount;
        private static Timer clearTimer;

        DumpCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static RuntimeInfo getDump(File dump, Serializable format) throws Error, IOException {
            Image im;
            ImageSoftReference softReference;
            Map<File, ImageSoftReference> map = imageMap;
            synchronized (map) {
                if (clearTimer != null) {
                    clearTimer.cancel();
                    clearTimer = null;
                }
                if ((softReference = imageMap.get(dump)) != null && (im = softReference.obtain()) != null) {
                    ++imageCount;
                    return new RuntimeInfo(factoryMap.get(im), im, null, null, null, null);
                }
            }
            im = DTFJIndexBuilder.getUncachedDump(dump, format);
            map = imageMap;
            synchronized (map) {
                softReference = imageMap.get(dump);
                if (softReference == null || softReference.get() == null) {
                    imageMap.put(dump, new ImageSoftReference(im));
                }
                ++imageCount;
            }
            return new RuntimeInfo(factoryMap.get(im), im, null, null, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void releaseDump(File dump, RuntimeInfo dtfj, boolean free) {
            if (dtfj.image == null) {
                return;
            }
            ImageSoftReference closeDump = null;
            Map<File, ImageSoftReference> map = imageMap;
            synchronized (map) {
                ImageSoftReference sr = imageMap.get(dump);
                if (sr != null && sr.release(dtfj.image)) {
                    dtfj.clear();
                    if (sr.count == 0 && (sr.old || InitDTFJ.getDefault() == null)) {
                        imageMap.remove(dump);
                        closeDump = sr;
                    }
                } else {
                    ImageSoftReference newsr = new ImageSoftReference(dtfj.image);
                    if ((sr == null || sr.get() == null) && InitDTFJ.getDefault() != null) {
                        imageMap.put(dump, newsr);
                        dtfj.clear();
                    } else {
                        newsr.release(dtfj.image);
                        dtfj.clear();
                        closeDump = newsr;
                    }
                }
                if (--imageCount <= 0 && free) {
                    if (clearTimer == null) {
                        clearTimer = new Timer();
                    }
                    clearTimer.schedule(new TimerTask(){

                        public void run() {
                            DumpCache.clearCachedDumps();
                        }
                    }, 30000L);
                }
            }
            if (closeDump != null) {
                closeDump.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void clearCachedDump(File dump) {
            ImageSoftReference sr;
            Map<File, ImageSoftReference> map = imageMap;
            synchronized (map) {
                sr = imageMap.get(dump);
                if (sr != null) {
                    if (sr.count >= 1) {
                        sr.old = true;
                        sr = null;
                    } else {
                        sr = imageMap.remove(dump);
                    }
                }
            }
            if (sr != null) {
                sr.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void clearCachedDumps() {
            ArrayList<ImageSoftReference> toClean;
            boolean closeFailed = false;
            boolean softRefCleared = false;
            Map<File, ImageSoftReference> map = imageMap;
            synchronized (map) {
                toClean = new ArrayList<ImageSoftReference>();
                Iterator<Map.Entry<File, ImageSoftReference>> it = imageMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<File, ImageSoftReference> e = it.next();
                    if (e.getValue().count != 0) continue;
                    toClean.add(e.getValue());
                    it.remove();
                }
            }
            for (ImageSoftReference sr : toClean) {
                Image dumpImage = (Image)sr.get();
                sr.clear();
                if (dumpImage != null) {
                    factoryMap.remove(dumpImage);
                    try {
                        dumpImage.close();
                    }
                    catch (NoSuchMethodError e) {
                        closeFailed = true;
                        dumpImage = null;
                    }
                    continue;
                }
                softRefCleared = true;
            }
            DTFJIndexBuilder.cleanUp(closeFailed, softRefCleared);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ImageSoftReference
    extends SoftReference<Image> {
        private int count = 1;
        private boolean old;

        public ImageSoftReference(Image o) {
            super(o);
        }

        public Image obtain() {
            if (this.old) {
                return null;
            }
            Image x = (Image)this.get();
            if (x != null) {
                ++this.count;
            }
            return x;
        }

        public boolean release(Image x1) {
            Image x = (Image)this.get();
            if (x == x1) {
                --this.count;
                return true;
            }
            return false;
        }

        public void close() {
            boolean closeFailed = false;
            boolean softRefCleared = false;
            Image dumpImage = (Image)this.get();
            this.clear();
            if (dumpImage != null) {
                if (this.count == 0) {
                    DumpCache.factoryMap.remove(dumpImage);
                    try {
                        dumpImage.close();
                    }
                    catch (NoSuchMethodError e) {
                        closeFailed = true;
                        dumpImage = null;
                    }
                }
            } else {
                softRefCleared = true;
            }
            DTFJIndexBuilder.cleanUp(closeFailed, softRefCleared);
        }
    }

    private static class ObjectToSize {
        private byte[] objectToSize;
        private HashMapIntLong bigObjs = new HashMapIntLong();
        private static final int SHIFT = 3;
        private static final int MASK = 255;

        ObjectToSize(int size) {
            this.objectToSize = new byte[size];
        }

        long get(int index) {
            if (this.bigObjs.containsKey(index)) {
                long size = this.bigObjs.get(index);
                return size;
            }
            return (this.objectToSize[index] & 0xFF) << 3;
        }

        long getSize(int index) {
            return this.get(index);
        }

        void set(int index, long size) {
            if ((size & 0xFFFFFFFFFFFFF807L) == 0L) {
                this.objectToSize[index] = (byte)(size >>> 3);
            } else {
                this.bigObjs.put(index, size);
            }
        }

        public IIndexReader.IOne2SizeIndex writeTo(File indexFile) throws IOException {
            final int size = this.objectToSize.length;
            return new IndexReader.SizeIndexReader(new IndexWriter.IntIndexStreamer().writeTo(indexFile, new IteratorInt(){
                int i;

                public boolean hasNext() {
                    return this.i < size;
                }

                public int next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return IndexWriter.SizeIndexCollectorUncompressed.compress((long)ObjectToSize.this.getSize(this.i++));
                }
            }));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RefMap<E>
    extends RefStore<E> {
        final HashMapLongObject<E> map = new HashMapLongObject();

        @Override
        public E put(long key, E value) {
            if (this.size() == 0) {
                this.first = key;
            }
            return (E)this.map.put(key ^ this.first, value);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public Iterator<HashMapLongObject.Entry<E>> entries() {
            final Iterator it = this.map.entries();
            return new Iterator<HashMapLongObject.Entry<E>>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public HashMapLongObject.Entry<E> next() {
                    final HashMapLongObject.Entry e = (HashMapLongObject.Entry)it.next();
                    return new HashMapLongObject.Entry<E>(){

                        public long getKey() {
                            return e.getKey() ^ (this).RefMap.this.first;
                        }

                        public E getValue() {
                            return e.getValue();
                        }
                    };
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
        }

        @Override
        public long[] getAllKeys() {
            long[] ret = this.map.getAllKeys();
            int i = 0;
            while (i < ret.length) {
                int n = i++;
                ret[n] = ret[n] ^ this.first;
            }
            return ret;
        }

        @Override
        public boolean containsKey(long k) {
            return this.map.containsKey(k ^ this.first);
        }

        @Override
        public IteratorLong keys() {
            final IteratorLong it = this.map.keys();
            return new IteratorLong(){

                public boolean hasNext() {
                    return it.hasNext();
                }

                public long next() {
                    return it.next() ^ RefMap.this.first;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RefSet<E>
    extends RefStore<E> {
        final SetLong set = new SetLong();

        @Override
        public E put(long key, E value) {
            if (this.size() == 0) {
                this.first = key;
            }
            return this.set.add(key ^ this.first) ? null : (E)value;
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public Iterator<HashMapLongObject.Entry<E>> entries() {
            final IteratorLong it = this.set.iterator();
            return new Iterator<HashMapLongObject.Entry<E>>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public HashMapLongObject.Entry<E> next() {
                    final long e = it.next();
                    return new HashMapLongObject.Entry<E>(){

                        public long getKey() {
                            return e ^ (this).RefSet.this.first;
                        }

                        public E getValue() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public long[] getAllKeys() {
            long[] ret = this.set.toArray();
            int i = 0;
            while (i < ret.length) {
                int n = i++;
                ret[n] = ret[n] ^ this.first;
            }
            return ret;
        }

        @Override
        public boolean containsKey(long k) {
            return this.set.contains(k ^ this.first);
        }

        @Override
        public IteratorLong keys() {
            final IteratorLong it = this.set.iterator();
            return new IteratorLong(){

                public boolean hasNext() {
                    return it.hasNext();
                }

                public long next() {
                    return it.next() ^ RefSet.this.first;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class RefStore<E> {
        long first;

        private RefStore() {
        }

        public abstract E put(long var1, E var3);

        public abstract int size();

        public abstract Iterator<HashMapLongObject.Entry<E>> entries();

        public abstract long[] getAllKeys();

        public abstract boolean containsKey(long var1);

        public abstract IteratorLong keys();
    }

    static class RuntimeInfo {
        private ImageFactory factory;
        private Image image;
        private ImageAddressSpace imageAddressSpace;
        private ImageProcess imageProcess;
        private JavaRuntime javaRuntime;
        private String runtimeId;

        public RuntimeInfo(ImageFactory fact, Image img, ImageAddressSpace space, ImageProcess process, JavaRuntime runtime, String id) {
            this.factory = fact;
            this.image = img;
            this.imageAddressSpace = space;
            this.imageProcess = process;
            this.javaRuntime = runtime;
            this.runtimeId = id;
        }

        public ImageFactory getImageFactory() {
            if (this.factory == null) {
                throw new IllegalStateException();
            }
            return this.factory;
        }

        public Image getImage() {
            if (this.image == null) {
                throw new IllegalStateException();
            }
            return this.image;
        }

        public ImageAddressSpace getImageAddressSpace() {
            if (this.imageAddressSpace == null) {
                throw new IllegalStateException();
            }
            return this.imageAddressSpace;
        }

        public ImageProcess getImageProcess() {
            if (this.imageProcess == null) {
                throw new IllegalStateException();
            }
            return this.imageProcess;
        }

        public JavaRuntime getJavaRuntime() {
            if (this.javaRuntime == null) {
                throw new IllegalStateException();
            }
            return this.javaRuntime;
        }

        public String getRuntimeId() {
            return this.runtimeId;
        }

        public void clear() {
            this.factory = null;
            this.image = null;
            this.imageAddressSpace = null;
            this.imageProcess = null;
            this.javaRuntime = null;
        }
    }
}

