/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

class AsmTypeHelper {
    AsmTypeHelper() {
    }

    public static AbstractInsnNode getUnboxingInstructionForType(Type primitiveType) {
        String objectType = AsmTypeHelper.getBoxingType(primitiveType);
        if (objectType == null) {
            return new InsnNode(0);
        }
        return AsmTypeHelper.getUnboxingInstructionForType(primitiveType, objectType);
    }

    public static AbstractInsnNode getUnboxingInstructionForType(Type primitiveType, String objectType) {
        String methodName = String.valueOf(primitiveType.getClassName()) + "Value";
        String desc = Type.getMethodDescriptor((Type)primitiveType, (Type[])new Type[0]);
        return new MethodInsnNode(182, objectType, methodName, desc, false);
    }

    public static String getBoxingType(Type primitiveType) {
        String className = null;
        switch (primitiveType.getSort()) {
            case 1: {
                className = "Boolean";
                break;
            }
            case 3: {
                className = "Byte";
                break;
            }
            case 2: {
                className = "Character";
                break;
            }
            case 8: {
                className = "Double";
                break;
            }
            case 6: {
                className = "Float";
                break;
            }
            case 5: {
                className = "Integer";
                break;
            }
            case 7: {
                className = "Long";
                break;
            }
            case 4: {
                className = "Short";
                break;
            }
            default: {
                return null;
            }
        }
        className = "java/lang/" + className;
        return className;
    }

    public static AbstractInsnNode getBoxingInstructionForType(Type type) {
        if (type.getSort() == 0) {
            return new InsnNode(1);
        }
        String className = AsmTypeHelper.getBoxingType(type);
        if (className == null) {
            return new InsnNode(0);
        }
        String desc = Type.getMethodDescriptor((Type)Type.getObjectType((String)className), (Type[])new Type[]{type});
        return new MethodInsnNode(184, className, "valueOf", desc, false);
    }
}

