/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;

public class AP2909
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;
    private boolean multipleContentFound;

    public AP2909(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.multipleContentFound = false;
        try {
            Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
            List ops = binding.getBindingOperations();
            int i = 0;
            while (i < ops.size()) {
                BindingOperation bindingOperation = (BindingOperation)ops.get(i);
                BindingInput bindingInput = bindingOperation.getBindingInput();
                BindingOutput bindingOutput = bindingOperation.getBindingOutput();
                List inputMimeParts = this.getMimeParts(bindingInput == null ? null : bindingInput.getExtensibilityElements());
                List outputMimeParts = this.getMimeParts(bindingOutput == null ? null : bindingOutput.getExtensibilityElements());
                if (this.containsInvalidMimePart(inputMimeParts)) {
                    throw new AssertionFailException("The invalid mime:part element is in the wsdl:input of the \"" + bindingOperation.getName() + "\" binding operation.");
                }
                if (this.containsInvalidMimePart(outputMimeParts)) {
                    throw new AssertionFailException("The invalid mime:part element is in the wsdl:output of the \"" + bindingOperation.getName() + "\" binding operation.");
                }
                ++i;
            }
            if (!this.multipleContentFound) {
                throw new AssertionNotApplicableException();
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException afe) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(afe.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean containsInvalidMimePart(List mimeParts) {
        int i = 0;
        while (i < mimeParts.size()) {
            boolean mimeContentFound = false;
            String mimeContentPart = null;
            List extElems = ((MIMEPart)mimeParts.get(i)).getExtensibilityElements();
            int j = 0;
            while (j < extElems.size()) {
                if (((ExtensibilityElement)extElems.get(j)).getElementType().equals(WSDL_MIME_CONTENT)) {
                    MIMEContent mimeContent = (MIMEContent)extElems.get(j);
                    if (mimeContentFound) {
                        this.multipleContentFound = true;
                        if (mimeContent.getPart() == null || !mimeContent.getPart().equals(mimeContentPart)) {
                            return true;
                        }
                    } else {
                        mimeContentFound = true;
                        mimeContentPart = mimeContent.getPart();
                    }
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private List getMimeParts(List extElems) {
        ArrayList mimeParts = new ArrayList();
        if (extElems != null) {
            int i = 0;
            while (i < extElems.size()) {
                ExtensibilityElement extElem = (ExtensibilityElement)extElems.get(i);
                if (extElem.getElementType().equals(WSDL_MIME_MULTIPART)) {
                    List mParts = ((MIMEMultipartRelated)extElem).getMIMEParts();
                    mimeParts.addAll(mParts);
                    int j = 0;
                    while (j < mParts.size()) {
                        List elems = this.getMimeParts(((MIMEPart)mParts.get(j)).getExtensibilityElements());
                        mimeParts.addAll(elems);
                        ++j;
                    }
                }
                ++i;
            }
        }
        return mimeParts;
    }
}

