/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.scoping;

import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.scoping.AbstractScope;
import org.eclipse.xtend.core.scoping.RecordingTypeScope;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.util.Strings;

public class TypeScopeWithWildcardImports
extends AbstractScope {
    private final ImportNormalizer[][] imports;
    private final RecordingTypeScope typeScope;
    private final AbstractScope parent;

    public TypeScopeWithWildcardImports(ImportNormalizer[][] imports, RecordingTypeScope typeScope) {
        this.imports = imports;
        this.typeScope = typeScope;
        this.parent = null;
    }

    public TypeScopeWithWildcardImports(List<ImportNormalizer> imports, RecordingTypeScope typeScope, AbstractScope parent) {
        this.imports = new ImportNormalizer[][]{imports.toArray(new ImportNormalizer[imports.size()])};
        this.typeScope = typeScope;
        this.parent = parent;
    }

    @Override
    public IEObjectDescription getSingleElement(QualifiedName name) {
        int i = 0;
        while (i < this.imports.length) {
            ImportNormalizer[] chunk = this.imports[i];
            IEObjectDescription result = null;
            int j = 0;
            while (j < chunk.length) {
                IEObjectDescription candidate;
                ImportNormalizer normalizer = chunk[j];
                QualifiedName resolvedName = normalizer.resolve(name);
                if (resolvedName != null && (candidate = this.typeScope.getSingleElement(resolvedName, true)) != null) {
                    if (result == null) {
                        result = candidate;
                    } else {
                        return null;
                    }
                }
                ++j;
            }
            if (result != null) {
                return result;
            }
            ++i;
        }
        return this.getSingleElementFromParent(name);
    }

    protected IEObjectDescription getSingleElementFromParent(QualifiedName name) {
        if (this.parent != null) {
            return this.parent.getSingleElement(name);
        }
        return this.typeScope.getSingleElement(name);
    }

    @Override
    protected void doGetElements(JvmType type, List<IEObjectDescription> result) {
        if (!(type instanceof JvmDeclaredType)) {
            return;
        }
        JvmDeclaredType declaredType = (JvmDeclaredType)type;
        String packageName = declaredType.getPackageName();
        if (!Strings.isEmpty((String)packageName)) {
            QualifiedName qualifiedPackageName = QualifiedName.create((List)Strings.split((String)packageName, (char)'.'));
            QualifiedName withDot = null;
            String withDollar = null;
            int i = 0;
            while (i < this.imports.length) {
                ImportNormalizer[] chunk = this.imports[i];
                int j = 0;
                while (j < chunk.length) {
                    ImportNormalizer normalizer = chunk[j];
                    QualifiedName namespacePrefix = normalizer.getImportedNamespacePrefix();
                    if (namespacePrefix.equals((Object)qualifiedPackageName)) {
                        if (withDot == null) {
                            withDot = QualifiedName.create((List)Strings.split((String)type.getQualifiedName('.'), (char)'.'));
                            withDollar = type.eContainer() instanceof JvmType ? type.getQualifiedName('$').substring(packageName.length() + 1) : null;
                        }
                        result.add(EObjectDescription.create((QualifiedName)withDot.skipFirst(qualifiedPackageName.getSegmentCount()), (EObject)type));
                        if (withDollar != null) {
                            result.add(EObjectDescription.create(withDollar, (EObject)type));
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (this.parent != null) {
            this.parent.doGetElements(type, result);
        } else {
            Iterables.addAll(result, this.typeScope.getElements((EObject)type));
        }
    }
}

