/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.dltk.internal.testing.model.ITestRunListener2;
import org.eclipse.dltk.internal.testing.model.ITestRunnerClient;
import org.eclipse.dltk.testing.DLTKTestingPlugin;
import org.eclipse.dltk.testing.ITestingClient;

public class RemoteTestRunnerClient
implements ITestingClient,
ITestRunnerClient {
    private final StringBuffer fFailedTrace = new StringBuffer();
    private final StringBuffer fExpectedResult = new StringBuffer();
    private final StringBuffer fActualResult = new StringBuffer();
    private final StringBuffer fFailedRerunTrace = new StringBuffer();
    ProcessingState fDefaultState = new DefaultProcessingState();
    ProcessingState fTraceState = new TraceProcessingState();
    ProcessingState fExpectedState = new AppendingProcessingState(this.fExpectedResult, "%EXPECTE");
    ProcessingState fActualState = new AppendingProcessingState(this.fActualResult, "%ACTUALE");
    ProcessingState fRerunState = new AppendingProcessingState(this.fFailedRerunTrace, "%RTRACEE");
    ProcessingState fCurrentState = this.fDefaultState;
    private ITestRunListener2[] fListeners;
    private String fVersion;
    private String fFailedTest;
    private String fFailedTestId;
    private int fFailedCode;
    private int fFailureKind;
    private List<Runnable> operations = new ArrayList<Runnable>();
    private Thread operationsThread;
    private boolean isTerminated = false;
    private Runnable runner = () -> {
        while (!this.isTerminated || this.operations.size() > 0) {
            Runnable operation = null;
            List<Runnable> list = this.operations;
            synchronized (list) {
                if (this.operations.size() > 0) {
                    operation = this.operations.get(0);
                    this.operations.remove(0);
                } else {
                    try {
                        this.operations.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (operation == null) continue;
            try {
                operation.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    };

    public RemoteTestRunnerClient() {
        this.operationsThread = new Thread(this.runner);
        this.operationsThread.start();
    }

    @Override
    public synchronized void startListening(ITestRunListener2 listener) {
        this.fListeners = new ITestRunListener2[]{listener};
    }

    @Override
    public synchronized void stopTest() {
    }

    private void receiveMessage(String message) {
        this.fCurrentState = this.fCurrentState.readMessage(message);
    }

    private void scanOldReranMessage(String arg) {
        int c = arg.indexOf(" ");
        int t = arg.indexOf(" ", c + 1);
        String className = arg.substring(0, c);
        String testName = arg.substring(c + 1, t);
        String status = arg.substring(t + 1);
        String testId = String.valueOf(className) + testName;
        this.notifyTestReran(testId, className, testName, status);
    }

    private void scanReranMessage(String arg) {
        int i = arg.indexOf(32);
        int c = arg.indexOf(32, i + 1);
        int t = arg.indexOf(32, c + 1);
        String testId = arg.substring(0, i);
        String className = arg.substring(i + 1, c);
        String testName = arg.substring(c + 1, t);
        String status = arg.substring(t + 1);
        this.notifyTestReran(testId, className, testName, status);
    }

    private void notifyTestReran(String testId, String className, String testName, String status) {
        int statusCode = 0;
        if (status.equals("FAILURE")) {
            statusCode = 2;
        } else if (status.equals("ERROR")) {
            statusCode = 1;
        }
        String trace = "";
        if (statusCode != 0) {
            trace = this.fFailedRerunTrace.toString();
        }
        this.notifyTestReran(testId, className, testName, statusCode, trace);
    }

    private void extractFailure(String arg, int status) {
        String[] s = this.extractTestId(arg);
        this.fFailedTestId = s[0];
        this.fFailedTest = s[1];
        this.fFailureKind = status;
    }

    private void extractFailure(String arg, int code, int status) {
        String[] s = this.extractTestId(arg);
        this.fFailedTestId = s[0];
        this.fFailedTest = s[1];
        this.fFailedCode = code;
        this.fFailureKind = status;
    }

    String[] extractTestId(String arg) {
        String[] result = new String[2];
        if (!this.hasTestId()) {
            result[0] = arg;
            result[1] = arg;
            return result;
        }
        int i = arg.indexOf(44);
        result[0] = arg.substring(0, i);
        result[1] = arg.substring(i + 1, arg.length());
        return result;
    }

    private boolean hasTestId() {
        if (this.fVersion == null) {
            return true;
        }
        return this.fVersion.equals("v2");
    }

    private void notifyTestReran(final String testId, final String className, final String testName, final int statusCode, final String trace) {
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(this){

                public void run() {
                    listener.testReran(testId, className, testName, statusCode, trace, fExpectedResult.toString(), fActualResult.toString());
                }
            });
            ++i;
        }
    }

    private void notifyTestTreeEntry(String treeEntry) {
        int i = 0;
        while (i < this.fListeners.length) {
            ITestRunListener2 listener = this.fListeners[i];
            if (!this.hasTestId()) {
                listener.testTreeEntry(this.fakeTestId(treeEntry));
            } else {
                listener.testTreeEntry(treeEntry);
            }
            ++i;
        }
    }

    private String fakeTestId(String treeEntry) {
        int index0 = treeEntry.indexOf(44);
        String testName = treeEntry.substring(0, index0).trim();
        return String.valueOf(testName) + "," + treeEntry;
    }

    private void notifyTestRunStopped(final long elapsedTime) {
        if (DLTKTestingPlugin.isStopped()) {
            return;
        }
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(this){

                public void run() {
                    listener.testRunStopped(elapsedTime);
                }
            });
            ++i;
        }
    }

    private void testRunEnded(final long elapsedTime) {
        if (DLTKTestingPlugin.isStopped()) {
            return;
        }
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(this){

                public void run() {
                    listener.testRunEnded(elapsedTime);
                }
            });
            ++i;
        }
        this.isTerminated = true;
    }

    private void notifyTestEnded(final String test) {
        if (DLTKTestingPlugin.isStopped()) {
            return;
        }
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(this){

                public void run() {
                    String[] s = this.extractTestId(test);
                    listener.testEnded(s[0], s[1]);
                }
            });
            ++i;
        }
    }

    private void notifyTestStarted(final String test) {
        if (DLTKTestingPlugin.isStopped()) {
            return;
        }
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(this){

                public void run() {
                    String[] s = this.extractTestId(test);
                    listener.testStarted(s[0], s[1]);
                }
            });
            ++i;
        }
    }

    private void notifyTestRunStarted(final int count) {
        if (DLTKTestingPlugin.isStopped()) {
            return;
        }
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(this){

                public void run() {
                    listener.testRunStarted(count);
                }
            });
            ++i;
        }
    }

    private void notifyTestFailed() {
        if (DLTKTestingPlugin.isStopped()) {
            return;
        }
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(this){

                public void run() {
                    listener.testFailed(fFailureKind, fFailedTestId, fFailedTest, fFailedTrace.toString(), fExpectedResult.toString(), fActualResult.toString(), fFailedCode);
                }
            });
            ++i;
        }
    }

    @Override
    public void rerunTest(String testId, String className, String testName) {
    }

    @Override
    public void stopWaiting() {
    }

    @Override
    public boolean isRunning() {
        return !this.isTerminated;
    }

    @Override
    public void testRunStart(int count) {
        if (!this.isTerminated) {
            this.addOperation(() -> {
                this.fCurrentState = this.fDefaultState;
                this.notifyTestRunStarted(count);
            });
        }
    }

    @Override
    public void testTree(int testId, String testName, boolean issuite, int testCound) {
        if (!this.isTerminated) {
            this.addOperation(() -> {
                this.fCurrentState = this.fDefaultState;
                this.notifyTestTreeEntry(String.valueOf(Integer.toString(testId)) + "," + testName + "," + Boolean.toString(issuite) + "," + Integer.toString(testCound));
            });
        }
    }

    @Override
    public void testTerminated(int elapse) {
        if (!this.isTerminated) {
            this.addOperation(() -> {
                this.fCurrentState = this.fDefaultState;
                this.testRunEnded(elapse);
            });
        }
    }

    @Override
    public void testStarted(int id, String name) {
        if (!this.isTerminated) {
            this.addOperation(() -> {
                this.fCurrentState = this.fDefaultState;
                this.notifyTestStarted(String.valueOf(Integer.toString(id)) + "," + name);
            });
        }
    }

    @Override
    public void testEnded(int id, String name) {
        if (!this.isTerminated) {
            this.addOperation(() -> {
                this.fCurrentState = this.fDefaultState;
                this.notifyTestEnded(String.valueOf(Integer.toString(id)) + "," + name);
            });
        }
    }

    @Override
    public void testFailed(int id, String name) {
        if (!this.isTerminated) {
            this.addOperation(() -> {
                this.fCurrentState = this.fDefaultState;
                this.extractFailure(String.valueOf(Integer.toString(id)) + "," + name, 2, -1);
            });
        }
    }

    @Override
    public void testFailed(int code, int id, String name) {
        if (!this.isTerminated) {
            this.addOperation(() -> {
                this.fCurrentState = this.fDefaultState;
                this.extractFailure(String.valueOf(Integer.toString(id)) + "," + name, code, 2);
            });
        }
    }

    @Override
    public void traceMessage(String message) {
        if (!this.isTerminated) {
            this.addOperation(() -> this.receiveMessage(message));
        }
    }

    @Override
    public void testError(int id, String name) {
        if (!this.isTerminated) {
            this.addOperation(() -> {
                this.fCurrentState = this.fDefaultState;
                this.extractFailure(String.valueOf(Integer.toString(id)) + "," + name, 1);
            });
        }
    }

    @Override
    public void testActual(String actual) {
        if (!this.isTerminated) {
            this.addOperation(() -> {
                this.receiveMessage("%ACTUALS");
                this.receiveMessage(actual);
                this.receiveMessage("%ACTUALE");
            });
        }
    }

    @Override
    public void testExpected(String expected) {
        if (!this.isTerminated) {
            this.addOperation(() -> {
                this.receiveMessage("%EXPECTS");
                this.receiveMessage(expected);
                this.receiveMessage("%EXPECTE");
            });
        }
    }

    @Override
    public void traceStart() {
        if (!this.isTerminated) {
            this.addOperation(() -> this.receiveMessage("%TRACES "));
        }
    }

    @Override
    public void traceEnd() {
        if (!this.isTerminated) {
            this.addOperation(() -> this.receiveMessage("%TRACEE "));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOperation(Runnable runnable) {
        List<Runnable> list = this.operations;
        synchronized (list) {
            this.operations.add(runnable);
            this.operations.notify();
        }
    }

    class AppendingProcessingState
    extends ProcessingState {
        private final StringBuffer fBuffer;
        private String fEndString;

        AppendingProcessingState(StringBuffer buffer, String endString) {
            this.fBuffer = buffer;
            this.fEndString = endString;
        }

        @Override
        ProcessingState readMessage(String message) {
            if (message.startsWith(this.fEndString)) {
                this.entireStringRead();
                return RemoteTestRunnerClient.this.fDefaultState;
            }
            this.fBuffer.append(message);
            this.fBuffer.append('\n');
            return this;
        }

        void entireStringRead() {
        }
    }

    class DefaultProcessingState
    extends ProcessingState {
        DefaultProcessingState() {
        }

        @Override
        ProcessingState readMessage(String message) {
            if (message.startsWith("%TRACES ")) {
                RemoteTestRunnerClient.this.fFailedTrace.setLength(0);
                return RemoteTestRunnerClient.this.fTraceState;
            }
            if (message.startsWith("%EXPECTS")) {
                RemoteTestRunnerClient.this.fExpectedResult.setLength(0);
                return RemoteTestRunnerClient.this.fExpectedState;
            }
            if (message.startsWith("%ACTUALS")) {
                RemoteTestRunnerClient.this.fActualResult.setLength(0);
                return RemoteTestRunnerClient.this.fActualState;
            }
            if (message.startsWith("%RTRACES")) {
                RemoteTestRunnerClient.this.fFailedRerunTrace.setLength(0);
                return RemoteTestRunnerClient.this.fRerunState;
            }
            String arg = message.substring(8);
            if (message.startsWith("%TESTC  ")) {
                int count = 0;
                int v = arg.indexOf(32);
                if (v == -1) {
                    RemoteTestRunnerClient.this.fVersion = "v1";
                    count = Integer.parseInt(arg);
                } else {
                    RemoteTestRunnerClient.this.fVersion = arg.substring(v + 1);
                    String sc = arg.substring(0, v);
                    count = Integer.parseInt(sc);
                }
                RemoteTestRunnerClient.this.notifyTestRunStarted(count);
                return this;
            }
            if (message.startsWith("%TESTS  ")) {
                RemoteTestRunnerClient.this.notifyTestStarted(arg);
                return this;
            }
            if (message.startsWith("%TESTE  ")) {
                RemoteTestRunnerClient.this.notifyTestEnded(arg);
                return this;
            }
            if (message.startsWith("%ERROR  ")) {
                RemoteTestRunnerClient.this.extractFailure(arg, 1);
                return this;
            }
            if (message.startsWith("%FAILED ")) {
                RemoteTestRunnerClient.this.extractFailure(arg, 2);
                return this;
            }
            if (message.startsWith("%RUNTIME")) {
                long elapsedTime = Long.parseLong(arg);
                RemoteTestRunnerClient.this.testRunEnded(elapsedTime);
                return this;
            }
            if (message.startsWith("%TSTSTP ")) {
                long elapsedTime = Long.parseLong(arg);
                RemoteTestRunnerClient.this.notifyTestRunStopped(elapsedTime);
                return this;
            }
            if (message.startsWith("%TSTTREE")) {
                RemoteTestRunnerClient.this.notifyTestTreeEntry(arg);
                return this;
            }
            if (message.startsWith("%TSTRERN")) {
                if (RemoteTestRunnerClient.this.hasTestId()) {
                    RemoteTestRunnerClient.this.scanReranMessage(arg);
                } else {
                    RemoteTestRunnerClient.this.scanOldReranMessage(arg);
                }
                return this;
            }
            return this;
        }
    }

    public abstract class ListenerSafeRunnable
    implements ISafeRunnable {
        public void handleException(Throwable exception) {
            DLTKTestingPlugin.log(exception);
        }
    }

    abstract class ProcessingState {
        ProcessingState() {
        }

        abstract ProcessingState readMessage(String var1);
    }

    class TraceProcessingState
    extends AppendingProcessingState {
        TraceProcessingState() {
            super(RemoteTestRunnerClient.this.fFailedTrace, "%TRACEE ");
        }

        @Override
        void entireStringRead() {
            RemoteTestRunnerClient.this.notifyTestFailed();
            RemoteTestRunnerClient.this.fExpectedResult.setLength(0);
            RemoteTestRunnerClient.this.fActualResult.setLength(0);
        }

        @Override
        ProcessingState readMessage(String message) {
            if (message.startsWith("%TRACEE ")) {
                RemoteTestRunnerClient.this.notifyTestFailed();
                RemoteTestRunnerClient.this.fFailedTrace.setLength(0);
                RemoteTestRunnerClient.this.fActualResult.setLength(0);
                RemoteTestRunnerClient.this.fExpectedResult.setLength(0);
                return RemoteTestRunnerClient.this.fDefaultState;
            }
            RemoteTestRunnerClient.this.fFailedTrace.append(message).append('\n');
            return this;
        }
    }
}

