/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.dap;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.dap.Activator;
import org.eclipse.cdt.debug.dap.DapDebugTarget;
import org.eclipse.cdt.debug.dap.InitializeLaunchConfigurations;
import org.eclipse.cdt.debug.dap.Messages;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate2;
import org.eclipse.cdt.launch.LaunchUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.IPersistableSourceLocator2;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.lsp4e.debug.launcher.DSPLaunchDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DapLaunchDelegate
extends AbstractCLaunchDelegate2 {
    private static final String DEBUG_ADAPTER_ROOT = "/debug-servers/node_modules/cdt-gdb-adapter/dist/";
    private static final String DEBUG_ADAPTER_JS = "debugAdapter.js";
    private static final String DEBUG_TARGET_ADAPTER_JS = "debugTargetAdapter.js";
    public static final String GDB = "gdb";
    public static final String PROGRAM = "program";
    public static final String ARGUMENTS = "arguments";
    public static final String VERBOSE = "verbose";
    public static final String LOG_FILE = "logFile";
    public static final String INIT_COMMANDS = "initCommands";
    private InitializeLaunchConfigurations initializeLaunchConfigurations = new InitializeLaunchConfigurations(this::warnNodeJSMissing);

    private void warnNodeJSMissing() {
        Display.getDefault().asyncExec(() -> MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Missing node.js", (String)"Could not find node.js. This prevents being able to debug with the CDT Debug Adapter.\nPlease make sure node.js is installed and that your PATH environement variable contains the location to the `node` executable."));
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(GDB, org.eclipse.cdt.dsf.gdb.launching.LaunchUtils.getGDBPath((ILaunchConfiguration)configuration).toOSString());
        params.put(PROGRAM, LaunchUtils.getProgramPath((ILaunchConfiguration)configuration));
        params.put(ARGUMENTS, LaunchUtils.getProgramArguments((ILaunchConfiguration)configuration));
        params.put("request", "launch");
        this.launch(configuration, mode, launch, monitor, false, params);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor, boolean targetDebugAdapter, Map<String, Object> params) throws CoreException {
        String debugAdapterJs = DEBUG_ADAPTER_ROOT + (targetDebugAdapter ? DEBUG_TARGET_ADAPTER_JS : DEBUG_ADAPTER_JS);
        try {
            URL fileURL = FileLocator.toFileURL((URL)((Object)((Object)Activator.getDefault())).getClass().getResource(debugAdapterJs));
            if (fileURL == null) {
                throw new IOException(String.valueOf(Messages.DapLaunchDelegate_missing_debugAdapter_script) + "org.eclipse.cdt.debug.dap" + debugAdapterJs);
            }
            String path = new File(fileURL.toURI()).toString();
            List<String> debugCmdArgs = Collections.singletonList(path);
            DSPLaunchDelegate.DSPLaunchDelegateLaunchBuilder builder = new DSPLaunchDelegate.DSPLaunchDelegateLaunchBuilder(configuration, mode, launch, monitor);
            builder.setLaunchDebugAdapter(this.initializeLaunchConfigurations.getNodeJsLocation().orElseThrow(() -> new IOException("Cannot find node runtime")), debugCmdArgs);
            builder.setMonitorDebugAdapter(true);
            builder.setDspParameters(params);
            DSPLaunchDelegate dspLaunchDelegate = new DSPLaunchDelegate(){

                protected IDebugTarget createDebugTarget(SubMonitor subMonitor, Runnable cleanup, InputStream inputStream, OutputStream outputStream, ILaunch launch, Map<String, Object> dspParameters) throws CoreException {
                    DapDebugTarget target = new DapDebugTarget(launch, cleanup, inputStream, outputStream, dspParameters);
                    target.initialize((IProgressMonitor)subMonitor.split(80));
                    return target;
                }
            };
            dspLaunchDelegate.launch(builder);
        }
        catch (IOException | URISyntaxException e) {
            Status errorStatus = new Status(4, "org.eclipse.cdt.debug.dap", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)errorStatus);
            Display.getDefault().asyncExec(() -> DapLaunchDelegate.lambda$3(e, (IStatus)errorStatus));
        }
    }

    protected String getPluginID() {
        return "org.eclipse.cdt.debug.dap";
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        IPersistableSourceLocator locator = this.createLocator(configuration);
        Launch launch = new Launch(configuration, mode, (ISourceLocator)locator);
        return launch;
    }

    private IPersistableSourceLocator createLocator(ILaunchConfiguration configuration) throws CoreException {
        String type = "org.eclipse.lsp4e.debug.sourceLocator";
        IPersistableSourceLocator locator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(type);
        String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
        if (memento == null) {
            locator.initializeDefaults(configuration);
        } else if (locator instanceof IPersistableSourceLocator2) {
            ((IPersistableSourceLocator2)locator).initializeFromMemento(memento, configuration);
        } else {
            locator.initializeFromMemento(memento);
        }
        return locator;
    }

    private static /* synthetic */ void lambda$3(Exception exception, IStatus iStatus) {
        ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debug error", (String)exception.getMessage(), (IStatus)iStatus);
    }
}

