/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.launch;

import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.cli.MavenCli;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.core.embedder.IMavenLauncherConfiguration;
import org.eclipse.m2e.core.internal.Bundles;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.launch.AbstractMavenRuntime;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenEmbeddedRuntime
extends AbstractMavenRuntime {
    private static final String MAVEN_CORE_POM_PROPERTIES = "META-INF/maven/org.apache.maven/maven-core/pom.properties";
    private static final Logger log = LoggerFactory.getLogger(MavenEmbeddedRuntime.class);
    private static final String MAVEN_EMBEDDER_BUNDLE_SYMBOLICNAME = "org.eclipse.m2e.maven.runtime";
    private static final String MAVEN_EXECUTOR_CLASS = MavenCli.class.getName();
    public static final String PLEXUS_CLASSWORLD_NAME = "plexus.core";
    private static String[] LAUNCHER_CLASSPATH;
    private static String[] CLASSPATH;
    private static volatile String mavenVersion;
    private static final Bundle m2eCore;

    static {
        m2eCore = MavenPluginActivator.getDefault().getBundle();
    }

    public MavenEmbeddedRuntime() {
        super("EMBEDDED");
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public String getLocation() {
        return "EMBEDDED";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public void createLauncherConfiguration(IMavenLauncherConfiguration collector, IProgressMonitor monitor) throws CoreException {
        String entry;
        collector.setMainType(MAVEN_EXECUTOR_CLASS, PLEXUS_CLASSWORLD_NAME);
        this.initClasspath(this.findMavenEmbedderBundle());
        collector.addRealm("]launcher");
        String[] stringArray = LAUNCHER_CLASSPATH;
        int n = LAUNCHER_CLASSPATH.length;
        int n2 = 0;
        while (n2 < n) {
            entry = stringArray[n2];
            collector.addArchiveEntry(entry);
            ++n2;
        }
        collector.addRealm(PLEXUS_CLASSWORLD_NAME);
        this.collectExtensions(collector, monitor);
        stringArray = CLASSPATH;
        n = CLASSPATH.length;
        n2 = 0;
        while (n2 < n) {
            entry = stringArray[n2];
            if (!entry.contains("plexus-build-api")) {
                collector.addArchiveEntry(entry);
            }
            ++n2;
        }
    }

    private synchronized void initClasspath(Bundle mavenRuntimeBundle) {
        if (CLASSPATH == null) {
            LinkedHashSet<String> allEntries = new LinkedHashSet<String>();
            this.addBundleClasspathEntries(allEntries, mavenRuntimeBundle, true);
            LinkedHashSet bundles = new LinkedHashSet();
            ArrayList requiredWires = new ArrayList();
            BundleWiring wiring = (BundleWiring)mavenRuntimeBundle.adapt(BundleWiring.class);
            requiredWires.addAll(wiring.getRequiredWires("osgi.wiring.bundle"));
            requiredWires.addAll(wiring.getRequiredWires("osgi.wiring.package"));
            requiredWires.stream().map(BundleWire::getProvider).map(BundleReference::getBundle).forEach(bundles::add);
            for (Bundle bundle : bundles) {
                this.addBundleClasspathEntries(allEntries, bundle, false);
            }
            ArrayList<String> cp = new ArrayList<String>();
            ArrayList<String> lcp = new ArrayList<String>();
            for (String entry : allEntries) {
                if (entry.contains("plexus-classworlds")) {
                    lcp.add(entry);
                    continue;
                }
                cp.add(entry);
            }
            CLASSPATH = cp.toArray(new String[cp.size()]);
            LAUNCHER_CLASSPATH = lcp.toArray(new String[lcp.size()]);
        }
    }

    private void addBundleClasspathEntries(Set<String> entries, Bundle bundle, boolean addFragments) {
        Bundle[] fragments;
        entries.addAll(Bundles.getClasspathEntries(bundle));
        if (addFragments && (fragments = Platform.getFragments((Bundle)bundle)) != null) {
            Bundle[] bundleArray = fragments;
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle fragment = bundleArray[n2];
                entries.addAll(Bundles.getClasspathEntries(fragment));
                ++n2;
            }
        }
    }

    private Bundle findMavenEmbedderBundle() {
        return Bundles.findDependencyBundle(m2eCore, MAVEN_EMBEDDER_BUNDLE_SYMBOLICNAME);
    }

    public String toString() {
        Bundle embedder = this.findMavenEmbedderBundle();
        if (embedder != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getVersion(embedder));
            String version = (String)embedder.getHeaders().get("Bundle-Version");
            sb.append('/').append(version);
            return sb.toString();
        }
        return MAVEN_EMBEDDER_BUNDLE_SYMBOLICNAME;
    }

    private synchronized String getVersion(Bundle bundle) {
        if (mavenVersion != null) {
            return mavenVersion;
        }
        this.initClasspath(bundle);
        try {
            String version;
            Properties pomProperties;
            block28: {
                String mavenCoreJarPath = null;
                String[] stringArray = CLASSPATH;
                int n = CLASSPATH.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    if (path.contains("maven-core")) {
                        mavenCoreJarPath = path;
                        break;
                    }
                    ++n2;
                }
                if (mavenCoreJarPath == null) {
                    throw new IllegalStateException("Could not find maven core jar file");
                }
                pomProperties = new Properties();
                Path mavenCoreJar = Path.of(mavenCoreJarPath, new String[0]);
                if (Files.isRegularFile(mavenCoreJar, new LinkOption[0])) {
                    Throwable throwable = null;
                    stringArray = null;
                    try (ZipFile zip = new ZipFile(mavenCoreJarPath);){
                        ZipEntry zipEntry = zip.getEntry(MAVEN_CORE_POM_PROPERTIES);
                        if (zipEntry != null) {
                            pomProperties.load(zip.getInputStream(zipEntry));
                        }
                        break block28;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                if (Files.isDirectory(mavenCoreJar, new LinkOption[0])) {
                    Throwable throwable = null;
                    stringArray = null;
                    try (BufferedReader r = Files.newBufferedReader(mavenCoreJar.resolve(MAVEN_CORE_POM_PROPERTIES));){
                        pomProperties.load(r);
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
            }
            if ((version = pomProperties.getProperty("version")) != null) {
                mavenVersion = version;
                return mavenVersion;
            }
        }
        catch (Exception e) {
            log.warn("Could not determine embedded maven version", (Throwable)e);
        }
        return Messages.MavenEmbeddedRuntime_unknown;
    }

    @Override
    public String getVersion() {
        Bundle bundle = this.findMavenEmbedderBundle();
        return this.getVersion(bundle);
    }
}

