/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.chart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.device.ICallBackNotifier;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.CallBackValue;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mat.impl.chart.ChartBuilder;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IResultPie;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.actions.OpenHelpPageAction;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.internal.chart.ChartCanvas;
import org.eclipse.mat.ui.internal.chart.Messages;
import org.eclipse.mat.ui.util.PopupMenu;
import org.eclipse.mat.ui.util.QueryContextMenu;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.widgets.FormText;

public class PieChartPane
extends AbstractEditorPane
implements ISelectionProvider {
    List<ISelectionChangedListener> selectionListeners = new ArrayList<ISelectionChangedListener>();
    private TraverseListener traverseListener;
    FormText label;
    ChartCanvas canvas;
    QueryResult queryResult;
    QueryContextMenu contextMenu;
    List<? extends IResultPie.Slice> slices;
    IResultPie.Slice current;
    private Menu menu;
    String sliceName = null;

    public void initWithArgument(Object argument) {
        if (argument != null) {
            int fb;
            int fg;
            this.contextMenu = new QueryContextMenu((AbstractEditorPane)this, new ContextProvider(null){

                public IContextObject getContext(Object row) {
                    return ((IResultPie.Slice)row).getContext();
                }
            });
            this.queryResult = (QueryResult)argument;
            IResultPie pie = (IResultPie)this.queryResult.getSubject();
            this.slices = pie.getSlices();
            Color bgColor = this.canvas.getParent().getBackground();
            Color fgColor = this.canvas.getParent().getForeground();
            int br = bgColor.getRed();
            int bg = bgColor.getGreen();
            int bb = bgColor.getBlue();
            int fr = fgColor.getRed();
            int deltaf = (br - fr) * (br - fr) + (bg - (fg = fgColor.getGreen())) * (bg - fg) + (bb - (fb = fgColor.getBlue())) * (bb - fb);
            if (deltaf < 27648) {
                RGB fore = fgColor.getRGB();
                float[] fgf = fore.getHSB();
                RGB back = bgColor.getRGB();
                float[] bgf = back.getHSB();
                fgf[2] = (double)bgf[2] < 0.25 ? 0.8f : ((double)bgf[2] < 0.5 ? 1.0f : ((double)bgf[2] < 0.75 ? 0.0f : 0.2f));
                RGB fore2 = new RGB(fgf[0], fgf[1], fgf[2]);
                fr = fore2.red;
                fg = fore2.green;
                fb = fore2.blue;
            }
            Chart chart = ChartBuilder.create((IResultPie)pie, (boolean)true, (ColorDefinition)ColorDefinitionImpl.create((int)br, (int)bg, (int)bb), (ColorDefinition)ColorDefinitionImpl.create((int)fr, (int)fg, (int)fb));
            this.canvas.setChart(chart);
            this.canvas.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = PieChartPane.this.sliceName;
                }
            });
            this.canvas.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    if (PieChartPane.this.canvas.isFocusControl()) {
                        e.gc.drawFocus(PieChartPane.this.canvas.getBounds().x, PieChartPane.this.canvas.getBounds().y, PieChartPane.this.canvas.getBounds().width, PieChartPane.this.canvas.getBounds().height);
                    }
                }
            });
            this.canvas.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    PieChartPane.this.canvas.redraw();
                }

                public void focusLost(FocusEvent e) {
                    Color tmpCol = PieChartPane.this.canvas.getParent().getBackground();
                    Plot p = PieChartPane.this.canvas.getChart().getPlot();
                    p.setBackground((Fill)ColorDefinitionImpl.create((int)tmpCol.getRed(), (int)tmpCol.getGreen(), (int)tmpCol.getBlue()));
                    PieChartPane.this.canvas.setChart(PieChartPane.this.canvas.getChart());
                    PieChartPane.this.canvas.redraw();
                }
            });
            this.canvas.redraw();
        }
    }

    public void createPartControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        this.traverseListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                }
            }
        };
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(0, 0).applyTo(top);
        this.canvas = new ChartCanvas(top, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 300).applyTo((Control)this.canvas);
        this.canvas.addTraverseListener(this.traverseListener);
        this.label = new FormText(top, 0);
        GridDataFactory.fillDefaults().grab(true, false).indent(5, 0).hint(-1, 45).applyTo((Control)this.label);
        this.canvas.renderer.setProperty("device.component", (Object)new CallBackListener());
    }

    public void contributeToToolBar(IToolBarManager manager) {
        if (this.queryResult.getQuery() != null && this.queryResult.getQuery().getHelpUrl() != null) {
            manager.appendToGroup("help", (IAction)new OpenHelpPageAction(this.queryResult.getQuery().getHelpUrl()));
        }
        super.contributeToToolBar(manager);
    }

    public String getTitle() {
        return Messages.PieChartPane_Chart;
    }

    public Image getTitleImage() {
        return this.queryResult != null ? MemoryAnalyserPlugin.getDefault().getImage(this.queryResult.getQuery()) : null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public ISelection getSelection() {
        IContextObject ctx;
        if (this.current != null && (ctx = this.current.getContext()) != null) {
            return new StructuredSelection((Object)ctx);
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
    }

    private void fireSelectionEvent() {
        ArrayList<ISelectionChangedListener> receivers = new ArrayList<ISelectionChangedListener>(this.selectionListeners);
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : receivers) {
            listener.selectionChanged(event);
        }
    }

    public void dispose() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        if (this.label != null && !this.label.isDisposed()) {
            this.label.dispose();
        }
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.dispose();
        }
        super.dispose();
    }

    class CallBackListener
    implements ICallBackNotifier {
        CallBackListener() {
        }

        public void callback(Object event, Object source, CallBackValue value) {
            IContextObject ctx;
            StructureSource structuredSource = (StructureSource)source;
            DataPointHints dph = (DataPointHints)structuredSource.getSource();
            IResultPie.Slice slice = PieChartPane.this.slices.get(dph.getIndex());
            KeyEvent keyEvent = null;
            try {
                if (event instanceof KeyEvent) {
                    keyEvent = (KeyEvent)event;
                    switch (keyEvent.keyCode) {
                        case 0x1000001: {
                            if (dph.getIndex() == 0) {
                                dph.setIndex(PieChartPane.this.slices.size() - 1);
                                break;
                            }
                            dph.setIndex(dph.getIndex() - 1);
                            break;
                        }
                        case 0x1000002: {
                            if (dph.getIndex() == PieChartPane.this.slices.size() - 1) {
                                dph.setIndex(0);
                                break;
                            }
                            dph.setIndex(dph.getIndex() + 1);
                            break;
                        }
                    }
                    slice = PieChartPane.this.slices.get(dph.getIndex());
                }
            }
            catch (IndexOutOfBoundsException e) {
                dph.setIndex(0);
            }
            if (PieChartPane.this.current != slice) {
                PieChartPane.this.label.setText("<form>" + slice.getDescription() + "</form>", true, false);
                PieChartPane.this.current = slice;
                PieChartPane.this.sliceName = slice.getDescription().toString();
                this.formatSliceName();
                PieChartPane.this.canvas.getAccessible().textSelectionChanged();
                PieChartPane.this.fireSelectionEvent();
            }
            if (slice != null && ("click".equals(value.getIdentifier()) || keyEvent != null && keyEvent.character == ' ') && (ctx = slice.getContext()) != null) {
                if (PieChartPane.this.menu != null && !PieChartPane.this.menu.isDisposed()) {
                    PieChartPane.this.menu.dispose();
                }
                PopupMenu popupMenu = new PopupMenu();
                PieChartPane.this.contextMenu.addContextActions(popupMenu, (IStructuredSelection)new StructuredSelection((Object)slice), null);
                PieChartPane.this.menu = popupMenu.createMenu(PieChartPane.this.getEditorSite().getActionBars().getStatusLineManager(), (Control)PieChartPane.this.canvas);
                PieChartPane.this.menu.setVisible(true);
            }
        }

        private void formatSliceName() {
            PieChartPane.this.sliceName = PieChartPane.this.sliceName.replaceAll("<b>", "");
            PieChartPane.this.sliceName = PieChartPane.this.sliceName.replaceAll("<strong>", "");
            PieChartPane.this.sliceName = PieChartPane.this.sliceName.replaceAll("<p>", "");
            PieChartPane.this.sliceName = PieChartPane.this.sliceName.replaceAll("<q>", "");
            PieChartPane.this.sliceName = PieChartPane.this.sliceName.replaceAll("</p>", "");
            PieChartPane.this.sliceName = PieChartPane.this.sliceName.replaceAll("</b>", "");
            PieChartPane.this.sliceName = PieChartPane.this.sliceName.replaceAll("</strong>", "");
            PieChartPane.this.sliceName = PieChartPane.this.sliceName.replaceAll("</q>", "");
            PieChartPane.this.sliceName = PieChartPane.this.sliceName.replaceAll("<br>", "");
            PieChartPane.this.sliceName = PieChartPane.this.sliceName.replaceAll("<br/>", "");
        }

        public Chart getDesignTimeModel() {
            return PieChartPane.this.canvas.getChart();
        }

        public Chart getRunTimeModel() {
            return PieChartPane.this.canvas.getRunTimeModel();
        }

        public Object peerInstance() {
            return PieChartPane.this.canvas;
        }

        public void regenerateChart() {
            PieChartPane.this.canvas.redraw();
        }

        public void repaintChart() {
            PieChartPane.this.canvas.redraw();
        }
    }
}

