/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.extensionpoints.library;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.extensionpoints.Activator;
import org.eclipse.papyrus.uml.extensionpoints.Registry;
import org.eclipse.papyrus.uml.extensionpoints.library.IRegisteredLibrary;
import org.eclipse.papyrus.uml.extensionpoints.standard.ExtensionLabelProvider;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.UMLFactory;

public class RegisteredLibrarySelectionDialog
extends ElementListSelectionDialog {
    private EList<PackageImport> importedLibraries;
    private List<String> importedLibrariesNames;
    private IRegisteredLibrary[] regLibraries;
    private Package currentModel;

    public RegisteredLibrarySelectionDialog(Composite parent, Package umlModel) {
        super(parent.getShell(), (ILabelProvider)new ExtensionLabelProvider());
        this.currentModel = umlModel;
        this.importedLibraries = umlModel.getPackageImports();
        this.importedLibrariesNames = this.getImportedLibraryNames(this.importedLibraries);
        this.regLibraries = Registry.getRegisteredLibraries().toArray(new IRegisteredLibrary[0]);
        this.regLibraries = this.removeAlreadyImportededFromSelection();
        this.setTitle("Apply Libraries from Papyrus repository :");
        this.setElements(this.regLibraries);
    }

    public void run() {
        this.open();
        this.treatSelection();
    }

    private List<String> getImportedLibraryNames(EList<? extends PackageImport> appliedLibraries) {
        ArrayList<String> Libraries = new ArrayList<String>();
        for (PackageImport currentImport : appliedLibraries) {
            String currentName = UMLLabelInternationalization.getInstance().getLabel((NamedElement)currentImport.getImportedPackage());
            Libraries.add(currentName);
        }
        return Libraries;
    }

    private IRegisteredLibrary[] removeAlreadyImportededFromSelection() {
        ArrayList<IRegisteredLibrary> Libraries = new ArrayList<IRegisteredLibrary>();
        int i = 0;
        while (i < this.regLibraries.length) {
            String currentName = this.regLibraries[i].getName();
            if (!this.importedLibrariesNames.contains(currentName)) {
                Libraries.add(this.regLibraries[i]);
            }
            ++i;
        }
        IRegisteredLibrary[] cleandList = Libraries.toArray(new IRegisteredLibrary[Libraries.size()]);
        return cleandList;
    }

    private void treatSelection() {
        Object[] selection = this.getResult();
        if (selection == null) {
            return;
        }
        int i = 0;
        while (i < selection.length) {
            IRegisteredLibrary currentLibrary = (IRegisteredLibrary)selection[i];
            URI modelUri = currentLibrary.getUri();
            this.addModelLibraryImportFromURI(this.currentModel, modelUri);
            ++i;
        }
    }

    protected boolean addModelLibraryImportFromURI(Package currentModel, URI modelUri) {
        Resource modelResource = EMFHelper.getResourceSet((EObject)currentModel).getResource(modelUri, true);
        if (modelResource.getContents().size() <= 0) {
            Activator.log("The selected uri (" + modelUri.toString() + ") does not contain any model library !");
            return false;
        }
        Element root = (Element)modelResource.getContents().get(0);
        if (root instanceof Package) {
            Package libToImport = (Package)modelResource.getContents().get(0);
            PackageImport modelLibImport = UMLFactory.eINSTANCE.createPackageImport();
            modelLibImport.setImportedPackage(libToImport);
            return currentModel.getPackageImports().add((Object)modelLibImport);
        }
        Activator.log("The selected uri (" + modelUri.toString() + ") does not contain any model library !");
        return false;
    }
}

