/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.ptp.internal.rm.lml.core.JAXBUtil;
import org.eclipse.ptp.internal.rm.lml.core.messages.Messages;
import org.eclipse.ptp.internal.rm.lml.core.model.FastImpCheck;
import org.eclipse.ptp.internal.rm.lml.core.model.LMLCheck;
import org.eclipse.ptp.rm.lml.core.elements.DataElement;
import org.eclipse.ptp.rm.lml.core.elements.DataType;
import org.eclipse.ptp.rm.lml.core.elements.JobType;
import org.eclipse.ptp.rm.lml.core.elements.Nodedisplay;
import org.eclipse.ptp.rm.lml.core.elements.SchemeElement;
import org.eclipse.ptp.rm.lml.core.elements.SchemeType;
import org.eclipse.ptp.rm.lml.core.elements.UsageType;

public class LMLNodeData {
    private static final String emptyJobName = "empty";
    private Object data;
    private String impName;
    private ArrayList<Integer> levelList;
    private Object scheme;

    private static HashMap<String, Integer> convertUsageIntoJobMap(UsageType usage) {
        HashMap<String, Integer> usageJobMap = new HashMap<String, Integer>();
        int cpuSum = 0;
        for (JobType job : usage.getJob()) {
            usageJobMap.put(job.getOid(), job.getCpucount().intValue());
            cpuSum += job.getCpucount().intValue();
        }
        int emptyCount = usage.getCpucount().intValue() - cpuSum;
        if (emptyCount > 0) {
            if (usageJobMap.containsKey(emptyJobName)) {
                emptyCount += usageJobMap.get(emptyJobName).intValue();
            }
            usageJobMap.put(emptyJobName, emptyCount);
        }
        return usageJobMap;
    }

    private static void getLowerIdsAndSchemesForIds(Object scheme, ArrayList<Integer> numbersList, HashMap<Integer, SchemeElement> schemesMap) {
        List<? extends SchemeElement> schemeList = LMLCheck.getLowerSchemeElements(scheme);
        int i = 0;
        while (i < schemeList.size()) {
            SchemeElement lowerScheme = schemeList.get(i);
            if (lowerScheme.getList() != null) {
                int[] numbersArray;
                int[] nArray = numbersArray = LMLCheck.getNumbersFromNumberlist(lowerScheme.getList());
                int n = numbersArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int number = nArray[n2];
                    numbersList.add(number);
                    schemesMap.put(number, lowerScheme);
                    ++n2;
                }
            } else if (lowerScheme.getMin() != null) {
                int min;
                int max = min = lowerScheme.getMin().intValue();
                if (lowerScheme.getMax() != null) {
                    max = lowerScheme.getMax().intValue();
                }
                int step = lowerScheme.getStep().intValue();
                int j = min;
                while (j <= max) {
                    numbersList.add(j);
                    schemesMap.put(j, lowerScheme);
                    j += step;
                }
            }
            ++i;
        }
    }

    private static void mergeJobMaps(String rootJobName, HashMap<String, Integer> jobMap, HashMap<String, Integer> toMerge) {
        if (rootJobName == null) {
            rootJobName = emptyJobName;
        }
        for (String jobName : toMerge.keySet()) {
            int cpuCount = toMerge.get(jobName);
            jobMap.put(rootJobName, jobMap.get(rootJobName) - cpuCount);
            if (jobMap.containsKey(jobName)) {
                cpuCount += jobMap.get(jobName).intValue();
            }
            jobMap.put(jobName, cpuCount);
        }
    }

    public LMLNodeData(String impName, Nodedisplay nodedisplay) {
        ArrayList<Integer> idsList = new ArrayList<Integer>();
        if (impName.equals("")) {
            this.init(nodedisplay.getData(), nodedisplay.getScheme(), idsList, impName);
            return;
        }
        idsList = FastImpCheck.impNameToOneLevel(impName, nodedisplay.getScheme(), idsList);
        if (idsList == null) {
            throw new IllegalArgumentException(String.valueOf(Messages.LMLNodeData_0) + impName + Messages.LMLNodeData_1);
        }
        LMLCheck.SchemeAndData schemeData = LMLCheck.getSchemeAndDataByLevels(LMLCheck.copyArrayList(idsList), (Object)nodedisplay.getData(), (Object)nodedisplay.getScheme());
        SchemeElement scheme = LMLCheck.getSchemeByLevels(LMLCheck.copyArrayList(idsList), nodedisplay.getScheme());
        if (schemeData == null || scheme == null) {
            throw new IllegalArgumentException(Messages.LMLNodeData_2);
        }
        this.init(schemeData.data, scheme, idsList, impName);
    }

    public LMLNodeData(Object data, Object scheme, ArrayList<Integer> level, String impName) {
        this.init(data, scheme, level, impName);
    }

    public UsageType generateUsage() {
        HashMap<String, Integer> jobMap = this.getJobMap();
        int totalCPUCount = this.getLowestElementsCount();
        return JAXBUtil.createUsageType(totalCPUCount, jobMap);
    }

    public Object getData() {
        return this.data;
    }

    public DataElement getDataElement() {
        if (this.data instanceof DataElement) {
            return (DataElement)this.data;
        }
        return null;
    }

    public String getFullImpName() {
        return this.impName;
    }

    public String getImpName() {
        SchemeElement scheme = this.getSchemeElement();
        if (scheme == null) {
            return "";
        }
        return LMLCheck.getLevelName(scheme, this.levelList.get(this.levelList.size() - 1));
    }

    public ArrayList<Integer> getLevelIds() {
        return this.levelList;
    }

    public ArrayList<LMLNodeData> getLowerNodes() {
        ArrayList<LMLNodeData> result = new ArrayList<LMLNodeData>();
        Object scheme = this.getScheme();
        HashMap<Integer, SchemeElement> schemesMap = new HashMap<Integer, SchemeElement>();
        ArrayList<Integer> numbersList = new ArrayList<Integer>();
        LMLNodeData.getLowerIdsAndSchemesForIds(scheme, numbersList, schemesMap);
        ArrayList<Integer> levelsList = this.getLevelIds();
        Object data = this.getData();
        int j = 0;
        while (j < numbersList.size()) {
            int id = numbersList.get(j);
            LMLCheck.SchemeAndData schemeData = LMLCheck.getSchemeAndDataByLevels(id, data, scheme);
            Object lowData = schemeData.data;
            if (LMLCheck.getDataLevel(data) < LMLCheck.getSchemeLevel(scheme) && data instanceof DataElement) {
                lowData = data;
            }
            levelsList.add(id);
            String newImpName = String.valueOf(this.impName) + LMLCheck.getLevelName(schemesMap.get(id), id);
            LMLNodeData newNode = new LMLNodeData(lowData, schemesMap.get(id), levelsList, newImpName);
            levelsList.remove(levelsList.size() - 1);
            if (newNode != null) {
                result.add(newNode);
            }
            ++j;
        }
        return result;
    }

    public int getLowestElementsCount() {
        List<? extends SchemeElement> schemeElements = LMLCheck.getLowerSchemeElements(this.scheme);
        int lowerCPUCount = 0;
        if (schemeElements.size() > 0) {
            for (SchemeElement schemeElement : schemeElements) {
                lowerCPUCount += this.getLowestElementsCount(schemeElement);
            }
        } else {
            lowerCPUCount = 1;
        }
        return lowerCPUCount;
    }

    public Object getScheme() {
        return this.scheme;
    }

    public SchemeElement getSchemeElement() {
        if (this.scheme instanceof SchemeElement) {
            return (SchemeElement)this.scheme;
        }
        return null;
    }

    public boolean isDataElementOnNodeLevel() {
        DataElement data = this.getDataElement();
        if (data == null) {
            return true;
        }
        return this.levelList.size() == LMLCheck.getDataLevel(data);
    }

    public boolean isRootNode() {
        return this.getSchemeElement() == null;
    }

    private HashMap<String, Integer> getJobMap() {
        HashMap<String, Integer> jobMap = new HashMap<String, Integer>();
        String rootJob = emptyJobName;
        if (this.getDataElement() != null && this.getDataElement().getOid() != null) {
            rootJob = this.getDataElement().getOid();
        }
        jobMap.put(rootJob, this.getLowestElementsCount());
        if (this.isRootNode() || LMLCheck.getLowerDataElements(this.getDataElement()).size() > 0) {
            HashMap<String, Integer> directChildMap = new HashMap<String, Integer>();
            ArrayList<LMLNodeData> lowerNodes = this.getLowerNodes();
            for (LMLNodeData node : lowerNodes) {
                String jobName = node.getDataElement().getOid();
                if (jobName == null) {
                    jobName = emptyJobName;
                }
                int cpuCount = node.getLowestElementsCount();
                if (directChildMap.containsKey(jobName)) {
                    cpuCount += directChildMap.get(jobName).intValue();
                }
                directChildMap.put(jobName, cpuCount);
            }
            LMLNodeData.mergeJobMaps(rootJob, jobMap, directChildMap);
            for (LMLNodeData node : lowerNodes) {
                LMLNodeData.mergeJobMaps(node.getDataElement().getOid(), jobMap, node.getJobMap());
            }
        }
        if (this.getDataElement() != null && this.isDataElementOnNodeLevel() && LMLCheck.getLowerDataElements(this.getDataElement()).size() == 0 && this.getDataElement().getUsage() != null) {
            return LMLNodeData.convertUsageIntoJobMap(this.getDataElement().getUsage());
        }
        if (jobMap.containsKey(emptyJobName) && jobMap.get(emptyJobName) == 0) {
            jobMap.remove(emptyJobName);
        }
        return jobMap;
    }

    private int getLowestElementsCount(SchemeElement scheme) {
        int currentCount = 0;
        currentCount = scheme.getMin() != null ? (scheme.getMax() == null ? 1 : scheme.getMax().intValue() - scheme.getMin().intValue() + 1) : scheme.getList().split(",").length;
        List<? extends SchemeElement> schemeElements = LMLCheck.getLowerSchemeElements(scheme);
        int lowerCPUCount = 0;
        if (schemeElements.size() == 0) {
            lowerCPUCount = 1;
        } else {
            lowerCPUCount = 0;
            for (SchemeElement schemeElement : schemeElements) {
                lowerCPUCount += this.getLowestElementsCount(schemeElement);
            }
        }
        return currentCount * lowerCPUCount;
    }

    private void init(Object data, Object scheme, ArrayList<Integer> levelList, String impName) {
        if (!(data instanceof DataElement) && !(data instanceof DataType)) {
            throw new IllegalArgumentException(Messages.LMLNodeData_3);
        }
        if (!(scheme instanceof SchemeElement) && !(scheme instanceof SchemeType)) {
            throw new IllegalArgumentException(Messages.LMLNodeData_4);
        }
        this.data = data;
        this.scheme = scheme;
        this.levelList = new ArrayList<Integer>(levelList);
        this.impName = impName;
    }
}

