/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.util;

import java.util.HashMap;
import java.util.Vector;

public class StringMatcher {
    protected String fPattern;
    protected int fLength;
    protected boolean fIgnoreWildCards;
    protected boolean fIgnoreCase;
    protected boolean fHasLeadingStar;
    protected boolean fHasTrailingStar;
    protected String[] fSegments;
    protected HashMap[] fCharacterClassMaps;
    protected int fBound = 0;
    protected static final char fSingleWildCard = '\u0000';

    public Position find(String text, int start, int end) {
        if (this.fPattern == null || text == null) {
            throw new IllegalArgumentException();
        }
        int tlen = text.length();
        if (start < 0) {
            start = 0;
        }
        if (end > tlen) {
            end = tlen;
        }
        if (end < 0 || start >= end) {
            return null;
        }
        if (this.fLength == 0) {
            return new Position(start, start);
        }
        if (this.fIgnoreWildCards) {
            int x = this.posIn(text, start, end);
            if (x < 0) {
                return null;
            }
            return new Position(x, x + this.fLength);
        }
        int segCount = this.fSegments.length;
        if (segCount == 0) {
            return new Position(start, end);
        }
        int curPos = start;
        int matchStart = -1;
        int i = 0;
        while (i < segCount && curPos < end) {
            String current = this.fSegments[i];
            int nextMatch = this.regExpPosIn(text, curPos, end, current, this.fCharacterClassMaps[i]);
            if (nextMatch < 0) {
                return null;
            }
            if (i == 0) {
                matchStart = nextMatch;
            }
            curPos = nextMatch + current.length();
            ++i;
        }
        if (i < segCount) {
            return null;
        }
        return new Position(matchStart, curPos);
    }

    public StringMatcher(String aPattern, boolean ignoreCase, boolean ignoreWildCards) {
        this.fIgnoreCase = ignoreCase;
        this.fIgnoreWildCards = ignoreWildCards;
        this.fLength = aPattern.length();
        this.fPattern = this.fIgnoreCase ? aPattern.toUpperCase() : aPattern;
        if (this.fIgnoreWildCards) {
            this.parseNoWildCards();
        } else {
            this.parseWildCards();
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean match(String text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        if (start > end) {
            return false;
        }
        if (this.fIgnoreWildCards) {
            return end - start == this.fLength && this.fPattern.regionMatches(this.fIgnoreCase, 0, text, start, this.fLength) != false;
        }
        segCount = this.fSegments.length;
        if (segCount == 0 && (this.fHasLeadingStar || this.fHasTrailingStar)) {
            return true;
        }
        if (start == end) {
            return this.fLength == 0;
        }
        if (this.fLength == 0) {
            return start == end;
        }
        tlen = text.length();
        if (start < 0) {
            start = 0;
        }
        if (end > tlen) {
            end = tlen;
        }
        tCurPos = start;
        bound = end - this.fBound;
        if (bound < 0) {
            return false;
        }
        i = 0;
        current = this.fSegments[i];
        curCharClassMap = this.fCharacterClassMaps[i];
        segLength = current.length();
        if (!this.fHasLeadingStar) {
            if (!this.regExpRegionMatches(text, start, current, 0, segLength, curCharClassMap)) {
                return false;
            }
            ++i;
            tCurPos += segLength;
        }
        if (this.fSegments.length != 1 || this.fHasLeadingStar || this.fHasTrailingStar) ** GOTO lbl41
        return tCurPos == end;
lbl-1000:
        // 1 sources

        {
            current = this.fSegments[i];
            curCharClassMap = this.fCharacterClassMaps[i];
            k = current.indexOf(0);
            if (k < 0 ? (currentMatch = this.textPosIn(text, tCurPos, end, current)) < 0 : (currentMatch = this.regExpPosIn(text, tCurPos, end, current, curCharClassMap)) < 0) {
                return false;
            }
            tCurPos = currentMatch + current.length();
            ++i;
lbl41:
            // 2 sources

            ** while (i < segCount)
        }
lbl42:
        // 1 sources

        if (!this.fHasTrailingStar && tCurPos != end) {
            clen = current.length();
            return this.regExpRegionMatches(text, end - clen, current, 0, clen, curCharClassMap);
        }
        return i == segCount;
    }

    public boolean match(String text) {
        return this.match(text, 0, text.length());
    }

    private void parseNoWildCards() {
        this.fSegments = new String[1];
        this.fSegments[0] = this.fPattern;
        this.fBound = this.fLength;
    }

    private void parseWildCards() {
        if (this.fPattern.startsWith("*")) {
            this.fHasLeadingStar = true;
        }
        Vector<String> temp = new Vector<String>();
        HashMap<Integer, CharacterClass> segmentCCs = null;
        Vector allCCs = new Vector();
        int pos = 0;
        StringBuilder buf = new StringBuilder();
        block6: while (pos < this.fLength) {
            char c = this.fPattern.charAt(pos++);
            this.fHasTrailingStar = false;
            switch (c) {
                case '\\': {
                    if (pos >= this.fLength) {
                        buf.append(c);
                        break;
                    }
                    c = this.fPattern.charAt(pos++);
                    buf.append(c);
                    break;
                }
                case '*': {
                    this.fHasTrailingStar = true;
                    if (buf.length() <= 0) continue block6;
                    temp.addElement(buf.toString());
                    allCCs.addElement(segmentCCs);
                    this.fBound += buf.length();
                    buf.setLength(0);
                    segmentCCs = null;
                    break;
                }
                case '[': {
                    if (segmentCCs == null) {
                        segmentCCs = new HashMap<Integer, CharacterClass>();
                    }
                    if (pos >= this.fLength) {
                        buf.append(c);
                        break;
                    }
                    boolean negated = this.fPattern.charAt(pos) == '!';
                    int beginPos = negated ? pos + 1 : pos;
                    int endPos = this.fPattern.indexOf(93, beginPos + 1);
                    if (endPos == -1) {
                        buf.append(c);
                        break;
                    }
                    CharacterClass cc = new CharacterClass(negated, this.fPattern.substring(beginPos, endPos));
                    segmentCCs.put(buf.length(), cc);
                    pos = endPos + 1;
                }
                case '?': {
                    buf.append('\u0000');
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        if (buf.length() > 0) {
            temp.addElement(buf.toString());
            allCCs.addElement(segmentCCs);
            this.fBound += buf.length();
        }
        this.fSegments = new String[temp.size()];
        temp.copyInto(this.fSegments);
        this.fCharacterClassMaps = new HashMap[allCCs.size()];
        allCCs.copyInto(this.fCharacterClassMaps);
    }

    protected int posIn(String text, int start, int end) {
        return this.textPosIn(text, start, end, this.fPattern);
    }

    protected int regExpPosIn(String text, int start, int end, String p, HashMap ccMap) {
        int plen = p.length();
        int max = end - plen;
        int i = start;
        while (i <= max) {
            if (this.regExpRegionMatches(text, i, p, 0, plen, ccMap)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected boolean regExpRegionMatches(String text, int tStart, String p, int pStart, int plen, HashMap ccMap) {
        int ppos = 0;
        while (plen-- > 0) {
            char tc;
            char tchar = text.charAt(tStart++);
            char pchar = p.charAt(pStart++);
            if (!this.fIgnoreWildCards && pchar == '\u0000') {
                CharacterClass cc;
                if (ccMap != null && (cc = (CharacterClass)ccMap.get(ppos)) != null && !cc.match(tchar)) {
                    return false;
                }
            } else if (!(pchar == tchar || this.fIgnoreCase && (tc = Character.toUpperCase(tchar)) == pchar)) {
                return false;
            }
            ++ppos;
        }
        return true;
    }

    protected int textPosIn(String text, int start, int end, String p) {
        int plen = p.length();
        int max = end - plen;
        if (!this.fIgnoreCase) {
            int i = text.indexOf(p, start);
            if (i == -1 || i > max) {
                return -1;
            }
            return i;
        }
        int i = start;
        while (i <= max) {
            if (text.regionMatches(true, i, p, 0, plen)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected static class CharacterClass {
        final boolean isNegated;
        final String text;

        CharacterClass(boolean isNegated, String text) {
            this.isNegated = isNegated;
            this.text = text;
        }

        boolean listed(char c) {
            int i = 0;
            while (i < this.text.length()) {
                if (i + 2 < this.text.length() && this.text.charAt(i + 1) == '-') {
                    if (c >= this.text.charAt(i) && c <= this.text.charAt(i + 2)) {
                        return true;
                    }
                    i += 3;
                    continue;
                }
                if (c == this.text.charAt(i)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        boolean match(char c) {
            return this.listed(c) ^ this.isNegated;
        }
    }

    public static class Position {
        int start;
        int end;

        public Position(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

