/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.controls;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class SelfOrientingSashForm
extends SashForm {
    boolean inSetOrientation = false;

    public SelfOrientingSashForm(Composite parent, int style) {
        super(parent, style);
    }

    public int getOrientation() {
        int preferredOrientation;
        int currentOrientation = super.getOrientation();
        if (this.inSetOrientation) {
            return currentOrientation;
        }
        int n = preferredOrientation = this.isDisposed() ? currentOrientation : this.getPreferredOrientation();
        if (currentOrientation != preferredOrientation) {
            this.setOrientation(preferredOrientation);
        }
        return preferredOrientation;
    }

    public void setOrientation(int orientation) {
        if (this.inSetOrientation) {
            return;
        }
        this.inSetOrientation = true;
        super.setOrientation(orientation);
        this.inSetOrientation = false;
    }

    public void layout(boolean changed) {
        Rectangle area = this.getClientArea();
        if (area.width > 0 && area.height > 0) {
            int oldOrientation = super.getOrientation();
            int newOrientation = 256;
            if (area.width < area.height) {
                newOrientation = 512;
            }
            if (newOrientation != oldOrientation) {
                this.setOrientation(newOrientation);
                changed = true;
            }
        }
        super.layout(changed);
    }

    private int getPreferredOrientation() {
        Rectangle area = this.getClientArea();
        if (area.width > 0 && area.height > 0 && area.width < area.height) {
            return 512;
        }
        return 256;
    }
}

