/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.core.model.IConnectHandler;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateInDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.actions.IConnect;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.actions.ProcessInfo;
import org.eclipse.cdt.dsf.gdb.internal.ui.commands.Messages;
import org.eclipse.cdt.dsf.gdb.internal.ui.commands.RefreshableDebugCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.LaunchUIMessages;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.ProcessPrompter;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.IProcessExtendedInfo;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.mi.service.IMIProcessDMContext;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class GdbConnectCommand
extends RefreshableDebugCommand
implements IConnectHandler,
IConnect {
    private final ILaunch fLaunch;
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;
    private Map<String, String> fProcessNameToBinaryMap = new HashMap<String, String>();

    public GdbConnectCommand(DsfSession session, ILaunch launch) {
        this.fLaunch = launch;
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    protected boolean isExecutable(Object[] targets, IProgressMonitor monitor, IEnabledStateRequest request) throws CoreException {
        return this.canConnect();
    }

    public boolean canConnect() {
        Query<Boolean> canConnectQuery = new Query<Boolean>(){

            public void execute(DataRequestMonitor<Boolean> rm) {
                IProcesses procService = (IProcesses)GdbConnectCommand.this.fTracker.getService(IProcesses.class);
                ICommandControlService commandControl = (ICommandControlService)GdbConnectCommand.this.fTracker.getService(ICommandControlService.class);
                if (procService != null && commandControl != null) {
                    procService.isDebuggerAttachSupported((IDMContext)commandControl.getContext(), rm);
                } else {
                    rm.setData((Object)false);
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)canConnectQuery);
            return (Boolean)canConnectQuery.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        return false;
    }

    protected void doExecute(Object[] targets, IProgressMonitor monitor, final IRequest request) throws CoreException {
        Query<Boolean> connectQuery = new Query<Boolean>(){

            public void execute(DataRequestMonitor<Boolean> rm) {
                GdbConnectCommand.this.connect(new RequestMonitor((Executor)GdbConnectCommand.this.fExecutor, (RequestMonitor)rm, (DataRequestMonitor)rm){
                    private final /* synthetic */ DataRequestMonitor val$rm;
                    {
                        this.val$rm = dataRequestMonitor;
                        super($anonymous0, $anonymous1);
                    }

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            request.setStatus(this.getStatus());
                        }
                        this.val$rm.done();
                    }
                });
            }
        };
        try {
            try {
                this.fExecutor.execute((Runnable)connectQuery);
                connectQuery.get();
            }
            catch (InterruptedException interruptedException) {
                this.updateEnablement();
            }
            catch (ExecutionException executionException) {
                this.updateEnablement();
            }
            catch (CancellationException cancellationException) {
                this.updateEnablement();
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                this.updateEnablement();
            }
        }
        finally {
            this.updateEnablement();
        }
    }

    private void getAllDebuggedProcesses(IDMContext currentCtx, boolean allSessions, DataRequestMonitor<List<String>> drm) {
        SessionType sessionType = ((IGDBBackend)this.fTracker.getService(IGDBBackend.class)).getSessionType();
        LinkedList result = new LinkedList();
        LinkedList<DsfSession> sessions = new LinkedList<DsfSession>();
        if (allSessions && sessionType == SessionType.LOCAL) {
            sessions.addAll(Arrays.asList(DsfSession.getActiveSessions()));
        } else {
            sessions.add(DsfSession.getSession((String)currentCtx.getSessionId()));
        }
        final class ProcessRequestMonitor
        extends DataRequestMonitor<IDMContext[]> {
            private final /* synthetic */ List val$result;
            private final /* synthetic */ List val$sessions;
            private final /* synthetic */ IDMContext val$currentCtx;
            private final /* synthetic */ DataRequestMonitor val$drm;

            public ProcessRequestMonitor(Executor executor, List list, List list2, IDMContext iDMContext, DataRequestMonitor dataRequestMonitor) {
                this.val$result = list;
                this.val$sessions = list2;
                this.val$currentCtx = iDMContext;
                this.val$drm = dataRequestMonitor;
                super(executor, null);
            }

            public ProcessRequestMonitor(DsfExecutor executor, List list, List list2, IDMContext iDMContext, DataRequestMonitor dataRequestMonitor) {
                this.val$result = list;
                this.val$sessions = list2;
                this.val$currentCtx = iDMContext;
                this.val$drm = dataRequestMonitor;
                super((Executor)new ImmediateInDsfExecutor(executor), null);
            }

            protected void handleCompleted() {
                if (this.isSuccess() && this.getData() != null) {
                    IDMContext[] iDMContextArray = (IDMContext[])this.getData();
                    int n = iDMContextArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDMContext dmc = iDMContextArray[n2];
                        IMIProcessDMContext procDmc = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIProcessDMContext.class);
                        if (procDmc != null) {
                            this.val$result.add(procDmc.getProcId());
                        }
                        ++n2;
                    }
                }
                if (!this.val$sessions.isEmpty()) {
                    final DsfSession nextSession = (DsfSession)this.val$sessions.remove(0);
                    final boolean sameSession = this.val$currentCtx.getSessionId().equals(nextSession.getId());
                    nextSession.getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            DsfServicesTracker nextTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), nextSession.getId());
                            IGDBBackend nextSessionBackend = (IGDBBackend)nextTracker.getService(IGDBBackend.class);
                            if (sameSession || nextSessionBackend.getSessionType() == SessionType.LOCAL) {
                                ICommandControlService nextCommandControl = (ICommandControlService)nextTracker.getService(ICommandControlService.class);
                                IProcesses nextProcService = (IProcesses)nextTracker.getService(IProcesses.class);
                                nextProcService.getProcessesBeingDebugged((IDMContext)nextCommandControl.getContext(), (DataRequestMonitor)new ProcessRequestMonitor(nextSession.getExecutor(), val$result, val$sessions, val$currentCtx, val$drm));
                            } else {
                                new ProcessRequestMonitor(nextSession.getExecutor(), val$result, val$sessions, val$currentCtx, val$drm).done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10003, "Only local session", null));
                            }
                            nextTracker.dispose();
                        }
                    });
                } else {
                    this.val$drm.done((Object)this.val$result);
                }
            }
        }
        new ProcessRequestMonitor(ImmediateExecutor.getInstance(), result, sessions, currentCtx, drm).done();
    }

    public void connect(final RequestMonitor rm) {
        this.fExecutor.execute((Runnable)new DsfRunnable(){

            public void run() {
                IProcesses procService = (IProcesses)GdbConnectCommand.this.fTracker.getService(IProcesses.class);
                ICommandControlService commandControl = (ICommandControlService)GdbConnectCommand.this.fTracker.getService(ICommandControlService.class);
                IGDBBackend backend = (IGDBBackend)GdbConnectCommand.this.fTracker.getService(IGDBBackend.class);
                if (procService != null && commandControl != null && backend != null) {
                    final ICommandControlService.ICommandControlDMContext controlCtx = commandControl.getContext();
                    procService.getRunningProcesses((IDMContext)controlCtx, (DataRequestMonitor)new DataRequestMonitor<IProcesses.IProcessDMContext[]>((Executor)GdbConnectCommand.this.fExecutor, rm){

                        protected void handleSuccess() {
                            final ArrayList<ProcessInfo> procInfoList = new ArrayList<ProcessInfo>();
                            final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)(this).GdbConnectCommand.this.fExecutor, rm){

                                protected void handleSuccess() {
                                    GdbConnectCommand.this.getAllDebuggedProcesses((IDMContext)controlCtx, true, (DataRequestMonitor<List<String>>)new ImmediateDataRequestMonitor<List<String>>(rm){

                                        protected void handleSuccess() {
                                            GdbConnectCommand.this.connectToProcesses(controlCtx, procInfoList, (List)this.getData(), rm);
                                        }
                                    });
                                }
                            };
                            if (((IProcesses.IProcessDMContext[])this.getData()).length > 0 && ((IProcesses.IProcessDMContext[])this.getData())[0] instanceof IProcesses.IThreadDMData) {
                                IProcesses.IProcessDMContext[] iProcessDMContextArray = (IProcesses.IProcessDMContext[])this.getData();
                                int n = iProcessDMContextArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IProcesses.IProcessDMContext processCtx = iProcessDMContextArray[n2];
                                    IProcesses.IThreadDMData processData = (IProcesses.IThreadDMData)processCtx;
                                    int pid = 0;
                                    try {
                                        pid = Integer.parseInt(processData.getId());
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    String[] cores = null;
                                    String owner = null;
                                    if (processData instanceof IGDBProcesses.IGdbThreadDMData) {
                                        cores = ((IGDBProcesses.IGdbThreadDMData)processData).getCores();
                                        owner = ((IGDBProcesses.IGdbThreadDMData)processData).getOwner();
                                    }
                                    String description = null;
                                    if (processData instanceof IGDBProcesses.IGdbThreadDMData2) {
                                        description = ((IGDBProcesses.IGdbThreadDMData2)processData).getDescription();
                                    }
                                    procInfoList.add(new ProcessInfo(pid, processData.getName(), cores, owner, description));
                                    ++n2;
                                }
                                countingRm.setDoneCount(0);
                            } else {
                                IProcesses procService = (IProcesses)(this).GdbConnectCommand.this.fTracker.getService(IProcesses.class);
                                if (procService != null) {
                                    countingRm.setDoneCount(((IProcesses.IProcessDMContext[])this.getData()).length);
                                    IProcesses.IProcessDMContext[] iProcessDMContextArray = (IProcesses.IProcessDMContext[])this.getData();
                                    int n = iProcessDMContextArray.length;
                                    int n3 = 0;
                                    while (n3 < n) {
                                        IProcesses.IProcessDMContext processCtx = iProcessDMContextArray[n3];
                                        procService.getExecutionData((IProcesses.IThreadDMContext)processCtx, (DataRequestMonitor)new DataRequestMonitor<IProcesses.IThreadDMData>((Executor)(this).GdbConnectCommand.this.fExecutor, (RequestMonitor)countingRm){

                                            protected void handleSuccess() {
                                                IProcesses.IThreadDMData processData = (IProcesses.IThreadDMData)this.getData();
                                                int pid = 0;
                                                try {
                                                    pid = Integer.parseInt(processData.getId());
                                                }
                                                catch (NumberFormatException numberFormatException) {
                                                    // empty catch block
                                                }
                                                String[] cores = null;
                                                String owner = null;
                                                if (processData instanceof IGDBProcesses.IGdbThreadDMData) {
                                                    cores = ((IGDBProcesses.IGdbThreadDMData)processData).getCores();
                                                    owner = ((IGDBProcesses.IGdbThreadDMData)processData).getOwner();
                                                }
                                                String description = null;
                                                if (processData instanceof IGDBProcesses.IGdbThreadDMData2) {
                                                    description = ((IGDBProcesses.IGdbThreadDMData2)processData).getDescription();
                                                }
                                                procInfoList.add(new ProcessInfo(pid, processData.getName(), cores, owner, description));
                                                countingRm.done();
                                            }
                                        });
                                        ++n3;
                                    }
                                } else {
                                    countingRm.setDoneCount(0);
                                }
                            }
                        }
                    });
                } else {
                    rm.done();
                }
            }
        });
    }

    protected void connectToProcesses(final ICommandControlService.ICommandControlDMContext controlDmc, List<IProcessExtendedInfo> processes, List<String> debuggedProcesses, final RequestMonitor rm) {
        new PromptForPidJob(LaunchUIMessages.getString("ProcessPrompter.PromptJob"), processes.toArray(new IProcessExtendedInfo[processes.size()]), debuggedProcesses, new DataRequestMonitor<Object>((Executor)this.fExecutor, rm){

            protected void handleCancel() {
                rm.cancel();
                rm.done();
            }

            protected void handleSuccess() {
                Object data = this.getData();
                if (data instanceof IProcessExtendedInfo[]) {
                    GdbConnectCommand.this.attachToProcesses(controlDmc, (IProcessExtendedInfo[])data, rm);
                } else {
                    rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10005, "Invalid return type for process prompter", null));
                }
            }
        }).schedule();
    }

    protected void attachToProcesses(ICommandControlService.ICommandControlDMContext controlDmc, IProcessExtendedInfo[] processes, RequestMonitor rm) {
        IGDBProcesses procService = (IGDBProcesses)this.fTracker.getService(IGDBProcesses.class);
        IGDBBackend backend = (IGDBBackend)this.fTracker.getService(IGDBBackend.class);
        StringBuilder errors = new StringBuilder();
        if (procService != null && backend != null) {
            ArrayList<IProcessExtendedInfo> procList = new ArrayList<IProcessExtendedInfo>(Arrays.asList(processes));
            IProcessExtendedInfo[] previousProcAttempt = new IProcessExtendedInfo[1];
            class AttachToProcessRequestMonitor
            extends ImmediateDataRequestMonitor<IDMContext> {
                private final /* synthetic */ StringBuilder val$errors;
                private final /* synthetic */ IProcessExtendedInfo[] val$previousProcAttempt;
                private final /* synthetic */ List val$procList;
                private final /* synthetic */ IGDBProcesses val$procService;
                private final /* synthetic */ ICommandControlService.ICommandControlDMContext val$controlDmc;
                private final /* synthetic */ RequestMonitor val$rm;
                private final /* synthetic */ IGDBBackend val$backend;

                public AttachToProcessRequestMonitor(StringBuilder stringBuilder, IProcessExtendedInfo[] iProcessExtendedInfoArray, List list, IGDBProcesses iGDBProcesses, ICommandControlService.ICommandControlDMContext iCommandControlDMContext, RequestMonitor requestMonitor, IGDBBackend iGDBBackend) {
                    this.val$errors = stringBuilder;
                    this.val$previousProcAttempt = iProcessExtendedInfoArray;
                    this.val$procList = list;
                    this.val$procService = iGDBProcesses;
                    this.val$controlDmc = iCommandControlDMContext;
                    this.val$rm = requestMonitor;
                    this.val$backend = iGDBBackend;
                }

                protected void handleCompleted() {
                    if (!this.isSuccess()) {
                        GdbConnectCommand.this.formatErrorMessage(this.val$errors, this.val$previousProcAttempt[0], this.getStatus().getMessage());
                    }
                    if (!this.val$procList.isEmpty()) {
                        this.val$procService.isDebuggerAttachSupported((IDMContext)this.val$controlDmc, (DataRequestMonitor)new ImmediateDataRequestMonitor<Boolean>(){

                            protected void handleCompleted() {
                                if (this.isSuccess() && ((Boolean)this.getData()).booleanValue()) {
                                    IProcessExtendedInfo process;
                                    val$previousProcAttempt[0] = process = (IProcessExtendedInfo)val$procList.remove(0);
                                    String pidStr = Integer.toString(process.getPid());
                                    if (val$backend.getSessionType() == SessionType.REMOTE) {
                                        IPath binaryPath;
                                        if (((AttachToProcessRequestMonitor)this).GdbConnectCommand.this.fProcessNameToBinaryMap.isEmpty() && (binaryPath = val$backend.getProgramPath()) != null && !binaryPath.isEmpty()) {
                                            ((AttachToProcessRequestMonitor)this).GdbConnectCommand.this.fProcessNameToBinaryMap.put(binaryPath.lastSegment(), binaryPath.toOSString());
                                        }
                                        Path processPath = new Path(process.getName());
                                        String processShortName = processPath.lastSegment();
                                        new PromptAndAttachToProcessJob(pidStr, String.valueOf(LaunchUIMessages.getString("ProcessPrompterDialog.TitlePrefix")) + process.getName(), processShortName, (RequestMonitor)new AttachToProcessRequestMonitor(val$errors, val$previousProcAttempt, val$procList, val$procService, val$controlDmc, val$rm, val$backend)).schedule();
                                    } else {
                                        IProcesses.IProcessDMContext procDmc = val$procService.createProcessContext(val$controlDmc, pidStr);
                                        val$procService.attachDebuggerToProcess(procDmc, null, (DataRequestMonitor)new AttachToProcessRequestMonitor(val$errors, val$previousProcAttempt, val$procList, val$procService, val$controlDmc, val$rm, val$backend));
                                    }
                                } else {
                                    val$rm.done();
                                }
                            }
                        });
                    } else {
                        if (this.val$errors.length() != 0) {
                            this.val$rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", this.val$errors.toString()));
                        }
                        this.val$rm.done();
                    }
                }
            }
            new AttachToProcessRequestMonitor(errors, previousProcAttempt, procList, procService, controlDmc, rm, backend).done();
        } else {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10005, "Cannot find service", null));
        }
    }

    protected Object getTarget(Object element) {
        if (element instanceof GdbLaunch || element instanceof IDMVMContext) {
            return element;
        }
        return null;
    }

    protected boolean isRemainEnabled(IDebugCommandRequest request) {
        return false;
    }

    private void formatErrorMessage(StringBuilder errors, IProcessExtendedInfo process, String errorMsg) {
        Path path = new Path(process.getName());
        String name = path.lastSegment() == null ? process.getName() : path.lastSegment();
        if (errors.length() != 0) {
            errors.append(System.lineSeparator()).append(System.lineSeparator());
        }
        errors.append(Messages.GdbConnectCommand_FailureMessage).append(" ").append(name).append(" [").append(process.getPid()).append("]").append(System.lineSeparator()).append(Messages.GdbConnectCommand_Error).append(System.lineSeparator()).append(errorMsg);
    }

    private class PromptAndAttachToProcessJob
    extends UIJob {
        private final String fPid;
        private final RequestMonitor fRm;
        private final String fTitle;
        private final String fProcName;

        public PromptAndAttachToProcessJob(String pid, String title, String procName, RequestMonitor rm) {
            super("");
            this.fPid = pid;
            this.fTitle = title;
            this.fProcName = procName;
            this.fRm = rm;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Shell shell;
            String binaryPath = GdbConnectCommand.this.fProcessNameToBinaryMap.get(this.fProcName);
            if (binaryPath == null && (shell = GdbUIPlugin.getShell()) != null) {
                FileDialog fd = new FileDialog(shell, 0);
                fd.setText(this.fTitle);
                binaryPath = fd.open();
            }
            if (binaryPath == null) {
                this.fRm.done();
            } else {
                final String finalBinaryPath = binaryPath;
                GdbConnectCommand.this.fExecutor.execute((Runnable)new DsfRunnable(){

                    public void run() {
                        IGDBProcesses procService = (IGDBProcesses)((PromptAndAttachToProcessJob)PromptAndAttachToProcessJob.this).GdbConnectCommand.this.fTracker.getService(IGDBProcesses.class);
                        ICommandControlService commandControl = (ICommandControlService)((PromptAndAttachToProcessJob)PromptAndAttachToProcessJob.this).GdbConnectCommand.this.fTracker.getService(ICommandControlService.class);
                        if (procService != null && commandControl != null) {
                            IProcesses.IProcessDMContext procDmc = procService.createProcessContext(commandControl.getContext(), PromptAndAttachToProcessJob.this.fPid);
                            procService.attachDebuggerToProcess(procDmc, finalBinaryPath, (DataRequestMonitor)new DataRequestMonitor<IDMContext>((Executor)((PromptAndAttachToProcessJob)PromptAndAttachToProcessJob.this).GdbConnectCommand.this.fExecutor, PromptAndAttachToProcessJob.this.fRm){

                                protected void handleSuccess() {
                                    if ((this).PromptAndAttachToProcessJob.this.fProcName != null && !(this).PromptAndAttachToProcessJob.this.fProcName.isEmpty()) {
                                        ((PromptAndAttachToProcessJob)(this).PromptAndAttachToProcessJob.this).GdbConnectCommand.this.fProcessNameToBinaryMap.put((this).PromptAndAttachToProcessJob.this.fProcName, finalBinaryPath);
                                    }
                                    (this).PromptAndAttachToProcessJob.this.fRm.done();
                                }
                            });
                        } else {
                            PromptAndAttachToProcessJob.this.fRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10005, "Cannot find services", null));
                            PromptAndAttachToProcessJob.this.fRm.done();
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }

    protected class PromptForPidJob
    extends UIJob {
        IProcessExtendedInfo[] fProcessList;
        DataRequestMonitor<Object> fRequestMonitor;
        private List<String> fDebuggedProcesses;

        public PromptForPidJob(String name, IProcessExtendedInfo[] procs, List<String> debuggedProcesses, DataRequestMonitor<Object> rm) {
            super(name);
            this.fProcessList = null;
            this.fProcessList = procs;
            this.fRequestMonitor = rm;
            this.fDebuggedProcesses = debuggedProcesses;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Status NO_PID_STATUS = new Status(4, "org.eclipse.cdt.dsf.gdb.ui", -1, LaunchMessages.getString((String)"LocalAttachLaunchDelegate.No_Process_ID_selected"), null);
            try {
                ProcessPrompter.PrompterInfo info = new ProcessPrompter.PrompterInfo(this.fProcessList, this.fDebuggedProcesses);
                Object result = new ProcessPrompter().handleStatus(null, info);
                if (result == null) {
                    this.fRequestMonitor.cancel();
                } else if (result instanceof IProcessExtendedInfo[]) {
                    this.fRequestMonitor.setData(result);
                } else if (result instanceof Integer) {
                    this.fRequestMonitor.setData((Object)new IProcessExtendedInfo[]{new ProcessInfo((Integer)result, "")});
                } else {
                    this.fRequestMonitor.setStatus((IStatus)NO_PID_STATUS);
                }
            }
            catch (CoreException e) {
                this.fRequestMonitor.setStatus((IStatus)NO_PID_STATUS);
            }
            this.fRequestMonitor.done();
            return Status.OK_STATUS;
        }
    }
}

