/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.console;

import org.eclipse.cdt.debug.ui.debuggerconsole.IDebuggerConsoleView;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.ConsoleMessages;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.GdbConsoleLifecycleListener;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.GdbFullCliConsolePage;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.GdbTerminalConnector;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.IGDBDebuggerConsole;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.IGdbTerminalControlConnector;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.swt.SWTException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.AbstractConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.part.IPageBookViewPage;

public class GdbFullCliConsole
extends AbstractConsole
implements IGDBDebuggerConsole {
    private final ILaunch fLaunch;
    private final String fLabel;
    private final PTY fGdbPty;
    private GdbFullCliConsolePage fConsolePage;
    private final GdbTerminalConnector fTerminalConnector;

    public GdbFullCliConsole(ILaunch launch, String label, Process process, PTY pty) {
        super(label, null, false);
        this.fLaunch = launch;
        this.fLabel = label;
        this.fGdbPty = pty;
        new GdbConsoleLifecycleListener(this);
        this.fTerminalConnector = new GdbTerminalConnector(process);
        this.resetName();
    }

    protected void dispose() {
        this.fTerminalConnector.dispose();
        super.dispose();
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public void resetName() {
        block3: {
            String newName = this.computeName();
            String name = this.getName();
            if (!name.equals(newName)) {
                try {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> this.setName(newName));
                }
                catch (SWTException e) {
                    if (e.code == 24 || e.code == 45) break block3;
                    throw e;
                }
            }
        }
    }

    protected String computeName() {
        if (this.fLaunch == null) {
            return "";
        }
        String label = this.fLabel;
        ILaunchConfiguration config = this.fLaunch.getLaunchConfiguration();
        if (config != null && !DebugUITools.isPrivate((ILaunchConfiguration)config)) {
            String type = null;
            try {
                type = config.getType().getName();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(config.getName());
            if (type != null) {
                buffer.append(" [");
                buffer.append(type);
                buffer.append("] ");
            }
            buffer.append(label);
            label = buffer.toString();
        }
        if (this.fLaunch.isTerminated()) {
            return String.valueOf(ConsoleMessages.ConsoleMessages_console_terminated) + label;
        }
        return label;
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        return null;
    }

    public IPageBookViewPage createDebuggerPage(IDebuggerConsoleView view) {
        view.setFocus();
        this.fConsolePage = new GdbFullCliConsolePage(this, view, this.fGdbPty);
        return this.fConsolePage;
    }

    public IGdbTerminalControlConnector getTerminalControlConnector() {
        return this.fTerminalConnector;
    }
}

