/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.preferences;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.dsf.debug.internal.ui.preferences.IntegerWithBooleanFieldEditor;
import org.eclipse.cdt.dsf.debug.internal.ui.preferences.StringWithBooleanFieldEditor;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.preferences.MessagesForPreferences;
import org.eclipse.cdt.dsf.gdb.service.command.CustomTimeoutsMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class GdbDebugPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final int DEFAULT_GDB_COMMAND_LABEL_WIDTH_HINT = 300;
    private IntegerWithBooleanFieldEditor fCommandTimeoutField;
    private Button fTimeoutAdvancedButton;
    private CustomTimeoutsMap fCustomTimeouts;

    public GdbDebugPreferencePage() {
        super(0);
        IPreferenceStore store = GdbUIPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
        this.setDescription(MessagesForPreferences.GdbDebugPreferencePage_description);
        this.fCustomTimeouts = new CustomTimeoutsMap();
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        super.initialize();
        this.initializeCustomTimeouts();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.updateTimeoutButtons();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.dsf.gdb.ui.dsfgdb_preference_page");
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Group group1 = new Group(parent, 0);
        group1.setText(MessagesForPreferences.GdbDebugPreferencePage_defaults_label);
        GridLayout groupLayout = new GridLayout(3, false);
        group1.setLayout((Layout)groupLayout);
        group1.setLayoutData((Object)new GridData(768));
        final StringFieldEditor stringFieldEditorCommand = new StringFieldEditor("defaultGdbCommand", MessagesForPreferences.GdbDebugPreferencePage_GDB_debugger, (Composite)group1);
        stringFieldEditorCommand.fillIntoGrid((Composite)group1, 2);
        GridData stringFieldLayoutData = (GridData)stringFieldEditorCommand.getTextControl((Composite)group1).getLayoutData();
        stringFieldLayoutData.widthHint = 300;
        this.addField((FieldEditor)stringFieldEditorCommand);
        Button browsebutton = new Button((Composite)group1, 8);
        browsebutton.setText(MessagesForPreferences.GdbDebugPreferencePage_Browse_button);
        browsebutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GdbDebugPreferencePage.this.handleBrowseButtonSelected(MessagesForPreferences.GdbDebugPreferencePage_GDB_debugger_dialog_title, stringFieldEditorCommand);
            }
        });
        this.setButtonLayoutData(browsebutton);
        final StringFieldEditor stringFieldEditorGdbInit = new StringFieldEditor("defaultGdbInit", MessagesForPreferences.GdbDebugPreferencePage_GDB_command_file, (Composite)group1);
        stringFieldEditorGdbInit.fillIntoGrid((Composite)group1, 2);
        this.addField((FieldEditor)stringFieldEditorGdbInit);
        browsebutton = new Button((Composite)group1, 8);
        browsebutton.setText(MessagesForPreferences.GdbDebugPreferencePage_Browse_button);
        browsebutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GdbDebugPreferencePage.this.handleBrowseButtonSelected(MessagesForPreferences.GdbDebugPreferencePage_GDB_command_file_dialog_title, stringFieldEditorGdbInit);
            }
        });
        this.setButtonLayoutData(browsebutton);
        StringWithBooleanFieldEditor enableStopAtMain = new StringWithBooleanFieldEditor("defaultStopAtMain", "defaultStopAtMainSymbol", MessagesForPreferences.GdbDebugPreferencePage_Stop_on_startup_at, (Composite)group1);
        enableStopAtMain.fillIntoGrid((Composite)group1, 3);
        this.addField((FieldEditor)enableStopAtMain);
        this.fCommandTimeoutField = new IntegerWithBooleanFieldEditor("org.eclipse.cdt.dsf.gdb.commandTimeout", "org.eclipse.cdt.dsf.gdb.commandTimeoutValue", MessagesForPreferences.GdbDebugPreferencePage_Command_timeout, (Composite)group1);
        this.fCommandTimeoutField.setValidRange(0, Integer.MAX_VALUE);
        this.fCommandTimeoutField.fillIntoGrid((Composite)group1, 2);
        this.addField((FieldEditor)this.fCommandTimeoutField);
        this.fTimeoutAdvancedButton = new Button((Composite)group1, 8);
        this.fTimeoutAdvancedButton.setText(MessagesForPreferences.GdbDebugPreferencePage_Advanced_button);
        this.fTimeoutAdvancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GdbDebugPreferencePage.this.handleAdvancedButtonSelected(MessagesForPreferences.GdbDebugPreferencePage_GDB_debugger_dialog_title);
            }
        });
        this.setButtonLayoutData(this.fTimeoutAdvancedButton);
        ListenableBooleanFieldEditor enableNonStop = new ListenableBooleanFieldEditor("defaultNonStop", MessagesForPreferences.GdbDebugPreferencePage_Non_stop_mode, 0, (Composite)group1);
        enableNonStop.fillIntoGrid((Composite)group1, 3);
        this.addField((FieldEditor)enableNonStop);
        if (Platform.getOS().startsWith("win")) {
            BooleanFieldEditor externalConsoleField = new BooleanFieldEditor("org.eclipse.cdt.dsf.gdb.externalConsole", MessagesForPreferences.GdbDebugPreferencePage_external_console, (Composite)group1);
            externalConsoleField.fillIntoGrid((Composite)group1, 3);
            this.addField((FieldEditor)externalConsoleField);
        }
        StringWithBooleanFieldEditor remoteTimeout = new StringWithBooleanFieldEditor("defaultRemoteTimeoutEnabled", "defaultRemoteTimeoutValue", MessagesForPreferences.GdbDebugPreferencePage_remoteTimeout_label, (Composite)group1);
        remoteTimeout.getCheckboxControl((Composite)group1).setToolTipText(MessagesForPreferences.GdbDebugPreferencePage_remoteTimeout_tooltip);
        remoteTimeout.getTextControl((Composite)group1).setToolTipText(MessagesForPreferences.GdbDebugPreferencePage_remoteTimeout_tooltip);
        remoteTimeout.fillIntoGrid((Composite)group1, 3);
        this.addField((FieldEditor)remoteTimeout);
        group1.setLayout((Layout)groupLayout);
        Group group2 = new Group(parent, 0);
        group2.setText(MessagesForPreferences.GdbDebugPreferencePage_general_behavior_label);
        groupLayout = new GridLayout(3, false);
        group2.setLayout((Layout)groupLayout);
        group2.setLayoutData((Object)new GridData(768));
        IntegerFieldEditor suspendTimeout = new IntegerFieldEditor("suspendTimeoutValue", MessagesForPreferences.GdbDebugPreferencePage_suspendTimeout_label, (Composite)group2);
        suspendTimeout.setValidRange(5, Integer.MAX_VALUE);
        suspendTimeout.fillIntoGrid((Composite)group2, 3);
        this.addField((FieldEditor)suspendTimeout);
        BooleanFieldEditor boolField = new BooleanFieldEditor("autoTerminateGdb", MessagesForPreferences.GdbDebugPreferencePage_autoTerminateGdb_label, (Composite)group2);
        boolField.fillIntoGrid((Composite)group2, 3);
        this.addField((FieldEditor)boolField);
        group2.setLayout((Layout)groupLayout);
        boolField = new BooleanFieldEditor("useInspectorHover", MessagesForPreferences.GdbDebugPreferencePage_useInspectorHover_label, (Composite)group2);
        boolField.fillIntoGrid((Composite)group2, 3);
        this.addField((FieldEditor)boolField);
        group2.setLayout((Layout)groupLayout);
        boolField = new BooleanFieldEditor("org.eclipse.cdt.dsf.gdb.hideRunningThreads", MessagesForPreferences.GdbDebugPreferencePage_hideRunningThreads, (Composite)group2);
        boolField.fillIntoGrid((Composite)group2, 3);
        this.addField((FieldEditor)boolField);
        group2.setLayout((Layout)groupLayout);
        boolField = new BooleanFieldEditor("org.eclipse.cdt.dsf.gdb.aggressiveBpFilter", MessagesForPreferences.GdbDebugPreferencePage_useAggressiveBpFilter, (Composite)group2);
        boolField.fillIntoGrid((Composite)group2, 3);
        this.addField((FieldEditor)boolField);
        group2.setLayout((Layout)groupLayout);
        boolField = new BooleanFieldEditor("tracesEnable", MessagesForPreferences.GdbDebugPreferencePage_enableTraces_label, (Composite)group2);
        boolField.fillIntoGrid((Composite)group2, 1);
        this.addField((FieldEditor)boolField);
        group2.setLayout((Layout)groupLayout);
        IntegerFieldEditor gdbTracesLimit = new IntegerFieldEditor("maxGdbTraces", "", (Composite)group2);
        gdbTracesLimit.setValidRange(10000, 2000000000);
        gdbTracesLimit.fillIntoGrid((Composite)group2, 2);
        this.addField((FieldEditor)gdbTracesLimit);
        group2.setLayout((Layout)groupLayout);
        StringWithBooleanFieldEditor gdbMaxLines = new StringWithBooleanFieldEditor("maxMiOutputLinesEnable", "maxMiOutputLines", MessagesForPreferences.GdbDebugPreferencePage_enableMaxMessageLines_label, (Composite)group2);
        gdbMaxLines.fillIntoGrid((Composite)group2, 3);
        this.addField((FieldEditor)gdbMaxLines);
        group2.setLayout((Layout)groupLayout);
        boolField = new BooleanFieldEditor("org.eclipse.cdt.dsf.gdb.useRtti", String.valueOf(MessagesForPreferences.GdbDebugPreferencePage_use_rtti_label1) + " \n" + MessagesForPreferences.GdbDebugPreferencePage_use_rtti_label2, (Composite)group2);
        boolField.fillIntoGrid((Composite)group2, 3);
        this.addField((FieldEditor)boolField);
        group2.setLayout((Layout)groupLayout);
        Group group = new Group(parent, 0);
        group.setText(MessagesForPreferences.GdbDebugPreferencePage_prettyPrinting_label);
        groupLayout = new GridLayout(3, false);
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(768));
        final ListenableBooleanFieldEditor enablePrettyPrintingField = new ListenableBooleanFieldEditor("enablePrettyPrinting", String.valueOf(MessagesForPreferences.GdbDebugPreferencePage_enablePrettyPrinting_label1) + " \n" + MessagesForPreferences.GdbDebugPreferencePage_enablePrettyPrinting_label2, 0, (Composite)group);
        enablePrettyPrintingField.fillIntoGrid((Composite)group, 3);
        this.addField((FieldEditor)enablePrettyPrintingField);
        final Composite indentHelper = new Composite((Composite)group, 0);
        GridLayout helperLayout = new GridLayout(3, false);
        indentHelper.setLayout((Layout)helperLayout);
        GridData helperData = new GridData(4, 4, true, false, 3, 1);
        helperData.horizontalIndent = 20;
        indentHelper.setLayoutData((Object)helperData);
        final IntegerFieldEditor childCountLimitField = new IntegerFieldEditor("initialChildCountLimitForCollections", MessagesForPreferences.GdbDebugPreferencePage_initialChildCountLimitForCollections_label, indentHelper);
        childCountLimitField.setValidRange(1, 10000);
        childCountLimitField.fillIntoGrid(indentHelper, 3);
        boolean prettyPrintingEnabled = this.getPreferenceStore().getBoolean("enablePrettyPrinting");
        childCountLimitField.setEnabled(prettyPrintingEnabled, indentHelper);
        this.addField((FieldEditor)childCountLimitField);
        enablePrettyPrintingField.getChangeControl((Composite)group).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = enablePrettyPrintingField.getBooleanValue();
                childCountLimitField.setEnabled(enabled, indentHelper);
            }
        });
        indentHelper.setLayout((Layout)helperLayout);
        group.setLayout((Layout)groupLayout);
    }

    private void handleBrowseButtonSelected(String dialogTitle, StringFieldEditor stringFieldEditor) {
        String res;
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(dialogTitle);
        String gdbCommand = stringFieldEditor.getStringValue().trim();
        int lastSeparatorIndex = gdbCommand.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(gdbCommand.substring(0, lastSeparatorIndex));
        }
        if ((res = dialog.open()) == null) {
            return;
        }
        stringFieldEditor.setStringValue(res);
    }

    private void handleAdvancedButtonSelected(String dialogTitle) {
        AdvancedTimeoutSettingsDialog dialog = new AdvancedTimeoutSettingsDialog(this.getShell(), this.fCustomTimeouts.entrySet());
        if (dialog.open() == 0) {
            this.fCustomTimeouts = dialog.getResult();
        }
    }

    protected void adjustGridLayout() {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource().equals(this.fCommandTimeoutField) && event.getNewValue() instanceof Boolean) {
            this.fTimeoutAdvancedButton.setEnabled(((Boolean)event.getNewValue()).booleanValue());
        }
        super.propertyChange(event);
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            String memento = store.getDefaultString("org.eclipse.cdt.dsf.gdb.commandCustomTimeouts");
            this.fCustomTimeouts.initializeFromMemento(memento);
        }
        super.performDefaults();
        this.updateTimeoutButtons();
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("org.eclipse.cdt.dsf.gdb.commandCustomTimeouts", this.fCustomTimeouts.getMemento());
        return super.performOk();
    }

    private void updateTimeoutButtons() {
        this.fTimeoutAdvancedButton.setEnabled(this.fCommandTimeoutField.getBooleanValue());
    }

    private void initializeCustomTimeouts() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            String memento = store.getString("org.eclipse.cdt.dsf.gdb.commandCustomTimeouts");
            this.fCustomTimeouts.initializeFromMemento(memento);
        }
    }

    class AdvancedTimeoutSettingsDialog
    extends TitleAreaDialog {
        private TableViewer fViewer;
        private Button fAddButton;
        private Button fDeleteButton;
        private List<CommandTimeoutEntry> fEntries;
        private final ICellEditorValidator fCommandValidator;
        private final ICellEditorValidator fTimeoutValidator;

        AdvancedTimeoutSettingsDialog(Shell parentShell, Set<Map.Entry<String, Integer>> entries) {
            super(parentShell);
            this.fCommandValidator = new ICellEditorValidator(){

                public String isValid(Object value) {
                    if (value instanceof String && ((String)value).trim().length() == 0) {
                        return MessagesForPreferences.GdbDebugPreferencePage_Command_field_can_not_be_empty;
                    }
                    return null;
                }
            };
            this.fTimeoutValidator = new ICellEditorValidator(){

                public String isValid(Object value) {
                    if (value instanceof String) {
                        try {
                            int intValue = Integer.decode((String)value);
                            if (intValue < 0) {
                                return MessagesForPreferences.GdbDebugPreferencePage_Timeout_value_can_not_be_negative;
                            }
                        }
                        catch (NumberFormatException e) {
                            return MessagesForPreferences.GdbDebugPreferencePage_Invalid_timeout_value;
                        }
                    }
                    return null;
                }
            };
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.fEntries = new LinkedList<CommandTimeoutEntry>();
            for (Map.Entry<String, Integer> entry : entries) {
                this.fEntries.add(new CommandTimeoutEntry(entry.getKey(), entry.getValue()));
            }
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(MessagesForPreferences.GdbDebugPreferencePage_Advanced_Timeout_Settings);
            this.setTitle(MessagesForPreferences.GdbDebugPreferencePage_Advanced_timeout_dialog_title);
            this.setTitleImage(GdbUIPlugin.getImage("org.eclipse.cdt.dsf.gdb.ui.imageAdvancedTimeoutSettings"));
            this.setMessage(MessagesForPreferences.GdbDebugPreferencePage_Advanced_timeout_dialog_message);
            Composite control = (Composite)super.createDialogArea(parent);
            Composite comp = new Composite(control, 0);
            GridData gd = new GridData(4, 4, true, true);
            GridLayout layout = new GridLayout(2, false);
            layout.marginLeft = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
            comp.setLayout((Layout)layout);
            comp.setLayoutData((Object)gd);
            this.fViewer = new TableViewer(comp, 2816);
            final Table table = this.fViewer.getTable();
            gd = new GridData(4, 4, true, true);
            gd.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
            table.setLayoutData((Object)gd);
            ControlDecoration decoration = new ControlDecoration((Control)table, 16512, control);
            decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
            decoration.setDescriptionText(MessagesForPreferences.GdbDebugPreferencePage_Advanced_timeout_settings_dialog_tooltip);
            this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    AdvancedTimeoutSettingsDialog.this.okPressed();
                }
            });
            this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    AdvancedTimeoutSettingsDialog.this.updateDialogButtons();
                }
            });
            Composite btnComp = new Composite(comp, 0);
            btnComp.setLayout((Layout)new GridLayout());
            btnComp.setLayoutData((Object)new GridData(131072, 128, false, false));
            this.fAddButton = new Button(btnComp, 8);
            this.fAddButton.setText(MessagesForPreferences.GdbDebugPreferencePage_Add_button);
            this.fAddButton.setFont(JFaceResources.getDialogFont());
            this.setButtonLayoutData(this.fAddButton);
            this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AdvancedTimeoutSettingsDialog.this.addNewEntry();
                }
            });
            this.fDeleteButton = new Button(btnComp, 8);
            this.fDeleteButton.setText(MessagesForPreferences.GdbDebugPreferencePage_Delete_button);
            this.fDeleteButton.setFont(JFaceResources.getDialogFont());
            this.setButtonLayoutData(this.fDeleteButton);
            this.fDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AdvancedTimeoutSettingsDialog.this.deleteEntries();
                }
            });
            table.setLayoutData((Object)new GridData(4, 4, true, true));
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            TableViewerColumn commandColumn = new TableViewerColumn(this.fViewer, 16384);
            commandColumn.getColumn().setText(MessagesForPreferences.GdbDebugPreferencePage_Command_column_name);
            commandColumn.setLabelProvider((CellLabelProvider)this.createCommandLabelProvider());
            commandColumn.setEditingSupport(this.createCommandEditingSupport((ColumnViewer)this.fViewer));
            TableViewerColumn timeoutColumn = new TableViewerColumn(this.fViewer, 16384);
            timeoutColumn.getColumn().setText(MessagesForPreferences.GdbDebugPreferencePage_Timeout_column_name);
            timeoutColumn.setLabelProvider((CellLabelProvider)this.createTimeoutLabelProvider());
            timeoutColumn.setEditingSupport(this.createTimeoutEditingSupport((ColumnViewer)this.fViewer));
            this.fViewer.setContentProvider((IContentProvider)this.createCustomTimeoutsContentProvider());
            table.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle area = table.getClientArea();
                    if (area.width > 0) {
                        TableColumn[] cols = table.getColumns();
                        cols[0].setWidth(area.width * 50 / 100);
                        cols[1].setWidth(area.width * 50 / 100);
                        table.removeControlListener((ControlListener)this);
                    }
                }
            });
            this.fViewer.setInput(this.fEntries);
            this.updateDialogButtons();
            return control;
        }

        void updateDialogButtons() {
            Button okButton;
            if (this.fViewer != null && this.fDeleteButton != null) {
                this.fDeleteButton.setEnabled(!this.fViewer.getSelection().isEmpty());
            }
            if ((okButton = this.getButton(0)) != null) {
                okButton.setEnabled(this.getErrorMessage() == null);
            }
        }

        void addNewEntry() {
            CommandTimeoutEntry newEntry = new CommandTimeoutEntry("", 0);
            this.fEntries.add(newEntry);
            this.fViewer.refresh();
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)newEntry));
            this.validateEntry(newEntry);
            this.updateDialogButtons();
            this.fViewer.editElement((Object)newEntry, 0);
        }

        void deleteEntries() {
            IStructuredSelection sel = (IStructuredSelection)this.fViewer.getSelection();
            if (!sel.isEmpty()) {
                this.fEntries.removeAll(sel.toList());
            }
            this.fViewer.refresh();
            this.validate();
            this.updateDialogButtons();
        }

        CustomTimeoutsMap getResult() {
            CustomTimeoutsMap map = new CustomTimeoutsMap();
            for (CommandTimeoutEntry entry : this.fEntries) {
                map.put((Object)entry.fCommand, (Object)entry.fTimeout);
            }
            return map;
        }

        void validate() {
            for (CommandTimeoutEntry entry : this.fEntries) {
                this.validateEntry(entry);
            }
        }

        void validateEntry(CommandTimeoutEntry entry) {
            String errorMessage = this.fCommandValidator.isValid((Object)entry.fCommand);
            this.setErrorMessage(errorMessage != null ? errorMessage : this.fTimeoutValidator.isValid((Object)entry.fTimeout.toString()));
        }

        IStructuredContentProvider createCustomTimeoutsContentProvider() {
            return new IStructuredContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    if (inputElement instanceof List) {
                        List list = (List)inputElement;
                        return list.toArray(new Object[list.size()]);
                    }
                    return null;
                }
            };
        }

        ColumnLabelProvider createCommandLabelProvider() {
            return new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof CommandTimeoutEntry) {
                        return ((CommandTimeoutEntry)element).fCommand;
                    }
                    return super.getText(element);
                }
            };
        }

        ColumnLabelProvider createTimeoutLabelProvider() {
            return new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof CommandTimeoutEntry) {
                        return ((CommandTimeoutEntry)element).fTimeout.toString();
                    }
                    return super.getText(element);
                }
            };
        }

        EditingSupport createCommandEditingSupport(ColumnViewer viewer) {
            return new AbstractEditingSupport(this, viewer){

                @Override
                boolean processValue(CommandTimeoutEntry entry, String value) {
                    entry.fCommand = value;
                    return true;
                }

                @Override
                Object doGetValue(CommandTimeoutEntry entry) {
                    return entry.fCommand;
                }

                @Override
                ICellEditorValidator getValidator() {
                    return fCommandValidator;
                }
            };
        }

        EditingSupport createTimeoutEditingSupport(ColumnViewer viewer) {
            return new AbstractEditingSupport(this, viewer){

                @Override
                boolean processValue(CommandTimeoutEntry entry, String value) {
                    try {
                        entry.fTimeout = Integer.decode(value);
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }

                @Override
                Object doGetValue(CommandTimeoutEntry entry) {
                    return entry.fTimeout.toString();
                }

                @Override
                ICellEditorValidator getValidator() {
                    return fTimeoutValidator;
                }
            };
        }

        abstract class AbstractEditingSupport
        extends EditingSupport {
            public AbstractEditingSupport(ColumnViewer viewer) {
                super(viewer);
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof CommandTimeoutEntry && value instanceof String && this.processValue((CommandTimeoutEntry)element, (String)value)) {
                    AdvancedTimeoutSettingsDialog.this.fViewer.refresh(element);
                    AdvancedTimeoutSettingsDialog.this.validate();
                    AdvancedTimeoutSettingsDialog.this.updateDialogButtons();
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof CommandTimeoutEntry) {
                    return this.doGetValue((CommandTimeoutEntry)element);
                }
                return null;
            }

            protected CellEditor getCellEditor(Object element) {
                TextCellEditor editor = new TextCellEditor((Composite)this.getViewer().getControl());
                editor.setValidator(this.getValidator());
                editor.addListener((ICellEditorListener)new CellEditorListener((CellEditor)editor));
                return editor;
            }

            protected boolean canEdit(Object element) {
                return element instanceof CommandTimeoutEntry;
            }

            abstract boolean processValue(CommandTimeoutEntry var1, String var2);

            abstract Object doGetValue(CommandTimeoutEntry var1);

            abstract ICellEditorValidator getValidator();
        }

        class CellEditorListener
        implements ICellEditorListener {
            CellEditor fEditor;

            public CellEditorListener(CellEditor editor) {
                this.fEditor = editor;
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                if (newValidState) {
                    AdvancedTimeoutSettingsDialog.this.setErrorMessage(null);
                } else {
                    AdvancedTimeoutSettingsDialog.this.setErrorMessage(this.fEditor.getErrorMessage());
                }
                AdvancedTimeoutSettingsDialog.this.updateDialogButtons();
            }

            public void cancelEditor() {
            }

            public void applyEditorValue() {
                AdvancedTimeoutSettingsDialog.this.validate();
                AdvancedTimeoutSettingsDialog.this.updateDialogButtons();
            }
        }

        class CommandTimeoutEntry {
            String fCommand;
            Integer fTimeout;

            CommandTimeoutEntry(String command, Integer timeout) {
                this.fCommand = command;
                this.fTimeout = timeout;
            }
        }
    }

    private class ListenableBooleanFieldEditor
    extends BooleanFieldEditor {
        public ListenableBooleanFieldEditor(String name, String labelText, int style, Composite parent) {
            super(name, labelText, style, parent);
        }

        public Button getChangeControl(Composite parent) {
            return super.getChangeControl(parent);
        }
    }
}

