/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.core.concurrent.TCFOperationMonitor;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.AbstractOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;
import org.eclipse.tcf.util.TCFFileInputStream;

public class OpTargetFileDigest
extends AbstractOperation {
    FSTreeNode node;
    byte[] digest;

    public OpTargetFileDigest(FSTreeNode node) {
        this.node = node;
    }

    @Override
    public IStatus doRun(IProgressMonitor monitor) {
        IStatus iStatus;
        long totalSize = this.node.getSize();
        monitor.beginTask(this.getName(), 100);
        final String path = this.node.getLocation(true);
        final TCFOperationMonitor result = new TCFOperationMonitor();
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                IFileSystem fs = OpTargetFileDigest.this.node.getRuntimeModel().getFileSystem();
                if (fs == null) {
                    result.setCancelled();
                } else {
                    OpTargetFileDigest.this.tcfGetInputStream(fs, path, (TCFOperationMonitor<InputStream>)result);
                }
            }
        });
        IStatus status = result.waitDone(monitor);
        if (!status.isOK()) {
            return status;
        }
        FilterInputStream in = new BufferedInputStream((InputStream)result.getValue());
        try {
            int length;
            int chunk_size = (int)totalSize / 100;
            int percentRead = 0;
            long bytesRead = 0L;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            in = new DigestInputStream(in, digest);
            byte[] data = new byte[5120];
            while ((length = ((InputStream)in).read(data)) >= 0) {
                int percent;
                if (chunk_size != 0 && (percent = (int)(bytesRead += (long)length) / chunk_size) != percentRead) {
                    monitor.worked(percent - percentRead);
                    percentRead = percent;
                }
                if (!monitor.isCanceled()) continue;
                IStatus iStatus2 = Status.CANCEL_STATUS;
                return iStatus2;
            }
            this.digest = digest.digest();
            iStatus = Status.OK_STATUS;
        }
        catch (Exception e) {
            IStatus iStatus3 = StatusHelper.createStatus(MessageFormat.format(Messages.OpTargetFileDigest_error_download, path), e);
            return iStatus3;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception exception) {}
            }
        }
        return iStatus;
    }

    protected void tcfGetInputStream(IFileSystem fileSystem, final String path, final TCFOperationMonitor<InputStream> result) {
        int flags = 1;
        if (!result.checkCancelled()) {
            fileSystem.open(path, flags, null, new IFileSystem.DoneOpen(){

                public void doneOpen(IToken token, IFileSystem.FileSystemException error, IFileSystem.IFileHandle handle) {
                    if (error != null) {
                        result.setError(MessageFormat.format(Messages.OpTargetFileDigest_error_openFile, path), (Throwable)error);
                    } else {
                        result.setDone((Object)new TCFFileInputStream(handle));
                    }
                }
            });
        }
    }

    public byte[] getDigest() {
        return this.digest;
    }

    @Override
    public String getName() {
        return "Update target digest";
    }
}

