/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.ui.pde.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class Trace {
    protected static final String PARENTHESIS_OPEN = "(";
    protected static final String PARENTHESIS_CLOSE = ")";
    protected static final String PREFIX_CHANGING = "CHANGING ";
    protected static final String PREFIX_CATCHING = "CAUGHT ";
    protected static final String PREFIX_THROWING = "THROWN ";
    protected static final String PREFIX_ENTERING = "ENTERING ";
    protected static final String PREFIX_EXITING = "EXITING ";
    protected static final String SEPARATOR_METHOD = "#";
    protected static final String SEPARATOR_PARAMETER = ", ";
    protected static final String SEPARATOR_RETURN = ":";
    protected static final String SEPARATOR_SPACE = " ";
    protected static final String LABEL_OLD_VALUE = "old=";
    protected static final String LABEL_NEW_VALUE = "new=";
    private static final Map cachedOptions = new HashMap();

    private Trace() {
    }

    protected static boolean shouldTrace(Plugin plugin) {
        return plugin.isDebugging();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldTrace(Plugin plugin, String option) {
        if (Trace.shouldTrace(plugin)) {
            Boolean value = null;
            Map map = cachedOptions;
            synchronized (map) {
                value = (Boolean)cachedOptions.get(option);
                if (value == null) {
                    value = Boolean.valueOf(Platform.getDebugOption((String)option));
                    cachedOptions.put(option, value);
                }
            }
            return value;
        }
        return false;
    }

    protected static String getArgumentString(Object argument) {
        return String.valueOf(argument);
    }

    protected static String getArgumentsString(Object[] arguments) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < arguments.length) {
            buffer.append(Trace.getArgumentString(arguments[i]));
            if (i < arguments.length - 1) {
                buffer.append(SEPARATOR_PARAMETER);
            }
            ++i;
        }
        return buffer.toString();
    }

    protected static void trace(String message) {
        System.out.println(message);
    }

    public static void trace(Plugin plugin, String message) {
        if (Trace.shouldTrace(plugin)) {
            Trace.trace(message);
        }
    }

    public static void trace(Plugin plugin, String option, String message) {
        if (Trace.shouldTrace(plugin, option)) {
            Trace.trace(message);
        }
    }

    public static void changing(Plugin plugin, String option, String valueDescription, Object oldValue, Object newValue) {
        if (Trace.shouldTrace(plugin, option)) {
            Trace.trace(PREFIX_CHANGING + valueDescription + SEPARATOR_SPACE + LABEL_OLD_VALUE + Trace.getArgumentString(oldValue) + SEPARATOR_PARAMETER + LABEL_NEW_VALUE + Trace.getArgumentString(newValue));
        }
    }

    public static void changing(Plugin plugin, String option, Class clazz, String methodName, String valueDescription, Object oldValue, Object newValue) {
        if (Trace.shouldTrace(plugin, option)) {
            Trace.trace(PREFIX_CHANGING + valueDescription + SEPARATOR_SPACE + LABEL_OLD_VALUE + Trace.getArgumentString(oldValue) + SEPARATOR_PARAMETER + LABEL_NEW_VALUE + Trace.getArgumentString(newValue) + SEPARATOR_SPACE + PARENTHESIS_OPEN + clazz.getName() + SEPARATOR_METHOD + methodName + PARENTHESIS_CLOSE);
        }
    }

    public static void catching(Plugin plugin, String option, Class clazz, String methodName, Throwable throwable) {
        if (Trace.shouldTrace(plugin, option)) {
            Trace.trace(PREFIX_CATCHING + throwable.getMessage() + SEPARATOR_SPACE + PARENTHESIS_OPEN + clazz.getName() + SEPARATOR_METHOD + methodName + PARENTHESIS_CLOSE);
            throwable.printStackTrace(System.err);
        }
    }

    public static void throwing(Plugin plugin, String option, Class clazz, String methodName, Throwable throwable) {
        if (Trace.shouldTrace(plugin, option)) {
            Trace.trace(PREFIX_THROWING + throwable.getMessage() + SEPARATOR_SPACE + PARENTHESIS_OPEN + clazz.getName() + SEPARATOR_METHOD + methodName + PARENTHESIS_CLOSE);
            throwable.printStackTrace(System.err);
        }
    }

    public static void entering(Plugin plugin, String option, Class clazz, String methodName) {
        if (Trace.shouldTrace(plugin, option)) {
            Trace.trace(PREFIX_ENTERING + clazz.getName() + SEPARATOR_METHOD + methodName);
        }
    }

    public static void entering(Plugin plugin, String option, Class clazz, String methodName, Object parameter) {
        if (Trace.shouldTrace(plugin, option)) {
            Trace.trace(PREFIX_ENTERING + clazz.getName() + SEPARATOR_METHOD + methodName + PARENTHESIS_OPEN + Trace.getArgumentString(parameter) + PARENTHESIS_CLOSE);
        }
    }

    public static void entering(Plugin plugin, String option, Class clazz, String methodName, Object[] parameters) {
        if (Trace.shouldTrace(plugin, option)) {
            Trace.trace(PREFIX_ENTERING + clazz.getName() + SEPARATOR_METHOD + methodName + PARENTHESIS_OPEN + Trace.getArgumentsString(parameters) + PARENTHESIS_CLOSE);
        }
    }

    public static void exiting(Plugin plugin, String option, Class clazz, String methodName) {
        if (Trace.shouldTrace(plugin, option)) {
            Trace.trace(PREFIX_EXITING + clazz.getName() + SEPARATOR_METHOD + methodName);
        }
    }

    public static void exiting(Plugin plugin, String option, Class clazz, String methodName, Object returnValue) {
        if (Trace.shouldTrace(plugin, option)) {
            Trace.trace(PREFIX_EXITING + clazz.getName() + SEPARATOR_METHOD + methodName + SEPARATOR_RETURN + Trace.getArgumentString(returnValue));
        }
    }
}

