/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.acceleo.interpreter;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationContext;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationResult;
import org.eclipse.acceleo.ui.interpreter.view.Variable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.acceleo.interpreter.Messages;
import org.eclipse.sirius.common.tools.api.interpreter.CompoundInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IEvaluationResult;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.EcoreMetamodelDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class SiriusEvaluationTask
implements Callable<EvaluationResult> {
    private EvaluationContext context;

    public SiriusEvaluationTask(EvaluationContext context) {
        this.context = context;
    }

    @Override
    public EvaluationResult call() throws Exception {
        IStatus status;
        IInterpreter vpInterpreter;
        Session curSession;
        EObject target;
        this.checkCancelled();
        String expression = this.context.getExpression();
        if (this.context.getTargetEObjects().isEmpty()) {
            Status errorStatus = new Status(4, "org.eclipse.sirius.common.acceleo.interpreter", MessageFormat.format(Messages.SiriusEvaluationTask_status_noEvaluationTarget, expression));
            return new EvaluationResult((IStatus)errorStatus);
        }
        EObject semanticTarget = target = (EObject)this.context.getTargetEObjects().get(0);
        if (target instanceof DSemanticDecorator) {
            semanticTarget = ((DSemanticDecorator)target).getTarget();
        }
        if ((curSession = SessionManager.INSTANCE.getSession(semanticTarget)) != null) {
            vpInterpreter = curSession.getInterpreter();
        } else {
            vpInterpreter = CompoundInterpreter.INSTANCE.getInterpreterForExpression(expression);
            LinkedHashSet<EcoreMetamodelDescriptor> mmDescriptors = new LinkedHashSet<EcoreMetamodelDescriptor>();
            Set<EPackage> knownEPackages = this.collectEPackagesToRegister(target);
            Iterator iterator = knownEPackages.iterator();
            while (iterator.hasNext()) {
                EPackage ePackage = (EPackage)iterator.next();
                mmDescriptors.add(new EcoreMetamodelDescriptor(ePackage));
            }
            vpInterpreter.activateMetamodels(mmDescriptors);
        }
        assert (vpInterpreter != null);
        this.checkCancelled();
        for (Variable var : this.context.getVariables()) {
            vpInterpreter.setVariable(var.getName(), var.getValue());
        }
        EvaluationResult evaluationResult = null;
        try {
            IEvaluationResult result = vpInterpreter.evaluateExpression(target, expression);
            status = this.createResultStatus(result);
            evaluationResult = new EvaluationResult(result.getValue(), status);
        }
        catch (EvaluationException e) {
            status = new Status(4, "org.eclipse.sirius.common.acceleo.interpreter", e.getMessage(), (Throwable)e);
            evaluationResult = new EvaluationResult(status);
        }
        assert (evaluationResult != null);
        return evaluationResult;
    }

    private Set<EPackage> collectEPackagesToRegister(EObject target) {
        LinkedHashSet localEPackageRegistries = new LinkedHashSet();
        LinkedHashSet<EPackage> knownEPackages = new LinkedHashSet<EPackage>();
        this.context.getTargetNotifiers().stream().filter(EObject.class::isInstance).map(EObject.class::cast).forEachOrdered(targetEObject -> {
            Resource targetEObjectResource;
            EPackage ePackage = targetEObject.eClass().getEPackage();
            if (ePackage != null && ePackage.getNsURI() != null) {
                knownEPackages.add(ePackage);
            }
            if ((targetEObjectResource = targetEObject.eResource()) != null && targetEObjectResource.getResourceSet() != null) {
                localEPackageRegistries.add(targetEObjectResource.getResourceSet().getPackageRegistry());
            }
        });
        LinkedHashSet localyRegisteredNsURIs = new LinkedHashSet();
        for (EPackage.Registry registry : localEPackageRegistries) {
            localyRegisteredNsURIs.addAll(registry.keySet());
            for (String nsURI : registry.keySet()) {
                Object value = registry.get((Object)nsURI);
                if (!(value instanceof EPackage)) continue;
                knownEPackages.add((EPackage)value);
            }
        }
        for (String nsURI : EPackage.Registry.INSTANCE.keySet()) {
            Object value;
            if (!localyRegisteredNsURIs.isEmpty() && localyRegisteredNsURIs.contains(nsURI) || !((value = EPackage.Registry.INSTANCE.get((Object)nsURI)) instanceof EPackage)) continue;
            knownEPackages.add((EPackage)value);
        }
        return knownEPackages;
    }

    private IStatus createResultStatus(Object result) {
        Status status = new Status(0, "org.eclipse.sirius.common.acceleo.interpreter", "");
        if (result instanceof IEvaluationResult) {
            IEvaluationResult evaluationResult = (IEvaluationResult)result;
            status = this.getStatus(evaluationResult);
        } else if (result != null) {
            String message = this.getDefaultMessage(result);
            status = new Status(0, "org.eclipse.sirius.common.acceleo.interpreter", message);
        }
        return status;
    }

    private IStatus getStatus(IEvaluationResult evaluationResult) {
        Object result = evaluationResult.getValue();
        String message = this.getDefaultMessage(result);
        Diagnostic diagnostic = evaluationResult.getDiagnostic();
        int statusCode = BasicDiagnostic.toIStatus((Diagnostic)diagnostic).getSeverity();
        Status status = new Status(statusCode, "org.eclipse.sirius.common.acceleo.interpreter", message);
        if (diagnostic.getSeverity() != 0 && !diagnostic.getChildren().isEmpty()) {
            MultiStatus multiStatus = new MultiStatus("org.eclipse.sirius.common.acceleo.interpreter", statusCode, message, null);
            List children = diagnostic.getChildren();
            for (Diagnostic childDiagnostic : children) {
                int childStatusCode = BasicDiagnostic.toIStatus((Diagnostic)childDiagnostic).getSeverity();
                String childMessage = childDiagnostic.getMessage();
                Status childStatus = new Status(childStatusCode, "org.eclipse.sirius.common.acceleo.interpreter", childMessage);
                multiStatus.add((IStatus)childStatus);
            }
            status = multiStatus;
        }
        return status;
    }

    private String getDefaultMessage(Object result) {
        String type = "null";
        if (result != null) {
            type = result.getClass().getSimpleName();
        }
        String size = null;
        if (result instanceof String) {
            size = String.valueOf(((String)result).length());
        } else if (result instanceof Collection) {
            size = String.valueOf(((Collection)result).size());
            if (result instanceof List) {
                type = "Sequence";
            } else if (result instanceof Set) {
                type = "Set";
            }
        } else if (result instanceof EObject) {
            EObject eObject = (EObject)result;
            EClass eClass = eObject.eClass();
            EPackage ePackage = eClass.getEPackage();
            type = String.valueOf(ePackage.getName()) + "::" + eClass.getName();
        }
        String message = size == null ? MessageFormat.format(Messages.SiriusEvaluationTask_status_resultMessage, type) : MessageFormat.format(Messages.SiriusEvaluationTask_status_sizedResultMessage, type, size);
        return message;
    }

    private void checkCancelled() {
        if (Thread.currentThread().isInterrupted()) {
            throw new CancellationException();
        }
    }
}

