/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.api.tests.conditions.evaluation;

import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionEvaluationException;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionEvaluationService;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionTokenAssessmentService;
import org.eclipse.passage.lic.api.conditions.evaluation.ParsedExpression;
import org.eclipse.passage.lic.api.tests.fakes.conditions.evaluation.FakeExpressionTokenAssessmentService;
import org.eclipse.passage.lic.api.tests.fakes.conditions.evaluation.FakeParsedExpression;
import org.junit.Assert;
import org.junit.Test;

public abstract class ExpressionEvaluationServiceContractTest {
    @Test(expected=NullPointerException.class)
    public final void prohibitsNullExpression() {
        this.prohibitsNullArgument(null, new FakeExpressionTokenAssessmentService());
    }

    @Test(expected=NullPointerException.class)
    public final void prohibitsNullAssessor() {
        this.prohibitsNullArgument(new FakeParsedExpression(), null);
    }

    @Test(expected=ExpressionEvaluationException.class)
    public final void canOnlyEvaluateExpressionOfSameProtocl() throws ExpressionEvaluationException {
        this.evaluator().evaluate((ParsedExpression)new FakeParsedExpression("fake"), (ExpressionTokenAssessmentService)new FakeExpressionTokenAssessmentService());
    }

    private void prohibitsNullArgument(ParsedExpression expression, ExpressionTokenAssessmentService assessor) {
        try {
            this.evaluator().evaluate(expression, assessor);
        }
        catch (ExpressionEvaluationException e) {
            Assert.fail((String)"No evaluation activity is expected to be started for invalid incoming data");
        }
    }

    protected abstract ExpressionEvaluationService evaluator();
}

