/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.api.tests.conditions.mining;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.conditions.Condition;
import org.eclipse.passage.lic.api.conditions.ValidityPeriodClosed;
import org.eclipse.passage.lic.api.conditions.mining.ConditionTransport;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public abstract class ConditionTransportContractTest {
    @Test
    public final void identifiedByContentType() {
        Assert.assertNotNull((Object)this.transport().id());
    }

    @Test
    public final void readYourOwnWritings() throws IOException {
        Collection<Condition> sedentaries = this.conditions();
        Assume.assumeTrue((String)"Too few: supply at least two test conditions for transportation", (sedentaries.size() > 1 ? 1 : 0) != 0);
        ConditionTransport transport = this.transport();
        Collection<Condition> nomads = this.read(transport, this.serialized(sedentaries));
        Assert.assertEquals(new HashSet<String>(this.textual(sedentaries)), new HashSet<String>(this.textual(nomads)));
    }

    @Test(expected=IOException.class)
    public final void failOnNotSufficientData() throws IOException {
        this.read(this.transport(), this.serializedInvalid());
    }

    @Test(expected=IOException.class)
    public final void failOnEmptySource() throws IOException {
        this.read(this.transport(), "");
    }

    private Collection<Condition> read(ConditionTransport transport, String source) throws IOException {
        return transport.read((InputStream)new ByteArrayInputStream(source.getBytes())).conditions();
    }

    private Set<String> textual(Collection<Condition> condition) {
        return condition.stream().map(this::textual).collect(Collectors.toSet());
    }

    private String textual(Condition condition) {
        return condition.feature() + condition.versionMatch().version() + condition.versionMatch().rule().identifier() + ((ValidityPeriodClosed)condition.validityPeriod()).from() + ((ValidityPeriodClosed)condition.validityPeriod()).to() + condition.evaluationInstructions().type().identifier() + condition.evaluationInstructions().expression();
    }

    protected abstract String serialized(Collection<Condition> var1);

    protected abstract String serializedInvalid();

    protected abstract ConditionTransport transport();

    protected abstract Collection<Condition> conditions();
}

