/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.ExternalFeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.core.target.DirectoryBundleContainer;
import org.eclipse.pde.internal.core.target.FeatureBundleContainer;
import org.eclipse.pde.internal.core.target.InvalidTargetBundle;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.pde.internal.core.target.ProfileBundleContainer;
import org.eclipse.pde.internal.core.target.TargetDefinitionDocumentTools;
import org.eclipse.pde.internal.core.target.TargetDefinitionPersistenceHelper;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public class TargetDefinition
implements ITargetDefinition {
    private Document fDocument;
    private Element fRoot;
    private String fName;
    private NameVersionDescriptor[] fIncluded;
    private String fProgramArgs;
    private String fVMArgs;
    private IPath fJREContainer;
    private String fArch;
    private String fOS;
    private String fWS;
    private String fNL;
    private ITargetLocation[] fContainers;
    private final ITargetHandle fHandle;
    private IStatus fResolutionStatus;
    private NameVersionDescriptor[] fImplicit;
    private int fUIMode = 0;
    public static final int MODE_PLUGIN = 0;
    public static final int MODE_FEATURE = 1;
    private static Map<String, TargetFeature[]> fFeaturesInLocation = new HashMap<String, TargetFeature[]>();
    private TargetFeature[] fFeatures;
    private TargetBundle[] fOtherBundles;
    private int fSequenceNumber = -1;

    TargetDefinition(ITargetHandle handle) {
        this.fHandle = handle;
        this.setDocument(TargetDefinition.createNewDocument());
    }

    private static Document createNewDocument() {
        try {
            Document doc = XmlProcessorFactory.newDocumentWithErrorOnDOCTYPE();
            ProcessingInstruction instruction = doc.createProcessingInstruction("pde", "version=\"3.8\"");
            doc.appendChild(instruction);
            doc.appendChild(doc.createElement("target"));
            return doc;
        }
        catch (ParserConfigurationException e) {
            return null;
        }
    }

    @Override
    public void setDocument(Document document) {
        if (document != null) {
            Element root = document.getDocumentElement();
            if (root != null && root.getNodeName().equalsIgnoreCase("target")) {
                this.fDocument = document;
                this.fRoot = root;
            }
            return;
        }
        this.fDocument = null;
        this.fRoot = null;
    }

    @Override
    public Document getDocument() {
        return this.fDocument;
    }

    @Override
    public String getArch() {
        return this.fArch;
    }

    @Override
    public ITargetLocation[] getTargetLocations() {
        return this.fContainers;
    }

    @Override
    public String getNL() {
        return this.fNL;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getOS() {
        return this.fOS;
    }

    @Override
    public String getProgramArguments() {
        return this.fProgramArgs;
    }

    @Override
    public String getVMArguments() {
        return this.fVMArgs;
    }

    @Override
    public String getWS() {
        return this.fWS;
    }

    @Override
    public void setArch(String arch) {
        this.incrementSequenceNumber();
        this.fArch = arch;
        if (this.fRoot != null && arch != null && !arch.isEmpty()) {
            Element archNode = TargetDefinitionDocumentTools.getChildElement(this.fRoot, "environment", "arch");
            archNode.setTextContent(arch);
        } else {
            this.removeElement("environment", "arch");
        }
    }

    @Override
    public void setNL(String nl) {
        this.incrementSequenceNumber();
        this.fNL = nl;
        if (this.fRoot != null && nl != null && !nl.isEmpty()) {
            Element nlNode = TargetDefinitionDocumentTools.getChildElement(this.fRoot, "environment", "nl");
            nlNode.setTextContent(nl);
        } else {
            this.removeElement("environment", "nl");
        }
    }

    @Override
    public void setName(String name) {
        this.fName = name;
        if (this.fRoot != null) {
            if (name != null && !name.isEmpty()) {
                this.fRoot.setAttribute("name", name);
            } else {
                this.fRoot.removeAttribute("name");
            }
        }
    }

    @Override
    public void setOS(String os) {
        this.incrementSequenceNumber();
        this.fOS = os;
        if (this.fRoot != null && os != null && !os.isEmpty()) {
            Element nlNode = TargetDefinitionDocumentTools.getChildElement(this.fRoot, "environment", "os");
            nlNode.setTextContent(os);
        } else {
            this.removeElement("environment", "os");
        }
    }

    @Override
    public void setProgramArguments(String args) {
        if (args != null && args.isEmpty()) {
            args = null;
        }
        this.fProgramArgs = args;
        if (this.fRoot != null && args != null) {
            Element programArgsNode = TargetDefinitionDocumentTools.getChildElement(this.fRoot, "launcherArgs", "programArgs");
            programArgsNode.setTextContent(args);
        } else {
            this.removeElement("launcherArgs", "programArgs");
        }
    }

    @Override
    public void setVMArguments(String args) {
        if (args != null && args.isEmpty()) {
            args = null;
        }
        this.fVMArgs = args;
        if (this.fRoot != null && args != null) {
            Element programArgsNode = TargetDefinitionDocumentTools.getChildElement(this.fRoot, "launcherArgs", "vmArgs");
            programArgsNode.setTextContent(args);
        } else {
            this.removeElement("launcherArgs", "vmArgs");
        }
    }

    @Override
    public void setWS(String ws) {
        this.incrementSequenceNumber();
        this.fWS = ws;
        if (this.fRoot != null && ws != null && !ws.isEmpty()) {
            Element nlNode = TargetDefinitionDocumentTools.getChildElement(this.fRoot, "environment", "ws");
            nlNode.setTextContent(ws);
        } else {
            this.removeElement("environment", "ws");
        }
    }

    @Override
    public void setTargetLocations(ITargetLocation[] locations) {
        this.incrementSequenceNumber();
        this.fFeatures = null;
        this.fOtherBundles = null;
        if (locations != null && locations.length == 0) {
            locations = null;
        }
        this.fContainers = locations;
        if (locations == null) {
            this.setIncluded(null);
        } else {
            ITargetLocation[] iTargetLocationArray = locations;
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation location = iTargetLocationArray[n2];
                if (location instanceof AbstractBundleContainer) {
                    ((AbstractBundleContainer)location).associateWithTarget(this);
                }
                ++n2;
            }
        }
        try {
            if (this.fRoot != null && locations != null) {
                Element containersElement = TargetDefinitionDocumentTools.getChildElement(this.fRoot, "locations");
                this.serializeBundleContainers(locations, containersElement);
            } else {
                this.removeElement("locations");
            }
        }
        catch (IOException | ParserConfigurationException | CoreException | DOMException | SAXException e) {
            PDECore.log(e);
        }
    }

    public void flushCaches(String location) {
        this.fFeatures = null;
        this.fOtherBundles = null;
        if (location == null) {
            fFeaturesInLocation.clear();
        } else {
            fFeaturesInLocation.remove(location);
        }
        if (this.fContainers == null) {
            this.setIncluded(null);
        }
    }

    @Override
    public IStatus resolve(IProgressMonitor monitor) {
        ITargetLocation[] targetLocations = this.getTargetLocations();
        if (targetLocations == null || targetLocations.length == 0) {
            this.fResolutionStatus = Status.OK_STATUS;
            return this.fResolutionStatus;
        }
        this.fResolutionStatus = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.TargetDefinition_1, (int)(targetLocations.length * 100));
        try {
            MultiStatus status = new MultiStatus("org.eclipse.pde.core", 0, Messages.TargetDefinition_2, null);
            HashMap<P2TargetUtils, List> synchronizers = new HashMap<P2TargetUtils, List>();
            P2TargetUtils.fgTargetArtifactRepo.clear();
            P2TargetUtils.fgArtifactKeyRepoFile.clear();
            ITargetLocation[] iTargetLocationArray = targetLocations;
            int n = targetLocations.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation location = iTargetLocationArray[n2];
                subMonitor.checkCanceled();
                subMonitor.subTask(Messages.TargetDefinition_4);
                P2TargetUtils synchronizer = (P2TargetUtils)location.getAdapter(P2TargetUtils.class);
                if (synchronizer == null) {
                    IStatus s2 = location.resolve(this, (IProgressMonitor)subMonitor.split(100));
                    if (!s2.isOK()) {
                        status.add(s2);
                    }
                } else {
                    synchronizers.computeIfAbsent(synchronizer, nil -> new ArrayList()).add(location);
                }
                ++n2;
            }
            if (!synchronizers.isEmpty()) {
                List delayedLocations = synchronizers.values().stream().flatMap(Collection::stream).toList();
                subMonitor.setWorkRemaining(synchronizers.size() * 100 + delayedLocations.size());
                for (Map.Entry entry : synchronizers.entrySet()) {
                    subMonitor.checkCanceled();
                    try {
                        ((P2TargetUtils)entry.getKey()).synchronize(this, (IProgressMonitor)subMonitor.split(100));
                        ((List)entry.getValue()).stream().map(loc -> loc.getStatus()).filter(Objects::nonNull).filter(s -> !s.isOK()).forEach(arg_0 -> ((MultiStatus)status).add(arg_0));
                    }
                    catch (CoreException e) {
                        PDECore.log(e.getStatus());
                        status.add(e.getStatus());
                    }
                }
                for (ITargetLocation location : delayedLocations) {
                    subMonitor.checkCanceled();
                    IStatus s3 = location.resolve(this, (IProgressMonitor)subMonitor.split(1));
                    if (s3.isOK()) continue;
                    status.add(s3);
                }
            }
            if (status.isOK()) {
                IStatus iStatus = this.fResolutionStatus = Status.OK_STATUS;
                return iStatus;
            }
            this.fResolutionStatus = status;
            MultiStatus multiStatus = this.fResolutionStatus;
            return multiStatus;
        }
        catch (OperationCanceledException e) {
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        finally {
            TargetPlatformHelper.addTargetDefinitionMap(this);
            subMonitor.done();
        }
    }

    @Override
    public boolean isResolved() {
        ITargetLocation[] containers = this.getTargetLocations();
        if (containers != null) {
            ITargetLocation[] iTargetLocationArray = containers;
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation targetLocation = iTargetLocationArray[n2];
                if (!targetLocation.isResolved()) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    @Override
    public IStatus getStatus() {
        if (this.fResolutionStatus != null && !this.fResolutionStatus.isOK()) {
            return this.fResolutionStatus;
        }
        if (this.isResolved()) {
            ITargetLocation[] containers = this.getTargetLocations();
            if (containers != null) {
                MultiStatus result = new MultiStatus("org.eclipse.pde.core", 0, Messages.TargetDefinition_5, null);
                ITargetLocation[] iTargetLocationArray = containers;
                int n = containers.length;
                int n2 = 0;
                while (n2 < n) {
                    ITargetLocation container = iTargetLocationArray[n2];
                    IStatus containerStatus = container.getStatus();
                    if (containerStatus != null && !containerStatus.isOK()) {
                        result.add(containerStatus);
                    }
                    ++n2;
                }
                TargetBundle[] bundles = this.getBundles();
                int i = 0;
                while (i < bundles.length) {
                    if (!bundles[i].getStatus().isOK()) {
                        result.add(bundles[i].getStatus());
                    }
                    ++i;
                }
                if (result.isOK()) {
                    return Status.OK_STATUS;
                }
                return result;
            }
            return Status.OK_STATUS;
        }
        return null;
    }

    @Override
    public void setIncluded(NameVersionDescriptor[] included) {
        this.fIncluded = included;
        if (included != null && this.fRoot != null) {
            Arrays.sort(included, (o1, o2) -> {
                int compareType = o1.getType().compareTo(o2.getType());
                if (compareType != 0) {
                    return compareType;
                }
                return o1.getId().compareTo(o2.getId());
            });
            Element includedElement = TargetDefinitionDocumentTools.getChildElement(this.fRoot, "includeBundles");
            this.serializeBundles(includedElement, included);
        } else {
            this.removeElement("includeBundles");
        }
    }

    @Override
    public NameVersionDescriptor[] getIncluded() {
        return this.fIncluded;
    }

    @Override
    public TargetBundle[] getBundles() {
        return this.getBundles(false);
    }

    @Override
    public TargetBundle[] getAllBundles() {
        return this.getBundles(true);
    }

    private TargetBundle[] getBundles(boolean allBundles) {
        if (this.isResolved()) {
            ITargetLocation[] containers = this.getTargetLocations();
            if (containers != null) {
                ArrayList all = new ArrayList();
                ITargetLocation[] iTargetLocationArray = containers;
                int n = containers.length;
                int n2 = 0;
                while (n2 < n) {
                    ITargetLocation container = iTargetLocationArray[n2];
                    TargetBundle[] bundles = container.getBundles();
                    if (bundles != null) {
                        Collections.addAll(all, bundles);
                    }
                    ++n2;
                }
                TargetBundle[] allResolvedBundles = all.toArray(new TargetBundle[all.size()]);
                if (allBundles) {
                    return allResolvedBundles;
                }
                return this.filterBundles(allResolvedBundles, this.getIncluded());
            }
            return new TargetBundle[0];
        }
        return null;
    }

    private TargetBundle[] filterBundles(TargetBundle[] bundles, NameVersionDescriptor[] filter) {
        if (filter == null) {
            return bundles;
        }
        if (filter.length == 0) {
            return new TargetBundle[0];
        }
        boolean containsFeatures = false;
        ArrayList<NameVersionDescriptor> missingFeatures = new ArrayList<NameVersionDescriptor>();
        ArrayList<NameVersionDescriptor> included = new ArrayList<NameVersionDescriptor>();
        NameVersionDescriptor[] nameVersionDescriptorArray = filter;
        int n = filter.length;
        int n2 = 0;
        while (n2 < n) {
            NameVersionDescriptor element = nameVersionDescriptorArray[n2];
            if (element.getType() == "plugin") {
                included.add(element);
            } else if (element.getType() == "feature") {
                containsFeatures = true;
                TargetFeature[] features = this.getAllFeatures();
                TargetFeature bestMatch = null;
                TargetFeature[] targetFeatureArray = features;
                int n3 = features.length;
                int n4 = 0;
                while (n4 < n3) {
                    TargetFeature feature = targetFeatureArray[n4];
                    if (feature.getId().equals(element.getId())) {
                        Version v2;
                        Version v1;
                        if (element.getVersion() != null) {
                            if (element.getVersion().equals(feature.getVersion())) {
                                bestMatch = feature;
                                break;
                            }
                        } else if (bestMatch != null && (v1 = Version.parseVersion((String)feature.getVersion())).compareTo((Object)(v2 = Version.parseVersion((String)bestMatch.getVersion()))) > 0) {
                            bestMatch = feature;
                        }
                        if (bestMatch == null) {
                            bestMatch = feature;
                        }
                    }
                    ++n4;
                }
                if (bestMatch != null) {
                    NameVersionDescriptor[] plugins = bestMatch.getPlugins();
                    Collections.addAll(included, plugins);
                } else {
                    missingFeatures.add(element);
                }
            }
            ++n2;
        }
        List<TargetBundle> result = TargetDefinition.getMatchingBundles(bundles, included.toArray(new NameVersionDescriptor[included.size()]), !containsFeatures);
        if (containsFeatures && !missingFeatures.isEmpty()) {
            for (NameVersionDescriptor missing : missingFeatures) {
                BundleInfo info = new BundleInfo(missing.getId(), missing.getVersion(), null, -1, false);
                String message = NLS.bind((String)Messages.TargetDefinition_RequiredFeatureCouldNotBeFound, (Object)missing.getId());
                Status status = new Status(4, "org.eclipse.pde.core", 110, message, null);
                result.add(new InvalidTargetBundle(info, (IStatus)status));
            }
        }
        return result.toArray(new TargetBundle[result.size()]);
    }

    static List<TargetBundle> getMatchingBundles(TargetBundle[] collection, NameVersionDescriptor[] included, boolean handleMissingBundles) {
        Object resolved;
        if (included == null) {
            ArrayList<TargetBundle> result = new ArrayList<TargetBundle>();
            result.addAll(Arrays.asList(collection));
            return result;
        }
        HashMap<String, List<TargetBundle>> bundleMap = new HashMap<String, List<TargetBundle>>(collection.length);
        TargetBundle[] targetBundleArray = collection;
        int n = collection.length;
        int n2 = 0;
        while (n2 < n) {
            resolved = targetBundleArray[n2];
            ArrayList<Object> list = (ArrayList<Object>)bundleMap.get(((TargetBundle)resolved).getBundleInfo().getSymbolicName());
            if (list == null) {
                list = new ArrayList<Object>(3);
                bundleMap.put(((TargetBundle)resolved).getBundleInfo().getSymbolicName(), list);
            }
            list.add(resolved);
            ++n2;
        }
        resolved = new ArrayList();
        NameVersionDescriptor[] nameVersionDescriptorArray = included;
        int n3 = included.length;
        n = 0;
        while (n < n3) {
            NameVersionDescriptor element = nameVersionDescriptorArray[n];
            BundleInfo info = new BundleInfo(element.getId(), element.getVersion(), null, -1, false);
            TargetBundle bundle = TargetDefinition.resolveBundle(bundleMap, info, handleMissingBundles);
            if (bundle != null) {
                resolved.add(bundle);
            }
            ++n;
        }
        return resolved;
    }

    private static TargetBundle resolveBundle(Map<String, List<TargetBundle>> bundleMap, BundleInfo info, boolean handleMissingBundles) {
        List<TargetBundle> list = bundleMap.get(info.getSymbolicName());
        if (list != null) {
            String version = info.getVersion();
            if (version == null || version.equals("0.0.0")) {
                if (list.size() > 1) {
                    Collections.sort(list, (o1, o2) -> {
                        BundleInfo b1 = o1.getBundleInfo();
                        BundleInfo b2 = o2.getBundleInfo();
                        try {
                            Version v1 = Version.create((String)b1.getVersion());
                            Version v2 = Version.create((String)b2.getVersion());
                            return v1.compareTo((Object)v2);
                        }
                        catch (IllegalArgumentException e) {
                            PDECore.log(e);
                            return b1.getVersion().compareTo(b2.getVersion());
                        }
                    });
                }
                TargetBundle rb = list.get(list.size() - 1);
                return rb;
            }
            for (TargetBundle bundle : list) {
                if (!bundle.getBundleInfo().getVersion().equals(version)) continue;
                return bundle;
            }
            for (TargetBundle bundle : list) {
                try {
                    org.osgi.framework.Version bundleVersion = new org.osgi.framework.Version(bundle.getBundleInfo().getVersion());
                    org.osgi.framework.Version infoVersion = new org.osgi.framework.Version(version);
                    if (bundleVersion.getMajor() != infoVersion.getMajor() || bundleVersion.getMinor() != infoVersion.getMinor() || bundleVersion.getMicro() != infoVersion.getMicro()) continue;
                    return bundle;
                }
                catch (IllegalArgumentException bundleVersion) {
                    // empty catch block
                }
            }
            if (!handleMissingBundles) {
                return null;
            }
            int sev = 4;
            String message = NLS.bind((String)Messages.AbstractBundleContainer_1, (Object[])new Object[]{info.getVersion(), info.getSymbolicName()});
            Status status = new Status(sev, "org.eclipse.pde.core", 101, message, null);
            return new InvalidTargetBundle(info, (IStatus)status);
        }
        if (!handleMissingBundles) {
            return null;
        }
        int sev = 4;
        String message = NLS.bind((String)Messages.AbstractBundleContainer_3, (Object)info.getSymbolicName());
        Status status = new Status(sev, "org.eclipse.pde.core", 100, message, null);
        return new InvalidTargetBundle(info, (IStatus)status);
    }

    @Override
    public ITargetHandle getHandle() {
        return this.fHandle;
    }

    void setContents(InputStream stream) throws CoreException {
        try {
            this.fArch = null;
            this.fContainers = null;
            this.fImplicit = null;
            this.fJREContainer = null;
            this.fIncluded = null;
            this.fName = null;
            this.fNL = null;
            this.fOS = null;
            this.fProgramArgs = null;
            this.fVMArgs = null;
            this.fWS = null;
            this.fSequenceNumber = 0;
            this.fDocument = null;
            this.fRoot = null;
            TargetDefinitionPersistenceHelper.initFromXML(this, stream);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.setDocument(TargetDefinition.createNewDocument());
            this.abort(Messages.TargetDefinition_0, e);
        }
    }

    void write(OutputStream stream) throws CoreException {
        try {
            if (this.fContainers != null && this.fContainers.length != 0) {
                Element containersElement = TargetDefinitionDocumentTools.getChildElement(this.fRoot, "locations");
                this.serializeBundleContainers(this.fContainers, containersElement);
            }
            TargetDefinitionPersistenceHelper.persistXML(this, stream);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            this.abort(Messages.TargetDefinition_3, e);
        }
    }

    private void abort(String message, Exception e) throws CoreException {
        throw new CoreException(Status.error((String)message, (Throwable)e));
    }

    @Override
    public NameVersionDescriptor[] getImplicitDependencies() {
        return this.fImplicit;
    }

    @Override
    public void setImplicitDependencies(NameVersionDescriptor[] bundles) {
        if (bundles != null && bundles.length == 0) {
            bundles = null;
        }
        this.fImplicit = bundles;
        if (this.fRoot != null && bundles != null && bundles.length > 0) {
            Element implicitDependenciesElement = TargetDefinitionDocumentTools.getChildElement(this.fRoot, "implicitDependencies");
            ArrayList<Element> descriptorElements = new ArrayList<Element>();
            NameVersionDescriptor[] nameVersionDescriptorArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                NameVersionDescriptor descriptor = nameVersionDescriptorArray[n2];
                Element plugin = this.fDocument.createElement("plugin");
                plugin.setAttribute("id", descriptor.getId());
                if (descriptor.getVersion() != null) {
                    plugin.setAttribute("version", descriptor.getVersion());
                }
                descriptorElements.add(plugin);
                ++n2;
            }
            TargetDefinitionDocumentTools.updateElements(implicitDependenciesElement, null, descriptorElements, (o1, o2) -> o1.getAttribute("id").compareTo(o2.getAttribute("id")));
        } else {
            this.removeElement("implicitDependencies");
        }
    }

    @Override
    public IPath getJREContainer() {
        return this.fJREContainer;
    }

    @Override
    public void setJREContainer(IPath containerPath) {
        this.fJREContainer = containerPath;
        if (this.fRoot != null && containerPath != null) {
            Element jreElement = TargetDefinitionDocumentTools.getChildElement(this.fRoot, "targetJRE");
            jreElement.setAttribute("path", containerPath.toPortableString());
        } else {
            this.removeElement("targetJRE");
        }
    }

    public boolean isContentEqual(ITargetDefinition definition) {
        return Objects.equals(this.getName(), definition.getName()) && Objects.equals(this.getArch(), definition.getArch()) && Objects.equals(this.getNL(), definition.getNL()) && Objects.equals(this.getOS(), definition.getOS()) && Objects.equals(this.getWS(), definition.getWS()) && Objects.equals(this.getProgramArguments(), definition.getProgramArguments()) && Objects.equals(this.getVMArguments(), definition.getVMArguments()) && Objects.equals(this.getJREContainer(), definition.getJREContainer()) && Arrays.equals(this.getIncluded(), definition.getIncluded()) && TargetDefinition.unorderedArraysEqualsSerialized(this.getTargetLocations(), definition.getTargetLocations()) && Arrays.equals(this.getImplicitDependencies(), definition.getImplicitDependencies());
    }

    public boolean isContentEquivalent(ITargetDefinition definition) {
        return Objects.equals(this.getArch(), definition.getArch()) && Objects.equals(this.getNL(), definition.getNL()) && Objects.equals(this.getOS(), definition.getOS()) && Objects.equals(this.getWS(), definition.getWS()) && this.isArgsNullOrEqual(this.getProgramArguments(), definition.getProgramArguments()) && this.isArgsNullOrEqual(this.getVMArguments(), definition.getVMArguments()) && Objects.equals(this.getJREContainer(), definition.getJREContainer()) && Arrays.equals(this.getIncluded(), definition.getIncluded()) && TargetDefinition.unorderedArraysEqualsSerialized(this.getTargetLocations(), definition.getTargetLocations()) && Arrays.equals(this.getImplicitDependencies(), definition.getImplicitDependencies());
    }

    private static boolean unorderedArraysEqualsSerialized(ITargetLocation[] one, ITargetLocation[] two) {
        if (one == two) {
            return true;
        }
        if (one == null || two == null || one.length != two.length) {
            return false;
        }
        Set oneXml = Arrays.stream(one).filter(Objects::nonNull).map(l -> Objects.requireNonNullElse(l.serialize(), l)).collect(Collectors.toSet());
        Set twoXml = Arrays.stream(two).filter(Objects::nonNull).map(l -> Objects.requireNonNullElse(l.serialize(), l)).collect(Collectors.toSet());
        return oneXml.equals(twoXml);
    }

    private boolean isArgsNullOrEqual(String args1, String args2) {
        return args1 == null && args2 == null || Arrays.equals(DebugPlugin.parseArguments((String)args1), DebugPlugin.parseArguments((String)args2));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.fName != null ? this.fName : "No Name");
        if (this.fContainers == null) {
            buf.append("\n\tNo containers");
        } else {
            ITargetLocation[] iTargetLocationArray = this.fContainers;
            int n = this.fContainers.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation fContainer = iTargetLocationArray[n2];
                buf.append("\n\t").append(fContainer.toString());
                ++n2;
            }
        }
        buf.append("\nEnv: ").append(this.fOS).append("/").append(this.fWS).append("/").append(this.fArch).append("/").append(this.fNL);
        buf.append("\nJRE: ").append(this.fJREContainer);
        buf.append("\nArgs: ").append(this.fProgramArgs).append("/").append(this.fVMArgs);
        buf.append("\nImplicit: ").append(this.fImplicit == null ? "null" : Integer.toString(this.fImplicit.length));
        buf.append("\nHandle: ").append(this.fHandle.toString());
        return buf.toString();
    }

    public TargetFeature[] resolveFeatures(String locationPath, IProgressMonitor monitor) throws CoreException {
        String path = locationPath;
        if (path == null) {
            path = TargetPlatform.getDefaultLocation();
        } else {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            path = manager.performStringSubstitution(path);
        }
        TargetFeature[] models = null;
        if (fFeaturesInLocation != null) {
            models = fFeaturesInLocation.get(path);
        }
        if (models != null) {
            return models;
        }
        models = ExternalFeatureModelManager.createFeatures(path, new ArrayList<String>(), monitor);
        fFeaturesInLocation.put(path, models);
        return models;
    }

    @Override
    public TargetFeature[] getAllFeatures() {
        if (!this.isResolved()) {
            return null;
        }
        if (this.fFeatures != null) {
            return this.fFeatures;
        }
        ITargetLocation[] containers = this.getTargetLocations();
        HashMap<NameVersionDescriptor, TargetFeature> result = new HashMap<NameVersionDescriptor, TargetFeature>();
        if (containers != null && containers.length > 0) {
            ITargetLocation[] iTargetLocationArray = containers;
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation container = iTargetLocationArray[n2];
                TargetFeature[] currentFeatures = container.getFeatures();
                if (currentFeatures != null && currentFeatures.length > 0) {
                    TargetFeature[] targetFeatureArray = currentFeatures;
                    int n3 = currentFeatures.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TargetFeature feature = targetFeatureArray[n4];
                        if (feature.getId() != null) {
                            NameVersionDescriptor key = new NameVersionDescriptor(feature.getId(), feature.getVersion());
                            result.put(key, feature);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        this.fFeatures = result.values().toArray(new TargetFeature[result.size()]);
        return this.fFeatures;
    }

    public TargetBundle[] getOtherBundles() {
        TargetFeature[] features;
        if (!this.isResolved()) {
            return null;
        }
        if (this.fOtherBundles != null) {
            return this.fOtherBundles;
        }
        TargetBundle[] allBundles = this.getAllBundles();
        HashMap<String, TargetBundle> remaining = new HashMap<String, TargetBundle>();
        TargetBundle[] targetBundleArray = allBundles;
        int n = allBundles.length;
        int n2 = 0;
        while (n2 < n) {
            TargetBundle allBundle = targetBundleArray[n2];
            remaining.put(allBundle.getBundleInfo().getSymbolicName(), allBundle);
            ++n2;
        }
        TargetFeature[] targetFeatureArray = features = this.getAllFeatures();
        int n3 = features.length;
        n = 0;
        while (n < n3) {
            NameVersionDescriptor[] plugins;
            TargetFeature feature = targetFeatureArray[n];
            NameVersionDescriptor[] nameVersionDescriptorArray = plugins = feature.getPlugins();
            int n4 = plugins.length;
            int n5 = 0;
            while (n5 < n4) {
                NameVersionDescriptor plugin = nameVersionDescriptorArray[n5];
                remaining.remove(plugin.getId());
                ++n5;
            }
            ++n;
        }
        Collection values = remaining.values();
        this.fOtherBundles = values.toArray(new TargetBundle[values.size()]);
        return this.fOtherBundles;
    }

    public Set<Object> getFeaturesAndBundles() {
        if (!this.isResolved()) {
            return null;
        }
        TargetFeature[] allFeatures = this.getAllFeatures();
        TargetBundle[] allExtraBundles = this.getOtherBundles();
        NameVersionDescriptor[] included = this.getIncluded();
        if (included == null) {
            HashSet<Object> result = new HashSet<Object>();
            result.addAll(Arrays.asList(allFeatures));
            result.addAll(Arrays.asList(allExtraBundles));
            return result;
        }
        HashSet<Object> result = new HashSet<Object>();
        NameVersionDescriptor[] nameVersionDescriptorArray = included;
        int n = included.length;
        int n2 = 0;
        while (n2 < n) {
            NameVersionDescriptor element = nameVersionDescriptorArray[n2];
            if (element.getType() == "plugin") {
                var12_13 = allExtraBundles;
                var11_12 = allExtraBundles.length;
                var10_11 = 0;
                while (var10_11 < var11_12) {
                    Object allExtraBundle = var12_13[var10_11];
                    if (((TargetBundle)allExtraBundle).getBundleInfo().getSymbolicName().equals(element.getId())) {
                        result.add(allExtraBundle);
                    }
                    ++var10_11;
                }
            } else if (element.getType() == "feature") {
                var12_13 = allFeatures;
                var11_12 = allFeatures.length;
                var10_11 = 0;
                while (var10_11 < var11_12) {
                    Object allFeature = var12_13[var10_11];
                    if (((TargetFeature)allFeature).getId().equals(element.getId())) {
                        result.add(allFeature);
                    }
                    ++var10_11;
                }
            }
            ++n2;
        }
        return result;
    }

    public int getUIMode() {
        return this.fUIMode;
    }

    public void setUIMode(int mode) {
        this.fUIMode = mode;
        if (this.fRoot != null && mode == 1) {
            this.fRoot.setAttribute("includeMode", "feature");
        }
    }

    public int getSequenceNumber() {
        return this.fSequenceNumber;
    }

    public int incrementSequenceNumber() {
        return ++this.fSequenceNumber;
    }

    void setSequenceNumber(int value) {
        this.fSequenceNumber = value;
    }

    private void removeElement(String ... childNames) {
        if (this.fRoot != null) {
            TargetDefinitionDocumentTools.removeElement(this.fRoot, childNames);
        }
    }

    private void serializeBundleContainers(ITargetLocation[] targetLocations, Element containersElement) throws DOMException, CoreException, SAXException, IOException, ParserConfigurationException {
        String type;
        ArrayList<Element> newContainers = new ArrayList<Element>();
        ArrayList<Element> newIUContainers = new ArrayList<Element>();
        ArrayList<Element> newGenericContainers = new ArrayList<Element>();
        ArrayList<Element> oldContainers = new ArrayList<Element>();
        ArrayList<Element> oldIUContainers = new ArrayList<Element>();
        ArrayList<Element> oldGenericContainers = new ArrayList<Element>();
        DocumentBuilder docBuilder = XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE();
        ITargetLocation[] iTargetLocationArray = targetLocations;
        int n = targetLocations.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetLocation targetLocation = iTargetLocationArray[n2];
            type = targetLocation.getType();
            if (targetLocation instanceof DirectoryBundleContainer) {
                containerElement = this.createContainerElement(type, targetLocation.getLocation(false));
                newContainers.add(containerElement);
            } else if (targetLocation instanceof FeatureBundleContainer) {
                containerElement = this.createContainerElement(type, targetLocation.getLocation(false));
                String version = ((FeatureBundleContainer)targetLocation).getFeatureVersion();
                String id = ((FeatureBundleContainer)targetLocation).getFeatureId();
                if (version != null) {
                    containerElement.setAttribute("version", version);
                }
                if (id != null) {
                    containerElement.setAttribute("id", id);
                }
                newContainers.add(containerElement);
            } else if (targetLocation instanceof ProfileBundleContainer) {
                containerElement = this.createContainerElement(type, targetLocation.getLocation(false));
                String configurationArea = ((ProfileBundleContainer)targetLocation).getConfigurationLocation();
                if (configurationArea != null) {
                    containerElement.setAttribute("configuration", configurationArea);
                }
                newContainers.add(containerElement);
            } else {
                String xml = targetLocation.serialize();
                if (xml != null) {
                    Document document = docBuilder.parse(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
                    Element root = document.getDocumentElement();
                    if (!root.getNodeName().equalsIgnoreCase("location")) {
                        throw new CoreException(Status.error((String)NLS.bind((String)Messages.TargetDefinitionPersistenceHelper_WrongRootElementInXML, (Object)type, (Object)xml)));
                    }
                    root.setAttribute("type", type);
                    if ("InstallableUnit".equals(type)) {
                        newIUContainers.add(root);
                    } else {
                        newGenericContainers.add(root);
                    }
                }
            }
            ++n2;
        }
        NodeList nodes = containersElement.getChildNodes();
        int j = 0;
        while (j < nodes.getLength()) {
            block29: {
                Node node = nodes.item(j);
                if (!(node instanceof Element)) break block29;
                Element element = (Element)node;
                if (!node.getNodeName().equalsIgnoreCase("location")) break block29;
                switch (type = element.getAttribute("type")) {
                    case "InstallableUnit": {
                        oldIUContainers.add(element);
                        break;
                    }
                    case "Feature": 
                    case "Directory": 
                    case "Profile": {
                        oldContainers.add(element);
                        break;
                    }
                    default: {
                        oldGenericContainers.add(element);
                    }
                }
            }
            ++j;
        }
        this.updateContainerElements(containersElement, oldContainers, newContainers);
        this.updateGenericContainerElements(containersElement, oldGenericContainers, newGenericContainers);
        this.updateIUContainerElements(containersElement, oldIUContainers, newIUContainers);
    }

    private Element createContainerElement(String type, String path) {
        Element containerElement = this.fDocument.createElement("location");
        containerElement.setAttribute("type", type);
        containerElement.setAttribute("path", path);
        return containerElement;
    }

    private void updateGenericContainerElements(Element containersElement, List<Element> oldContainers, List<Element> newContainers) {
        TargetDefinitionDocumentTools.updateElements(containersElement, oldContainers, newContainers, null);
    }

    private void updateContainerElements(Element containersElement, List<Element> oldContainers, List<Element> newContainers) {
        TargetDefinitionDocumentTools.updateElements(containersElement, oldContainers, newContainers, (o1, o2) -> {
            int typeCompare = o1.getAttribute("type").compareTo(o2.getAttribute("type"));
            int pathCompare = o1.getAttribute("path").compareTo(o2.getAttribute("path"));
            int idCompare = 0;
            if (o1 instanceof FeatureBundleContainer) {
                idCompare = o1.getAttribute("id").compareTo(o2.getAttribute("id"));
            }
            return typeCompare == 0 && pathCompare == 0 && idCompare == 0 ? 0 : 1;
        });
    }

    private void updateIUContainerElements(Element containersElement, List<Element> oldContainers, List<Element> newContainers) {
        Node node;
        String repoURL;
        ArrayList<Element> units;
        NodeList nodes;
        HashMap oldContainersByRepo = new HashMap();
        HashMap<Element, ArrayList<Element>> oldUnitsByContainer = new HashMap<Element, ArrayList<Element>>();
        for (Element element : oldContainers) {
            nodes = element.getChildNodes();
            units = new ArrayList<Element>();
            repoURL = null;
            int i = 0;
            while (i < nodes.getLength()) {
                node = nodes.item(i);
                if (node instanceof Element) {
                    if (repoURL == null && node.getNodeName().equalsIgnoreCase("repository")) {
                        repoURL = ((Element)node).getAttribute("location");
                        if (!oldContainersByRepo.containsKey(repoURL)) {
                            oldContainersByRepo.put(repoURL, new ArrayList());
                        }
                        ((List)oldContainersByRepo.get(repoURL)).add(element);
                    } else if (node.getNodeName().equalsIgnoreCase("unit")) {
                        units.add((Element)node);
                    }
                }
                ++i;
            }
            if (repoURL != null) {
                oldUnitsByContainer.put(element, units);
                continue;
            }
            TargetDefinitionDocumentTools.removeChildAndWhitespace(element);
        }
        for (Element element : newContainers) {
            nodes = element.getChildNodes();
            units = new ArrayList();
            repoURL = null;
            int i = 0;
            while (i < nodes.getLength()) {
                node = nodes.item(i);
                if (node instanceof Element) {
                    if (repoURL == null && node.getNodeName().equalsIgnoreCase("repository")) {
                        repoURL = ((Element)node).getAttribute("location");
                    } else if (node.getNodeName().equalsIgnoreCase("unit")) {
                        units.add((Element)node);
                    }
                }
                ++i;
            }
            if (repoURL == null) continue;
            if (oldContainersByRepo.containsKey(repoURL)) {
                Element oldContainer = (Element)((List)oldContainersByRepo.get(repoURL)).get(0);
                TargetDefinitionDocumentTools.updateElements(oldContainer, (List)oldUnitsByContainer.get(oldContainer), units, (o1, o2) -> o1.getAttribute("id").compareTo(o2.getAttribute("id")));
                if (((List)oldContainersByRepo.get(repoURL)).size() == 1) {
                    oldContainersByRepo.remove(repoURL);
                    continue;
                }
                ((List)oldContainersByRepo.get(repoURL)).remove(0);
                continue;
            }
            Node movedContainer = this.fDocument.importNode(element, true);
            TargetDefinitionDocumentTools.addChildWithIndent(containersElement, movedContainer);
        }
        for (Map.Entry entry : oldContainersByRepo.entrySet()) {
            ((List)entry.getValue()).forEach(TargetDefinitionDocumentTools::removeChildAndWhitespace);
        }
    }

    private void serializeBundles(Element parent, NameVersionDescriptor[] bundles) {
        ArrayList<Element> bundlElements = new ArrayList<Element>();
        NameVersionDescriptor[] nameVersionDescriptorArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            NameVersionDescriptor bundle = nameVersionDescriptorArray[n2];
            if (bundle.getType() == "feature") {
                includedBundle = this.fDocument.createElement("feature");
                includedBundle.setAttribute("id", bundle.getId());
                version = bundle.getVersion();
                if (version != null) {
                    includedBundle.setAttribute("version", version);
                }
                bundlElements.add(includedBundle);
            } else {
                includedBundle = this.fDocument.createElement("plugin");
                includedBundle.setAttribute("id", bundle.getId());
                version = bundle.getVersion();
                if (version != null) {
                    includedBundle.setAttribute("version", version);
                }
                bundlElements.add(includedBundle);
            }
            ++n2;
        }
        TargetDefinitionDocumentTools.updateElements(parent, null, bundlElements, (o1, o2) -> o1.getAttribute("id").compareTo(o2.getAttribute("id")));
    }
}

