/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.xbase.lib.Pure;

@FinalFieldsConstructor
@SuppressWarnings("all")
public class QueryRegistryTreePackage {
  @Accessors(AccessorType.PUBLIC_GETTER)
  private final QueryRegistryTreeSource parent;

  @Accessors(AccessorType.PUBLIC_GETTER)
  private final String packageName;

  @Accessors(AccessorType.PUBLIC_GETTER)
  private final Map<String, QueryRegistryTreeEntry> entries = Maps.<String, QueryRegistryTreeEntry>newTreeMap();

  @Pure
  public QueryRegistryTreeSource getParent() {
    return this.parent;
  }

  @Pure
  public String getPackageName() {
    return this.packageName;
  }

  @Pure
  public Map<String, QueryRegistryTreeEntry> getEntries() {
    return this.entries;
  }

  public QueryRegistryTreePackage(final QueryRegistryTreeSource parent, final String packageName) {
    super();
    this.parent = parent;
    this.packageName = packageName;
  }
}
