/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutAnimator;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.HideNodeHelper;
import org.eclipse.zest.core.widgets.IContainer;
import org.eclipse.zest.core.widgets.internal.AspectRatioFreeformLayer;
import org.eclipse.zest.core.widgets.internal.ContainerFigure;
import org.eclipse.zest.core.widgets.internal.ExpandGraphLabel;
import org.eclipse.zest.core.widgets.internal.ZestRootLayer;
import org.eclipse.zest.layouts.InvalidLayoutConfiguration;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;

public class GraphContainer
extends GraphNode
implements IContainer {
    private static final double SCALED_WIDTH = 300.0;
    private static final double SCALED_HEIGHT = 200.0;
    private static final int CONTAINER_HEIGHT = 200;
    private static final int MIN_WIDTH = 250;
    private static final int ANIMATION_TIME = 100;
    private static final int SUBLAYER_OFFSET = 2;
    private ExpandGraphLabel expandGraphLabel;
    private List<GraphNode> childNodes = null;
    private int childAreaHeight = 200;
    public ZestRootLayer zestLayer;
    private ScrollPane scrollPane;
    private LayoutAlgorithm layoutAlgorithm;
    private boolean isExpanded = false;
    private AspectRatioFreeformLayer scalledLayer;

    public GraphContainer(IContainer graph, int style) {
        this(graph, style, "");
    }

    public GraphContainer(IContainer graph, int style, String text) {
        this(graph, style, text, null);
    }

    public GraphContainer(IContainer graph, int style, String text, Image image) {
        super(graph, style, text, image);
        this.initModel(graph, text, image);
        this.close(false);
        this.childNodes = new ArrayList<GraphNode>();
    }

    public void setCustomFigure(IFigure nodeFigure) {
        throw new RuntimeException("Operation not supported:  Containers cannot have custom figures");
    }

    @Override
    public IFigure getNodeFigure() {
        return this.nodeFigure;
    }

    public void close(boolean animate) {
        if (animate) {
            Animation.markBegin();
        }
        this.isExpanded = false;
        this.expandGraphLabel.setExpandedState(2);
        Rectangle newBounds = this.scrollPane.getBounds().getCopy();
        newBounds.height = 0;
        this.scrollPane.setSize(this.scrollPane.getSize().width, 0);
        this.updateFigureForModel((IFigure)this.zestLayer);
        this.scrollPane.setVisible(false);
        for (IFigure child : this.zestLayer.getChildren()) {
            GraphNode gn;
            HideNodeHelper hideNodeHelper;
            GraphItem item = this.getGraph().getGraphItem(child);
            item.setVisible(false);
            if (!(item instanceof GraphNode) || (hideNodeHelper = (gn = (GraphNode)item).getHideNodeHelper()) == null) continue;
            hideNodeHelper.resetCounter();
        }
        Rectangle containerBounds = new Rectangle(this.getLocation(), new Dimension(this.getSize().width, 200 + this.expandGraphLabel.getSize().height));
        this.moveNodesUp(containerBounds, this);
        if (animate) {
            Animation.run((int)100);
        }
        this.updateFigureForModel(this.getModelFigure());
    }

    private static void addNodeToOrderedList(List orderedNodeList, GraphNode node) {
        Iterator orderedNodeIterator = orderedNodeList.iterator();
        int counter = 0;
        while (orderedNodeIterator.hasNext()) {
            GraphNode nextOrderedNode = (GraphNode)((Object)orderedNodeIterator.next());
            if (nextOrderedNode.getLocation().y + nextOrderedNode.getBounds().height > node.getLocation().y + node.getBounds().height) break;
            ++counter;
        }
        orderedNodeList.add(counter, node);
    }

    private static List getOrderedNodesBelowY(List nodes, int yValue, GraphNode yValueNode) {
        Iterator iterator = nodes.iterator();
        LinkedList orderedNode = new LinkedList();
        while (iterator.hasNext()) {
            GraphNode node = (GraphNode)((Object)iterator.next());
            if (node == yValueNode || node.getLocation().y + node.getBounds().height <= yValue) continue;
            GraphContainer.addNodeToOrderedList(orderedNode, node);
        }
        ArrayList arrayList = new ArrayList();
        iterator = orderedNode.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    private static boolean nodeInStripe(int left, int right, GraphNode node) {
        return node.getBounds().x < right && node.getBounds().x + node.getBounds().width > left;
    }

    void pack(Graph g) {
        GraphNode highestNode = GraphContainer.getHighestNode(g);
        this.moveNodesUp(highestNode.getBounds(), highestNode);
    }

    static GraphNode getHighestNode(Graph g) {
        GraphNode lowest = null;
        for (GraphNode graphNode : g.getNodes()) {
            if (lowest != null && lowest.getBounds().y <= graphNode.getBounds().y) continue;
            lowest = graphNode;
        }
        return lowest;
    }

    private void moveNodesUp(Rectangle containerBounds, GraphNode graphContainer) {
        List orderedNodesBelowY = GraphContainer.getOrderedNodesBelowY(this.parent.getNodes(), containerBounds.y, graphContainer);
        int leftSide = containerBounds.x;
        int rightSide = containerBounds.x + containerBounds.width;
        LinkedList nodesToConsider = new LinkedList(orderedNodesBelowY);
        GraphContainer.addNodeToOrderedList(orderedNodesBelowY, graphContainer);
        while (!nodesToConsider.isEmpty()) {
            GraphNode node = (GraphNode)((Object)nodesToConsider.get(0));
            if (GraphContainer.nodeInStripe(leftSide, rightSide, node)) {
                leftSide = Math.min(leftSide, node.getBounds().x);
                rightSide = Math.max(rightSide, node.getBounds().x + node.getBounds().width);
                GraphNode previousNode = null;
                int i = 0;
                while (i < orderedNodesBelowY.size()) {
                    if (orderedNodesBelowY.get(i) == node) break;
                    ++i;
                }
                int j = i - 1;
                while (j >= 0) {
                    GraphNode pastNode = (GraphNode)((Object)orderedNodesBelowY.get(j));
                    if (GraphContainer.nodeInStripe(node.getBounds().x, node.getBounds().x + node.getBounds().width, pastNode)) {
                        previousNode = pastNode;
                        break;
                    }
                    --j;
                }
                if (previousNode == null) {
                    previousNode = graphContainer;
                }
                int previousLocation = previousNode.getBounds().y + previousNode.getBounds().height + 2;
                orderedNodesBelowY.remove(i);
                node.setLocation(node.getLocation().x, previousLocation);
                GraphContainer.addNodeToOrderedList(orderedNodesBelowY, node);
            }
            nodesToConsider.remove((Object)node);
        }
    }

    public void open(boolean animate) {
        if (animate) {
            Animation.markBegin();
        }
        this.isExpanded = true;
        this.expandGraphLabel.setExpandedState(1);
        this.scrollPane.setSize(this.computeChildArea());
        this.scrollPane.setVisible(true);
        for (IFigure child : this.zestLayer.getChildren()) {
            GraphItem item = this.getGraph().getGraphItem(child);
            item.setVisible(true);
        }
        this.updateFigureForModel(this.getModelFigure());
        Rectangle containerBounds = new Rectangle(this.getLocation(), new Dimension(this.getSize().width, 200 + this.expandGraphLabel.getSize().height));
        this.moveNodesDown(containerBounds, this);
        this.moveNodesUp(containerBounds, this);
        if (animate) {
            Animation.run((int)100);
        }
        this.getFigure().getUpdateManager().performValidation();
    }

    private void moveNodesDown(Rectangle containerBounds, GraphContainer graphContainer) {
        List nodesBelowHere = GraphContainer.getOrderedNodesBelowY(this.parent.getNodes(), containerBounds.y, graphContainer);
        Iterator nodesBelowHereIterator = nodesBelowHere.iterator();
        LinkedList<GraphNode> nodesToMove = new LinkedList<GraphNode>();
        int left = containerBounds.x;
        int right = containerBounds.x + containerBounds.width;
        while (nodesBelowHereIterator.hasNext()) {
            GraphNode node = (GraphNode)((Object)nodesBelowHereIterator.next());
            if (!GraphContainer.nodeInStripe(left, right, node)) continue;
            nodesToMove.add(node);
            left = Math.min(left, node.getBounds().x);
            right = Math.max(right, node.getBounds().x + node.getBounds().width);
        }
        List intersectingNodes = this.intersectingNodes(containerBounds, nodesToMove, graphContainer);
        int delta = this.getMaxMovement(containerBounds, intersectingNodes);
        if (delta > 0) {
            this.shiftNodesDown(nodesToMove, delta);
        }
    }

    void highlightNode(GraphNode node) {
    }

    void highlightEdge(GraphConnection connection) {
    }

    void highlightNode(GraphContainer container) {
    }

    void unhighlightNode(GraphNode node) {
    }

    void unhighlightNode(GraphContainer container) {
    }

    private List intersectingNodes(Rectangle bounds, List nodesToCheck, GraphNode node) {
        LinkedList<GraphNode> result = new LinkedList<GraphNode>();
        for (GraphNode nodeToCheck : nodesToCheck) {
            if (node == nodeToCheck || !bounds.intersects(nodeToCheck.getBounds())) continue;
            result.add(nodeToCheck);
        }
        return result;
    }

    private int getMaxMovement(Rectangle bounds, List nodesToMove) {
        Iterator iterator = nodesToMove.iterator();
        int maxMovement = 0;
        while (iterator.hasNext()) {
            GraphNode node = (GraphNode)((Object)iterator.next());
            int yValue = node.getLocation().y;
            int distanceFromBottom = bounds.y + bounds.height - yValue;
            maxMovement = Math.max(maxMovement, distanceFromBottom);
        }
        return maxMovement + 3;
    }

    private void shiftNodesDown(List nodesToShift, int amount) {
        for (GraphNode node : nodesToShift) {
            node.setLocation(node.getLocation().x, node.getLocation().y + amount);
        }
    }

    @Override
    public Graph getGraph() {
        return this.graph.getGraph();
    }

    @Override
    public int getItemType() {
        return 3;
    }

    @Override
    public void setLayoutAlgorithm(LayoutAlgorithm algorithm, boolean applyLayout) {
        this.layoutAlgorithm = algorithm;
        if (applyLayout) {
            this.applyLayout();
        }
    }

    public LayoutAlgorithm getLayoutAlgorithm() {
        return this.layoutAlgorithm;
    }

    @Override
    public void applyLayout() {
        if (this.getNodes().isEmpty()) {
            return;
        }
        int layoutStyle = 0;
        if (this.checkStyle(16)) {
            layoutStyle = 1;
        }
        if (this.layoutAlgorithm == null) {
            this.layoutAlgorithm = new TreeLayoutAlgorithm(layoutStyle);
        }
        this.layoutAlgorithm.setStyle(this.layoutAlgorithm.getStyle() | layoutStyle);
        Dimension d = new Dimension();
        d.width = 300;
        d.height = 200;
        d.width -= 10;
        d.height -= 10;
        if (d.isEmpty()) {
            return;
        }
        LayoutRelationship[] connectionsToLayout = this.getGraph().getConnectionsToLayout(this.getNodes());
        LayoutEntity[] nodesToLayout = this.getGraph().getNodesToLayout(this.getNodes());
        try {
            Animation.markBegin();
            this.layoutAlgorithm.applyLayout(nodesToLayout, connectionsToLayout, 25.0, 25.0, (double)(d.width - 50), (double)(d.height - 50), false, false);
            Animation.run((int)100);
            this.getFigure().getUpdateManager().performUpdate();
        }
        catch (InvalidLayoutConfiguration e) {
            e.printStackTrace();
        }
    }

    public double getScale() {
        return this.scalledLayer.getScale();
    }

    public void setScale(double scale) {
        this.scalledLayer.setScale(scale);
    }

    @Override
    protected Rectangle getHideContainerBounds() {
        Point loc = this.getLocation();
        ContainerDimension containerDimension = this.computeContainerSize();
        Dimension size = new Dimension(containerDimension.width + 10, containerDimension.labelHeight + 10);
        return new Rectangle(loc, size);
    }

    @Override
    protected void initFigure() {
        this.setModelFigure(this.createContainerFigure());
        if (this.graph.getHideNodesEnabled()) {
            this.nodeFigure = new ContainerFigure();
            this.nodeFigure.add(this.getModelFigure());
            this.setHideNodeHelper(new HideNodeHelper(this));
        } else {
            this.nodeFigure = this.getModelFigure();
        }
    }

    private Dimension computeChildArea() {
        ContainerDimension containerDimension = this.computeContainerSize();
        Dimension dimension = new Dimension();
        dimension.width = containerDimension.width;
        dimension.height = containerDimension.expandedHeight - containerDimension.labelHeight + 2;
        return dimension;
    }

    private ContainerDimension computeContainerSize() {
        ContainerDimension dimension = new ContainerDimension();
        int labelHeight = this.expandGraphLabel.getPreferredSize().height;
        int labelWidth = this.expandGraphLabel.getPreferredSize().width;
        if (labelWidth < 250) {
            labelWidth = 250;
            this.expandGraphLabel.setPreferredSize(labelWidth, labelHeight);
        }
        if (labelHeight < 30) {
            labelHeight = 30;
        }
        dimension.labelHeight = labelHeight;
        dimension.width = labelWidth;
        dimension.width = Math.max(dimension.width, this.size.width);
        dimension.expandedHeight = dimension.labelHeight + this.childAreaHeight - 2;
        dimension.expandedHeight = Math.max(dimension.expandedHeight, this.size.height);
        return dimension;
    }

    private double computeHeightScale() {
        Dimension childArea = this.computeChildArea();
        return (double)childArea.height / 200.0;
    }

    private double computeWidthScale() {
        Dimension childArea = this.computeChildArea();
        return (double)childArea.width / 300.0;
    }

    private IFigure createContainerFigure() {
        GraphContainer node = this;
        ContainerFigure containerFigure = new ContainerFigure();
        containerFigure.setOpaque(true);
        containerFigure.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        containerFigure.setLayoutManager((LayoutManager)new FreeformLayout());
        this.expandGraphLabel = new ExpandGraphLabel(this, node.getText(), node.getImage(), false);
        this.expandGraphLabel.setText(this.getText());
        this.expandGraphLabel.setImage(this.getImage());
        ContainerDimension containerDimension = this.computeContainerSize();
        this.scrollPane = new ScrollPane();
        this.scrollPane.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        FreeformViewport viewport = new FreeformViewport();
        this.scrollPane.setViewport((Viewport)viewport);
        viewport.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        this.scrollPane.setScrollBarVisibility(1);
        this.scalledLayer = new AspectRatioFreeformLayer("debug label");
        this.scalledLayer.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        this.scalledLayer.setScale(this.computeWidthScale(), this.computeHeightScale());
        this.zestLayer = new ZestRootLayer();
        this.zestLayer.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        this.scalledLayer.add((IFigure)this.zestLayer);
        this.zestLayer.setLayoutManager((LayoutManager)new FreeformLayout());
        this.scrollPane.setSize(this.computeChildArea());
        this.scrollPane.setLocation(new Point(0, containerDimension.labelHeight - 2));
        this.scrollPane.setForegroundColor(ColorConstants.gray);
        this.expandGraphLabel.setBackgroundColor(this.getBackgroundColor());
        this.expandGraphLabel.setForegroundColor(this.getForegroundColor());
        this.expandGraphLabel.setLocation(new Point(0, 0));
        containerFigure.add((IFigure)this.scrollPane);
        containerFigure.add((IFigure)this.expandGraphLabel);
        this.scrollPane.getViewport().setContents((IFigure)this.scalledLayer);
        this.scrollPane.setBorder((Border)new LineBorder());
        return containerFigure;
    }

    @Override
    protected void updateFigureForModel(IFigure currentFigure) {
        this.expandGraphLabel.setTextT(this.getText());
        this.expandGraphLabel.setImage(this.getImage());
        this.expandGraphLabel.setFont(this.getFont());
        if (this.highlighted == 1) {
            this.expandGraphLabel.setForegroundColor(this.getForegroundColor());
            this.expandGraphLabel.setBackgroundColor(this.getHighlightColor());
        } else {
            this.expandGraphLabel.setForegroundColor(this.getForegroundColor());
            this.expandGraphLabel.setBackgroundColor(this.getBackgroundColor());
        }
        ContainerDimension containerDimension = this.computeContainerSize();
        this.expandGraphLabel.setSize(containerDimension.width, containerDimension.labelHeight);
        if (this.isExpanded) {
            this.setSize(containerDimension.width, containerDimension.expandedHeight);
        } else {
            this.setSize(containerDimension.width, containerDimension.labelHeight);
        }
        this.scrollPane.setLocation(new Point(this.expandGraphLabel.getLocation().x, this.expandGraphLabel.getLocation().y + containerDimension.labelHeight - 2));
    }

    @Override
    protected void refreshLocation() {
        if (this.nodeFigure == null || this.nodeFigure.getParent() == null) {
            return;
        }
        Point loc = this.getLocation();
        ContainerDimension containerDimension = this.computeContainerSize();
        Dimension size = new Dimension();
        this.expandGraphLabel.setSize(containerDimension.width, containerDimension.labelHeight);
        this.childAreaHeight = this.computeChildArea().height;
        if (this.isExpanded) {
            size.width = containerDimension.width;
            size.height = containerDimension.expandedHeight;
        } else {
            size.width = containerDimension.width;
            size.height = containerDimension.labelHeight;
        }
        Rectangle bounds = new Rectangle(loc, size);
        this.nodeFigure.getParent().setConstraint(this.nodeFigure, (Object)bounds);
        this.scrollPane.setLocation(new Point(this.expandGraphLabel.getLocation().x, this.expandGraphLabel.getLocation().y + containerDimension.labelHeight - 2));
        this.scrollPane.setSize(this.computeChildArea());
        this.scalledLayer.setScale(this.computeWidthScale(), this.computeHeightScale());
        if (this.getHideNodeHelper() != null) {
            bounds.width += 10;
            bounds.height += 10;
            this.getHideNodeHelper().updateNodeBounds(bounds);
        }
    }

    void addConnectionFigure(PolylineConnection connection) {
        this.getModelFigure().add((IFigure)connection);
    }

    void addNode(GraphNode node) {
        this.zestLayer.addNode(node.getNodeFigure());
        if (!this.childNodes.contains((Object)node)) {
            this.childNodes.add(node);
        }
    }

    void addNode(GraphContainer container) {
    }

    @Override
    public List<GraphNode> getNodes() {
        return this.childNodes;
    }

    @Override
    void paint() {
        for (GraphNode node : this.getNodes()) {
            node.paint();
        }
    }

    class ContainerDimension {
        int width;
        int labelHeight;
        int expandedHeight;

        ContainerDimension() {
        }
    }
}

