/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.javamail.store.pop3.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.IllegalWriteException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import org.apache.geronimo.javamail.store.pop3.POP3CommandFactory;
import org.apache.geronimo.javamail.store.pop3.POP3Connection;
import org.apache.geronimo.javamail.store.pop3.POP3Folder;
import org.apache.geronimo.javamail.store.pop3.POP3Response;
import org.apache.geronimo.javamail.store.pop3.response.POP3ListResponse;
import org.apache.geronimo.javamail.store.pop3.response.POP3ResponseFactory;

public class POP3Message
extends MimeMessage {
    private POP3Connection pop3Con;
    private int msgSize = -1;
    private int headerSize = -1;
    private InputStream rawHeaders;
    private boolean loadHeaders = true;
    private Session session;

    protected POP3Message(Folder folder, int msgnum, Session session, POP3Connection pop3Con) {
        super(folder, msgnum);
        this.pop3Con = pop3Con;
        this.session = session;
    }

    protected InputStream getContentStream() throws MessagingException {
        POP3Response msgResponse = null;
        try {
            msgResponse = this.pop3Con.sendCommand(POP3CommandFactory.getCOMMAND_RETR(this.msgnum));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loadHeaders = true;
        this.loadHeaders(msgResponse.getData());
        this.loadContent(msgResponse.getData());
        return this.contentStream;
    }

    public void setFlags(Flags newFlags, boolean set) throws MessagingException {
        Flags oldFlags = (Flags)this.flags.clone();
        super.setFlags(newFlags, set);
        if (!this.flags.equals(oldFlags)) {
            ((POP3Folder)this.folder).notifyMessageChangedListeners(1, this);
        }
    }

    protected void loadHeaders(InputStream in) throws MessagingException {
        if (this.loadHeaders || this.rawHeaders == null) {
            this.rawHeaders = in;
            this.headers = new InternetHeaders(this.rawHeaders);
            this.loadHeaders = false;
        }
    }

    protected void loadContent(InputStream stream) throws MessagingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int byteRead = stream.read();
            int lastByte = -1;
            while (byteRead > 0 && (byteRead != 32 || lastByte != 10)) {
                lastByte = byteRead;
                byteRead = stream.read();
            }
            while (stream.available() > 0) {
                out.write(stream.read());
            }
            this.contentStream = new ByteArrayInputStream(out.toByteArray());
            this.msgSize = this.contentStream.available();
        }
        catch (IOException e) {
            throw new MessagingException("Error loading content info", e);
        }
    }

    public int getSize() throws MessagingException {
        if (this.msgSize >= 0) {
            return this.msgSize;
        }
        try {
            if (this.msgSize < 0) {
                if (this.rawHeaders == null) {
                    this.loadHeaders();
                }
                POP3ListResponse res = (POP3ListResponse)POP3ResponseFactory.getListResponse(this.pop3Con.sendCommand(POP3CommandFactory.getCOMMAND_LIST(this.msgnum)));
                this.msgSize = res.getSize() - this.headerSize;
            }
            return this.msgSize;
        }
        catch (MessagingException ex) {
            throw new MessagingException("error getting size", ex);
        }
    }

    protected void loadHeaders() throws MessagingException {
        POP3Response msgResponse = null;
        try {
            msgResponse = this.pop3Con.sendCommand(POP3CommandFactory.getCOMMAND_TOP(this.msgnum, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loadHeaders(msgResponse.getData());
    }

    public String[] getHeader(String name) throws MessagingException {
        if (this.rawHeaders == null) {
            this.loadHeaders();
        }
        return this.headers.getHeader(name);
    }

    public String getHeader(String name, String delimiter) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getHeader(name, delimiter);
    }

    public Enumeration getAllHeaders() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getMatchingHeaders(names);
    }

    public Enumeration getNonMatchingHeaders(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getNonMatchingHeaders(names);
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getMatchingHeaderLines(names);
    }

    public Enumeration getNonMatchingHeaderLines(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getNonMatchingHeaderLines(names);
    }

    public void addHeader(String name, String value) throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    public void setHeader(String name, String value) throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    public void removeHeader(String name) throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    public void addHeaderLine(String line) throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    public void saveChanges() throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }
}

