/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;

public class SecurityUtil {
    private SecurityUtil() {
    }

    public static String formatMessage(final String pattern, final Object ... args) {
        String piTmp0 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return MessageFormat.format(pattern, args);
            }
        });
        return piTmp0;
    }

    public static FileInputStream newFileInputStream(final File file) throws FileNotFoundException {
        FileInputStream piTmp0;
        block2: {
            piTmp0 = null;
            try {
                piTmp0 = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                    @Override
                    public FileInputStream run() throws FileNotFoundException {
                        return new FileInputStream(file);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (!(typedException instanceof FileNotFoundException)) break block2;
                throw (FileNotFoundException)typedException;
            }
        }
        return piTmp0;
    }

    public static FileInputStream newFileInputStream(final String filename) throws FileNotFoundException {
        FileInputStream piTmp0;
        block2: {
            piTmp0 = null;
            try {
                piTmp0 = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                    @Override
                    public FileInputStream run() throws FileNotFoundException {
                        return new FileInputStream(filename);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (!(typedException instanceof FileNotFoundException)) break block2;
                throw (FileNotFoundException)typedException;
            }
        }
        return piTmp0;
    }

    public static FileOutputStream newFileOutputStream(final String filename) throws FileNotFoundException {
        FileOutputStream piTmp0;
        block2: {
            piTmp0 = null;
            try {
                piTmp0 = AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                    @Override
                    public FileOutputStream run() throws FileNotFoundException {
                        return new FileOutputStream(filename);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (!(typedException instanceof FileNotFoundException)) break block2;
                throw (FileNotFoundException)typedException;
            }
        }
        return piTmp0;
    }

    public static InputStreamReader newInputStreamReader(final InputStream in, final String charsetName) throws UnsupportedEncodingException {
        InputStreamReader piTmp0;
        block2: {
            piTmp0 = null;
            try {
                piTmp0 = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStreamReader>(){

                    @Override
                    public InputStreamReader run() throws UnsupportedEncodingException {
                        return new InputStreamReader(in, charsetName);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (!(typedException instanceof UnsupportedEncodingException)) break block2;
                throw (UnsupportedEncodingException)typedException;
            }
        }
        return piTmp0;
    }

    public static FileReader newFileReader(final String filename) throws FileNotFoundException {
        FileReader piTmp0;
        block2: {
            piTmp0 = null;
            try {
                piTmp0 = AccessController.doPrivileged(new PrivilegedExceptionAction<FileReader>(){

                    @Override
                    public FileReader run() throws FileNotFoundException {
                        return new FileReader(filename);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (!(typedException instanceof FileNotFoundException)) break block2;
                throw (FileNotFoundException)typedException;
            }
        }
        return piTmp0;
    }

    public static FileReader newFileReader(final File file) throws FileNotFoundException {
        FileReader piTmp0;
        block2: {
            piTmp0 = null;
            try {
                piTmp0 = AccessController.doPrivileged(new PrivilegedExceptionAction<FileReader>(){

                    @Override
                    public FileReader run() throws FileNotFoundException {
                        return new FileReader(file);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (!(typedException instanceof FileNotFoundException)) break block2;
                throw (FileNotFoundException)typedException;
            }
        }
        return piTmp0;
    }

    public static FileWriter newFileWriter(final String filename) throws IOException {
        FileWriter piTmp0;
        block2: {
            piTmp0 = null;
            try {
                piTmp0 = AccessController.doPrivileged(new PrivilegedExceptionAction<FileWriter>(){

                    @Override
                    public FileWriter run() throws IOException {
                        return new FileWriter(filename);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (!(typedException instanceof IOException)) break block2;
                throw (IOException)typedException;
            }
        }
        return piTmp0;
    }

    public static FileWriter newFileWriter(final File file) throws IOException {
        FileWriter piTmp0;
        block2: {
            piTmp0 = null;
            try {
                piTmp0 = AccessController.doPrivileged(new PrivilegedExceptionAction<FileWriter>(){

                    @Override
                    public FileWriter run() throws IOException {
                        return new FileWriter(file);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (!(typedException instanceof IOException)) break block2;
                throw (IOException)typedException;
            }
        }
        return piTmp0;
    }

    public static OutputStreamWriter newOutputStreamWriter(final OutputStream out, final String charsetName) throws UnsupportedEncodingException {
        OutputStreamWriter piTmp0;
        block2: {
            piTmp0 = null;
            try {
                piTmp0 = AccessController.doPrivileged(new PrivilegedExceptionAction<OutputStreamWriter>(){

                    @Override
                    public OutputStreamWriter run() throws UnsupportedEncodingException {
                        return new OutputStreamWriter(out, charsetName);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (!(typedException instanceof UnsupportedEncodingException)) break block2;
                throw (UnsupportedEncodingException)typedException;
            }
        }
        return piTmp0;
    }

    public static Object readObject(final ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Object piTmp0;
        block3: {
            piTmp0 = null;
            try {
                piTmp0 = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IOException, ClassNotFoundException {
                        return ois.readObject();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (typedException instanceof IOException) {
                    throw (IOException)typedException;
                }
                if (!(typedException instanceof ClassNotFoundException)) break block3;
                throw (ClassNotFoundException)typedException;
            }
        }
        return piTmp0;
    }

    public static ObjectOutputStream newObjectOutputStream(final OutputStream out) throws IOException {
        ObjectOutputStream piTmp0;
        block2: {
            piTmp0 = null;
            try {
                piTmp0 = AccessController.doPrivileged(new PrivilegedExceptionAction<ObjectOutputStream>(){

                    @Override
                    public ObjectOutputStream run() throws IOException {
                        return new ObjectOutputStream(out);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (!(typedException instanceof IOException)) break block2;
                throw (IOException)typedException;
            }
        }
        return piTmp0;
    }

    public static ObjectInputStream newObjectInputStream(final InputStream is) throws IOException {
        ObjectInputStream piTmp0;
        block2: {
            piTmp0 = null;
            try {
                piTmp0 = AccessController.doPrivileged(new PrivilegedExceptionAction<ObjectInputStream>(){

                    @Override
                    public ObjectInputStream run() throws IOException {
                        return new ObjectInputStream(is);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (!(typedException instanceof IOException)) break block2;
                throw (IOException)typedException;
            }
        }
        return piTmp0;
    }

    public static ImageOutputStream newImageOutputStream(final Object output) throws IOException {
        ImageOutputStream piTmp0;
        block2: {
            piTmp0 = null;
            try {
                piTmp0 = AccessController.doPrivileged(new PrivilegedExceptionAction<ImageOutputStream>(){

                    @Override
                    public ImageOutputStream run() throws IOException {
                        return ImageIO.createImageOutputStream(output);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (!(typedException instanceof IOException)) break block2;
                throw (IOException)typedException;
            }
        }
        return piTmp0;
    }

    public static <K, V> Hashtable<K, V> newHashtable() {
        Hashtable piTmp0 = (Hashtable)AccessController.doPrivileged(new PrivilegedAction<Hashtable<K, V>>(){

            @Override
            public Hashtable<K, V> run() {
                return new Hashtable();
            }
        });
        return piTmp0;
    }

    public static ClassLoader getClassLoader(final Class<?> cls) {
        ClassLoader piTmp0 = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return cls.getClassLoader();
            }
        });
        return piTmp0;
    }

    public static URLClassLoader newURLClassLoader(final URL[] urls, final ClassLoader parent) {
        URLClassLoader piTmp0 = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls, parent);
            }
        });
        return piTmp0;
    }

    public static <T> T newClassInstance(Class<T> cls) throws InstantiationException, IllegalAccessException {
        return cls.newInstance();
    }

    public static Class<?> loadClass(final ClassLoader loader, final String name) throws ClassNotFoundException {
        Class piTmp0;
        block2: {
            piTmp0 = null;
            try {
                piTmp0 = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                    @Override
                    public Class<?> run() throws ClassNotFoundException {
                        return loader.loadClass(name);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (!(typedException instanceof ClassNotFoundException)) break block2;
                throw (ClassNotFoundException)typedException;
            }
        }
        return piTmp0;
    }

    public static Method[] getMethods(final Class<?> cls) throws SecurityException {
        Method[] piTmp0;
        block2: {
            piTmp0 = null;
            try {
                piTmp0 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method[]>(){

                    @Override
                    public Method[] run() throws SecurityException {
                        return cls.getMethods();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (!(typedException instanceof SecurityException)) break block2;
                throw (SecurityException)typedException;
            }
        }
        return piTmp0;
    }

    public static Object invokeMethod(final Method method, final Object caller, final Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object piTmp0;
        block4: {
            piTmp0 = null;
            try {
                piTmp0 = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                        return method.invoke(caller, args);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (typedException instanceof IllegalAccessException) {
                    throw (IllegalAccessException)typedException;
                }
                if (typedException instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)typedException;
                }
                if (!(typedException instanceof InvocationTargetException)) break block4;
                throw (InvocationTargetException)typedException;
            }
        }
        return piTmp0;
    }

    public static <T> Constructor<T> getConstructor(final Class<T> cls, final Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Constructor piTmp0;
        block3: {
            piTmp0 = null;
            try {
                piTmp0 = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<T>>(){

                    @Override
                    public Constructor<T> run() throws NoSuchMethodException, SecurityException {
                        return cls.getConstructor(parameterTypes);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (typedException instanceof NoSuchMethodException) {
                    throw (NoSuchMethodException)typedException;
                }
                if (!(typedException instanceof SecurityException)) break block3;
                throw (SecurityException)typedException;
            }
        }
        return piTmp0;
    }

    public static String getSysProp(final String key) {
        String piTmp0 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
        return piTmp0;
    }

    public static String setSysProp(final String key, final String value) {
        String piTmp0 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.setProperty(key, value);
            }
        });
        return piTmp0;
    }

    public static void sysExit(final int status) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                System.exit(status);
                return null;
            }
        });
    }

    public static URL newURL(final String spec) throws MalformedURLException {
        URL piTmp0;
        block2: {
            piTmp0 = null;
            try {
                piTmp0 = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                    @Override
                    public URL run() throws MalformedURLException {
                        return new URL(spec);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (!(typedException instanceof MalformedURLException)) break block2;
                throw (MalformedURLException)typedException;
            }
        }
        return piTmp0;
    }

    public static Process execRuntimeCommand(final Runtime runtime, final String command) throws IOException {
        Process piTmp0;
        block2: {
            piTmp0 = null;
            try {
                piTmp0 = AccessController.doPrivileged(new PrivilegedExceptionAction<Process>(){

                    @Override
                    public Process run() throws IOException {
                        return runtime.exec(command);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (!(typedException instanceof IOException)) break block2;
                throw (IOException)typedException;
            }
        }
        return piTmp0;
    }

    public static TransformerFactory newTransformerFactory() throws Exception {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<TransformerFactory>(){

            @Override
            public TransformerFactory run() throws Exception {
                try {
                    return TransformerFactory.newInstance();
                }
                catch (TransformerFactoryConfigurationError error) {
                    throw error.getException();
                }
            }
        });
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory() {
        DocumentBuilderFactory piTmp0 = AccessController.doPrivileged(new PrivilegedAction<DocumentBuilderFactory>(){

            @Override
            public DocumentBuilderFactory run() {
                return DocumentBuilderFactory.newInstance();
            }
        });
        return piTmp0;
    }

    public static URL toURL(final URI uri) throws MalformedURLException {
        URL piTmp0;
        block2: {
            piTmp0 = null;
            try {
                piTmp0 = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                    @Override
                    public URL run() throws MalformedURLException {
                        return uri.toURL();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (!(typedException instanceof MalformedURLException)) break block2;
                throw (MalformedURLException)typedException;
            }
        }
        return piTmp0;
    }

    public static File newFile(final URI uri) throws NullPointerException, IllegalArgumentException {
        File piTmp0;
        block3: {
            piTmp0 = null;
            try {
                piTmp0 = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                    @Override
                    public File run() throws NullPointerException, IllegalArgumentException {
                        return new File(uri);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (typedException instanceof NullPointerException) {
                    throw (NullPointerException)typedException;
                }
                if (!(typedException instanceof IllegalArgumentException)) break block3;
                throw (IllegalArgumentException)typedException;
            }
        }
        return piTmp0;
    }

    public static String urlEncode(final String s, final String enc) throws UnsupportedEncodingException {
        String piTmp0;
        block2: {
            piTmp0 = null;
            try {
                piTmp0 = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws UnsupportedEncodingException {
                        return URLEncoder.encode(s, enc);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (!(typedException instanceof UnsupportedEncodingException)) break block2;
                throw (UnsupportedEncodingException)typedException;
            }
        }
        return piTmp0;
    }

    public static PrintWriter newPrintWriter(final Writer out, final boolean autoFlush) {
        PrintWriter piTmp0 = AccessController.doPrivileged(new PrivilegedAction<PrintWriter>(){

            @Override
            public PrintWriter run() {
                return new PrintWriter(out, autoFlush);
            }
        });
        return piTmp0;
    }

    public static ImageOutputStream createImageOutputStream(final Object output) throws IOException {
        ImageOutputStream piTmp0;
        block2: {
            piTmp0 = null;
            try {
                piTmp0 = AccessController.doPrivileged(new PrivilegedExceptionAction<ImageOutputStream>(){

                    @Override
                    public ImageOutputStream run() throws IOException {
                        return ImageIO.createImageOutputStream(output);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception typedException = e.getException();
                if (!(typedException instanceof IOException)) break block2;
                throw (IOException)typedException;
            }
        }
        return piTmp0;
    }

    public static String getSystemEnv(final String name) {
        String piTmp0 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getenv(name);
            }
        });
        return piTmp0;
    }
}

