/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.util;

import java.util.logging.Level;
import java.util.logging.Logger;

public class BirtTimer {
    protected long startTime;
    protected long endTime;

    public void start() {
        this.endTime = this.startTime = System.currentTimeMillis();
    }

    public void stop() {
        this.endTime = System.currentTimeMillis();
    }

    public int delta() {
        return (int)(this.endTime - this.startTime);
    }

    public void restart() {
        this.start();
    }

    public void logTimeTaken(Logger logger, Level level, String operationName) {
        if (logger.isLoggable(level)) {
            logger.log(level, "{0} takes {1} Milliseconds.", new String[]{operationName, Integer.toString(this.delta())});
        }
    }

    public void logTimeTaken(Logger logger, Level level, String id, String operationName) {
        if (logger.isLoggable(level)) {
            logger.log(level, "{0}: {1} takes {2} Milliseconds.", new String[]{id, operationName, Integer.toString(this.delta())});
        }
    }
}

