/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.event;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.event.Event;
import org.eclipse.buildship.core.internal.event.EventListener;
import org.eclipse.buildship.core.internal.event.ListenerRegistry;

public final class DefaultListenerRegistry
implements ListenerRegistry {
    private final Object LOCK = new Object();
    private final Set<EventListener> listeners = new LinkedHashSet<EventListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventListener(EventListener listener) {
        Object object = this.LOCK;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEventListener(EventListener listener) {
        Object object = this.LOCK;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(Event event) {
        ImmutableList listeners;
        Iterator iterator = this.LOCK;
        synchronized (iterator) {
            listeners = ImmutableList.copyOf(this.listeners);
        }
        for (EventListener listener : listeners) {
            try {
                listener.onEvent(event);
            }
            catch (Exception e) {
                CorePlugin.logger().warn("Listener " + listener.getClass().getName() + " failed to handle " + event.getClass().getName(), e);
            }
        }
    }
}

