/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.extension;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.extension.ExtensionManager;
import org.eclipse.buildship.core.internal.extension.ProjectConfiguratorContribution;
import org.eclipse.buildship.core.invocation.InvocationCustomizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class DefaultExtensionManager
implements ExtensionManager {
    @Override
    public List<InvocationCustomizer> loadCustomizers() {
        Collection<IConfigurationElement> elements = this.loadElements("invocationcustomizers");
        ArrayList<InvocationCustomizer> result = new ArrayList<InvocationCustomizer>(elements.size());
        for (IConfigurationElement element : elements) {
            try {
                result.add((InvocationCustomizer)InvocationCustomizer.class.cast(element.createExecutableExtension("class")));
            }
            catch (Exception e) {
                CorePlugin.logger().warn("Cannot load invocationcustomizers extension", e);
            }
        }
        return result;
    }

    @Override
    public List<ProjectConfiguratorContribution> loadConfigurators() {
        Collection<IConfigurationElement> elements = this.loadElements("projectconfigurators");
        ArrayList<ProjectConfiguratorContribution> result = new ArrayList<ProjectConfiguratorContribution>(elements.size());
        for (IConfigurationElement element : elements) {
            ProjectConfiguratorContribution contribution = ProjectConfiguratorContribution.from(element);
            result.add(contribution);
        }
        return result;
    }

    @VisibleForTesting
    Collection<IConfigurationElement> loadElements(String extensionPointName) {
        return Arrays.asList(Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.buildship.core", extensionPointName));
    }
}

