/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.clangd.internal.config;

import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.lsp.clangd.ClangdCProjectDescriptionListener;
import org.eclipse.cdt.lsp.clangd.ClangdCompilationDatabaseProvider;
import org.eclipse.cdt.lsp.clangd.ClangdCompilationDatabaseSettings;
import org.eclipse.cdt.lsp.clangd.internal.config.ClangdCompilationDatabaseSetterBase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ServiceCaller;

public class ClangdCompilationDatabaseSetter
extends ClangdCompilationDatabaseSetterBase {
    private static final String COMPILE_COMMANDS_JSON = "compile_commands.json";
    private final ServiceCaller<ClangdCompilationDatabaseSettings> settings = new ServiceCaller(this.getClass(), ClangdCompilationDatabaseSettings.class);
    private final ServiceCaller<ClangdCompilationDatabaseProvider> clangdCompilationDatabaseProvider = new ServiceCaller(this.getClass(), ClangdCompilationDatabaseProvider.class);
    private final ServiceCaller<ClangdCProjectDescriptionListener> clangdCProjectDescriptionListener = new ServiceCaller(this.getClass(), ClangdCProjectDescriptionListener.class);
    private final ICProjectDescriptionListener descriptionListener = new ICProjectDescriptionListener(){

        public void handleEvent(CProjectDescriptionEvent event) {
            ClangdCompilationDatabaseSetter.this.cProjectDescriptionEventHandler(event);
        }
    };
    private final IResourceChangeListener postBuildListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            ClangdCompilationDatabaseSetter.this.resourceChangedHandler(event);
        }
    };

    public Optional<WorkspaceJob> cProjectDescriptionEventHandler(CProjectDescriptionEvent event) {
        Optional[] jobs = new Optional[]{Optional.empty()};
        IProject project = event.getProject();
        if (project != null && this.isSetCompilationDatabaseEnabled(project) && !this.clangdCProjectDescriptionListener.call(c -> c.handleEvent(event))) {
            this.clangdCompilationDatabaseProvider.call(provider -> {
                optionalArray[0] = provider.getCompilationDatabasePath(event).map(path -> this.setCompilationDatabase(project, (String)path));
            });
        }
        return jobs[0];
    }

    public Optional<WorkspaceJob> resourceChangedHandler(IResourceChangeEvent event) {
        Optional[] jobs = new Optional[]{Optional.empty()};
        if (event.getDelta() != null) {
            for (IProject project : this.collectAffectedProjects(event)) {
                if (!this.isSetCompilationDatabaseEnabled(project)) continue;
                this.clangdCompilationDatabaseProvider.call(provider -> {
                    optionalArray[0] = provider.getCompilationDatabasePath(event, project).map(path -> this.setCompilationDatabase(project, (String)path));
                });
            }
        }
        return jobs[0];
    }

    private Set<IProject> collectAffectedProjects(IResourceChangeEvent event) {
        HashMap projectsMap = new HashMap();
        try {
            event.getDelta().accept(delta -> {
                IProject project;
                IResource iResource = delta.getResource();
                if (iResource instanceof IProject && (project = (IProject)iResource).isAccessible() && project.hasNature("org.eclipse.cdt.core.cnature")) {
                    projectsMap.put(project, true);
                } else {
                    IFile file;
                    IResource iResource2 = delta.getResource();
                    if (iResource2 instanceof IFile && (file = (IFile)iResource2).getProject() != null && file.getProject().isAccessible() && file.getProject().hasNature("org.eclipse.cdt.core.cnature")) {
                        if (COMPILE_COMMANDS_JSON.contentEquals(file.getName()) || ".clangd".contentEquals(file.getName()) || file.getFileExtension() != null && "prefs".contentEquals(file.getFileExtension())) {
                            projectsMap.put(file.getProject(), false);
                        } else if (projectsMap.getOrDefault(file.getProject(), false).booleanValue()) {
                            projectsMap.remove(file.getProject());
                        }
                    }
                }
                return true;
            });
        }
        catch (CoreException e) {
            Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
        }
        return projectsMap.keySet();
    }

    public ClangdCompilationDatabaseSetter start(IWorkspace workspace) {
        workspace.addResourceChangeListener(this.postBuildListener, 16);
        CCorePlugin.getDefault().getProjectDescriptionManager().addCProjectDescriptionListener(this.descriptionListener, 4);
        return this;
    }

    public void stop(IWorkspace workspace) {
        workspace.removeResourceChangeListener(this.postBuildListener);
        CCorePlugin.getDefault().getProjectDescriptionManager().removeCProjectDescriptionListener(this.descriptionListener);
    }

    private boolean isSetCompilationDatabaseEnabled(IProject project) {
        boolean[] enabled = new boolean[1];
        this.settings.call(settings -> {
            blArray[0] = settings.enableSetCompilationDatabasePath(project);
        });
        return enabled[0];
    }
}

