/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.buildmodel;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildDescription;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildIOType;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildResource;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildStep;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildDescription;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildIOType;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildModelMessages;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildStep;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.DbgUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class BuildResource
implements IBuildResource {
    private List<BuildIOType> fDepArgs = new ArrayList<BuildIOType>();
    private BuildIOType fProducerArg;
    private boolean fNeedsRebuild;
    private boolean fIsRemoved;
    private IPath fFullWorkspacePath;
    private boolean fIsProjectRc;
    private BuildDescription fInfo;
    private URI fLocationURI;

    protected BuildResource(BuildDescription info, IResource rc) {
        this(info, info.calcResourceLocation(rc), rc.getLocationURI());
    }

    protected BuildResource(BuildDescription info, IPath fullWorkspacePath, URI locationURI) {
        if (locationURI == null) {
            throw new IllegalArgumentException();
        }
        this.fLocationURI = locationURI;
        this.fFullWorkspacePath = fullWorkspacePath;
        this.fInfo = info;
        this.fIsProjectRc = fullWorkspacePath != null;
        info.resourceCreated(this);
        if (DbgUtil.DEBUG) {
            DbgUtil.trace("resource " + String.valueOf(fullWorkspacePath) + " created");
        }
    }

    @Override
    public IPath getLocation() {
        if (this.fFullWorkspacePath == null) {
            return new Path(this.fLocationURI.getPath());
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(this.fFullWorkspacePath);
        if (resource == null) {
            return new Path(this.fLocationURI.getPath());
        }
        if (resource.getLocation() != null) {
            return resource.getLocation();
        }
        return new Path(this.fLocationURI.getPath());
    }

    @Override
    public IPath getFullPath() {
        return this.fFullWorkspacePath;
    }

    @Override
    public IBuildIOType getProducerIOType() {
        return this.fProducerArg;
    }

    @Override
    public IBuildIOType[] getDependentIOTypes() {
        return this.fDepArgs.toArray(new BuildIOType[this.fDepArgs.size()]);
    }

    @Override
    public boolean needsRebuild() {
        return this.fNeedsRebuild;
    }

    @Override
    public boolean isRemoved() {
        return this.fIsRemoved;
    }

    public void setRemoved(boolean removed) {
        if (DbgUtil.DEBUG && removed) {
            DbgUtil.trace("REMOVED state: resource " + DbgUtil.resourceName(this));
        }
        this.fIsRemoved = removed;
        if (this.fIsRemoved) {
            this.fNeedsRebuild = false;
        }
    }

    public void setRebuildState(boolean rebuild) {
        this.fNeedsRebuild = rebuild;
    }

    protected void addToArg(BuildIOType arg) {
        if (arg.isInput()) {
            this.fDepArgs.add(arg);
        } else if (this.fProducerArg == null) {
            this.fProducerArg = arg;
        } else if (this.fProducerArg.getStep() == this.fInfo.getInputStep()) {
            BuildStep inStep = (BuildStep)this.fInfo.getInputStep();
            inStep.removeResource(this.fProducerArg, this, true);
            this.fProducerArg = arg;
        } else {
            ITool tool;
            IBuildStep step = this.fProducerArg.getStep();
            ITool iTool = tool = step instanceof BuildStep ? ((BuildStep)step).getTool() : null;
            if (tool != null && !arg.isInput()) {
                return;
            }
            Object err = "ProducerArgument not null!!!\n";
            String rcName = DbgUtil.resourceName(this);
            String step1Name = DbgUtil.stepName(this.fProducerArg.getStep());
            String step2Name = DbgUtil.stepName(arg.getStep());
            String[] rcs = new String[]{rcName, step1Name, step2Name};
            String externalizedErr = BuildModelMessages.getFormattedString("BuildResource.0", rcs);
            if (DbgUtil.DEBUG) {
                err = (String)err + externalizedErr + "curent producer: " + DbgUtil.dumpStep(this.fProducerArg.getStep()) + "\n producer attempt: " + DbgUtil.dumpStep(arg.getStep());
            }
            throw new IllegalArgumentException(externalizedErr);
        }
    }

    void removeFromArg(BuildIOType arg) {
        if (arg.isInput()) {
            this.fDepArgs.remove(arg);
        } else if (this.fProducerArg == arg) {
            this.fProducerArg = null;
        } else {
            throw new IllegalArgumentException("Resource is not produced by this arg!!!");
        }
    }

    @Override
    public boolean isProjectResource() {
        return this.fIsProjectRc;
    }

    BuildIOType[][] clear() {
        BuildIOType[] outs;
        BuildIOType[][] types = new BuildIOType[2][];
        types[0] = new BuildIOType[1];
        types[0][0] = this.fProducerArg;
        types[1] = outs = (BuildIOType[])this.getDependentIOTypes();
        if (this.fProducerArg != null) {
            this.fProducerArg.removeResource(this);
        }
        int i = 0;
        while (i < outs.length) {
            outs[i].removeResource(this);
            ++i;
        }
        return types;
    }

    BuildIOType[][] remove() {
        BuildIOType[][] types = this.clear();
        if (DbgUtil.DEBUG) {
            DbgUtil.trace("resource " + DbgUtil.resourceName(this) + " removed");
        }
        this.fInfo.resourceRemoved(this);
        this.fInfo = null;
        return types;
    }

    @Override
    public IBuildDescription getBuildDescription() {
        return this.fInfo;
    }

    @Override
    public IBuildStep[] getDependentSteps() {
        HashSet<IBuildStep> set = new HashSet<IBuildStep>();
        Iterator<BuildIOType> iter = this.fDepArgs.iterator();
        while (iter.hasNext()) {
            set.add(iter.next().getStep());
        }
        return set.toArray(new BuildStep[set.size()]);
    }

    @Override
    public IBuildStep getProducerStep() {
        if (this.fProducerArg != null) {
            return this.fProducerArg.getStep();
        }
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("BR ");
        IPath fullPath = this.getFullPath();
        if (fullPath != null) {
            buf.append("WSP|").append(fullPath);
        } else {
            buf.append("FS|").append(this.getLocation());
        }
        return buf.toString();
    }

    @Override
    public URI getLocationURI() {
        return this.fLocationURI;
    }
}

