/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.visualizer.ui.util;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class GUIUtils {
    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static void exec(Runnable runnable) {
        Display display = GUIUtils.getDisplay();
        GUIUtils.exec(display, runnable, false);
    }

    public static void exec(Runnable runnable, boolean blocking) {
        Display display = GUIUtils.getDisplay();
        GUIUtils.exec(display, runnable, blocking);
    }

    public static void execAndWait(Runnable runnable) {
        Display display = GUIUtils.getDisplay();
        GUIUtils.exec(display, runnable, true);
    }

    protected static void exec(Display display, Runnable runnable, boolean blocking) {
        if (display != null && runnable != null) {
            if (blocking) {
                display.syncExec(runnable);
            } else {
                display.asyncExec(runnable);
            }
        }
    }

    public static void drawText(GC gc, String text, int x, int y) {
        gc.drawText(text, x, y, 1);
    }

    public static void drawText(GC gc, String text, Rectangle clip, int x, int y) {
        Rectangle oldClip = gc.getClipping();
        gc.setClipping(clip);
        GUIUtils.drawText(gc, text, x, y);
        gc.setClipping(oldClip);
    }

    public static void drawTextAligned(GC gc, String text, int x, int y, boolean left, boolean top) {
        if (left && top) {
            gc.drawText(text, x, y, 1);
        } else {
            Point te = gc.textExtent(text);
            int dx = left ? 0 : te.x;
            int dy = top ? 0 : te.y;
            gc.drawText(text, x - dx, y - dy, 1);
        }
    }

    public static void drawTextAligned(GC gc, String text, Rectangle clip, int x, int y, boolean left, boolean top) {
        Rectangle oldClip = gc.getClipping();
        gc.setClipping(clip);
        GUIUtils.drawTextAligned(gc, text, x, y, left, top);
        gc.setClipping(oldClip);
    }

    public static void drawTextCentered(GC gc, String text, int x, int y) {
        Point te = gc.textExtent(text);
        gc.drawText(text, x - (int)Math.round((double)te.x / 2.0), y - (int)Math.round((double)te.y / 2.0), 1);
    }

    public static void drawTextCentered(GC gc, String text, Rectangle clip, int x, int y) {
        Rectangle oldClip = gc.getClipping();
        gc.setClipping(clip);
        GUIUtils.drawTextCentered(gc, text, x, y);
        gc.setClipping(oldClip);
    }

    public static void inset(Rectangle rect, int margin) {
        rect.x += margin;
        rect.y += margin;
        rect.width -= margin * 2;
        if (rect.width < 0) {
            rect.width = 0;
        }
        rect.height -= margin * 2;
        if (rect.height < 0) {
            rect.height = 0;
        }
    }
}

