/*******************************************************************************
 * Copyright (c) 2005, 2017 IBM Corporation and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 *******************************************************************************/
package org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage;

import java.text.MessageFormat;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage.BuildpathModifierQueries.IRemoveLinkedFolderQuery;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/**
 * Dialog to prompt whether a linked folder should be deleted.
 *
 * @see IRemoveLinkedFolderQuery
 */
class RemoveLinkedFolderDialog extends MessageDialog {

	/** The remove status */
	private int fRemoveStatus = IRemoveLinkedFolderQuery.REMOVE_BUILD_PATH_AND_FOLDER;

	/** The remove build path and folder button */
	private Button fRemoveBuildPathAndFolder;

	/** The remove build path button */
	private Button fRemoveBuildPath;

	/**
	 * Creates a new remove linked folder dialog.
	 *
	 * @param shell  the parent shell to use
	 * @param folder the linked folder to remove
	 */
	RemoveLinkedFolderDialog(final Shell shell, final IFolder folder) {
		super(shell, NewWizardMessages.BuildpathModifierQueries_confirm_remove_linked_folder_label, null,
				MessageFormat.format(NewWizardMessages.BuildpathModifierQueries_confirm_remove_linked_folder_message,
						folder.getFullPath()),
				MessageDialog.QUESTION, new String[] { IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL }, 0); // yes
																													// is
																													// the
																													// default
		Assert.isTrue(folder.isLinked());
	}

	@Override
	protected Control createCustomArea(final Composite parent) {

		final Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout());

		fRemoveBuildPathAndFolder = new Button(composite, SWT.RADIO);
		fRemoveBuildPathAndFolder.addSelectionListener(selectionListener);

		fRemoveBuildPathAndFolder.setText(NewWizardMessages.BuildpathModifierQueries_delete_linked_folder);
		fRemoveBuildPathAndFolder.setFont(parent.getFont());

		fRemoveBuildPath = new Button(composite, SWT.RADIO);
		fRemoveBuildPath.addSelectionListener(selectionListener);

		fRemoveBuildPath.setText(NewWizardMessages.BuildpathModifierQueries_do_not_delete_linked_folder);
		fRemoveBuildPath.setFont(parent.getFont());

		fRemoveBuildPathAndFolder.setSelection(fRemoveStatus == IRemoveLinkedFolderQuery.REMOVE_BUILD_PATH_AND_FOLDER);
		fRemoveBuildPath.setSelection(fRemoveStatus == IRemoveLinkedFolderQuery.REMOVE_BUILD_PATH);

		return composite;
	}

	private SelectionListener selectionListener = new SelectionAdapter() {

		@Override
		public final void widgetSelected(final SelectionEvent event) {
			final Button button = (Button) event.widget;
			if (button.getSelection())
				fRemoveStatus = (button == fRemoveBuildPathAndFolder)
						? IRemoveLinkedFolderQuery.REMOVE_BUILD_PATH_AND_FOLDER
						: IRemoveLinkedFolderQuery.REMOVE_BUILD_PATH;
		}
	};

	/**
	 * Returns the remove status.
	 *
	 * @return the remove status, one of IRemoveLinkedFolderQuery#REMOVE_XXX
	 */
	public final int getRemoveStatus() {
		return fRemoveStatus;
	}
}
