/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class EclipsePreferencesHelper {
    public static final String PROPS_OVERRIDDEN_BY_CSS_PROP = "overriddenByCSS";
    public static final String SEPARATOR = ",";
    private static final String MULTI_VALUE_FORMATTER = "%s%s,";
    private static IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener;
    private static String previousThemeId;
    private static String currentThemeId;
    private static final String PROPS_DEFAULT_VALUE_BEFORE_OVERIDDEN_FROM_CSS = "defaultValueBeforeOverriddenFromCSS";

    public static void appendOverriddenPropertyName(IEclipsePreferences preferences, String name) {
        String value = preferences.get(PROPS_OVERRIDDEN_BY_CSS_PROP, SEPARATOR);
        if (value.equals(SEPARATOR)) {
            preferences.addPreferenceChangeListener(EclipsePreferencesHelper.getPreferenceChangeListener());
        }
        if (!EclipsePreferencesHelper.isOverriddenByCSS(value, name)) {
            preferences.put(PROPS_OVERRIDDEN_BY_CSS_PROP, String.format(MULTI_VALUE_FORMATTER, value, name));
        }
    }

    public static IEclipsePreferences.IPreferenceChangeListener getPreferenceChangeListener() {
        if (preferenceChangeListener == null) {
            preferenceChangeListener = new PreferenceOverriddenByCssChangeListener();
        }
        return preferenceChangeListener;
    }

    private static boolean isOverriddenByCSS(String propertiesOverriddenByCSS, String property) {
        return propertiesOverriddenByCSS.contains(SEPARATOR + property + SEPARATOR);
    }

    public static List<String> getOverriddenPropertyNames(IEclipsePreferences preferences) {
        String value = preferences.get(PROPS_OVERRIDDEN_BY_CSS_PROP, null);
        if (value == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = value.split(SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name != null && !name.isEmpty()) {
                result.add(name);
            }
            ++n2;
        }
        return result;
    }

    public static void removeOverriddenPropertyNames(IEclipsePreferences preferences) {
        preferences.remove(PROPS_OVERRIDDEN_BY_CSS_PROP);
        preferences.removePreferenceChangeListener(EclipsePreferencesHelper.getPreferenceChangeListener());
    }

    public static void removeOverriddenByCssProperty(IEclipsePreferences preferences, String preferenceToRemove) {
        StringBuilder overriddenByCSS = new StringBuilder(SEPARATOR);
        for (String preference : EclipsePreferencesHelper.getOverriddenPropertyNames(preferences)) {
            if (preference.equals(preferenceToRemove)) continue;
            overriddenByCSS.append(preference).append(SEPARATOR);
        }
        preferences.put(PROPS_OVERRIDDEN_BY_CSS_PROP, overriddenByCSS.toString());
    }

    public static void setPreviousThemeId(String themeId) {
        previousThemeId = themeId;
    }

    public static void setCurrentThemeId(String themeId) {
        currentThemeId = themeId;
    }

    public static boolean isThemeChanged() {
        return currentThemeId != null && !currentThemeId.equals(previousThemeId);
    }

    public static void overrideDefault(IEclipsePreferences preferences, String name, String value) {
        String prefName = preferences.name();
        if (prefName == null) {
            return;
        }
        IEclipsePreferences defaultPrefs = DefaultScope.INSTANCE.getNode(prefName);
        if (defaultPrefs == null) {
            return;
        }
        String existing = defaultPrefs.get(name, null);
        if (existing != null && value != null && !existing.equals(value)) {
            defaultPrefs.put(name, value);
            preferences.put(name + ",defaultValueBeforeOverriddenFromCSS", existing);
        }
    }

    public static void resetOverriddenDefaults(IEclipsePreferences preferences) {
        try {
            String[] keys = preferences.keys();
            if (keys == null) {
                return;
            }
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (key != null && key.endsWith(",defaultValueBeforeOverriddenFromCSS")) {
                    String overriddenDefault = preferences.get(key, null);
                    String originKey = key.substring(0, key.lastIndexOf(",defaultValueBeforeOverriddenFromCSS"));
                    IEclipsePreferences defaultPrefs = DefaultScope.INSTANCE.getNode(preferences.name());
                    if (defaultPrefs != null) {
                        String currentDefault = defaultPrefs.get(originKey, null);
                        if (overriddenDefault != null && currentDefault != null && !currentDefault.equals(overriddenDefault)) {
                            defaultPrefs.put(originKey, overriddenDefault);
                        }
                    }
                    preferences.remove(key);
                }
                ++n2;
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static class PreferenceOverriddenByCssChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (this.isModified(event) && this.isRelatedToOverriddenByCss(event)) {
                this.removeOverriddenByCssProperty(event);
            }
        }

        private boolean isModified(IEclipsePreferences.PreferenceChangeEvent event) {
            return event.getOldValue() != null && event.getNewValue() != null;
        }

        private boolean isRelatedToOverriddenByCss(IEclipsePreferences.PreferenceChangeEvent event) {
            return EclipsePreferencesHelper.isOverriddenByCSS(event.getNode().get(EclipsePreferencesHelper.PROPS_OVERRIDDEN_BY_CSS_PROP, EclipsePreferencesHelper.SEPARATOR), event.getKey());
        }

        protected void removeOverriddenByCssProperty(IEclipsePreferences.PreferenceChangeEvent event) {
            Preferences preferences = event.getNode();
            if (preferences instanceof IEclipsePreferences) {
                EclipsePreferencesHelper.removeOverriddenByCssProperty((IEclipsePreferences)preferences, event.getKey());
            }
        }
    }
}

