/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.managedbuild.cross.riscv.core.preferences;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.embedcdt.internal.managedbuild.cross.riscv.core.Activator;
import org.eclipse.embedcdt.managedbuild.cross.core.preferences.PersistentPreferences;
import org.eclipse.embedcdt.managedbuild.cross.riscv.core.ToolchainDefinition;
import org.eclipse.embedcdt.managedbuild.cross.riscv.core.preferences.DefaultPreferences;
import org.osgi.service.prefs.Preferences;

public class DefaultPreferenceInitializer
extends AbstractPreferenceInitializer {
    DefaultPreferences fDefaultPreferences;
    PersistentPreferences fPersistentPreferences;

    public void initializeDefaultPreferences() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("riscv.DefaultPreferenceInitializer.initializeDefaultPreferences()");
        }
        this.fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
        this.fPersistentPreferences = Activator.getInstance().getPersistentPreferences();
        ToolchainDefinition td = ToolchainDefinition.getToolchain(ToolchainDefinition.getDefault());
        String toolchainName = td.getName();
        this.fDefaultPreferences.putToolchainName(toolchainName);
        String toolchainId = td.getId();
        this.fDefaultPreferences.putToolchainId(toolchainId);
        Preferences prefs = Platform.getPreferencesService().getRootNode().node("default");
        if (prefs instanceof IEclipsePreferences) {
            ((IEclipsePreferences)prefs).addNodeChangeListener((IEclipsePreferences.INodeChangeListener)new LateInitializer());
        }
    }

    private class LateInitializer
    implements IEclipsePreferences.INodeChangeListener {
        private LateInitializer() {
        }

        public void added(IEclipsePreferences.NodeChangeEvent event) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("riscv.LateInitializer.added() " + event + " " + event.getChild().name());
            }
            if ("org.eclipse.embedcdt.managedbuild.cross.riscv.core".equals(event.getChild().name())) {
                this.finalizeInitializationsDefaultPreferences();
                ((IEclipsePreferences)event.getSource()).removeNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
            }
        }

        public void removed(IEclipsePreferences.NodeChangeEvent event) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("riscv.LateInitializer.removed() " + event);
            }
        }

        public void finalizeInitializationsDefaultPreferences() {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("riscv.LateInitializer.finalizeInitializationsDefaultPreferences()");
            }
            for (ToolchainDefinition toolchain : ToolchainDefinition.getList()) {
                String toolchainId = toolchain.getId();
                String toolchainName = toolchain.getName();
                String executableName = toolchain.getFullCmdC();
                String path = DefaultPreferenceInitializer.this.fDefaultPreferences.getToolchainPath(toolchainId, toolchainName);
                if (!DefaultPreferenceInitializer.this.fDefaultPreferences.checkFolderExecutable(path, executableName)) {
                    path = DefaultPreferenceInitializer.this.fPersistentPreferences.getToolchainPath(toolchainId, toolchainName, null);
                }
                if (!DefaultPreferenceInitializer.this.fDefaultPreferences.checkFolderExecutable(path, executableName)) {
                    path = DefaultPreferenceInitializer.this.fDefaultPreferences.discoverToolchainPath(toolchainId, toolchainName, executableName);
                }
                if (path != null && !path.isEmpty()) {
                    DefaultPreferenceInitializer.this.fDefaultPreferences.putToolchainPath(toolchainId, toolchainName, path);
                }
                if (!Activator.getInstance().isDebugging()) continue;
                System.out.println("riscv.LateInitializer.finalizeInitializationsDefaultPreferences() done");
            }
        }
    }
}

