/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;

public class ResetTransactionRequest
extends CDOClientRequest<CDOCommitInfo> {
    private int transactionID;
    private int commitNumber;

    public ResetTransactionRequest(CDOClientProtocol protocol, int transactionID, int commitNumber) {
        super(protocol, (short)61);
        this.transactionID = transactionID;
        this.commitNumber = commitNumber;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeXInt(this.transactionID);
        out.writeXInt(this.commitNumber);
    }

    @Override
    protected CDOCommitInfo confirming(CDODataInput in) throws IOException {
        if (in.readBoolean()) {
            long timeStamp = in.readXLong();
            long previousTimeStamp = in.readXLong();
            InternalCDOCommitInfoManager commitInfoManager = this.getSession().getCommitInfoManager();
            return commitInfoManager.createCommitInfo(null, timeStamp, previousTimeStamp, null, null, null, null);
        }
        return null;
    }
}

