/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequestWithMonitoring;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class SwitchTargetRequest
extends CDOClientRequestWithMonitoring<Object> {
    private int viewID;
    private CDOBranchPoint branchPoint;
    private List<InternalCDOObject> invalidObjects;
    private List<CDORevisionKey> allChangedObjects;
    private List<CDOIDAndVersion> allDetachedObjects;

    public SwitchTargetRequest(CDOClientProtocol protocol, int viewID, CDOBranchPoint branchPoint, List<InternalCDOObject> invalidObjects, List<CDORevisionKey> allChangedObjects, List<CDOIDAndVersion> allDetachedObjects) {
        super(protocol, (short)4);
        this.viewID = viewID;
        this.branchPoint = branchPoint;
        this.invalidObjects = invalidObjects;
        this.allChangedObjects = allChangedObjects;
        this.allDetachedObjects = allDetachedObjects;
    }

    @Override
    protected void requesting(CDODataOutput out, OMMonitor monitor) throws IOException {
        out.writeXInt(this.viewID);
        out.writeCDOBranchPoint(this.branchPoint);
        out.writeXInt(this.invalidObjects.size());
        for (InternalCDOObject object : this.invalidObjects) {
            out.writeCDOID(object.cdoID());
        }
    }

    @Override
    protected boolean[] confirming(CDODataInput in, OMMonitor monitor) throws IOException {
        int size = in.readXInt();
        int i = 0;
        while (i < size) {
            this.allChangedObjects.add((CDORevisionKey)in.readCDORevisionDelta());
            ++i;
        }
        size = in.readXInt();
        i = 0;
        while (i < size) {
            CDOID id = in.readCDOID();
            this.allDetachedObjects.add(CDOIDUtil.createIDAndVersion((CDOID)id, (int)0));
            ++i;
        }
        return null;
    }
}

