/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.protocol.CDOProtocolConstants;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequestWithMonitoring;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class UnitRequest
extends CDOClientRequestWithMonitoring<Boolean> {
    private int viewID;
    private CDOID rootID;
    private CDOProtocolConstants.UnitOpcode opcode;
    private boolean prefetchLockStates;
    private CDORevisionHandler revisionHandler;

    public UnitRequest(CDOClientProtocol protocol, int viewID, CDOID rootID, CDOProtocolConstants.UnitOpcode opcode, boolean prefetchLockStates, CDORevisionHandler revisionHandler) {
        super(protocol, (short)62);
        this.viewID = viewID;
        this.rootID = rootID;
        this.opcode = opcode;
        this.prefetchLockStates = prefetchLockStates;
        this.revisionHandler = revisionHandler;
    }

    @Override
    protected void requesting(CDODataOutput out, OMMonitor monitor) throws IOException {
        out.writeXInt(this.viewID);
        out.writeCDOID(this.rootID);
        out.writeByte(this.opcode.ordinal());
        if (this.opcode.canPrefetchLockStates()) {
            out.writeBoolean(this.prefetchLockStates);
        }
    }

    @Override
    protected Boolean confirming(CDODataInput in, OMMonitor monitor) throws IOException {
        if (this.opcode.isOpen()) {
            CDORevision revision;
            while ((revision = in.readCDORevision()) != null) {
                this.revisionHandler.handleRevision(revision);
            }
        }
        boolean result = in.readBoolean();
        if (this.opcode.canPrefetchLockStates() && result) {
            InternalCDOSession session = this.getSession();
            CDOView view = session.getView(this.viewID);
            CDOBranch branch = view.getBranch();
            CDOClientProtocol.readAndCacheLockStates(in, session, branch);
        }
        return result;
    }
}

