/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.eresource.impl;

import java.io.IOException;
import java.util.Map;
import java.util.function.BiFunction;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.util.CDODuplicateResourceException;
import org.eclipse.emf.cdo.eresource.CDOBinaryResource;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.CDOTextResource;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceNodeImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EStoreEObjectImpl;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.ObjectUtil;

public class CDOResourceFolderImpl
extends CDOResourceNodeImpl
implements CDOResourceFolder {
    protected CDOResourceFolderImpl() {
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    protected EClass eStaticClass() {
        return EresourcePackage.Literals.CDO_RESOURCE_FOLDER;
    }

    @Override
    public void recacheURIs() {
        InternalCDORevision revision = this.cdoRevision(false);
        if (revision != null) {
            CDOList list;
            boolean bypassPermissionChecks = revision.bypassPermissionChecks(true);
            try {
                list = revision.getListOrNull((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_FOLDER__NODES);
            }
            finally {
                revision.bypassPermissionChecks(bypassPermissionChecks);
            }
            if (list != null) {
                InternalCDOView view = this.cdoView();
                for (Object value : list) {
                    if (value instanceof CDOID) {
                        CDOID id = (CDOID)value;
                        value = view.getObject(id, false);
                    }
                    if (!(value instanceof CDOResourceNodeImpl)) continue;
                    CDOResourceNodeImpl child = (CDOResourceNodeImpl)value;
                    child.recacheURIs();
                }
            }
        }
    }

    @Override
    protected EList<?> createList(EStructuralFeature eStructuralFeature) throws CDODuplicateResourceException {
        if (eStructuralFeature == EresourcePackage.Literals.CDO_RESOURCE_FOLDER__NODES) {
            return new EStoreEObjectImpl.BasicEStoreEList<CDOResourceNode>((InternalEObject)this, eStructuralFeature){
                private static final long serialVersionUID = 1L;

                protected CDOResourceNode validate(int index, CDOResourceNode newNode) {
                    String newPath = String.valueOf(CDOResourceFolderImpl.this.getPath()) + CDOURIUtil.SEGMENT_SEPARATOR + newNode.getName();
                    CDOResourceFolderImpl.this.checkDuplicates(newPath);
                    return (CDOResourceNode)super.validate(index, (Object)newNode);
                }
            };
        }
        return super.createList(eStructuralFeature);
    }

    @Override
    public EList<CDOResourceNode> getNodes() {
        return (EList)this.eGet((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_FOLDER__NODES, true);
    }

    @Override
    public CDOResourceNode getNode(String name) {
        for (CDOResourceNode resourceNode : this.getNodes()) {
            if (!ObjectUtil.equals((Object)resourceNode.getName(), (Object)name)) continue;
            return resourceNode;
        }
        return null;
    }

    private <T extends CDOResourceNode> T addNode(String name, BiFunction<CDOTransaction, String, T> creator) {
        StringBuilder path = new StringBuilder(this.getPath());
        if (!name.startsWith(CDOURIUtil.SEGMENT_SEPARATOR)) {
            path.append(CDOURIUtil.SEGMENT_SEPARATOR);
        }
        path.append(name);
        InternalCDOTransaction transaction = this.cdoView().toTransaction();
        return (T)((CDOResourceNode)creator.apply(transaction, path.toString()));
    }

    @Override
    public CDOResourceFolder addResourceFolder(String name) {
        return this.addNode(name, (transaction, path) -> transaction.createResourceFolder((String)path));
    }

    @Override
    public CDOResource addResource(String name) {
        return this.addNode(name, (transaction, path) -> transaction.createResource((String)path));
    }

    @Override
    public CDOTextResource addTextResource(String name) {
        return this.addNode(name, (transaction, path) -> transaction.createTextResource((String)path));
    }

    @Override
    public CDOBinaryResource addBinaryResource(String name) {
        return this.addNode(name, (transaction, path) -> transaction.createBinaryResource((String)path));
    }

    @Override
    public void delete(Map<?, ?> options) throws IOException {
        if (!FSMUtil.isTransient(this)) {
            if (this.getFolder() == null) {
                InternalCDOView view = this.cdoView();
                view.getRootResource().getContents().remove((Object)this);
            } else {
                this.basicSetFolder(null, false);
            }
        }
    }
}

