/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.ui.quickfix;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xcore.ui.internal.XcoreActivator;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XcoreClasspathUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(XcoreClasspathUpdater.class);
    private static final String PLUGIN_NATURE = "org.eclipse.pde.PluginNature";

    public boolean addBundle(IJavaProject javaProject, String bundleID, IProgressMonitor monitor) {
        boolean result = false;
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            IProject project = javaProject.getProject();
            if (project.hasNature(PLUGIN_NATURE)) {
                result = this.addBundleToManifest(project, bundleID, (IProgressMonitor)progress.newChild(1));
            } else {
                URL entry;
                Bundle bundle = Platform.getBundle((String)bundleID);
                if (bundle != null && (entry = bundle.getEntry("/")) != null) {
                    URI uri = URI.createURI((String)FileLocator.resolve((URL)entry).toURI().toString());
                    if (uri.isArchive()) {
                        String authority = uri.authority();
                        uri = URI.createURI((String)authority.substring(0, authority.length() - 1));
                    }
                    if (uri.isFile()) {
                        String location = uri.toFileString();
                        File binFolder = new File(location, "bin");
                        if (binFolder.isDirectory()) {
                            location = binFolder.toString();
                        }
                        if (this.addJarToClasspath(javaProject, (IPath)new Path(location), (IProgressMonitor)progress.newChild(1))) {
                            result = true;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            LOG.error("Error adding '" + bundleID + "' to the classpath", (Throwable)exception);
        }
        return result;
    }

    protected boolean addJarToClasspath(IJavaProject javaProject, IPath location, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry newClasspthEntry = JavaCore.newLibraryEntry((IPath)location, null, null);
        IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
        IClasspathEntry[] newRawClasspath = new IClasspathEntry[rawClasspath.length + 1];
        int i = 0;
        while (i < rawClasspath.length) {
            IClasspathEntry entry = rawClasspath[i];
            if (entry.getEntryKind() == 1 && entry.getPath().equals((Object)location)) {
                return false;
            }
            newRawClasspath[i + 1] = entry;
            ++i;
        }
        newRawClasspath[0] = newClasspthEntry;
        javaProject.setRawClasspath(newRawClasspath, monitor);
        return true;
    }

    protected boolean addBundleToManifest(IProject project, String bundleID, IProgressMonitor monitor) throws IOException, CoreException {
        IResource manifestResource = project.findMember("META-INF/MANIFEST.MF");
        if (manifestResource != null && manifestResource.isAccessible() && !manifestResource.getResourceAttributes().isReadOnly() && manifestResource instanceof IFile) {
            OutputStream output = null;
            InputStream input = null;
            try {
                IFile manifestFile = (IFile)manifestResource;
                Object manifest = XcoreClasspathUpdater.createMergeableManifest(manifestFile.getContents());
                XcoreClasspathUpdater.addRequiredBundle(manifest, bundleID);
                if (XcoreClasspathUpdater.isModified(manifest)) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    output = new BufferedOutputStream(out);
                    XcoreClasspathUpdater.write(manifest, output);
                    ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                    input = new BufferedInputStream(in);
                    manifestFile.setContents(input, true, true, monitor);
                    return true;
                }
                return false;
            }
            finally {
                if (output != null) {
                    output.close();
                }
                if (input != null) {
                    input.close();
                }
            }
        }
        return false;
    }

    private static Object createMergeableManifest(InputStream inputStream) throws CoreException {
        Class mergeableManifestClass;
        try {
            mergeableManifestClass = CommonPlugin.loadClass((String)"org.eclipse.xtext.util", (String)"org.eclipse.xtext.util.MergeableManifest2");
        }
        catch (Exception exception) {
            try {
                mergeableManifestClass = CommonPlugin.loadClass((String)"org.eclipse.xtext.util", (String)"org.eclipse.xtext.util.MergeableManifest");
            }
            catch (ClassNotFoundException exception2) {
                throw new CoreException((IStatus)new Status(4, XcoreActivator.getInstance().getBundle().getSymbolicName(), exception.getMessage(), (Throwable)exception));
            }
        }
        try {
            return mergeableManifestClass.getConstructor(InputStream.class).newInstance(inputStream);
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, XcoreActivator.getInstance().getBundle().getSymbolicName(), exception.getMessage(), (Throwable)exception));
        }
    }

    private static void addRequiredBundle(Object mergeableManifest, String bundleID) throws CoreException {
        try {
            mergeableManifest.getClass().getMethod("addRequiredBundles", Set.class).invoke(mergeableManifest, Collections.singleton(bundleID));
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, XcoreActivator.getInstance().getBundle().getSymbolicName(), exception.getMessage(), (Throwable)exception));
        }
    }

    private static boolean isModified(Object mergeableManifest) throws CoreException {
        try {
            return (Boolean)mergeableManifest.getClass().getMethod("isModified", new Class[0]).invoke(mergeableManifest, new Object[0]);
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, XcoreActivator.getInstance().getBundle().getSymbolicName(), exception.getMessage(), (Throwable)exception));
        }
    }

    private static void write(Object mergeableManifest, OutputStream outputStream) throws CoreException {
        try {
            mergeableManifest.getClass().getMethod("write", OutputStream.class).invoke(mergeableManifest, outputStream);
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, XcoreActivator.getInstance().getBundle().getSymbolicName(), exception.getMessage(), (Throwable)exception));
        }
    }
}

