/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.mvc.fx.handlers.AbstractHandler;
import org.eclipse.gef.mvc.fx.handlers.IOnTypeHandler;
import org.eclipse.gef.mvc.fx.operations.SelectOperation;
import org.eclipse.gef.mvc.fx.parts.IContentPart;

public class SelectAllOnTypeHandler
extends AbstractHandler
implements IOnTypeHandler {
    protected List<? extends IContentPart<? extends Node>> getSelectableContentParts() {
        if (this.getHost().getViewer() == null) {
            return Collections.emptyList();
        }
        ArrayList<IContentPart<? extends Node>> parts = new ArrayList<IContentPart<? extends Node>>(this.getHost().getViewer().getContentPartMap().values());
        parts.removeIf(p -> !p.isSelectable());
        return parts;
    }

    protected boolean isSelectAll(KeyEvent keyEvent, Set<KeyCode> pressedKeys) {
        return keyEvent.isControlDown() && pressedKeys.contains(KeyCode.A);
    }

    @Override
    public void type(KeyEvent keyEvent, Set<KeyCode> pressedKeys) {
        if (this.isSelectAll(keyEvent, pressedKeys)) {
            SelectOperation selectOperation = new SelectOperation(this.getHost().getViewer(), this.getSelectableContentParts());
            try {
                this.getHost().getViewer().getDomain().execute(selectOperation, null);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

