/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.monitors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPreferenceInitializer;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaContendedMonitor;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaMonitor;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaMonitorThread;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaOwnedMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class ThreadMonitorManager
implements IDebugEventSetListener,
IPropertyChangeListener {
    private static ThreadMonitorManager fDefaultManager;
    private final HashMap<IDebugElement, Object> fJavaMonitorThreads = new HashMap();
    private final HashMap<IDebugElement, Object> fJavaMonitors = new HashMap();
    private boolean fIsEnabled;

    public static ThreadMonitorManager getDefault() {
        if (fDefaultManager == null) {
            fDefaultManager = new ThreadMonitorManager();
        }
        return fDefaultManager;
    }

    private ThreadMonitorManager() {
        IPreferenceStore preferenceStore = JDIDebugUIPlugin.getDefault().getPreferenceStore();
        preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.fIsEnabled = preferenceStore.getBoolean(IJavaDebugUIConstants.PREF_SHOW_MONITOR_THREAD_INFO);
        if (this.fIsEnabled) {
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            block11: {
                IAdaptable adaptable;
                int eventKind;
                DebugEvent debugEvent;
                block12: {
                    debugEvent = events[i];
                    Object eventSource = debugEvent.getSource();
                    eventKind = debugEvent.getKind();
                    IJavaThread javaThread = null;
                    if (!(eventSource instanceof IAdaptable)) break block11;
                    adaptable = (IAdaptable)eventSource;
                    javaThread = (IJavaThread)adaptable.getAdapter(IJavaThread.class);
                    if (javaThread == null) break block12;
                    switch (eventKind) {
                        case 1: 
                        case 2: {
                            if (debugEvent.getDetail() != 128) {
                                this.handleSuspendResume();
                                break;
                            }
                            break block11;
                        }
                        case 8: {
                            this.handleThreadTerminate(javaThread);
                        }
                    }
                    break block11;
                }
                IJavaDebugTarget target = (IJavaDebugTarget)adaptable.getAdapter(IJavaDebugTarget.class);
                if (target != null) {
                    switch (eventKind) {
                        case 1: 
                        case 2: {
                            if (debugEvent.getDetail() == 128) break;
                            this.handleSuspendResume();
                            break;
                        }
                        case 8: {
                            this.handleDebugTargetTerminate(target);
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void handleSuspendResume() {
        JavaMonitorThread[] threads = this.getJavaMonitorThreads();
        int i = 0;
        while (i < threads.length) {
            threads[i].setToUpdate();
            ++i;
        }
        DebugPlugin.getDefault().asyncExec((Runnable)new RefreshAndDetectDeadlock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleThreadTerminate(IJavaThread thread) {
        HashMap<IDebugElement, Object> hashMap = this.fJavaMonitorThreads;
        synchronized (hashMap) {
            this.fJavaMonitorThreads.remove(thread);
        }
    }

    private void handleDebugTargetTerminate(IJavaDebugTarget debugTarget) {
        this.clean(this.fJavaMonitors, debugTarget);
        this.clean(this.fJavaMonitorThreads, debugTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clean(Map<IDebugElement, Object> map, IJavaDebugTarget debugTarget) {
        IDebugElement[] debugElements = null;
        Map<IDebugElement, Object> map2 = map;
        synchronized (map2) {
            debugElements = new IDebugElement[map.size()];
            debugElements = map.keySet().toArray(debugElements);
        }
        int i = 0;
        while (i < debugElements.length) {
            if (debugElements[i].getDebugTarget().equals(debugTarget)) {
                Map<IDebugElement, Object> map3 = map;
                synchronized (map3) {
                    map.remove(debugElements[i]);
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaMonitorThread getJavaMonitorThread(IJavaThread thread, IThread originalThread) {
        HashMap<IDebugElement, Object> hashMap = this.fJavaMonitorThreads;
        synchronized (hashMap) {
            JavaMonitorThread javaMonitorThread = (JavaMonitorThread)((Object)this.fJavaMonitorThreads.get(thread));
            if (javaMonitorThread == null) {
                javaMonitorThread = new JavaMonitorThread(thread, originalThread);
                this.fJavaMonitorThreads.put((IDebugElement)thread, (Object)javaMonitorThread);
                DebugPlugin.getDefault().asyncExec((Runnable)new DetectDeadlock());
            } else if (originalThread != null) {
                javaMonitorThread.setOriginalThread(originalThread);
            }
            return javaMonitorThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaMonitor getJavaMonitor(IJavaObject monitor) {
        HashMap<IDebugElement, Object> hashMap = this.fJavaMonitors;
        synchronized (hashMap) {
            JavaMonitor javaMonitor = (JavaMonitor)this.fJavaMonitors.get(monitor);
            if (javaMonitor == null) {
                javaMonitor = new JavaMonitor(monitor);
                this.fJavaMonitors.put((IDebugElement)monitor, javaMonitor);
            }
            return javaMonitor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeJavaMonitor(JavaMonitor monitor) {
        HashMap<IDebugElement, Object> hashMap = this.fJavaMonitors;
        synchronized (hashMap) {
            this.fJavaMonitors.remove(monitor.getMonitor());
        }
    }

    public JavaContendedMonitor getContendedMonitor(IThread thread) {
        IJavaThread javaThread = (IJavaThread)thread.getAdapter(IJavaThread.class);
        if (javaThread == null || !this.fIsEnabled || !((IJavaDebugTarget)javaThread.getDebugTarget()).supportsMonitorInformation()) {
            return null;
        }
        return this.getJavaMonitorThread(javaThread, thread).getContendedMonitor();
    }

    public JavaOwnedMonitor[] getOwnedMonitors(IThread thread) {
        IJavaThread javaThread = (IJavaThread)thread.getAdapter(IJavaThread.class);
        if (javaThread == null || !this.fIsEnabled || !((IJavaDebugTarget)javaThread.getDebugTarget()).supportsMonitorInformation()) {
            return new JavaOwnedMonitor[0];
        }
        return this.getJavaMonitorThread(javaThread, thread).getOwnedMonitors();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(IJavaDebugUIConstants.PREF_SHOW_MONITOR_THREAD_INFO)) {
            this.fIsEnabled = JDIDebugUIPreferenceInitializer.getBoolean(event);
            if (this.fIsEnabled) {
                DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
            } else {
                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
            }
        }
    }

    public boolean isInDeadlock(IThread thread) {
        IJavaThread javaThread = (IJavaThread)thread.getAdapter(IJavaThread.class);
        if (!this.fIsEnabled || !((IJavaDebugTarget)javaThread.getDebugTarget()).supportsMonitorInformation()) {
            return false;
        }
        return this.getJavaMonitorThread(javaThread, thread).isInDeadlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaMonitor[] getJavaMonitors() {
        HashMap<IDebugElement, Object> hashMap = this.fJavaMonitors;
        synchronized (hashMap) {
            JavaMonitor[] monitors = new JavaMonitor[this.fJavaMonitors.size()];
            return this.fJavaMonitors.values().toArray(monitors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaMonitorThread[] getJavaMonitorThreads() {
        HashMap<IDebugElement, Object> hashMap = this.fJavaMonitorThreads;
        synchronized (hashMap) {
            JavaMonitorThread[] threads = new JavaMonitorThread[this.fJavaMonitorThreads.size()];
            return this.fJavaMonitorThreads.values().toArray(threads);
        }
    }

    class DetectDeadlock
    implements Runnable {
        DetectDeadlock() {
        }

        @Override
        public void run() {
            JavaMonitorThread thread;
            JavaMonitorThread[] threads = ThreadMonitorManager.this.getJavaMonitorThreads();
            JavaMonitor[] monitors = ThreadMonitorManager.this.getJavaMonitors();
            ArrayList inDeadlock = new ArrayList();
            int i = 0;
            while (i < threads.length) {
                thread = threads[i];
                ArrayList<JavaMonitorThread> threadStack = new ArrayList<JavaMonitorThread>();
                ArrayList<JavaMonitor> monitorStack = new ArrayList<JavaMonitor>();
                while (thread != null) {
                    boolean isInDeadlock = false;
                    if (inDeadlock.contains((Object)thread) || threadStack.contains((Object)thread)) {
                        isInDeadlock = true;
                    } else {
                        JavaMonitor monitor = thread.getContendedMonitor0();
                        if (monitor == null) {
                            thread = null;
                        } else if (inDeadlock.contains(monitor)) {
                            isInDeadlock = true;
                        } else {
                            threadStack.add(thread);
                            monitorStack.add(monitor);
                            thread = monitor.getOwningThread0();
                        }
                    }
                    if (!isInDeadlock) continue;
                    Iterator iter = threadStack.iterator();
                    while (iter.hasNext()) {
                        inDeadlock.add(iter.next());
                    }
                    iter = monitorStack.iterator();
                    while (iter.hasNext()) {
                        inDeadlock.add(iter.next());
                    }
                    thread = null;
                }
                ++i;
            }
            i = 0;
            while (i < threads.length) {
                thread = threads[i];
                thread.setInDeadlock(inDeadlock.contains((Object)thread));
                ++i;
            }
            i = 0;
            while (i < monitors.length) {
                JavaMonitor monitor = monitors[i];
                monitor.setInDeadlock(inDeadlock.contains(monitor));
                ++i;
            }
        }
    }

    class RefreshAndDetectDeadlock
    extends DetectDeadlock {
        RefreshAndDetectDeadlock() {
        }

        @Override
        public void run() {
            JavaMonitorThread[] threads = ThreadMonitorManager.this.getJavaMonitorThreads();
            int i = 0;
            while (i < threads.length) {
                threads[i].refresh();
                ++i;
            }
            super.run();
        }
    }
}

