/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.internal;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lfs.errors.LfsConfigInvalidException;
import org.eclipse.jgit.lfs.internal.LfsText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BlobBasedConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.treewalk.TreeWalk;

public class LfsConfig {
    private Repository db;
    private Config delegate;

    public LfsConfig(Repository db) {
        this.db = db;
    }

    private Config getDelegate() throws IOException {
        if (this.delegate == null) {
            this.delegate = this.load();
        }
        return this.delegate;
    }

    private Config load() throws IOException {
        Config result = null;
        if (!this.db.isBare() && (result = this.loadFromWorkingTree()) == null) {
            result = this.loadFromIndex();
        }
        if (result == null) {
            result = this.loadFromHead();
        }
        if (result == null) {
            result = this.emptyConfig();
        }
        return result;
    }

    @Nullable
    private Config loadFromWorkingTree() throws IOException {
        File lfsConfig = this.db.getFS().resolve(this.db.getWorkTree(), ".lfsconfig");
        if (lfsConfig.isFile()) {
            FileBasedConfig config = new FileBasedConfig(lfsConfig, this.db.getFS());
            try {
                config.load();
                return config;
            }
            catch (ConfigInvalidException e) {
                throw new LfsConfigInvalidException(LfsText.get().dotLfsConfigReadFailed, (Exception)((Object)e));
            }
        }
        return null;
    }

    @Nullable
    private Config loadFromIndex() throws IOException {
        try {
            DirCacheEntry entry = this.db.readDirCache().getEntry(".lfsconfig");
            if (entry != null) {
                return new BlobBasedConfig(null, this.db, (AnyObjectId)entry.getObjectId());
            }
        }
        catch (ConfigInvalidException e) {
            throw new LfsConfigInvalidException(LfsText.get().dotLfsConfigReadFailed, (Exception)((Object)e));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private Config loadFromHead() throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (RevWalk revWalk = new RevWalk(this.db);){
                ObjectId headCommitId = this.db.resolve("HEAD");
                if (headCommitId == null) {
                    return null;
                }
                RevCommit commit = revWalk.parseCommit((AnyObjectId)headCommitId);
                RevTree tree = commit.getTree();
                TreeWalk treewalk = TreeWalk.forPath((Repository)this.db, (String)".lfsconfig", (RevTree)tree);
                if (treewalk == null) return null;
                return new BlobBasedConfig(null, this.db, (AnyObjectId)treewalk.getObjectId(0));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (ConfigInvalidException e) {
            throw new LfsConfigInvalidException(LfsText.get().dotLfsConfigReadFailed, (Exception)((Object)e));
        }
    }

    private Config emptyConfig() {
        return new Config();
    }

    @Nullable
    public String getString(String section, String subsection, String name) throws IOException {
        String result = this.db.getConfig().getString(section, subsection, name);
        if (result == null) {
            result = this.getDelegate().getString(section, subsection, name);
        }
        return result;
    }
}

