/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.libval;

import java.util.ArrayList;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.jpt.common.core.JptCommonCoreMessages;
import org.eclipse.jpt.common.core.internal.InternalJptWorkspace;
import org.eclipse.jpt.common.core.internal.libval.LibraryValidatorConfig;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.utility.ExtensionPointTools;
import org.eclipse.jpt.common.core.libprov.JptLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.common.core.libval.LibraryValidator;
import org.eclipse.jpt.common.core.libval.LibraryValidatorManager;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.predicate.Predicate;

public class InternalLibraryValidatorManager
implements LibraryValidatorManager {
    private final InternalJptWorkspace jptWorkspace;
    private final ArrayList<LibraryValidatorConfig> libraryValidatorConfigs = new ArrayList();
    private static final String SIMPLE_EXTENSION_POINT_NAME = "libraryValidators";
    private static final String LIBRARY_VALIDATOR_ELEMENT = "libraryValidator";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String ENABLEMENT_ELEMENT = "enablement";

    public InternalLibraryValidatorManager(InternalJptWorkspace jptWorkspace) {
        this.jptWorkspace = jptWorkspace;
        this.initialize();
    }

    private void initialize() {
        IExtensionPoint extensionPoint = this.getExtensionPoint();
        if (extensionPoint == null) {
            throw new IllegalStateException("missing extension point: " + this.getExtensionPointName());
        }
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                LibraryValidatorConfig config;
                IConfigurationElement element = iConfigurationElementArray[n4];
                String elementName = element.getName();
                if (elementName.equals(LIBRARY_VALIDATOR_ELEMENT) && (config = this.buildLibraryValidatorConfig(element)) != null) {
                    this.libraryValidatorConfigs.add(config);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private LibraryValidatorConfig buildLibraryValidatorConfig(IConfigurationElement element) {
        String contributor = element.getContributor().getName();
        String id = element.getAttribute(ID_ATTRIBUTE);
        if (StringTools.isBlank((String)id)) {
            this.logMissingAttribute(element, ID_ATTRIBUTE);
            return null;
        }
        if (this.containsLibraryValidatorConfig(id)) {
            this.logError(JptCommonCoreMessages.REGISTRY_DUPLICATE, this.getExtensionPointName(), contributor, ID_ATTRIBUTE, id);
            return null;
        }
        String className = element.getAttribute(CLASS_ATTRIBUTE);
        if (className == null) {
            this.logMissingAttribute(element, CLASS_ATTRIBUTE);
            return null;
        }
        LibraryValidatorConfig config = new LibraryValidatorConfig(this, id, className);
        IConfigurationElement[] iConfigurationElementArray = element.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            if (child.getName().equals(ENABLEMENT_ELEMENT)) {
                if (config.getEnablementExpression() != null) {
                    this.logMultipleEnablements(element);
                    return null;
                }
                try {
                    config.setEnablementExpression(ExpressionConverter.getDefault().perform(child));
                }
                catch (CoreException ex) {
                    JptCommonCorePlugin.instance().logError(ex);
                    return null;
                }
            }
            ++n2;
        }
        config.setPluginID(contributor);
        return config;
    }

    @Override
    public Iterable<LibraryValidator> getLibraryValidators() {
        return IterableTools.removeNulls(this.getLibraryValidators_());
    }

    private Iterable<LibraryValidator> getLibraryValidators_() {
        return new TransformationIterable(this.libraryValidatorConfigs, LibraryValidatorConfig.LIBRARY_VALIDATOR_TRANSFORMER);
    }

    @Override
    public Iterable<LibraryValidator> getLibraryValidators(JptLibraryProviderInstallOperationConfig installConfig) {
        return IterableTools.removeNulls(this.getLibraryValidators_(installConfig));
    }

    private Iterable<LibraryValidator> getLibraryValidators_(JptLibraryProviderInstallOperationConfig installConfig) {
        return new TransformationIterable(this.getLibraryValidatorConfigs(installConfig), LibraryValidatorConfig.LIBRARY_VALIDATOR_TRANSFORMER);
    }

    private Iterable<LibraryValidatorConfig> getLibraryValidatorConfigs(JptLibraryProviderInstallOperationConfig installConfig) {
        return IterableTools.filter(this.libraryValidatorConfigs, (Predicate)new LibraryValidatorConfig.IsEnabled(installConfig));
    }

    private boolean containsLibraryValidatorConfig(String id) {
        return this.getLibraryValidatorConfig(id) != null;
    }

    private LibraryValidatorConfig getLibraryValidatorConfig(String id) {
        for (LibraryValidatorConfig config : this.libraryValidatorConfigs) {
            if (!config.getID().equals(id)) continue;
            return config;
        }
        return null;
    }

    private void logError(String msg, Object ... args) {
        this.getPlugin().logError(msg, args);
    }

    private void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.getPlugin().logError(ExtensionPointTools.buildMissingAttributeMessage(element, attributeName));
    }

    private void logMultipleEnablements(IConfigurationElement element) {
        this.getPlugin().logError(JptCommonCoreMessages.MULTIPLE_LIBRARY_VALIDATOR_ENABLEMENTS, element.getDeclaringExtension().getExtensionPointUniqueIdentifier(), element.getContributor().getName());
    }

    @Override
    public InternalJptWorkspace getJptWorkspace() {
        return this.jptWorkspace;
    }

    String getExtensionPointName() {
        return this.getPluginID() + ".libraryValidators";
    }

    private IExtensionPoint getExtensionPoint() {
        return this.getExtensionRegistry().getExtensionPoint(this.getPluginID(), SIMPLE_EXTENSION_POINT_NAME);
    }

    private IExtensionRegistry getExtensionRegistry() {
        return RegistryFactory.getRegistry();
    }

    private String getPluginID() {
        return this.getPlugin().getPluginID();
    }

    private JptCommonCorePlugin getPlugin() {
        return JptCommonCorePlugin.instance();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.libraryValidatorConfigs);
    }
}

