/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAttributeAnnotation;

public final class SourceXmlAttributeAnnotation
extends SourceAnnotation
implements XmlAttributeAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.xml.bind.annotation.XmlAttribute");
    private final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    private final AnnotationElementAdapter<String> nameAdapter;
    private String name;
    private TextRange nameTextRange;
    private TextRange nameValidationTextRange;
    private final DeclarationAnnotationElementAdapter<String> namespaceDeclarationAdapter;
    private final AnnotationElementAdapter<String> namespaceAdapter;
    private String namespace;
    private TextRange namespaceTextRange;
    private TextRange namespaceValidationTextRange;
    private final DeclarationAnnotationElementAdapter<Boolean> requiredDeclarationAdapter;
    private final AnnotationElementAdapter<Boolean> requiredAdapter;
    private Boolean required;
    private TextRange requiredTextRange;

    public SourceXmlAttributeAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement) {
        this(parent, annotatedElement, DECLARATION_ANNOTATION_ADAPTER, (AnnotationAdapter)new ElementAnnotationAdapter(annotatedElement, DECLARATION_ANNOTATION_ADAPTER));
    }

    public SourceXmlAttributeAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super((JavaResourceModel)parent, annotatedElement, daa, annotationAdapter);
        this.nameDeclarationAdapter = this.buildNameAdapter(daa);
        this.nameAdapter = this.buildAnnotationElementAdapter(this.nameDeclarationAdapter);
        this.namespaceDeclarationAdapter = this.buildNamespaceAdapter(daa);
        this.namespaceAdapter = this.buildAnnotationElementAdapter(this.namespaceDeclarationAdapter);
        this.requiredDeclarationAdapter = this.buildRequiredAdapter(daa);
        this.requiredAdapter = this.buildShortCircuitBooleanElementAdapter(this.requiredDeclarationAdapter);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"name");
    }

    private DeclarationAnnotationElementAdapter<String> buildNamespaceAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"namespace");
    }

    private DeclarationAnnotationElementAdapter<Boolean> buildRequiredAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daa, (String)"required");
    }

    private AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    private AnnotationElementAdapter<Boolean> buildShortCircuitBooleanElementAdapter(DeclarationAnnotationElementAdapter<Boolean> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlAttribute";
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.name = this.buildName(astAnnotation);
        this.nameTextRange = this.buildNameTextRange(astAnnotation);
        this.nameValidationTextRange = this.buildNameValidationTextRange(astAnnotation);
        this.namespace = this.buildNamespace(astAnnotation);
        this.namespaceTextRange = this.buildNamespaceTextRange(astAnnotation);
        this.namespaceValidationTextRange = this.buildNamespaceValidationTextRange(astAnnotation);
        this.required = this.buildRequired(astAnnotation);
        this.requiredTextRange = this.buildRequiredTextRange(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncName(this.buildName(astAnnotation));
        this.nameTextRange = this.buildNameTextRange(astAnnotation);
        this.nameValidationTextRange = this.buildNameValidationTextRange(astAnnotation);
        this.syncNamespace(this.buildNamespace(astAnnotation));
        this.namespaceTextRange = this.buildNamespaceTextRange(astAnnotation);
        this.namespaceValidationTextRange = this.buildNamespaceValidationTextRange(astAnnotation);
        this.syncRequired(this.buildRequired(astAnnotation));
        this.requiredTextRange = this.buildRequiredTextRange(astAnnotation);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (ObjectTools.notEquals((Object)this.name, (Object)name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(Annotation astAnnotation) {
        return (String)this.nameAdapter.getValue(astAnnotation);
    }

    private TextRange buildNameTextRange(Annotation astAnnotation) {
        return this.getAnnotationElementTextRange(this.nameDeclarationAdapter, astAnnotation);
    }

    private TextRange buildNameValidationTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astAnnotation);
    }

    @Override
    public TextRange getNameTextRange() {
        return this.nameTextRange;
    }

    @Override
    public TextRange getNameValidationTextRange() {
        return this.nameValidationTextRange;
    }

    @Override
    public boolean nameTouches(int pos) {
        return this.textRangeTouches(this.nameTextRange, pos);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        if (ObjectTools.notEquals((Object)this.namespace, (Object)namespace)) {
            this.namespace = namespace;
            this.namespaceAdapter.setValue((Object)namespace);
        }
    }

    private void syncNamespace(String astNamespace) {
        String old = this.namespace;
        this.namespace = astNamespace;
        this.firePropertyChanged("namespace", old, astNamespace);
    }

    private String buildNamespace(Annotation astAnnotation) {
        return (String)this.namespaceAdapter.getValue(astAnnotation);
    }

    private TextRange buildNamespaceTextRange(Annotation astAnnotation) {
        return this.getAnnotationElementTextRange(this.namespaceDeclarationAdapter, astAnnotation);
    }

    private TextRange buildNamespaceValidationTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.namespaceDeclarationAdapter, astAnnotation);
    }

    @Override
    public TextRange getNamespaceTextRange() {
        return this.namespaceTextRange;
    }

    @Override
    public TextRange getNamespaceValidationTextRange() {
        return this.namespaceValidationTextRange;
    }

    @Override
    public boolean namespaceTouches(int pos) {
        return this.textRangeTouches(this.namespaceTextRange, pos);
    }

    @Override
    public Boolean getRequired() {
        return this.required;
    }

    @Override
    public void setRequired(Boolean required) {
        if (ObjectTools.notEquals((Object)this.required, (Object)required)) {
            this.required = required;
            this.requiredAdapter.setValue((Object)required);
        }
    }

    private void syncRequired(Boolean astRequired) {
        Boolean old = this.required;
        this.required = astRequired;
        this.firePropertyChanged("required", old, astRequired);
    }

    private Boolean buildRequired(Annotation astAnnotation) {
        return (Boolean)this.requiredAdapter.getValue(astAnnotation);
    }

    private TextRange buildRequiredTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.requiredDeclarationAdapter, astAnnotation);
    }

    @Override
    public TextRange getRequiredTextRange() {
        return this.requiredTextRange;
    }
}

